/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.models;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.DefaultComboBoxModel;

public final class RecentsFilesComboModel
extends DefaultComboBoxModel {
    private final Stack<String> stack;
    private String keyProperties = null;
    private boolean autosave;

    public RecentsFilesComboModel(String string, boolean bl) {
        this(new Stack<String>());
        String[] stringArray;
        this.keyProperties = string;
        this.autosave = bl;
        for (String string2 : stringArray = AppPrefs.getProperty(string, "").split("\\|")) {
            if (string2.length() <= 0 || !new File(string2).exists()) continue;
            this.stack.add(0, string2);
        }
    }

    private RecentsFilesComboModel(Stack<String> stack) {
        super(stack);
        this.stack = stack;
        this.autosave = false;
    }

    @Override
    public void setSelectedItem(Object object) {
        super.setSelectedItem(object);
        this.addElement(object);
    }

    @Override
    public final void addElement(Object object) {
        if (object == null) {
            return;
        }
        int n = this.getIndexOf(object);
        if (n < 0) {
            if (!"".equals(object) && !"?".equals(object) && new File(object.toString()).exists()) {
                super.insertElementAt(object, 0);
                if (this.stack.size() > 5) {
                    this.remove(4);
                    if (this.autosave) {
                        this.store();
                    }
                }
            }
            if (this.autosave) {
                this.store();
            }
        }
    }

    private void remove(int n) {
        this.setSelectedItem(this.getElementAt(0));
        this.stack.removeElementAt(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public final Collection<String> getList() {
        return this.stack;
    }

    public void removeAllProperties() {
        AppPrefs.removeProperty(this.keyProperties);
    }

    /*
     * WARNING - void declaration
     */
    public void store() {
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<File> hashSet = new HashSet<File>(this.stack.size());
        boolean bl = Utils.isWindows();
        for (String string : this.stack) {
            void object;
            File file;
            if (bl && !string.endsWith("\\")) {
                String string2 = string + "\\";
            }
            if (hashSet.contains(file = new File((String)object))) continue;
            hashSet.add(file);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            stringBuilder.append(file.getAbsolutePath());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("|");
        }
        AppPrefs.storeProperty(this.keyProperties, stringBuilder.toString());
    }
}

