/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.logging.Logger;

public class FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class.getName());
    public static final String BACKUP_EXTENSION = ".backup";

    private FileUtils() {
    }

    public static OutputStream createEmptyFile(File file, long l, DownloadTask downloadTask) throws IOException {
        byte[] byArray = new byte[0x100000];
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.setLength(l);
            int n = 0x100000;
            for (long i = 0L; i != l; i += (long)n) {
                if (downloadTask.isTerminated()) {
                    return null;
                }
                if (l - i < 0x100000L) {
                    n = (int)(l - i);
                }
                randomAccessFile.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            throw iOException;
        }
        randomAccessFile.seek(0L);
        return new FileOutputStream(randomAccessFile.getFD());
    }

    public static void makeBackup(File file) throws IOException {
        boolean bl;
        File file2 = FileUtils.getBackupFile(file);
        if (file2.exists() && !(bl = file2.delete())) {
            logger.warning("Deleting old backup file " + file2 + " failed.");
        }
        if (!(bl = file.renameTo(file2))) {
            logger.warning("Making backup of file " + file + " to backup file " + file2 + " failed.");
        }
    }

    public static void renewBackup(File file) throws IOException {
        File file2 = FileUtils.getBackupFile(file);
        try {
            if (!file2.exists()) {
                throw new FileNotFoundException("Backup file does not exists");
            }
            FileUtils.copyfile(file2, file);
        }
        catch (IOException iOException) {
            logger.warning("Renewing file " + file + " from backup file " + file2 + " failed.");
            throw iOException;
        }
    }

    public static File getBackupFile(File file) {
        return new File(file.getParentFile(), file.getName() + BACKUP_EXTENSION);
    }

    public static void copyfile(File file, File file2) throws IOException {
        if (!file.exists() || !file.isFile()) {
            return;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            boolean bl;
            File file3 = file2.getParentFile();
            if (!file3.exists() && !(bl = file3.mkdirs())) {
                logger.warning("Creating path " + file3 + " failed");
            }
            inputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LogUtils.processException(logger, iOException);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    LogUtils.processException(logger, iOException);
                }
            }
        }
    }
}

