/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceListUI;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.api.renderers.SubstanceDefaultComboBoxRenderer;
import org.jvnet.substance.painter.highlight.SubstanceHighlightUtils;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceOutlineUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.border.SubstanceBorder;
import org.jvnet.substance.utils.combo.SubstanceComboBoxButton;
import org.jvnet.substance.utils.combo.SubstanceComboBoxEditor;
import org.jvnet.substance.utils.combo.SubstanceComboPopup;

public class SubstanceComboBoxUI
extends BasicComboBoxUI {
    protected ComboBoxPropertyChangeHandler substanceChangeHandler;
    protected FadeStateListener substanceFadeStateListener;
    protected FocusListener substanceFocusListener;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        SubstanceComboBoxUI ui = new SubstanceComboBoxUI();
        ui.comboBox = (JComboBox)comp;
        ui.comboBox.setOpaque(false);
        return ui;
    }

    @Override
    protected JButton createArrowButton() {
        SubstanceComboBoxButton result = new SubstanceComboBoxButton(this.comboBox);
        result.setFont(this.comboBox.getFont());
        result.setIcon(this.getCurrentIcon(result));
        return result;
    }

    private Icon getCurrentIcon(JButton button) {
        Icon icon = SubstanceCoreUtilities.getArrowIcon(button, SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox));
        return icon;
    }

    protected ListCellRenderer createRenderer() {
        return new SubstanceDefaultComboBoxRenderer.SubstanceUIResource(this.comboBox);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceChangeHandler = new ComboBoxPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.substanceChangeHandler);
        this.substanceFadeStateListener = new FadeStateListener(this.comboBox, null, null);
        this.substanceFadeStateListener.registerListeners();
    }

    @Override
    protected void uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.comboBox.removePropertyChangeListener(this.substanceChangeHandler);
        this.substanceChangeHandler = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Border b = this.comboBox.getBorder();
        if (b == null || b instanceof UIResource) {
            SubstanceBorder newB = new SubstanceBorder(SubstanceSizeUtils.getComboBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.comboBox)));
            this.comboBox.setBorder(newB);
        }
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new SubstanceComboBoxLayoutManager();
    }

    @Override
    protected Dimension getDefaultSize() {
        Component rend = new SubstanceDefaultComboBoxRenderer(this.comboBox).getListCellRendererComponent(this.listBox, (Object)" ", -1, false, false);
        rend.setFont(this.comboBox.getFont());
        return rend.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        SubstanceComboBoxButton button = (SubstanceComboBoxButton)this.arrowButton;
        Insets buttonInsets = button.getInsets();
        Insets insets = this.comboBox.getInsets();
        Dimension size = this.getDisplaySize();
        size.width += insets.left + insets.right;
        size.width += buttonInsets.left + buttonInsets.right;
        size.width = (int)((double)size.width + button.getMinimumSize().getWidth());
        size.height += insets.top + insets.bottom;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    @Override
    protected ComboPopup createPopup() {
        final SubstanceComboPopup sPopup = new SubstanceComboPopup(this.comboBox);
        final ComponentOrientation currOrientation = this.comboBox.getComponentOrientation();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComboBoxEditor editor;
                ListCellRenderer cellRenderer;
                if (SubstanceComboBoxUI.this.comboBox == null) {
                    return;
                }
                if (sPopup instanceof Component) {
                    Component cPopup = (Component)((Object)sPopup);
                    cPopup.applyComponentOrientation(currOrientation);
                    cPopup.doLayout();
                }
                if ((cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer()) instanceof Component) {
                    ((Component)((Object)cellRenderer)).applyComponentOrientation(currOrientation);
                }
                if ((editor = SubstanceComboBoxUI.this.comboBox.getEditor()) != null && editor.getEditorComponent() instanceof Component) {
                    editor.getEditorComponent().applyComponentOrientation(currOrientation);
                }
                SubstanceComboBoxUI.this.comboBox.repaint();
            }
        });
        return sPopup;
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        ListUI listUI = this.popup.getList().getUI();
        SubstanceListUI ui = (SubstanceListUI)listUI;
        ComponentState state = ui.getCellState(-1, null);
        boolean isEnabled = this.comboBox.isEnabled();
        boolean isSelected = hasFocus;
        if (isSelected && isEnabled) {
            state = ComponentState.SELECTED;
        }
        if (!isEnabled) {
            state = ComponentState.DISABLED_UNSELECTED;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.comboBox, state);
        float alpha = SubstanceColorSchemeUtilities.getAlpha(this.comboBox, state) * 0.8f;
        Rectangle newBounds = new Rectangle(1, 1, this.comboBox.getWidth() - 2, this.comboBox.getHeight() - 2);
        graphics.setComposite(TransitionLayout.getAlphaComposite(this.comboBox, alpha, g));
        SubstanceHighlightUtils.paintHighlight(graphics, this.comboBox, newBounds, 0.0f, null, colorScheme, colorScheme, 0.0f);
        graphics.dispose();
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Graphics2D graphics = (Graphics2D)g.create();
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = hasFocus ? renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, hasFocus) : renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, hasFocus);
        c.setFont(this.comboBox.getFont());
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            this.currentValuePane.paintComponent(graphics, c, this.comboBox, 1, 1, this.arrowButton.getX() - 1, this.comboBox.getHeight() - 2, shouldValidate);
        } else {
            int startX = this.arrowButton.getX() + this.arrowButton.getWidth();
            this.currentValuePane.paintComponent(graphics, c, this.comboBox, startX, 1, this.comboBox.getWidth() - startX - 1, this.comboBox.getHeight() - 2, shouldValidate);
        }
        graphics.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable() && this.hasFocus) {
            Rectangle r = this.rectangleForCurrentValue();
            ++r.y;
            r.height -= 2;
            r.width -= this.arrowButton.getWidth() + 10;
            this.paintFocus(g, r);
        }
    }

    protected void paintFocus(Graphics g, Rectangle bounds) {
        int fontSize = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
        int focusRingPadding = SubstanceSizeUtils.getFocusRingPadding(fontSize);
        SubstanceCoreUtilities.paintFocus(g, this.comboBox, this.comboBox, SubstanceOutlineUtilities.getBaseOutline(this.arrowButton.getX() - 1, this.comboBox.getHeight() - 3 * focusRingPadding / 2, SubstanceSizeUtils.getClassicButtonCornerRadius(fontSize), null, 0), bounds, 0.4f, 3 * focusRingPadding / 2);
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    @Override
    public void configureArrowButton() {
        super.configureArrowButton();
        this.arrowButton.setFocusable(false);
        this.substanceFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SubstanceComboBoxUI.this.arrowButton.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SubstanceComboBoxUI.this.arrowButton.setSelected(false);
            }
        };
        this.arrowButton.setSelected(this.comboBox.hasFocus());
        this.comboBox.addFocusListener(this.substanceFocusListener);
        this.configureArrowButtonStraightSide();
    }

    protected void configureArrowButtonStraightSide() {
        this.arrowButton.putClientProperty("substancelaf.buttonside", (Object)(this.comboBox.getComponentOrientation().isLeftToRight() ? SubstanceConstants.Side.LEFT : SubstanceConstants.Side.RIGHT));
    }

    @Override
    public void unconfigureArrowButton() {
        this.comboBox.removeFocusListener(this.substanceFocusListener);
        this.substanceFocusListener = null;
        super.unconfigureArrowButton();
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        if (this.editor instanceof JComponent) {
            Insets ins = SubstanceSizeUtils.getComboTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.editor));
            ((JComponent)this.editor).setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
            this.editor.setBackground(this.comboBox.getBackground());
        }
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new SubstanceComboBoxEditor.UIResource();
    }

    public class ComboBoxPropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        public ComboBoxPropertyChangeHandler() {
            super(SubstanceComboBoxUI.this);
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("componentOrientation")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SubstanceComboBoxUI.this.comboBox == null) {
                            return;
                        }
                        ComponentOrientation newOrientation = (ComponentOrientation)e.getNewValue();
                        ListCellRenderer cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer();
                        ComboBoxEditor editor = SubstanceComboBoxUI.this.comboBox.getEditor();
                        if (SubstanceComboBoxUI.this.popup instanceof Component) {
                            Component cPopup = (Component)((Object)SubstanceComboBoxUI.this.popup);
                            cPopup.applyComponentOrientation(newOrientation);
                            cPopup.doLayout();
                        }
                        if (cellRenderer instanceof Component) {
                            ((Component)((Object)cellRenderer)).applyComponentOrientation(newOrientation);
                        }
                        if (editor != null && editor.getEditorComponent() instanceof Component) {
                            editor.getEditorComponent().applyComponentOrientation(newOrientation);
                        }
                        if (SubstanceComboBoxUI.this.comboBox != null) {
                            SubstanceComboBoxUI.this.comboBox.repaint();
                        }
                        SubstanceComboBoxUI.this.configureArrowButtonStraightSide();
                    }
                });
            }
            if ("substancelaf.comboboxpopupFlyoutOrientation".equals(propertyName)) {
                ((SubstanceComboBoxButton)SubstanceComboBoxUI.this.arrowButton).setIcon(SubstanceCoreUtilities.getArrowIcon(SubstanceComboBoxUI.this.arrowButton, SubstanceCoreUtilities.getPopupFlyoutOrientation(SubstanceComboBoxUI.this.comboBox)));
            }
            if ("font".equals(propertyName)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SubstanceComboBoxUI.this.comboBox != null) {
                            SubstanceComboBoxUI.this.comboBox.updateUI();
                        }
                    }
                });
            }
            if ("background".equals(propertyName) && SubstanceComboBoxUI.this.comboBox.isEditable()) {
                SubstanceComboBoxUI.this.comboBox.getEditor().getEditorComponent().setBackground(SubstanceComboBoxUI.this.comboBox.getBackground());
                SubstanceComboBoxUI.this.popup.getList().setBackground(SubstanceComboBoxUI.this.comboBox.getBackground());
            }
        }
    }

    private class SubstanceComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private SubstanceComboBoxLayoutManager() {
            super(SubstanceComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = SubstanceComboBoxUI.this.getInsets();
            int buttonWidth = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(SubstanceComboBoxUI.this.comboBox));
            if (SubstanceComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(width - buttonWidth - insets.right, 0, buttonWidth + insets.right, height);
                } else {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(0, 0, buttonWidth + insets.left, height);
                }
            }
            if (SubstanceComboBoxUI.this.editor != null) {
                SubstanceComboBoxUI.this.editor.setBounds(SubstanceComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

