/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api.renderers;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.NumberFormat;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.TableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceTableUI;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceApi;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceStripingUtils;
import org.jvnet.substance.utils.border.SubstanceBorder;

@SubstanceApi
public class SubstanceDefaultTableCellRenderer
extends DefaultTableCellRenderer {
    public SubstanceDefaultTableCellRenderer() {
        this.putClientProperty("substancelaf.colorizationFactor", 1.0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        SubstanceColorScheme scheme;
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        TableUI tableUI = table.getUI();
        SubstanceTableUI ui = (SubstanceTableUI)tableUI;
        hasFocus = ui.isFocusedCell(row, column);
        SubstanceTableUI.TableCellId cellId = new SubstanceTableUI.TableCellId(row, column);
        Comparable<?> compId = ui.getId(row, column);
        ComponentState state = ui.getCellState(cellId);
        ComponentState prevState = ui.getPrevCellState(cellId);
        SubstanceColorScheme substanceColorScheme = scheme = state == ComponentState.DEFAULT ? ui.getDefaultColorScheme() : SubstanceColorSchemeUtilities.getColorScheme(table, state);
        if (scheme == null) {
            scheme = SubstanceColorSchemeUtilities.getColorScheme(table, state);
        }
        if (ui.hasRolloverAnimations() || ui.hasSelectionAnimations()) {
            super.setForeground(new ColorUIResource(SubstanceColorUtilities.getInterpolatedForegroundColor(table, compId, scheme, state, prevState, FadeKind.SELECTION, FadeKind.ROLLOVER)));
        } else {
            super.setForeground(new ColorUIResource(scheme.getForegroundColor()));
        }
        SubstanceStripingUtils.applyStripedBackground(table, row, this);
        this.setFont(table.getFont());
        SubstanceTableUI.TableCellId cellFocusId = new SubstanceTableUI.TableCellId(row, column);
        cellFocusId.setExactComparison(true);
        FadeState focusState = SubstanceFadeUtilities.getFadeState((Component)table, cellFocusId, FadeKind.FOCUS);
        Insets regInsets = ui.getCellRendererInsets();
        if (hasFocus || focusState != null) {
            SubstanceBorder border = new SubstanceBorder(regInsets);
            if (focusState != null) {
                border.setAlpha(focusState.getFadePosition());
            }
            if (!table.getShowHorizontalLines() && !table.getShowVerticalLines()) {
                this.setBorder(new CompoundBorder(new EmptyBorder(table.getRowMargin() / 2, 0, table.getRowMargin() / 2, 0), border));
            } else {
                this.setBorder(border);
            }
        } else {
            this.setBorder(new EmptyBorder(regInsets.top, regInsets.left, regInsets.bottom, regInsets.right));
        }
        this.setValue(value);
        this.setOpaque(false);
        this.setEnabled(table.isEnabled());
        return this;
    }

    @Override
    public final void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public static class DateRenderer
    extends SubstanceDefaultTableCellRenderer {
        DateFormat formatter;

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class DoubleRenderer
    extends NumberRenderer {
        NumberFormat formatter;

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class NumberRenderer
    extends SubstanceDefaultTableCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    public static class IconRenderer
    extends SubstanceDefaultTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public void setValue(Object value) {
            this.setIcon(value instanceof Icon ? (Icon)value : null);
            this.setText(null);
        }
    }

    public static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
            }
            SubstanceStripingUtils.applyStripedBackground(table, row, this);
            this.setSelected(value != null && (Boolean)value != false);
            this.setEnabled(table.isEnabled());
            TableUI tableUI = table.getUI();
            if (tableUI instanceof SubstanceTableUI) {
                SubstanceTableUI ui = (SubstanceTableUI)tableUI;
                hasFocus = ui.isFocusedCell(row, column);
                SubstanceTableUI.TableCellId cellFocusId = new SubstanceTableUI.TableCellId(row, column);
                cellFocusId.setExactComparison(true);
                FadeState focusState = SubstanceFadeUtilities.getFadeState((Component)table, cellFocusId, FadeKind.FOCUS);
                if (hasFocus || focusState != null) {
                    SubstanceBorder border = new SubstanceBorder();
                    if (focusState != null) {
                        border.setAlpha(focusState.getFadePosition());
                    }
                    this.setBorder(border);
                } else {
                    this.setBorder(noFocusBorder);
                }
            } else if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setOpaque(false);
            return this;
        }

        @Override
        public final void paint(Graphics g) {
            super.paint(g);
        }

        @Override
        protected final void paintComponent(Graphics g) {
            super.paintComponent(g);
        }
    }
}

