/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.highlight;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Set;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.painter.gradient.GlassGradientPainter;
import org.jvnet.substance.painter.highlight.SubstanceHighlightPainter;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceOutlineUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class GlassHighlightPainter
implements SubstanceHighlightPainter {
    public static final String DISPLAY_NAME = "Glass";
    protected static LazyResettableHashMap<BufferedImage> smallImageCache = new LazyResettableHashMap("GlassHighlightPainter");
    protected GlassGradientPainter painter = new GlassGradientPainter();

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void paintHighlight(Graphics2D graphics, Component comp, int width, int height, float borderAlpha, Set<SubstanceConstants.Side> openSides, SubstanceColorScheme colorScheme1, SubstanceColorScheme colorScheme2, float cyclePos) {
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(comp);
        if (openSides == null) {
            openSides = EnumSet.noneOf(SubstanceConstants.Side.class);
        }
        if (width * height < 100000) {
            String openKey = "";
            for (SubstanceConstants.Side oSide : openSides) {
                openKey = openKey + oSide.name() + "-";
            }
            HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, colorScheme1.getDisplayName(), colorScheme2.getDisplayName(), Float.valueOf(cyclePos), Float.valueOf(borderAlpha), openKey, borderPainter.getDisplayName());
            BufferedImage result = smallImageCache.get(key);
            if (result == null) {
                result = SubstanceCoreUtilities.getBlankImage(width, height);
                this.internalPaint((Graphics2D)result.getGraphics(), comp, width, height, colorScheme1, colorScheme2, cyclePos, borderPainter, borderAlpha, openSides);
                smallImageCache.put(key, result);
            }
            graphics.drawImage((Image)result, 0, 0, null);
            return;
        }
        this.internalPaint(graphics, comp, width, height, colorScheme1, colorScheme2, cyclePos, borderPainter, borderAlpha, openSides);
    }

    protected void internalPaint(Graphics2D graphics, Component comp, int width, int height, SubstanceColorScheme colorScheme1, SubstanceColorScheme colorScheme2, float cyclePos, SubstanceBorderPainter borderPainter, float borderAlpha, Set<SubstanceConstants.Side> openSides) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(-3, -3);
        this.painter.paintContourBackground(g2d, comp, width + 6, height + 6, new Rectangle(width + 6, height + 6), false, colorScheme1, colorScheme2, cyclePos, false, true);
        g2d.translate(3, 3);
        if (borderAlpha > 0.0f) {
            int openDelta = 3 + (int)Math.ceil(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(comp)));
            int deltaLeft = openSides.contains((Object)SubstanceConstants.Side.LEFT) ? openDelta : 0;
            int deltaRight = openSides.contains((Object)SubstanceConstants.Side.RIGHT) ? openDelta : 0;
            int deltaTop = openSides.contains((Object)SubstanceConstants.Side.TOP) ? openDelta : 0;
            int deltaBottom = openSides.contains((Object)SubstanceConstants.Side.BOTTOM) ? openDelta : 0;
            int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(comp)) / 2.0);
            GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, 0.0f, null, borderDelta);
            graphics.translate(-deltaLeft, -deltaTop);
            if (borderAlpha > 0.0f) {
                g2d.setComposite(TransitionLayout.getAlphaComposite(comp, borderAlpha, graphics));
                int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(comp));
                GeneralPath contourInner = SubstanceOutlineUtilities.getBaseOutline(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, 0.0f, null, borderDelta + borderThickness);
                borderPainter.paintBorder(g2d, comp, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, contourInner, colorScheme1, colorScheme2, cyclePos, true);
            }
        }
        g2d.dispose();
    }
}

