/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.painter.gradient.SubstanceGradientPainter;
import org.jvnet.substance.shaper.RectangularButtonShaper;
import org.jvnet.substance.shaper.StandardButtonShaper;
import org.jvnet.substance.shaper.SubstanceButtonShaper;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.PairwiseButtonBackgroundDelegate;
import org.jvnet.substance.utils.PulseTracker;
import org.jvnet.substance.utils.Sideable;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class ButtonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> regularBackgrounds = new LazyResettableHashMap("ButtonBackgroundDelegate");

    public static BufferedImage getFullAlphaBackground(AbstractButton button, ButtonModel model, SubstanceButtonShaper shaper, SubstanceGradientPainter painter, SubstanceBorderPainter borderPainter, int width, int height) {
        FadeState fadeState;
        SubstanceColorScheme borderScheme;
        SubstanceColorScheme colorScheme;
        JButton jb;
        ComponentState state = ComponentState.getState(model, button);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(button, null);
        float cyclePos = state.getCyclePosition();
        boolean isPulsating = false;
        if (button instanceof JButton && PulseTracker.isPulsating(jb = (JButton)button) && state != ComponentState.PRESSED_SELECTED && state != ComponentState.PRESSED_UNSELECTED) {
            isPulsating = true;
            cyclePos = (int)(PulseTracker.getCycles(jb) % 20L);
            if (cyclePos > 10.0f) {
                cyclePos = 19.0f - cyclePos;
            }
            cyclePos /= 10.0f;
        }
        SubstanceColorScheme colorScheme2 = colorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, state);
        SubstanceColorScheme borderScheme2 = borderScheme = SubstanceColorSchemeUtilities.getBorderColorScheme(button, state);
        boolean isWindowModified = false;
        if (SubstanceCoreUtilities.isTitleCloseButton(button)) {
            for (Container comp = button; comp != null; comp = comp.getParent()) {
                if (comp instanceof JInternalFrame) {
                    JInternalFrame jif = (JInternalFrame)comp;
                    isWindowModified = Boolean.TRUE.equals(jif.getClientProperty("windowModified"));
                    break;
                }
                if (comp instanceof JRootPane) {
                    JRootPane jrp = (JRootPane)comp;
                    isWindowModified = Boolean.TRUE.equals(jrp.getClientProperty("windowModified"));
                    break;
                }
                if (!(comp instanceof JInternalFrame.JDesktopIcon)) continue;
                JInternalFrame.JDesktopIcon jdi = (JInternalFrame.JDesktopIcon)comp;
                JInternalFrame jif = jdi.getInternalFrame();
                isWindowModified = Boolean.TRUE.equals(jif.getClientProperty("windowModified"));
                break;
            }
            if (isWindowModified) {
                colorScheme2 = SubstanceColorSchemeUtilities.YELLOW;
                colorScheme = SubstanceColorSchemeUtilities.ORANGE;
            }
        }
        if (!isWindowModified && !isPulsating && model.isEnabled() && (fadeState = SubstanceFadeUtilities.getFadeState((Component)button, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS)) != null) {
            colorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, state);
            colorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(button, prevState);
            borderScheme = SubstanceColorSchemeUtilities.getBorderColorScheme(button, state);
            borderScheme2 = SubstanceColorSchemeUtilities.getBorderColorScheme(button, prevState);
            cyclePos = fadeState.getFadePosition();
            if (fadeState.isFadingIn()) {
                cyclePos = 1.0f - cyclePos;
            }
        }
        Set<SubstanceConstants.Side> straightSides = SubstanceCoreUtilities.getSides(button, "substancelaf.buttonside");
        String straightKey = "";
        for (SubstanceConstants.Side sSide : straightSides) {
            straightKey = straightKey + sSide.name() + "-";
        }
        boolean isRoundButton = StandardButtonShaper.isRoundButton(button);
        float radius = 0.0f;
        if (shaper instanceof RectangularButtonShaper) {
            radius = ((RectangularButtonShaper)((Object)shaper)).getCornerRadius(button, null);
        }
        Set<SubstanceConstants.Side> openSides = SubstanceCoreUtilities.getSides(button, "substancelaf.buttonopenSide");
        boolean isContentAreaFilled = button.isContentAreaFilled();
        boolean isBorderPainted = button.isBorderPainted();
        HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, prevState.name(), state.name(), Float.valueOf(cyclePos), colorScheme.getDisplayName(), colorScheme2.getDisplayName(), borderScheme.getDisplayName(), borderScheme2.getDisplayName(), shaper.getDisplayName(), painter.getDisplayName(), borderPainter.getDisplayName(), straightKey, openSides, button.getClass().getName(), isRoundButton, Float.valueOf(radius), isContentAreaFilled, isBorderPainted, SubstanceSizeUtils.getComponentFontSize(button));
        BufferedImage existing = regularBackgrounds.get(key);
        if (existing == null) {
            int openDelta = (int)Math.ceil(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(button)));
            int deltaLeft = openSides.contains((Object)SubstanceConstants.Side.LEFT) ? openDelta : 0;
            int deltaRight = openSides.contains((Object)SubstanceConstants.Side.RIGHT) ? openDelta : 0;
            int deltaTop = openSides.contains((Object)SubstanceConstants.Side.TOP) ? openDelta : 0;
            int deltaBottom = openSides.contains((Object)SubstanceConstants.Side.BOTTOM) ? openDelta : 0;
            int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(button)) / 2.0);
            GeneralPath contour = shaper.getButtonOutline(button, new Insets(borderDelta, borderDelta, borderDelta, borderDelta), width + deltaLeft + deltaRight, height + deltaTop + deltaBottom);
            BufferedImage newBackground = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D finalGraphics = (Graphics2D)newBackground.getGraphics();
            finalGraphics.translate(-deltaLeft, -deltaTop);
            if (isContentAreaFilled) {
                painter.paintContourBackground(finalGraphics, button, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            }
            if (isBorderPainted) {
                int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(button));
                GeneralPath contourInner = shaper.getButtonOutline(button, new Insets(borderDelta + borderThickness, borderDelta + borderThickness, borderDelta + borderThickness, borderDelta + borderThickness), width + deltaLeft + deltaRight, height + deltaTop + deltaBottom);
                borderPainter.paintBorder(finalGraphics, button, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, contourInner, borderScheme, borderScheme2, cyclePos, borderScheme != borderScheme2);
            }
            regularBackgrounds.put(key, newBackground);
        }
        existing = regularBackgrounds.get(key);
        return existing;
    }

    public void updateBackground(Graphics g, AbstractButton button) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        if (SubstanceCoreUtilities.isButtonNeverPainted(button)) {
            return;
        }
        int width = button.getWidth();
        int height = button.getHeight();
        int y = 0;
        if (SubstanceCoreUtilities.isScrollButton(button) || SubstanceCoreUtilities.isSpinnerButton(button)) {
            Sideable sideable = (Sideable)((Object)button);
            PairwiseButtonBackgroundDelegate.updatePairwiseBackground(g, button, width, height, sideable.getSide(), false);
            return;
        }
        SubstanceGradientPainter painter = SubstanceCoreUtilities.getGradientPainter(button);
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(button);
        BufferedImage bgImage = ButtonBackgroundDelegate.getFullAlphaBackground(button, button.getModel(), shaper, painter, borderPainter, width, height);
        ComponentState state = ComponentState.getState(button);
        boolean isFlat = SubstanceCoreUtilities.hasFlatAppearance(button);
        boolean isSpecial = isFlat || !state.isKindActive(FadeKind.ENABLE);
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                if (FadeTracker.getInstance().isTracked(button, FadeKind.ROLLOVER) && !state.isKindActive(FadeKind.SELECTION) && state.isKindActive(FadeKind.ENABLE)) {
                    extraAlpha = FadeTracker.getInstance().getFade(button, FadeKind.ROLLOVER);
                } else if (state == ComponentState.DEFAULT) {
                    extraAlpha = 0.0f;
                }
                if (state == ComponentState.DISABLED_UNSELECTED) {
                    extraAlpha = 0.0f;
                }
            } else if (!state.isKindActive(FadeKind.ENABLE)) {
                extraAlpha = SubstanceColorSchemeUtilities.getAlpha(button, state);
            }
        }
        if (extraAlpha > 0.0f) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(TransitionLayout.getAlphaComposite(button, extraAlpha, g));
            graphics.drawImage((Image)bgImage, 0, y, null);
            graphics.dispose();
        }
    }

    public static boolean isRoundButton(AbstractButton button) {
        return !SubstanceCoreUtilities.isComboBoxButton(button) && !SubstanceCoreUtilities.isScrollButton(button) && SubstanceCoreUtilities.hasText(button);
    }

    public static boolean contains(AbstractButton button, int x, int y) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return false;
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        if (shaper == null) {
            return false;
        }
        GeneralPath contour = shaper.getButtonOutline(button);
        return contour.contains(x, y);
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceBackgroundDelegate: \n");
        sb.append("\t" + regularBackgrounds.size() + " regular");
        return sb.toString();
    }
}

