/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.icon.MenuArrowIcon;
import org.jvnet.substance.utils.menu.MenuUtilities;
import org.jvnet.substance.utils.menu.SubstanceMenu;

public class SubstanceMenuUI
extends BasicMenuUI
implements SubstanceMenu {
    protected MouseListener substanceMouseListener;
    protected FadeStateListener substanceFadeStateListener;
    protected MenuUtilities.MenuPropertyListener substanceMenuPropertyListener;
    protected PropertyChangeListener substancePropertyListener;
    protected FocusListener substanceFocusListener;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceMenuUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.menuItem.setRolloverEnabled(true);
        this.arrowIcon = new MenuArrowIcon(this.menuItem);
        this.defaultTextIconGap = SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(this.menuItem));
        this.menuItem.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.menuItem.putClientProperty("substancelaf.internal.highlightUse", Boolean.TRUE);
        LookAndFeel.installProperty(this.menuItem, "opaque", Boolean.FALSE);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceMenuPropertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.substanceMenuPropertyListener.install();
        this.substanceMouseListener = new MouseAdapter(){

            private boolean toRepaint() {
                MenuElement[] selectedMenuPath;
                for (MenuElement elem : selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()) {
                    if (elem != SubstanceMenuUI.this.menuItem) continue;
                    return true;
                }
                return selectedMenuPath.length == 0;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(true);
                    Rectangle bounds = SubstanceMenuUI.this.menuItem.getBounds();
                    SubstanceMenuUI.this.menuItem.getParent().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(false);
                    Rectangle bounds = SubstanceMenuUI.this.menuItem.getBounds();
                    SubstanceMenuUI.this.menuItem.getParent().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }
        };
        this.menuItem.addMouseListener(this.substanceMouseListener);
        this.substanceFocusListener = new FocusAdapter(){

            private boolean toRepaint() {
                MenuElement[] selectedMenuPath;
                for (MenuElement elem : selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()) {
                    if (elem != SubstanceMenuUI.this.menuItem) continue;
                    return true;
                }
                return selectedMenuPath.length == 0;
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(false);
                    Rectangle bounds = SubstanceMenuUI.this.menuItem.getBounds();
                    SubstanceMenuUI.this.menuItem.getParent().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }
        };
        this.menuItem.addFocusListener(this.substanceFocusListener);
        final HashSet<FadeKind> toIgnore = new HashSet<FadeKind>();
        this.substanceFadeStateListener = new FadeStateListener(this.menuItem, null, this.menuItem.getModel(), SubstanceCoreUtilities.getFadeCallback(this.menuItem, this.menuItem.getModel(), false, true, this.menuItem), toIgnore);
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceMenuUI.this.substanceFadeStateListener != null) {
                        SubstanceMenuUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceMenuUI.this.substanceFadeStateListener = new FadeStateListener(SubstanceMenuUI.this.menuItem, null, SubstanceMenuUI.this.menuItem.getModel(), SubstanceCoreUtilities.getFadeCallback(SubstanceMenuUI.this.menuItem, SubstanceMenuUI.this.menuItem.getModel(), false, false, SubstanceMenuUI.this.menuItem), toIgnore);
                    SubstanceMenuUI.this.substanceFadeStateListener.registerListeners();
                }
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SubstanceMenuUI.this.menuItem != null) {
                                SubstanceMenuUI.this.menuItem.updateUI();
                            }
                        }
                    });
                }
            }
        };
        this.menuItem.addPropertyChangeListener(this.substancePropertyListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.substanceMenuPropertyListener.uninstall();
        this.substanceMenuPropertyListener = null;
        this.menuItem.removeMouseListener(this.substanceMouseListener);
        this.substanceMouseListener = null;
        this.menuItem.removeFocusListener(this.substanceFocusListener);
        this.substanceFocusListener = null;
        this.menuItem.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
    }

    @Override
    public JMenuItem getAssociatedMenuItem() {
        return this.menuItem;
    }

    @Override
    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    @Override
    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    @Override
    public Icon getCheckIcon() {
        return null;
    }

    @Override
    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension superDim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        if (MenuUtilities.getPopupLayoutMetrics(this.menuItem, false) != null) {
            return new Dimension(MenuUtilities.getPreferredWidth(this.menuItem), superDim.height);
        }
        return superDim;
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        MenuUtilities.paintMenuItem(g, this.menuItem, checkIcon, arrowIcon, defaultTextIconGap);
    }
}

