/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.option;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.WriteableCommandLine;
import org.apache.commons.cli2.option.HelpLineImpl;
import org.apache.commons.cli2.option.OptionImpl;

public class PropertyOption
extends OptionImpl {
    public static final String DEFAULT_OPTION_STRING = "-D";
    public static final String DEFAULT_DESCRIPTION = "Passes properties and values to the application";
    public static final PropertyOption INSTANCE = new PropertyOption();
    private final String optionString;
    private final String description;
    private final Set prefixes;

    public PropertyOption() {
        this(DEFAULT_OPTION_STRING, DEFAULT_DESCRIPTION, 68);
    }

    public PropertyOption(String optionString, String description, int id) {
        super(id, false);
        this.optionString = optionString;
        this.description = description;
        this.prefixes = Collections.singleton(optionString);
    }

    @Override
    public boolean canProcess(WriteableCommandLine commandLine, String argument) {
        return argument != null && argument.startsWith(this.optionString) && argument.length() > this.optionString.length();
    }

    @Override
    public Set getPrefixes() {
        return this.prefixes;
    }

    @Override
    public void process(WriteableCommandLine commandLine, ListIterator arguments) throws OptionException {
        String value;
        String property;
        String arg = (String)arguments.next();
        if (!this.canProcess(commandLine, arg)) {
            throw new OptionException(this, "Unexpected.token", arg);
        }
        int propertyStart = this.optionString.length();
        int equalsIndex = arg.indexOf(61, propertyStart);
        if (equalsIndex < 0) {
            property = arg.substring(propertyStart);
            value = "true";
        } else {
            property = arg.substring(propertyStart, equalsIndex);
            value = arg.substring(equalsIndex + 1);
        }
        commandLine.addProperty(this, property, value);
    }

    @Override
    public Set getTriggers() {
        return Collections.singleton(this.optionString);
    }

    @Override
    public void validate(WriteableCommandLine commandLine) {
    }

    @Override
    public void appendUsage(StringBuffer buffer, Set helpSettings, Comparator comp) {
        boolean display = helpSettings.contains(DisplaySetting.DISPLAY_PROPERTY_OPTION);
        boolean bracketed = helpSettings.contains(DisplaySetting.DISPLAY_ARGUMENT_BRACKETED);
        if (display) {
            buffer.append(this.optionString);
            if (bracketed) {
                buffer.append('<');
            }
            buffer.append("property");
            if (bracketed) {
                buffer.append('>');
            }
            buffer.append("=");
            if (bracketed) {
                buffer.append('<');
            }
            buffer.append("value");
            if (bracketed) {
                buffer.append('>');
            }
        }
    }

    @Override
    public String getPreferredName() {
        return this.optionString;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List helpLines(int depth, Set helpSettings, Comparator comp) {
        if (helpSettings.contains(DisplaySetting.DISPLAY_PROPERTY_OPTION)) {
            HelpLineImpl helpLine = new HelpLineImpl(this, depth);
            return Collections.singletonList(helpLine);
        }
        return Collections.EMPTY_LIST;
    }
}

