/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.option.ArgumentImpl;
import org.apache.commons.cli2.resource.ResourceHelper;
import org.apache.commons.cli2.validation.Validator;

public class ArgumentBuilder {
    private static final ResourceHelper resources = ResourceHelper.getResourceHelper();
    private String name;
    private String description;
    private int minimum;
    private int maximum;
    private char initialSeparator;
    private char subsequentSeparator;
    private Validator validator;
    private String consumeRemaining;
    private List defaultValues;
    private int id;

    public ArgumentBuilder() {
        this.reset();
    }

    public final Argument create() {
        ArgumentImpl argument = new ArgumentImpl(this.name, this.description, this.minimum, this.maximum, this.initialSeparator, this.subsequentSeparator, this.validator, this.consumeRemaining, this.defaultValues, this.id);
        this.reset();
        return argument;
    }

    public final ArgumentBuilder reset() {
        this.name = "arg";
        this.description = null;
        this.minimum = 0;
        this.maximum = Integer.MAX_VALUE;
        this.initialSeparator = '\u0000';
        this.subsequentSeparator = '\u0000';
        this.validator = null;
        this.consumeRemaining = "--";
        this.defaultValues = null;
        this.id = 0;
        return this;
    }

    public final ArgumentBuilder withName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(resources.getMessage("ArgumentBuilder.null.name"));
        }
        if ("".equals(newName)) {
            throw new IllegalArgumentException(resources.getMessage("ArgumentBuilder.empty.name"));
        }
        this.name = newName;
        return this;
    }

    public final ArgumentBuilder withDescription(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public final ArgumentBuilder withMinimum(int newMinimum) {
        if (newMinimum < 0) {
            throw new IllegalArgumentException(resources.getMessage("ArgumentBuilder.negative.minimum"));
        }
        this.minimum = newMinimum;
        return this;
    }

    public final ArgumentBuilder withMaximum(int newMaximum) {
        if (newMaximum < 0) {
            throw new IllegalArgumentException(resources.getMessage("ArgumentBuilder.negative.maximum"));
        }
        this.maximum = newMaximum;
        return this;
    }

    public final ArgumentBuilder withInitialSeparator(char newInitialSeparator) {
        this.initialSeparator = newInitialSeparator;
        return this;
    }

    public final ArgumentBuilder withSubsequentSeparator(char newSubsequentSeparator) {
        this.subsequentSeparator = newSubsequentSeparator;
        return this;
    }

    public final ArgumentBuilder withValidator(Validator newValidator) {
        if (newValidator == null) {
            throw new IllegalArgumentException(resources.getMessage("ArgumentBuilder.null.validator"));
        }
        this.validator = newValidator;
        return this;
    }

    public final ArgumentBuilder withConsumeRemaining(String newConsumeRemaining) {
        if (newConsumeRemaining == null) {
            throw new IllegalArgumentException(resources.getMessage("ArgumentBuilder.null.consume.remaining"));
        }
        if ("".equals(newConsumeRemaining)) {
            throw new IllegalArgumentException(resources.getMessage("ArgumentBuilder.empty.consume.remaining"));
        }
        this.consumeRemaining = newConsumeRemaining;
        return this;
    }

    public final ArgumentBuilder withDefault(Object defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(resources.getMessage("ArgumentBuilder.null.default"));
        }
        if (this.defaultValues == null) {
            this.defaultValues = new ArrayList(1);
        }
        this.defaultValues.add(defaultValue);
        return this;
    }

    public final ArgumentBuilder withDefaults(List newDefaultValues) {
        if (newDefaultValues == null) {
            throw new IllegalArgumentException(resources.getMessage("ArgumentBuilder.null.defaults"));
        }
        this.defaultValues = newDefaultValues;
        return this;
    }

    public final ArgumentBuilder withId(int newId) {
        this.id = newId;
        return this;
    }
}

