/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultInputBlocker
extends Task.InputBlocker {
    private static final Logger logger = Logger.getLogger(DefaultInputBlocker.class.getName());
    private JDialog modalDialog = null;

    DefaultInputBlocker(Task task, Task.BlockingScope scope, Object target, ApplicationAction action) {
        super(task, scope, target, action);
    }

    private void setActionTargetBlocked(boolean f) {
        Action action = (Action)this.getTarget();
        action.setEnabled(!f);
    }

    private void setComponentTargetBlocked(boolean f) {
        Component c = (Component)this.getTarget();
        c.setEnabled(!f);
    }

    private void blockingDialogComponents(Component root, List<Component> rv) {
        String rootName = root.getName();
        if (rootName != null && rootName.startsWith("BlockingDialog")) {
            rv.add(root);
        }
        if (root instanceof Container) {
            for (Component child : ((Container)root).getComponents()) {
                this.blockingDialogComponents(child, rv);
            }
        }
    }

    private List<Component> blockingDialogComponents(Component root) {
        ArrayList<Component> rv = new ArrayList<Component>();
        this.blockingDialogComponents(root, rv);
        return rv;
    }

    private void injectBlockingDialogComponents(Component root) {
        ApplicationAction action;
        ResourceMap taskResourceMap = this.getTask().getResourceMap();
        if (taskResourceMap != null) {
            taskResourceMap.injectComponents(root);
        }
        if ((action = this.getAction()) != null) {
            ResourceMap actionResourceMap = action.getResourceMap();
            String actionName = action.getName();
            for (Component c : this.blockingDialogComponents(root)) {
                c.setName(actionName + "." + c.getName());
            }
            actionResourceMap.injectComponents(root);
        }
    }

    private JDialog createBlockingDialog() {
        JOptionPane optionPane = new JOptionPane();
        if (this.getTask().getUserCanCancel()) {
            JButton cancelButton = new JButton();
            cancelButton.setName("BlockingDialog.cancelButton");
            ActionListener doCancelTask = new ActionListener(){

                public void actionPerformed(ActionEvent ignore) {
                    DefaultInputBlocker.this.getTask().cancel(true);
                }
            };
            cancelButton.addActionListener(doCancelTask);
            optionPane.setOptions(new Object[]{cancelButton});
        } else {
            optionPane.setOptions(new Object[0]);
        }
        Component dialogOwner = (Component)this.getTarget();
        String taskTitle = this.getTask().getTitle();
        String dialogTitle = taskTitle == null ? "BlockingDialog" : taskTitle;
        final JDialog dialog = optionPane.createDialog(dialogOwner, dialogTitle);
        dialog.setModal(true);
        dialog.setName("BlockingDialog");
        dialog.setDefaultCloseOperation(0);
        WindowAdapter dialogCloseListener = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (DefaultInputBlocker.this.getTask().getUserCanCancel()) {
                    DefaultInputBlocker.this.getTask().cancel(true);
                    dialog.setVisible(false);
                }
            }
        };
        dialog.addWindowListener(dialogCloseListener);
        optionPane.setName("BlockingDialog.optionPane");
        this.injectBlockingDialogComponents(dialog);
        this.recreateOptionPaneMessage(optionPane);
        dialog.pack();
        return dialog;
    }

    private void recreateOptionPaneMessage(JOptionPane optionPane) {
        Object message = optionPane.getMessage();
        if (message instanceof String) {
            Font font = optionPane.getFont();
            final JTextArea textArea = new JTextArea((String)message);
            textArea.setFont(font);
            int lh = textArea.getFontMetrics(font).getHeight();
            Insets margin = new Insets(0, 0, lh, 24);
            textArea.setMargin(margin);
            textArea.setEditable(false);
            textArea.setWrapStyleWord(true);
            textArea.setBackground(optionPane.getBackground());
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)textArea, "Center");
            final JProgressBar progressBar = new JProgressBar();
            progressBar.setName("BlockingDialog.progressBar");
            progressBar.setIndeterminate(true);
            PropertyChangeListener taskPCL = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if ("progress".equals(e.getPropertyName())) {
                        progressBar.setIndeterminate(false);
                        progressBar.setValue((Integer)e.getNewValue());
                        DefaultInputBlocker.this.updateStatusBarString(progressBar);
                    } else if ("message".equals(e.getPropertyName())) {
                        textArea.setText((String)e.getNewValue());
                    }
                }
            };
            this.getTask().addPropertyChangeListener(taskPCL);
            panel.add((Component)progressBar, "South");
            this.injectBlockingDialogComponents(panel);
            optionPane.setMessage(panel);
        }
    }

    private void updateStatusBarString(JProgressBar progressBar) {
        if (!progressBar.isStringPainted()) {
            return;
        }
        String key = "progressBarStringFormat";
        if (progressBar.getClientProperty(key) == null) {
            progressBar.putClientProperty(key, progressBar.getString());
        }
        String fmt = (String)progressBar.getClientProperty(key);
        if (progressBar.getValue() <= 0) {
            progressBar.setString("");
        } else if (fmt == null) {
            progressBar.setString(null);
        } else {
            double pctComplete = (double)progressBar.getValue() / 100.0;
            long durSeconds = this.getTask().getExecutionDuration(TimeUnit.SECONDS);
            long durMinutes = durSeconds / 60L;
            long remSeconds = (long)(0.5 + (double)durSeconds / pctComplete) - durSeconds;
            long remMinutes = remSeconds / 60L;
            String s = String.format(fmt, durMinutes, durSeconds - durMinutes * 60L, remMinutes, remSeconds - remMinutes * 60L);
            progressBar.setString(s);
        }
    }

    private void showBusyGlassPane(boolean f) {
        RootPaneContainer rpc = null;
        for (Component root = (Component)this.getTarget(); root != null; root = root.getParent()) {
            if (!(root instanceof RootPaneContainer)) continue;
            rpc = (RootPaneContainer)((Object)root);
            break;
        }
        if (rpc != null) {
            String oldGPKey = "OldGlassPane";
            if (f) {
                BusyGlassPane glassPane = new BusyGlassPane();
                InputVerifier retainFocusWhileVisible = new InputVerifier(){

                    public boolean verify(JComponent c) {
                        return !c.isVisible();
                    }
                };
                glassPane.setInputVerifier(retainFocusWhileVisible);
                Component oldGlassPane = rpc.getGlassPane();
                rpc.getRootPane().putClientProperty(oldGPKey, oldGlassPane);
                rpc.setGlassPane(glassPane);
                glassPane.setVisible(true);
                glassPane.revalidate();
            } else {
                Component oldGlassPane = (Component)rpc.getRootPane().getClientProperty(oldGPKey);
                if (!oldGlassPane.isVisible()) {
                    rpc.getGlassPane().setVisible(false);
                }
                rpc.setGlassPane(oldGlassPane);
            }
        }
    }

    private int blockingDialogDelay() {
        Integer delay = null;
        String key = "BlockingDialogTimer.delay";
        ApplicationAction action = this.getAction();
        if (action != null) {
            ResourceMap actionResourceMap = action.getResourceMap();
            String actionName = action.getName();
            delay = actionResourceMap.getInteger(actionName + "." + key);
        }
        ResourceMap taskResourceMap = this.getTask().getResourceMap();
        if (delay == null && taskResourceMap != null) {
            delay = taskResourceMap.getInteger(key);
        }
        return delay == null ? 0 : delay;
    }

    private void showBlockingDialog(boolean f) {
        if (f) {
            if (this.modalDialog != null) {
                String msg = String.format("unexpected InputBlocker state [%s] %s", f, this);
                logger.warning(msg);
                this.modalDialog.dispose();
            }
            this.modalDialog = this.createBlockingDialog();
            ActionListener showModalDialog = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (DefaultInputBlocker.this.modalDialog != null) {
                        DefaultInputBlocker.this.modalDialog.setVisible(true);
                    }
                }
            };
            Timer showModalDialogTimer = new Timer(this.blockingDialogDelay(), showModalDialog);
            showModalDialogTimer.setRepeats(false);
            showModalDialogTimer.start();
        } else if (this.modalDialog != null) {
            this.modalDialog.dispose();
            this.modalDialog = null;
        } else {
            String msg = String.format("unexpected InputBlocker state [%s] %s", f, this);
            logger.warning(msg);
        }
    }

    @Override
    protected void block() {
        switch (this.getScope()) {
            case ACTION: {
                this.setActionTargetBlocked(true);
                break;
            }
            case COMPONENT: {
                this.setComponentTargetBlocked(true);
                break;
            }
            case WINDOW: 
            case APPLICATION: {
                this.showBusyGlassPane(true);
                this.showBlockingDialog(true);
            }
        }
    }

    @Override
    protected void unblock() {
        switch (this.getScope()) {
            case ACTION: {
                this.setActionTargetBlocked(false);
                break;
            }
            case COMPONENT: {
                this.setComponentTargetBlocked(false);
                break;
            }
            case WINDOW: 
            case APPLICATION: {
                this.showBusyGlassPane(false);
                this.showBlockingDialog(false);
            }
        }
    }

    private static class BusyGlassPane
    extends JPanel {
        BusyGlassPane() {
            super(null, false);
            this.setVisible(false);
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            MouseInputAdapter blockMouseEvents = new MouseInputAdapter(){};
            this.addMouseMotionListener(blockMouseEvents);
            this.addMouseListener(blockMouseEvents);
        }
    }
}

