/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionStorage {
    private static Logger logger = Logger.getLogger(SessionStorage.class.getName());
    private final Map<Class, Property> propertyMap;
    private final ApplicationContext context;

    protected SessionStorage(ApplicationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        this.context = context;
        this.propertyMap = new HashMap<Class, Property>();
        this.propertyMap.put(Window.class, new WindowProperty());
        this.propertyMap.put(JTabbedPane.class, new TabbedPaneProperty());
        this.propertyMap.put(JSplitPane.class, new SplitPaneProperty());
        this.propertyMap.put(JTable.class, new TableProperty());
    }

    protected final ApplicationContext getContext() {
        return this.context;
    }

    private void checkSaveRestoreArgs(Component root, String fileName) {
        if (root == null) {
            throw new IllegalArgumentException("null root");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
    }

    private String getComponentName(Component c) {
        return c.getName();
    }

    private String getComponentPathname(Component c) {
        String name = this.getComponentName(c);
        if (name == null) {
            return null;
        }
        StringBuilder path = new StringBuilder(name);
        while (c.getParent() != null && !(c instanceof Window) && !(c instanceof Applet)) {
            name = this.getComponentName(c = c.getParent());
            if (name == null) {
                int n = c.getParent().getComponentZOrder(c);
                if (n >= 0) {
                    Class<?> cls = c.getClass();
                    name = cls.getSimpleName();
                    if (name.length() == 0) {
                        name = "Anonymous" + cls.getSuperclass().getSimpleName();
                    }
                    name = name + n;
                } else {
                    logger.warning("Couldn't compute pathname for " + c);
                    return null;
                }
            }
            path.append("/").append(name);
        }
        return path.toString();
    }

    private void saveTree(List<Component> roots, Map<String, Object> stateMap) {
        ArrayList<Component> allChildren = new ArrayList<Component>();
        for (Component root : roots) {
            Component[] children;
            Object state;
            String pathname;
            Property p;
            if (root != null && (p = this.getProperty(root)) != null && (pathname = this.getComponentPathname(root)) != null && (state = p.getSessionState(root)) != null) {
                stateMap.put(pathname, state);
            }
            if (!(root instanceof Container) || (children = ((Container)root).getComponents()) == null || children.length <= 0) continue;
            Collections.addAll(allChildren, children);
        }
        if (allChildren.size() > 0) {
            this.saveTree(allChildren, stateMap);
        }
    }

    public void save(Component root, String fileName) throws IOException {
        this.checkSaveRestoreArgs(root, fileName);
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        this.saveTree(Collections.singletonList(root), stateMap);
        LocalStorage lst = this.getContext().getLocalStorage();
        lst.save(stateMap, fileName);
    }

    private void restoreTree(List<Component> roots, Map<String, Object> stateMap) {
        ArrayList<Component> allChildren = new ArrayList<Component>();
        for (Component root : roots) {
            Component[] children;
            String pathname;
            Property p;
            if (root != null && (p = this.getProperty(root)) != null && (pathname = this.getComponentPathname(root)) != null) {
                Object state = stateMap.get(pathname);
                if (state != null) {
                    p.setSessionState(root, state);
                } else {
                    logger.warning("No saved state for " + root);
                }
            }
            if (!(root instanceof Container) || (children = ((Container)root).getComponents()) == null || children.length <= 0) continue;
            Collections.addAll(allChildren, children);
        }
        if (allChildren.size() > 0) {
            this.restoreTree(allChildren, stateMap);
        }
    }

    public void restore(Component root, String fileName) throws IOException {
        this.checkSaveRestoreArgs(root, fileName);
        LocalStorage lst = this.getContext().getLocalStorage();
        Map stateMap = (Map)lst.load(fileName);
        if (stateMap != null) {
            this.restoreTree(Collections.singletonList(root), stateMap);
        }
    }

    private void checkClassArg(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("null class");
        }
    }

    public Property getProperty(Class cls) {
        this.checkClassArg(cls);
        while (cls != null) {
            Property p = this.propertyMap.get(cls);
            if (p != null) {
                return p;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public void putProperty(Class cls, Property property) {
        this.checkClassArg(cls);
        this.propertyMap.put(cls, property);
    }

    public final Property getProperty(Component c) {
        if (c == null) {
            throw new IllegalArgumentException("null component");
        }
        if (c instanceof Property) {
            return (Property)((Object)c);
        }
        Property p = null;
        if (c instanceof JComponent) {
            Object v = ((JComponent)c).getClientProperty(Property.class);
            p = v instanceof Property ? (Property)v : null;
        }
        return p != null ? p : this.getProperty(c.getClass());
    }

    public static class TableProperty
    implements Property {
        private void checkComponent(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(component instanceof JTable)) {
                throw new IllegalArgumentException("invalid component");
            }
        }

        public Object getSessionState(Component c) {
            this.checkComponent(c);
            JTable table = (JTable)c;
            int[] columnWidths = new int[table.getColumnCount()];
            boolean resizableColumnExists = false;
            for (int i = 0; i < columnWidths.length; ++i) {
                TableColumn tc = table.getColumnModel().getColumn(i);
                int n = columnWidths[i] = tc.getResizable() ? tc.getWidth() : -1;
                if (!tc.getResizable()) continue;
                resizableColumnExists = true;
            }
            return resizableColumnExists ? new TableState(columnWidths) : null;
        }

        public void setSessionState(Component c, Object state) {
            this.checkComponent(c);
            if (!(state instanceof TableState)) {
                throw new IllegalArgumentException("invalid state");
            }
            JTable table = (JTable)c;
            int[] columnWidths = ((TableState)state).getColumnWidths();
            if (table.getColumnCount() == columnWidths.length) {
                for (int i = 0; i < columnWidths.length; ++i) {
                    TableColumn tc;
                    if (columnWidths[i] == -1 || !(tc = table.getColumnModel().getColumn(i)).getResizable()) continue;
                    tc.setPreferredWidth(columnWidths[i]);
                }
            }
        }
    }

    public static class TableState {
        private int[] columnWidths = new int[0];

        private int[] copyColumnWidths(int[] columnWidths) {
            if (columnWidths == null) {
                throw new IllegalArgumentException("invalid columnWidths");
            }
            int[] copy = new int[columnWidths.length];
            System.arraycopy(columnWidths, 0, copy, 0, columnWidths.length);
            return copy;
        }

        public TableState() {
        }

        public TableState(int[] columnWidths) {
            this.columnWidths = this.copyColumnWidths(columnWidths);
        }

        public int[] getColumnWidths() {
            return this.copyColumnWidths(this.columnWidths);
        }

        public void setColumnWidths(int[] columnWidths) {
            this.columnWidths = this.copyColumnWidths(columnWidths);
        }
    }

    public static class SplitPaneProperty
    implements Property {
        private void checkComponent(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(component instanceof JSplitPane)) {
                throw new IllegalArgumentException("invalid component");
            }
        }

        public Object getSessionState(Component c) {
            this.checkComponent(c);
            JSplitPane p = (JSplitPane)c;
            return new SplitPaneState(p.getUI().getDividerLocation(p), p.getOrientation());
        }

        public void setSessionState(Component c, Object state) {
            this.checkComponent(c);
            if (state != null && !(state instanceof SplitPaneState)) {
                throw new IllegalArgumentException("invalid state");
            }
            JSplitPane p = (JSplitPane)c;
            SplitPaneState sps = (SplitPaneState)state;
            if (p.getOrientation() == sps.getOrientation()) {
                p.setDividerLocation(sps.getDividerLocation());
            }
        }
    }

    public static class SplitPaneState {
        private int dividerLocation = -1;
        private int orientation = 1;

        private void checkOrientation(int orientation) {
            if (orientation != 1 && orientation != 0) {
                throw new IllegalArgumentException("invalid orientation");
            }
        }

        public SplitPaneState() {
        }

        public SplitPaneState(int dividerLocation, int orientation) {
            this.checkOrientation(orientation);
            if (dividerLocation < -1) {
                throw new IllegalArgumentException("invalid dividerLocation");
            }
            this.dividerLocation = dividerLocation;
            this.orientation = orientation;
        }

        public int getDividerLocation() {
            return this.dividerLocation;
        }

        public void setDividerLocation(int dividerLocation) {
            if (dividerLocation < -1) {
                throw new IllegalArgumentException("invalid dividerLocation");
            }
            this.dividerLocation = dividerLocation;
        }

        public int getOrientation() {
            return this.orientation;
        }

        public void setOrientation(int orientation) {
            this.checkOrientation(orientation);
            this.orientation = orientation;
        }
    }

    public static class TabbedPaneProperty
    implements Property {
        private void checkComponent(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(component instanceof JTabbedPane)) {
                throw new IllegalArgumentException("invalid component");
            }
        }

        public Object getSessionState(Component c) {
            this.checkComponent(c);
            JTabbedPane p = (JTabbedPane)c;
            return new TabbedPaneState(p.getSelectedIndex(), p.getTabCount());
        }

        public void setSessionState(Component c, Object state) {
            this.checkComponent(c);
            if (state != null && !(state instanceof TabbedPaneState)) {
                throw new IllegalArgumentException("invalid state");
            }
            JTabbedPane p = (JTabbedPane)c;
            TabbedPaneState tps = (TabbedPaneState)state;
            if (p.getTabCount() == tps.getTabCount()) {
                p.setSelectedIndex(tps.getSelectedIndex());
            }
        }
    }

    public static class TabbedPaneState {
        private int selectedIndex;
        private int tabCount;

        public TabbedPaneState() {
            this.selectedIndex = -1;
            this.tabCount = 0;
        }

        public TabbedPaneState(int selectedIndex, int tabCount) {
            if (tabCount < 0) {
                throw new IllegalArgumentException("invalid tabCount");
            }
            if (selectedIndex < -1 || selectedIndex > tabCount) {
                throw new IllegalArgumentException("invalid selectedIndex");
            }
            this.selectedIndex = selectedIndex;
            this.tabCount = tabCount;
        }

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        public void setSelectedIndex(int selectedIndex) {
            if (selectedIndex < -1) {
                throw new IllegalArgumentException("invalid selectedIndex");
            }
            this.selectedIndex = selectedIndex;
        }

        public int getTabCount() {
            return this.tabCount;
        }

        public void setTabCount(int tabCount) {
            if (tabCount < 0) {
                throw new IllegalArgumentException("invalid tabCount");
            }
            this.tabCount = tabCount;
        }
    }

    public static class WindowProperty
    implements Property {
        private void checkComponent(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(component instanceof Window)) {
                throw new IllegalArgumentException("invalid component");
            }
        }

        private int getScreenCount() {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length;
        }

        public Object getSessionState(Component c) {
            GraphicsConfiguration gc;
            this.checkComponent(c);
            int frameState = 0;
            if (c instanceof Frame) {
                frameState = ((Frame)c).getExtendedState();
            }
            Rectangle gcBounds = (gc = c.getGraphicsConfiguration()) == null ? null : gc.getBounds();
            Rectangle frameBounds = c.getBounds();
            if (c instanceof JFrame && 0 != (frameState & 6)) {
                String clientPropertyKey = "WindowState.normalBounds";
                Object r = ((JFrame)c).getRootPane().getClientProperty(clientPropertyKey);
                if (r instanceof Rectangle) {
                    frameBounds = (Rectangle)r;
                }
            }
            return new WindowState(frameBounds, gcBounds, this.getScreenCount(), frameState);
        }

        public void setSessionState(Component c, Object state) {
            this.checkComponent(c);
            if (state != null && !(state instanceof WindowState)) {
                throw new IllegalArgumentException("invalid state");
            }
            Window w = (Window)c;
            if (!w.isLocationByPlatform() && state != null) {
                WindowState windowState = (WindowState)state;
                Rectangle gcBounds0 = windowState.getGraphicsConfigurationBounds();
                int sc0 = windowState.getScreenCount();
                GraphicsConfiguration gc = c.getGraphicsConfiguration();
                Rectangle gcBounds1 = gc == null ? null : gc.getBounds();
                int sc1 = this.getScreenCount();
                if (gcBounds0 != null && gcBounds0.equals(gcBounds1) && sc0 == sc1) {
                    w.setBounds(windowState.getBounds());
                }
                if (w instanceof Frame) {
                    ((Frame)w).setExtendedState(windowState.getFrameState());
                }
            }
        }
    }

    public static class WindowState {
        private final Rectangle bounds;
        private Rectangle gcBounds = null;
        private int screenCount;
        private int frameState = 0;

        public WindowState() {
            this.bounds = new Rectangle();
        }

        public WindowState(Rectangle bounds, Rectangle gcBounds, int screenCount, int frameState) {
            if (bounds == null) {
                throw new IllegalArgumentException("null bounds");
            }
            if (screenCount < 1) {
                throw new IllegalArgumentException("invalid screenCount");
            }
            this.bounds = bounds;
            this.gcBounds = gcBounds;
            this.screenCount = screenCount;
            this.frameState = frameState;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.bounds);
        }

        public void setBounds(Rectangle bounds) {
            this.bounds.setBounds(bounds);
        }

        public int getScreenCount() {
            return this.screenCount;
        }

        public void setScreenCount(int screenCount) {
            this.screenCount = screenCount;
        }

        public int getFrameState() {
            return this.frameState;
        }

        public void setFrameState(int frameState) {
            this.frameState = frameState;
        }

        public Rectangle getGraphicsConfigurationBounds() {
            return this.gcBounds == null ? null : new Rectangle(this.gcBounds);
        }

        public void setGraphicsConfigurationBounds(Rectangle gcBounds) {
            this.gcBounds = gcBounds == null ? null : new Rectangle(gcBounds);
        }
    }

    public static interface Property {
        public Object getSessionState(Component var1);

        public void setSessionState(Component var1, Object var2);
    }
}

