/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.http.ntlm;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class NTLMResponses {
    public static byte[] LM_HASH_MAGIC_CONSTANT = null;

    public static byte[] getLMResponse(String string, byte[] byArray) throws Exception {
        byte[] byArray2 = NTLMResponses.lmHash(string);
        return NTLMResponses.lmResponse(byArray2, byArray);
    }

    public static byte[] getNTLMResponse(String string, byte[] byArray) throws Exception {
        byte[] byArray2 = NTLMResponses.ntlmHash(string);
        return NTLMResponses.lmResponse(byArray2, byArray);
    }

    private static byte[] lmHash(String string) throws Exception {
        byte[] byArray = string.toUpperCase().getBytes("US-ASCII");
        int n = Math.min(byArray.length, 14);
        byte[] byArray2 = new byte[14];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        Key key = NTLMResponses.createDESKey(byArray2, 0);
        Key key2 = NTLMResponses.createDESKey(byArray2, 7);
        Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
        cipher.init(1, key);
        byte[] byArray3 = cipher.doFinal(LM_HASH_MAGIC_CONSTANT);
        cipher.init(1, key2);
        byte[] byArray4 = cipher.doFinal(LM_HASH_MAGIC_CONSTANT);
        byte[] byArray5 = new byte[16];
        System.arraycopy(byArray3, 0, byArray5, 0, 8);
        System.arraycopy(byArray4, 0, byArray5, 8, 8);
        return byArray5;
    }

    private static byte[] ntlmHash(String string) throws Exception {
        byte[] byArray = string.getBytes("UnicodeLittleUnmarked");
        MessageDigest messageDigest = MessageDigest.getInstance("MD4");
        return messageDigest.digest(byArray);
    }

    private static byte[] lmResponse(byte[] byArray, byte[] byArray2) throws Exception {
        byte[] byArray3 = new byte[21];
        System.arraycopy(byArray, 0, byArray3, 0, 16);
        Key key = NTLMResponses.createDESKey(byArray3, 0);
        Key key2 = NTLMResponses.createDESKey(byArray3, 7);
        Key key3 = NTLMResponses.createDESKey(byArray3, 14);
        Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
        cipher.init(1, key);
        byte[] byArray4 = cipher.doFinal(byArray2);
        cipher.init(1, key2);
        byte[] byArray5 = cipher.doFinal(byArray2);
        cipher.init(1, key3);
        byte[] byArray6 = cipher.doFinal(byArray2);
        byte[] byArray7 = new byte[24];
        System.arraycopy(byArray4, 0, byArray7, 0, 8);
        System.arraycopy(byArray5, 0, byArray7, 8, 8);
        System.arraycopy(byArray6, 0, byArray7, 16, 8);
        return byArray7;
    }

    private static Key createDESKey(byte[] byArray, int n) {
        byte[] byArray2 = new byte[7];
        System.arraycopy(byArray, n, byArray2, 0, 7);
        byte[] byArray3 = new byte[]{byArray2[0], (byte)(byArray2[0] << 7 | (byArray2[1] & 0xFF) >>> 1), (byte)(byArray2[1] << 6 | (byArray2[2] & 0xFF) >>> 2), (byte)(byArray2[2] << 5 | (byArray2[3] & 0xFF) >>> 3), (byte)(byArray2[3] << 4 | (byArray2[4] & 0xFF) >>> 4), (byte)(byArray2[4] << 3 | (byArray2[5] & 0xFF) >>> 5), (byte)(byArray2[5] << 2 | (byArray2[6] & 0xFF) >>> 6), (byte)(byArray2[6] << 1)};
        NTLMResponses.oddParity(byArray3);
        return new SecretKeySpec(byArray3, "DES");
    }

    private static void oddParity(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            boolean bl;
            byte by = byArray[i];
            boolean bl2 = bl = ((by >>> 7 ^ by >>> 6 ^ by >>> 5 ^ by >>> 4 ^ by >>> 3 ^ by >>> 2 ^ by >>> 1) & 1) == 0;
            if (bl) {
                int n = i;
                byArray[n] = (byte)(byArray[n] | 1);
                continue;
            }
            int n = i;
            byArray[n] = (byte)(byArray[n] & 0xFFFFFFFE);
        }
    }

    static {
        try {
            LM_HASH_MAGIC_CONSTANT = "KGS!@#$%".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }
}

