/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.option;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.WriteableCommandLine;
import org.apache.commons.cli2.option.ParentImpl;
import org.apache.commons.cli2.resource.ResourceHelper;

public class Command
extends ParentImpl {
    private final String preferredName;
    private final Set aliases;
    private final Set triggers;

    public Command(String preferredName, String description, Set aliases, boolean required, Argument argument, Group children, int id) {
        super(argument, children, description, id, required);
        if (preferredName == null || preferredName.length() < 1) {
            throw new IllegalArgumentException(ResourceHelper.getResourceHelper().getMessage("Command.preferredName.too.short"));
        }
        this.preferredName = preferredName;
        this.aliases = aliases == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(aliases));
        HashSet<String> newTriggers = new HashSet<String>();
        newTriggers.add(preferredName);
        newTriggers.addAll(this.aliases);
        this.triggers = Collections.unmodifiableSet(newTriggers);
    }

    @Override
    public void processParent(WriteableCommandLine commandLine, ListIterator arguments) throws OptionException {
        String arg = (String)arguments.next();
        if (!this.canProcess(commandLine, arg)) {
            throw new OptionException(this, "Unexpected.token", arg);
        }
        commandLine.addOption(this);
        arguments.set(this.preferredName);
    }

    @Override
    public Set getTriggers() {
        return this.triggers;
    }

    @Override
    public void validate(WriteableCommandLine commandLine) throws OptionException {
        if (this.isRequired() && !commandLine.hasOption(this)) {
            throw new OptionException(this, "Option.missing.required", this.getPreferredName());
        }
        super.validate(commandLine);
    }

    @Override
    public void appendUsage(StringBuffer buffer, Set helpSettings, Comparator comp) {
        boolean optional = !this.isRequired() && helpSettings.contains(DisplaySetting.DISPLAY_OPTIONAL);
        boolean displayAliases = helpSettings.contains(DisplaySetting.DISPLAY_ALIASES);
        if (optional) {
            buffer.append('[');
        }
        buffer.append(this.preferredName);
        if (displayAliases && !this.aliases.isEmpty()) {
            buffer.append(" (");
            ArrayList list = new ArrayList(this.aliases);
            Collections.sort(list);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String alias = (String)i.next();
                buffer.append(alias);
                if (!i.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append(')');
        }
        super.appendUsage(buffer, helpSettings, comp);
        if (optional) {
            buffer.append(']');
        }
    }

    @Override
    public String getPreferredName() {
        return this.preferredName;
    }
}

