/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.WinPreferencesFactory;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.ResourceMap;

public final class AppPrefs {
    private static final Logger logger = Logger.getLogger(AppPrefs.class.getName());
    private final String propertiesFileName;
    private static volatile Preferences properties;
    private final ApplicationContext context;
    private String userNode;
    private static final String CONFIG_DIR = "config";
    private boolean pendingChanges;
    private static final Timer syncTimer;
    private static final int SYNC_INTERVAL = 30;
    private final Object syncLock = new Object();

    AppPrefs(ApplicationContext context, Map<String, String> properties, boolean resetOptions) {
        String blindMode;
        this.context = context;
        String id = context.getResourceMap().getString("Application.id", new Object[0]);
        if (id == null || id.isEmpty()) {
            throw new IllegalStateException("Config property Application.ID is empty!");
        }
        this.propertiesFileName = id.toLowerCase() + ".xml";
        AppPrefs.properties = this.loadProperties();
        if (resetOptions) {
            try {
                AppPrefs.properties.clear();
            }
            catch (BackingStoreException e) {
                LogUtils.processException(logger, e);
            }
        }
        if (AppPrefs.getProperty("detectBlindMode", AppPrefs.getProperty("blindMode", false)) && (blindMode = System.getProperty("javax.accessibility.assistive_technologies", null)) != null) {
            logger.info("Detecting blindMode " + blindMode);
            AppPrefs.storeProperty("blindMode", true);
        }
        if (!properties.isEmpty()) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String value = entry.getValue();
                if ("default".equals(value)) {
                    AppPrefs.properties.remove(entry.getKey());
                    continue;
                }
                AppPrefs.properties.put(entry.getKey(), value);
            }
        }
        if (Utils.isWindows()) {
            AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("Property changed: " + evt.getKey());
                    }
                    Object object = AppPrefs.this.syncLock;
                    synchronized (object) {
                        if (!"proxy.password".equals(evt.getKey())) {
                            AppPrefs.this.pendingChanges = true;
                        }
                    }
                }
            });
            syncTimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = AppPrefs.this.syncLock;
                    synchronized (object) {
                        if (AppPrefs.this.pendingChanges) {
                            AppPrefs.this.sync();
                        }
                    }
                }
            }, 30000L, 30000L);
        }
    }

    public static int getProperty(String key, int defaultValue) {
        return AppPrefs.getPreferences().getInt(key, defaultValue);
    }

    public static long getProperty(String key, long defaultValue) {
        return AppPrefs.getPreferences().getLong(key, defaultValue);
    }

    public static boolean getProperty(String key, boolean defaultValue) {
        return AppPrefs.getPreferences().getBoolean(key, defaultValue);
    }

    public static String getProperty(String key) {
        return AppPrefs.getPreferences().get(key, null);
    }

    public static void storeProperty(String key, boolean value) {
        AppPrefs.getPreferences().putBoolean(key, value);
    }

    public static void storeProperty(String key, String value) {
        if (value == null) {
            AppPrefs.getPreferences().remove(key);
        } else {
            AppPrefs.getPreferences().put(key, value);
        }
    }

    public static void storeProperty(String key, int value) {
        AppPrefs.getPreferences().putInt(key, value);
    }

    public static void storeProperty(String key, long value) {
        AppPrefs.getPreferences().putLong(key, value);
    }

    public static String getProperty(String key, String defaultValue) {
        return AppPrefs.getPreferences().get(key, defaultValue);
    }

    public static void removeProperty(String key) {
        AppPrefs.getPreferences().remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        Object object = this.syncLock;
        synchronized (object) {
            this.sync();
        }
    }

    private void sync() {
        OutputStream outputStream = null;
        try {
            LocalStorage localStorage;
            File outDir;
            if (!AppPrefs.getProperty("proxy.savepassword", false)) {
                AppPrefs.removeProperty("proxy.password");
            }
            if (!((outDir = (localStorage = this.context.getLocalStorage()).getDirectory()).exists() || outDir.isDirectory() || outDir.mkdirs())) {
                logger.warning("Couldn't create dir " + outDir);
            }
            outputStream = new FileOutputStream(new File(outDir, this.propertiesFileName));
            AppPrefs.getPreferences().exportNode(outputStream);
            outputStream.close();
            logger.config("Preferences were saved successfuly");
            this.pendingChanges = false;
        }
        catch (IOException e) {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, e.getMessage(), ex);
            }
            logger.severe("Couldn't save app getPreferences(). This is a fatal error. Please reinstall the application.");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private String getUserNode() {
        if (this.userNode == null) {
            ResourceMap map = this.context.getResourceMap();
            String vendor = map.getString("Application.vendorId", new Object[0]);
            String applicationID = map.getString("Application.id", new Object[0]);
            if (vendor.isEmpty() || applicationID.isEmpty()) {
                logger.warning("AppPrefs - vendor or application ID is empty");
            }
            this.userNode = vendor.toLowerCase() + "/" + applicationID.toLowerCase();
        }
        return this.userNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preferences loadProperties() {
        if (Utils.isWindows()) {
            System.getProperties().put("java.util.prefs.PreferencesFactory", WinPreferencesFactory.class.getName());
        }
        LocalStorage localStorage = this.context.getLocalStorage();
        if (System.getProperties().containsKey("portable")) {
            localStorage.setDirectory(new File(Utils.getAppPath(), CONFIG_DIR));
        }
        File storageDir = localStorage.getDirectory();
        logger.info("Config files directory: " + storageDir.getAbsolutePath());
        File userFile = new File(storageDir, this.propertiesFileName);
        if (!userFile.exists()) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "File with user settings " + userFile + " was not found. First run. Using default settings");
            }
            return Preferences.userRoot().node(this.getUserNode());
        }
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(storageDir, this.propertiesFileName));
            Preferences.importPreferences(inputStream);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.CONFIG, "User preferences file was not found (first application start?)");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return Preferences.userRoot().node(this.getUserNode());
    }

    public static void initEmptyPreferences() {
        properties = Preferences.userRoot();
    }

    public static Preferences getPreferences() {
        if (properties == null) {
            throw new IllegalStateException("Properties were not initialized yet");
        }
        return properties;
    }

    public static void negateProperty(String key, boolean defaultValue) {
        AppPrefs.storeProperty(key, !AppPrefs.getProperty(key, defaultValue));
    }

    static {
        syncTimer = new Timer("AppPrefsSyncTimer", true);
    }
}

