/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public class FileTypeIconProvider {
    private static final Logger logger = Logger.getLogger(FileTypeIconProvider.class.getName());
    private static final Pattern fileExtensionPattern = Pattern.compile("[\\.\\-_]([a-z\\d]+?)$");
    private static final Pattern fileNamePattern = Pattern.compile("/([^/]*?(\\.|-)(zip|rar|avi|wmv|mp\\d?|srt|sub|apk))\\.html?", 10);
    private static final Pattern encodedPattern = Pattern.compile("%[A-Z0-9]{2}%");
    private final Map<String, Icon> systemIcons = new ConcurrentHashMap<String, Icon>();
    private final ResourceMap resourceMap;

    public FileTypeIconProvider(ApplicationContext context) {
        this.resourceMap = context.getResourceMap();
    }

    public static String identifyFileType(String fileName) {
        if (fileName == null) {
            return "";
        }
        Matcher matcher = fileExtensionPattern.matcher(fileName = fileName.toLowerCase(Locale.ENGLISH));
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String identifyFileName(String url) {
        Matcher matcher = fileNamePattern.matcher(url);
        if (matcher.find()) {
            return FileTypeIconProvider.checkEncodedFileName(matcher.group(1));
        }
        String[] strings = url.split("/");
        for (int i = strings.length - 1; i >= 0; --i) {
            String s = strings[i].trim();
            if (s.isEmpty()) continue;
            return s;
        }
        String s = url.replace(":", "_").trim();
        if (s.startsWith("?")) {
            s = s.substring(1);
        }
        if (s.isEmpty()) {
            return "?";
        }
        return FileTypeIconProvider.checkEncodedFileName(s);
    }

    private static String checkEncodedFileName(String name) {
        if (encodedPattern.matcher(name).find()) {
            return Utils.urlDecode(name);
        }
        return name;
    }

    public Icon getIconImageByFileType(String fileType, boolean bigImage) {
        if (fileType == null) {
            return null;
        }
        if (AppPrefs.getProperty("useSystemIcons", true)) {
            fileType = fileType.toLowerCase(Locale.ENGLISH);
            return this.getSystemIcon(fileType, bigImage);
        }
        fileType = fileType.toUpperCase(Locale.ENGLISH);
        String base = bigImage ? "iconFileTypeBig_" + fileType : "iconFileTypeSmall_" + fileType;
        if (this.resourceMap.containsKey(base)) {
            return this.resourceMap.getImageIcon(base);
        }
        if (bigImage) {
            return this.resourceMap.getImageIcon("iconFileTypeBig_ISO");
        }
        return this.resourceMap.getImageIcon("iconFileTypeSmall_ISO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getSystemIcon(String extension, boolean bigImage) {
        Icon icon = this.systemIcons.get(extension + bigImage);
        if (icon != null) {
            return icon;
        }
        File file = null;
        try {
            file = File.createTempFile("icon", "." + extension);
            icon = bigImage ? FileTypeIconProvider.getShellFolderIcon(file) : FileSystemView.getFileSystemView().getSystemIcon(file);
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassFormatError classFormatError) {
        }
        finally {
            if (file != null && !file.delete()) {
                logger.warning("Failed to delete temporary file " + file);
            }
        }
        if (icon == null) {
            icon = bigImage ? this.resourceMap.getImageIcon("iconFileTypeBig_UNKNOWN") : this.resourceMap.getImageIcon("iconFileTypeSmall_UNKNOWN");
        }
        this.systemIcons.put(extension + bigImage, icon);
        return icon;
    }

    private static Icon getShellFolderIcon(File file) {
        try {
            Method method = Class.forName("sun.awt.shell.ShellFolder").getMethod("getShellFolder", File.class);
            Object sf = method.invoke(null, file);
            Method m = sf.getClass().getMethod("getIcon", Boolean.TYPE);
            m.setAccessible(true);
            Object result = m.invoke(sf, true);
            if (result != null) {
                return new ImageIcon((Image)result);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

