/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.application;

import cz.vity.freerapid.core.AppPrefs;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.swingx.error.ErrorInfo;

public class SubmitErrorInfo
extends AbstractBean {
    private String name = "";
    private String email = "";
    private String comment = "";
    private ErrorInfo errorInfo;

    public SubmitErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
        this.setName(AppPrefs.getProperty("submitError.name"));
        this.setEmail(AppPrefs.getProperty("submitError.email"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.getName();
        this.name = name;
        this.firePropertyChange("name", oldValue, name);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        String oldValue = this.getEmail();
        this.email = email;
        this.firePropertyChange("email", oldValue, email);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.comment = comment;
        this.firePropertyChange("comment", oldValue, comment);
    }

    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    private static String getUserInfo() {
        StringBuilder builder = new StringBuilder();
        String unknown = "Unknown";
        builder.append("java.version=").append(System.getProperty("java.version", "Unknown")).append('\n');
        builder.append("os.name=").append(System.getProperty("os.name", "Unknown")).append('\n');
        builder.append("user.language=").append(System.getProperty("user.language", "Unknown")).append('\n');
        builder.append("user.name=").append(System.getProperty("user.name", "Unknown")).append('\n');
        builder.append("user.dir=").append(System.getProperty("user.dir", "Unknown")).append('\n');
        builder.append("user.country=").append(System.getProperty("user.country", "Unknown")).append('\n');
        return builder.toString();
    }

    public void toURLPostData(PostMethod method) {
        String email = this.getEmail();
        if (email == null) {
            email = "";
        }
        AppPrefs.storeProperty("submitError.email", email);
        String name = this.getName();
        if (name == null) {
            name = "";
        }
        AppPrefs.storeProperty("submitError.name", name);
        method.addParameter("product", "FreeRapid");
        method.addParameter("version", "1.0beta");
        method.addParameter("name", name);
        method.addParameter("locale", Locale.getDefault().getLanguage());
        method.addParameter("os", System.getProperty("os.name", "Unknown"));
        method.addParameter("comment", this.getComment());
        method.addParameter("email", email);
        method.addParameter("userinfo", SubmitErrorInfo.getUserInfo());
        this.getErrorInfo().getErrorException().printStackTrace();
        StringWriter sw = new StringWriter();
        this.getErrorInfo().getErrorException().printStackTrace(new PrintWriter(sw));
        method.addParameter("exception", sw.toString());
    }
}

