/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CheckPluginUpdateTask;
import cz.vity.freerapid.core.tasks.ConnectResult;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.core.tasks.exceptions.NoAvailableConnection;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadClient;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class CheckForNewVersionTask
extends CoreTask<ConnectResult, Void> {
    private static final Logger logger = Logger.getLogger(CheckForNewVersionTask.class.getName());
    private static final String PARAM_VERSION = "version";
    private static final String PARAM_LANGUAGE = "lang";
    private static final String PARAM_VERSION_ONLY = "versiononly";
    private static final String PARAM_COUNTRY = "country";
    private final boolean showInfoMessages;
    private static int counter = 0;
    private String newVersionURL;

    public CheckForNewVersionTask(boolean showInfoMessages) {
        super(Application.getInstance());
        logger.info("Starting to check for a new version");
        this.showInfoMessages = showInfoMessages;
        this.setUserCanCancel(false);
        this.setDescription("");
        this.setMessage("");
        this.setTaskToForeground();
    }

    @Override
    protected ConnectResult doInBackground() throws Exception {
        if (counter++ > 4) {
            return ConnectResult.SAME_VERSION;
        }
        this.message("message.connecting", new Object[0]);
        String url = AppPrefs.getProperty("checkForNewVersionURL", "http://wordrider.net/checkfrd.php");
        ClientManager clientManager = ((MainApp)this.getApplication()).getManagerDirector().getClientManager();
        List<ConnectionSettings> connectionSettingses = clientManager.getEnabledConnections();
        ResourceMap map = this.getApplication().getContext().getResourceMap(CheckPluginUpdateTask.class);
        if (connectionSettingses.isEmpty()) {
            throw new NoAvailableConnection(map.getString("noAvailableConnection", new Object[0]));
        }
        DownloadClient client = new DownloadClient();
        client.initClient(connectionSettingses.get(0));
        PostMethod postMethod = client.getPostMethod(url);
        postMethod.addParameter(PARAM_VERSION, "FreeRapid 1.0beta");
        postMethod.addParameter(PARAM_VERSION_ONLY, "1.0beta");
        Locale locale = Locale.getDefault();
        postMethod.addParameter(PARAM_LANGUAGE, locale.getLanguage());
        postMethod.addParameter(PARAM_COUNTRY, locale.getCountry());
        logger.info("Connected to the web, Writing params");
        this.message("message.connect.status.checking", new Object[0]);
        if (client.makeRequest(postMethod, true) != 200) {
            throw new ConnectException(map.getString("Connection_failed", new Object[0]));
        }
        this.message("message.checkingData", new Object[0]);
        if (this.isCancelled()) {
            throw new InterruptedException();
        }
        logger.info("disconnecting");
        this.message("message.connect.status.disconnect", new Object[0]);
        String line = client.getContentAsString();
        if (line != null) {
            String lineL = line.toLowerCase();
            if (lineL.contains("required")) {
                int i = lineL.indexOf("http://");
                this.newVersionURL = i != -1 ? line.substring(i).trim() : "http://wordrider.net/freerapid";
                return ConnectResult.NEW_VERSION_REQUIRED;
            }
            if (lineL.contains("yes")) {
                return ConnectResult.CONNECT_NEW_VERSION;
            }
            return ConnectResult.SAME_VERSION;
        }
        return ConnectResult.SAME_VERSION;
    }

    @Override
    protected void succeeded(ConnectResult result) {
        super.succeeded(result);
        switch (result) {
            case SAME_VERSION: {
                if (!this.showInfoMessages) break;
                Swinger.showInformationDialog(this.getResourceMap().getString("message.connect.sameVersion", new Object[0]));
                break;
            }
            case NEW_VERSION_REQUIRED: {
                Swinger.showInformationDialog(this.getResourceMap().getString("message.connect.newVersionRequired", new Object[0]));
                Browser.openBrowser(this.newVersionURL);
                this.getApplication().exit();
                return;
            }
            case CONNECT_NEW_VERSION: {
                int res = Swinger.getChoiceYesNo(this.getResourceMap().getString("message.connect.newVersion", new Object[0]));
                if (res != 0) break;
                Browser.showHomepage();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    protected void failed(Throwable cause) {
        LogUtils.processException(logger, cause);
        if (this.handleRuntimeException(cause)) {
            return;
        }
        if (!this.showInfoMessages) {
            return;
        }
        if (cause instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_submit_failed", cause.getMessage());
        }
    }
}

