/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.QuietMode;
import cz.vity.freerapid.core.tasks.CloseInTimeTask;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.core.tasks.CountingOutputStream;
import cz.vity.freerapid.core.tasks.DownloadTaskError;
import cz.vity.freerapid.core.tasks.MoveFileTask;
import cz.vity.freerapid.core.tasks.SpeedRegulator;
import cz.vity.freerapid.gui.FRDUtils;
import cz.vity.freerapid.gui.managers.TaskServiceManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.exceptions.CaptchaEntryInputMismatchException;
import cz.vity.freerapid.plugins.exceptions.ErrorDuringDownloadingException;
import cz.vity.freerapid.plugins.exceptions.InvalidURLOrServiceProblemException;
import cz.vity.freerapid.plugins.exceptions.NotEnoughSpaceException;
import cz.vity.freerapid.plugins.exceptions.NotRecoverableDownloadException;
import cz.vity.freerapid.plugins.exceptions.PluginImplementationException;
import cz.vity.freerapid.plugins.exceptions.URLNotAvailableAnymoreException;
import cz.vity.freerapid.plugins.exceptions.YouHaveToWaitException;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.FileState;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFileDownloadTask;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Sound;
import cz.vity.freerapid.utilities.Utils;
import java.awt.EventQueue;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.jdesktop.application.Application;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;

public class DownloadTask
extends CoreTask<Void, Long>
implements HttpFileDownloadTask {
    private static final Logger logger = Logger.getLogger(DownloadTask.class.getName());
    private static final int FILE_ALREADY_EXISTS_MAGIC = -2;
    protected HttpDownloadClient client;
    protected DownloadFile downloadFile;
    protected ShareDownloadService service;
    private Integer sleep = 0;
    private static Timer timer = new Timer();
    private DownloadTaskError serviceError;
    private int youHaveToSleepSecondsTime = 0;
    private static final int INPUT_BUFFER_SIZE = 1024;
    private static final int OUTPUT_FILE_BUFFER_SIZE = 600000;
    private volatile boolean connectionTimeOut;
    private int fileAlreadyExists;
    private volatile byte[] buffer;
    private boolean useRelativeStoreFileIfPossible = true;
    private boolean skipped = false;

    public DownloadTask(Application application) {
        super(application);
        this.init();
    }

    public DownloadTask(Application application, HttpDownloadClient client, DownloadFile downloadFile, ShareDownloadService service) {
        super(application);
        this.client = client;
        this.downloadFile = downloadFile;
        this.service = service;
        this.init();
        downloadFile.setConnectionSettings(client.getSettings());
    }

    protected void init() {
        this.serviceError = DownloadTaskError.NO_ERROR;
        this.setInputBlocker(null);
        this.setUserCanCancel(true);
        this.youHaveToSleepSecondsTime = 0;
        this.connectionTimeOut = false;
        this.fileAlreadyExists = -2;
    }

    @Override
    protected Void doInBackground() throws Exception {
        int seconds;
        this.initDownloadThread();
        if (AppPrefs.getProperty("blindMode", false)) {
            Sound.playSound(this.getContext().getResourceMap().getString("fileAdded", new Object[0]));
        }
        if (this.downloadFile.getDownloaded() < 0L) {
            this.downloadFile.setDownloaded(0L);
        }
        if ((seconds = AppPrefs.getProperty("firstSleepTime", 4)) > 0) {
            this.sleep(seconds);
        }
        this.downloadFile.setState(DownloadState.GETTING);
        try {
            this.service.run(this);
        }
        catch (IllegalStateException e) {
            throw new Exception(e);
        }
        this.service = null;
        return null;
    }

    protected void initDownloadThread() {
        this.client.getHTTPClient().setHttpConnectionManager(new SimpleHttpConnectionManager());
        int timerPurge = timer.purge();
        if (timerPurge > 0) {
            logger.info("Purged timers " + timerPurge);
        }
        this.client.getHTTPClient().getHttpConnectionManager().closeIdleConnections(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountingOutputStream getFileOutputStream(File f, long fileSize, long startPosition) throws NotEnoughSpaceException, IOException {
        OutputStream fos;
        long freeSpace = f.getParentFile().getUsableSpace();
        logger.info("Free space on disk: " + freeSpace);
        int minDiskSpace = AppPrefs.getProperty("minDiskSpaceMB", 30);
        if (freeSpace < fileSize + (long)(minDiskSpace * 1024) * 1024L - (f.exists() ? f.length() : 0L)) {
            if (f.exists() && f.length() == 0L && !f.delete()) {
                logger.warning("Cannot delete temporary file");
            }
            throw new NotEnoughSpaceException();
        }
        if (AppPrefs.getProperty("preCreateFile", false) && this.client.getHTTPClient().getParams().isParameterFalse("noContentLengthAvailable")) {
            Class<DownloadTask> clazz = DownloadTask.class;
            synchronized (DownloadTask.class) {
                if (this.isTerminated()) {
                    // ** MonitorExit[var10_6] (shouldn't be in output)
                    return null;
                }
                fos = FileUtils.createEmptyFile(f, fileSize, startPosition, this);
                if (this.isTerminated()) {
                    // ** MonitorExit[var10_6] (shouldn't be in output)
                    return null;
                }
                // ** MonitorExit[var10_6] (shouldn't be in output)
            }
        } else if (startPosition == 0L) {
            fos = new FileOutputStream(f);
        } else {
            RandomAccessFile raf = new RandomAccessFile(f, "rw");
            raf.seek(startPosition);
            fos = new FileOutputStream(raf.getFD());
        }
        return new CountingOutputStream(fos);
    }

    @Override
    public boolean isTerminated() {
        return this.isCancelled() || Thread.currentThread().isInterrupted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveToFile(InputStream inputStream) throws Exception {
        OutputStream fileOutputStream;
        block36: {
            long startPosition;
            if (inputStream == null) {
                throw new NullPointerException("Input stream for saving cannot be null");
            }
            this.downloadFile.setFileState(FileState.CHECKED_AND_EXISTING);
            boolean temporary = this.useTemporaryFiles();
            this.setBuffer(new byte[AppPrefs.getProperty("inputBufferSize", 1024)]);
            this.fileAlreadyExists = this.checkExists();
            if (this.fileAlreadyExists == 2) {
                if (this.useTemporaryFiles() || this.downloadFile.getOutputFile().length() != this.downloadFile.getDownloaded()) {
                    this.skipped = true;
                    this.downloadFile.setErrorMessage(this.getResourceMap().getString("fileAlreadyExistsTooltip", new Object[0]));
                    this.cancel(true);
                    return;
                }
            } else if (this.fileAlreadyExists == 0) {
                String unique = this.getNewUniqueFileName(this.downloadFile.getOutputFile());
                if (this.downloadFile.getFileNameRenameTo() != null) {
                    this.downloadFile.setFileNameRenameTo(unique);
                } else {
                    this.downloadFile.setFileName(unique);
                }
            }
            String fileName = this.downloadFile.getFileNameRenameTo() != null ? this.downloadFile.getFileNameRenameTo() : this.downloadFile.getFileName();
            File outputFile = this.downloadFile.getOutputFile();
            SpeedRegulator speedRegulator = ((MainApp)this.getApplication()).getManagerDirector().getSpeedRegulator();
            File saveToDirectory = this.downloadFile.getSaveToDirectory();
            CountingOutputStream cos = null;
            fileOutputStream = null;
            try {
                if (!saveToDirectory.exists() && !saveToDirectory.mkdirs()) {
                    throw new IOException("Cannot create directory");
                }
                File storeFile = this.downloadFile.getStoreFile();
                if (this.downloadFile.getStoreFile() == null || !this.downloadFile.getStoreFile().exists()) {
                    File file = temporary ? File.createTempFile(fileName + "." + (fileName.length() < 3 ? "xx" : ""), ".part", saveToDirectory) : (storeFile = outputFile);
                    if (!System.getProperties().containsKey("exePath")) {
                        this.downloadFile.setStoreFile(this.useRelativeStoreFileIfPossible ? FRDUtils.getAbsRelPath(storeFile) : storeFile);
                    } else {
                        this.downloadFile.setStoreFile(storeFile);
                    }
                    this.downloadFile.setDownloaded(0L);
                }
                long fileSize = this.downloadFile.getFileSize();
                Long startPositionObject = (Long)this.downloadFile.getProperties().get("startPosition");
                if (startPositionObject == null) {
                    startPosition = 0L;
                } else {
                    startPosition = startPositionObject;
                    this.downloadFile.getProperties().remove("startPosition");
                }
                if (AppPrefs.getProperty("blindMode", false)) {
                    Sound.playSound(this.getContext().getResourceMap().getString("startDownloadWav", new Object[0]));
                }
                try {
                    cos = this.getFileOutputStream(storeFile, fileSize, startPosition);
                    fileOutputStream = this.getBufferedOutputStream(cos);
                    if (this.isTerminated()) {
                        this.closeFileStream(fileOutputStream);
                        this.checkDeleteTempFile();
                        this.closeFileStream(fileOutputStream);
                        this.checkDeleteTempFile();
                        if (!this.wasInterrupted(this.downloadFile.getStoreFile()) && cos != null) {
                            this.downloadFile.setRealDownload(startPosition + cos.count);
                            this.downloadFile.setDownloaded(this.downloadFile.getRealDownload());
                        }
                        this.closeFileStream(fileOutputStream);
                        this.checkDeleteTempFile();
                        return;
                    }
                }
                catch (Exception e) {
                    try {
                        throw e;
                        catch (Throwable e2) {
                            throw new IOException("ErrorDuringDownload", e2);
                        }
                    }
                    catch (Throwable throwable) {
                        this.closeFileStream(fileOutputStream);
                        this.checkDeleteTempFile();
                        if (this.wasInterrupted(this.downloadFile.getStoreFile())) throw throwable;
                        if (cos == null) throw throwable;
                        this.downloadFile.setRealDownload(startPosition + cos.count);
                        this.downloadFile.setDownloaded(this.downloadFile.getRealDownload());
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                this.closeFileStream(fileOutputStream);
                this.checkDeleteTempFile();
                throw throwable;
            }
            {
                int len;
                long counter = 0L;
                this.downloadFile.setState(DownloadState.DOWNLOADING);
                Long suppose = (Long)this.downloadFile.getProperties().get("supposeToDownload");
                if (suppose == null) {
                    suppose = this.downloadFile.getFileSize();
                } else {
                    this.downloadFile.getProperties().remove("supposeToDownload");
                }
                logger.info("starting download from position " + startPosition);
                this.downloadFile.setDownloaded(startPosition);
                this.downloadFile.setRealDownload(this.downloadFile.getDownloaded());
                speedRegulator.addDownloading(this.downloadFile, this);
                byte[] buf = this.getBuffer();
                while ((len = inputStream.read(buf)) != -1) {
                    fileOutputStream.write(buf, 0, len);
                    counter += (long)len;
                    this.downloadFile.setRealDownload(startPosition + cos.count);
                    if (this.isTerminated()) {
                        fileOutputStream.flush();
                        break;
                    }
                    boolean ok = speedRegulator.takeTokens(this.downloadFile, len);
                    if (!ok && counter != suppose) {
                        Thread.sleep(1000L);
                    }
                    buf = this.buffer;
                }
                if (!this.isTerminated()) {
                    if (this.client.getHTTPClient().getParams().isParameterTrue("noContentLengthAvailable")) {
                        this.downloadFile.setFileSize(startPosition + counter);
                    } else if (counter != suppose) {
                        logger.info("File size does not match - expected " + suppose + " but " + counter + " was downloaded");
                        throw new IOException("ErrorDuringDownload");
                    }
                } else {
                    logger.info("File downloading was terminated");
                }
                this.closeFileStream(fileOutputStream);
                this.checkDeleteTempFile();
                if (this.wasInterrupted(this.downloadFile.getStoreFile()) || cos == null) break block36;
                this.downloadFile.setRealDownload(startPosition + cos.count);
                this.downloadFile.setDownloaded(this.downloadFile.getRealDownload());
            }
        }
        this.closeFileStream(fileOutputStream);
        this.checkDeleteTempFile();
    }

    private OutputStream getBufferedOutputStream(OutputStream out) {
        return new BufferedOutputStream(out, AppPrefs.getProperty("outputFileBufferSize", 600000));
    }

    protected boolean useTemporaryFiles() {
        return AppPrefs.getProperty("useTemporaryFiles", false);
    }

    private void closeFileStream(OutputStream fileOutputStream) {
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error closing file stream", e);
        }
    }

    private void checkDeleteTempFile() {
        File storeFile = this.downloadFile.getStoreFile();
        if (this.wasInterrupted(storeFile)) {
            logger.info("Deleting partial file " + storeFile);
            boolean b = storeFile.delete();
            if (!b) {
                logger.info("Deleting partial file failed (" + storeFile + ")");
            } else {
                this.downloadFile.setStoreFile(null);
            }
        }
        if (this.downloadFile.getState() == DownloadState.CANCELLED) {
            this.downloadFile.setDownloaded(0L);
        }
    }

    private boolean wasInterrupted(File storeFile) {
        return this.isTerminated() && storeFile != null && storeFile.exists() && (this.downloadFile.getState() == DownloadState.CANCELLED || this.downloadFile.getState() == DownloadState.DELETED);
    }

    @Override
    protected void cancelled() {
        if (this.downloadFile != null) {
            if (this.connectionTimeOut) {
                this.downloadFile.setState(DownloadState.ERROR);
                this.setServiceError(DownloadTaskError.CONNECTION_TIMEOUT);
            } else if (this.downloadFile.getState() != DownloadState.PAUSED) {
                this.downloadFile.setState(this.skipped ? DownloadState.SKIPPED : DownloadState.CANCELLED);
            }
        }
    }

    public void setConnectionTimeOut(boolean connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSleep(int sleep) {
        Integer newValue;
        Integer oldValue;
        DownloadTask downloadTask = this;
        synchronized (downloadTask) {
            oldValue = this.sleep;
            newValue = this.sleep = Integer.valueOf(sleep);
        }
        this.firePropertyChange("sleep", oldValue, newValue);
    }

    @Override
    protected void failed(Throwable cause) {
        Application app;
        boolean connectError;
        if (cause instanceof IllegalArgumentException) {
            cause = new PluginImplementationException(this.service.getName() + " " + this.downloadFile.getFileUrl().toExternalForm(), cause);
        } else if (!(cause instanceof ErrorDuringDownloadingException)) {
            super.failed(cause);
            LogUtils.processException(logger, cause);
        }
        this.error(cause);
        if (cause instanceof PluginImplementationException) {
            logger.warning("Content from the last request\n" + this.client.getContentAsString());
            LogUtils.processException(logger, cause);
        }
        if (cause instanceof NotEnoughSpaceException) {
            this.downloadFile.setErrorMessage(this.getResourceMap().getString("NotEnoughSpaceException", this.downloadFile.getStoreFile().getParentFile()));
            this.setServiceError(DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR);
        } else if (cause instanceof UnknownHostException) {
            this.downloadFile.setErrorMessage(this.getResourceMap().getString("UnknownHostError", new Object[0]));
        } else if (cause instanceof NotRecoverableDownloadException) {
            this.setServiceError(DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR);
        } else if (cause instanceof YouHaveToWaitException) {
            YouHaveToWaitException waitException = (YouHaveToWaitException)cause;
            this.youHaveToSleepSecondsTime = waitException.getHowManySecondsToWait();
            this.setServiceError(DownloadTaskError.YOU_HAVE_TO_WAIT_ERROR);
        }
        boolean bl = connectError = cause instanceof NoRouteToHostException || cause instanceof ConnectException || cause instanceof UnknownHostException;
        if (AppPrefs.getProperty("testFiles", true)) {
            this.updateFileState(cause, connectError);
        }
        if (AppPrefs.getProperty("disableConnectionOnException", false) && connectError) {
            this.setServiceError(DownloadTaskError.NO_ROUTE_TO_HOST);
        }
        if (this.getServiceError() == DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR) {
            this.downloadFile.setErrorAttemptsCount(0);
            this.downloadFile.setTimeToQueued(-1);
            this.downloadFile.setTimeToQueuedMax(-1);
        }
        if (this.isAllComplete(app = this.getApplication())) {
            this.checkShutDown(app);
        }
    }

    protected void updateFileState(Throwable cause, boolean connectError) {
        if (cause instanceof URLNotAvailableAnymoreException || cause instanceof InvalidURLOrServiceProblemException) {
            this.downloadFile.setFileState(FileState.FILE_NOT_FOUND);
        } else if (!connectError && !(cause instanceof CaptchaEntryInputMismatchException) && this.serviceError == DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR) {
            this.downloadFile.setFileState(FileState.ERROR_GETTING_INFO);
        }
    }

    protected void error(Throwable cause) {
        this.setServiceError(DownloadTaskError.GENERAL_ERROR);
        if (this.downloadFile == null) {
            return;
        }
        this.setFileErrorMessage(cause);
        if (!(cause instanceof YouHaveToWaitException)) {
            if (AppPrefs.getProperty("playSoundsFailed", true)) {
                Sound.playSound(this.getContext().getResourceMap().getString("errorWav", new Object[0]));
            }
            this.downloadFile.setState(DownloadState.ERROR);
        } else {
            this.downloadFile.setState(DownloadState.SLEEPING);
        }
    }

    protected void setFileErrorMessage(Throwable cause) {
        if (this.downloadFile != null) {
            this.downloadFile.setErrorMessage(Swinger.getMessageFromException(this.getResourceMap(), cause));
        }
    }

    @Override
    protected void interrupted(InterruptedException e) {
        this.cancelled();
    }

    @Override
    protected void succeeded(Void result) {
        super.succeeded(result);
        boolean runTask = false;
        boolean overWriteFile = false;
        File storeFile = this.downloadFile.getStoreFile();
        File outputFile = this.downloadFile.getOutputFile();
        if (storeFile != null && storeFile.exists()) {
            if (storeFile.equals(outputFile)) {
                this.runMoveFileTask(false);
                return;
            }
            if (outputFile.exists()) {
                int property = 0;
                try {
                    property = this.fileAlreadyExistsProperty();
                }
                catch (InvocationTargetException e) {
                    LogUtils.processException(logger, e);
                }
                catch (InterruptedException e) {
                    LogUtils.processException(logger, e);
                }
                switch (property) {
                    case 1: {
                        runTask = true;
                        overWriteFile = true;
                        break;
                    }
                    case 0: {
                        runTask = true;
                    }
                }
            } else {
                runTask = true;
            }
        }
        if (runTask) {
            this.runMoveFileTask(overWriteFile);
        } else {
            this.setCompleted();
            if (storeFile != null && storeFile.exists() && storeFile.delete()) {
                this.downloadFile.setStoreFile(null);
            }
        }
    }

    protected int checkExists() throws InvocationTargetException, InterruptedException {
        if (!this.downloadFile.getOutputFile().exists()) {
            return -2;
        }
        return this.fileAlreadyExistsProperty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int fileAlreadyExistsProperty() throws InvocationTargetException, InterruptedException {
        if (this.fileAlreadyExists != -2) {
            return this.fileAlreadyExists;
        }
        final int[] property = new int[]{AppPrefs.getProperty("whatToDoIfFileAlreadyExists", 3)};
        if (property[0] != 3) return property[0];
        Class<DownloadTask> clazz = DownloadTask.class;
        synchronized (DownloadTask.class) {
            if (EventQueue.isDispatchThread()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.showFileAlreadyExistsDialog();
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    property[0] = DownloadTask.this.showFileAlreadyExistsDialog();
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return property[0];
        }
    }

    private int showFileAlreadyExistsDialog() {
        boolean bringToFront;
        boolean bl = bringToFront = !QuietMode.getInstance().isActive() || !QuietMode.getInstance().isDialogsDisabled();
        if (!bringToFront) {
            QuietMode.getInstance().playUserInteractionRequiredSound();
        }
        return Swinger.showOptionDialog(this.getResourceMap(), bringToFront, 3, "errorMessage", "fileAlreadyExists", new String[]{"renameFile", "overWriteFile", "skipFile"}, this.downloadFile.getOutputFile());
    }

    private void setCompleted() {
        this.downloadFile.setCompleteTaskDuration(this.getExecutionDuration(TimeUnit.SECONDS));
        if (this.downloadFile.getState() != DownloadState.QUEUED) {
            this.downloadFile.setState(DownloadState.COMPLETED);
            if (AppPrefs.getProperty("blindMode", false)) {
                Sound.playSound(this.getContext().getResourceMap().getString("doneWav", new Object[0]));
            }
        }
    }

    @Override
    public void saveToHistoryList(File savedAs) {
        if (savedAs != null) {
            this.downloadFile.setFileName(savedAs.getName());
        }
        logger.info("Saving to history " + this.downloadFile.getFileName());
        boolean saveHistory = AppPrefs.getProperty("useHistory", true);
        if (saveHistory) {
            ((MainApp)this.getApplication()).getManagerDirector().getFileHistoryManager().addHistoryItem(this.downloadFile, savedAs);
        }
    }

    private void runMoveFileTask(boolean overWriteFile) {
        MoveFileTask moveFileTask = new MoveFileTask(this.getApplication(), this.downloadFile.getStoreFile(), this.downloadFile.getOutputFile(), true, overWriteFile, this.downloadFile);
        moveFileTask.addTaskListener(new TaskListener.Adapter<Void, Void>(){
            public boolean succeeded = false;

            @Override
            public void finished(TaskEvent<Void> event) {
                super.succeeded(event);
                if (this.succeeded) {
                    DownloadTask.this.doAllSucceededActions();
                }
            }

            @Override
            public void succeeded(TaskEvent<Void> event) {
                this.succeeded = true;
                DownloadTask.this.setCompleted();
            }

            @Override
            public void failed(TaskEvent<Throwable> event) {
                DownloadTask.this.downloadFile.setState(DownloadState.ERROR);
                DownloadTask.this.downloadFile.setErrorMessage(DownloadTask.this.getResourceMap().getString("transferFailed", event.getValue().getMessage()));
                Sound.playSound(DownloadTask.this.getContext().getResourceMap().getString("errorWav", new Object[0]));
            }

            @Override
            public void cancelled(TaskEvent<Void> event) {
                DownloadTask.this.downloadFile.setState(DownloadState.CANCELLED);
            }

            @Override
            public void interrupted(TaskEvent<InterruptedException> event) {
                DownloadTask.this.downloadFile.setState(DownloadState.CANCELLED);
            }
        });
        MainApp app = (MainApp)this.getApplication();
        TaskServiceManager serviceManager = app.getManagerDirector().getTaskServiceManager();
        serviceManager.getTaskService("moveFile").execute(moveFileTask);
    }

    private void doAllSucceededActions() {
        Application app = this.getApplication();
        boolean allComplete = this.isAllComplete(app);
        if (allComplete) {
            boolean sound = AppPrefs.getProperty("playSoundOK", true);
            if (sound) {
                Sound.playSound(this.getContext().getResourceMap().getString("doneWav", new Object[0]));
            }
            this.checkShutDown(app);
        }
    }

    private void checkShutDown(Application app) {
        if (AppPrefs.getProperty("autoshutdown", 0) != 0) {
            app.getContext().getTaskService().execute(new CloseInTimeTask(app));
        }
    }

    private boolean isAllComplete(Application app) {
        return ((MainApp)app).getManagerDirector().getDataManager().checkAllComplete();
    }

    private String getNewUniqueFileName(File to) {
        File newFile;
        File dir = to.getParentFile();
        String pureFileName = Utils.getPureFilenameWithDots(to);
        String ext = Utils.getExtension(to);
        ext = ext != null ? "." + ext : "";
        int counter = 2;
        while ((newFile = new File(dir, pureFileName + "-" + String.valueOf(counter) + ext)).exists()) {
            ++counter;
        }
        return newFile.getName();
    }

    @Override
    public void sleep(int seconds) throws InterruptedException {
        this.setSleep(0);
        this.downloadFile.setState(DownloadState.WAITING);
        this.downloadFile.setTimeToQueuedMax(seconds);
        logger.info("Going to sleep for " + seconds + " seconds");
        for (int i = seconds; i > 0 && !this.isTerminated(); --i) {
            this.setSleep(i);
            Thread.sleep(1000L);
        }
        if (this.isTerminated()) {
            throw new InterruptedException();
        }
    }

    @Override
    public DownloadFile getDownloadFile() {
        return this.downloadFile;
    }

    @Override
    public HttpDownloadClient getClient() {
        return this.client;
    }

    public DownloadTaskError getServiceError() {
        return this.serviceError;
    }

    private void setServiceError(DownloadTaskError serviceError) {
        this.serviceError = serviceError;
    }

    public int getYouHaveToSleepSecondsTime() {
        return this.youHaveToSleepSecondsTime;
    }

    protected void setDownloadFile(DownloadFile downloadFile) {
        this.downloadFile = downloadFile;
    }

    void setBuffer(byte[] buffer) {
        assert (buffer.length != 0);
        this.buffer = buffer;
    }

    byte[] getBuffer() {
        return this.buffer;
    }

    protected void setUseRelativeStoreFileIfPossible(boolean useRelative) {
        this.useRelativeStoreFileIfPossible = useRelative;
    }
}

