/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.event.SwingPropertyChangeSupport;

public final class SpeedRegulator
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(SpeedRegulator.class.getName());
    private Map<DownloadFile, DownloadFileInfo> downloading = new Hashtable<DownloadFile, DownloadFileInfo>(10);
    private final float SPEED_BACKUP = 1.3f;
    private static int globalSpeed;
    private final Object lock = new Object();
    private Timer timer = null;
    private static final int SPEED_MINIMUM_HOLDED = 10;
    private SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this, true);
    private volatile long speed = 0L;
    private volatile float averageSpeed = 0.0f;

    public SpeedRegulator() {
        this.initProperties();
        this.initSpeeds();
    }

    private void initProperties() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if ("speedLimitEnabled".equals(evt.getKey()) || "speedLimit".equals(evt.getKey())) {
                    SpeedRegulator.this.initSpeeds();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSpeeds() {
        Object object = this.lock;
        synchronized (object) {
            globalSpeed = AppPrefs.getProperty("speedLimitEnabled", false) ? AppPrefs.getProperty("speedLimit", 250) : -1;
        }
    }

    private void assignTokensToFiles() {
        int downloadingCount = this.downloading.size();
        Set<DownloadFile> files = this.downloading.keySet();
        if (globalSpeed > 0 && downloadingCount > 0) {
            long available = globalSpeed;
            HashSet<DownloadFile> notSatisfied = new HashSet<DownloadFile>(files);
            boolean firstIteration = true;
            do {
                int speedPerFile = Math.max((int)((float)available / (float)notSatisfied.size()), 1);
                for (DownloadFile file : files) {
                    int set;
                    if (!notSatisfied.contains(file)) continue;
                    if (firstIteration) {
                        file.setTokensLimit(0);
                    }
                    int lastTaken = file.getTakenTokens();
                    if (file.hasSpeedLimit()) {
                        int min = Math.min(file.getSpeedLimit() - file.getTokensLimit(), speedPerFile);
                        set = lastTaken < 0 || downloadingCount == 1 ? min : (lastTaken > 0 ? Math.min(min, (int)((float)lastTaken * 1.3f)) : Math.min(min, 10));
                        assert (set >= 0);
                        if (file.getTokensLimit() + set == file.getSpeedLimit()) {
                            notSatisfied.remove(file);
                        }
                    } else {
                        if (lastTaken < 0 || downloadingCount == 1) {
                            set = speedPerFile;
                        } else if (lastTaken > 0) {
                            if (firstIteration) {
                                set = Math.min(speedPerFile, (int)((float)lastTaken * 1.3f));
                            } else {
                                int last = (int)((float)lastTaken * 1.3f);
                                set = Math.min(speedPerFile, Math.min(last, Math.abs(last - file.getTokensLimit())));
                                if (set == 0) {
                                    set = 1;
                                }
                            }
                        } else {
                            set = Math.min(speedPerFile, 10);
                        }
                        assert (set >= 0);
                    }
                    available -= (long)set;
                    file.setTokensLimit(file.getTokensLimit() + set);
                }
                firstIteration = false;
            } while (available > 0L && notSatisfied.size() > 0);
            for (DownloadFile file : files) {
                file.setTakenTokens(0);
            }
        } else {
            for (DownloadFile file : files) {
                file.setTokensLimit(file.hasSpeedLimit() ? file.getSpeedLimit() : Integer.MAX_VALUE);
                file.setTakenTokens(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        Object object = this.lock;
        synchronized (object) {
            this.assignTokensToFiles();
            long speed = 0L;
            float avgSpeed = 0.0f;
            int size = this.downloading.size();
            for (DownloadFileInfo info : this.downloading.values()) {
                if (info.file.getState() != DownloadState.DOWNLOADING) continue;
                info.tick();
                speed += info.speed;
                avgSpeed += info.averageSpeed;
            }
            this.fireSpeed(speed);
            this.fireAvgSpeed(avgSpeed / (float)size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean takeTokens(DownloadFile file, int bytes) {
        int kilobytes = (int)Math.round((double)bytes / 1024.0);
        Object object = this.lock;
        synchronized (object) {
            DownloadFileInfo info = this.downloading.get(file);
            if (info == null) {
                return true;
            }
            info.counter = info.counter + (long)bytes;
            int taken = file.getTakenTokens();
            file.setTakenTokens(taken == -1 ? kilobytes : taken + kilobytes);
            return file.getTokensLimit() > file.getTakenTokens();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDownloading(DownloadFile file, DownloadTask task) {
        Object object = this.lock;
        synchronized (object) {
            file.setTakenTokens(-1);
            file.addPropertyChangeListener("state", this);
            file.setTokensLimit(Integer.MAX_VALUE);
            file.setSpeed(0L);
            file.setAverageSpeed(0.0f);
            this.downloading.put(file, new DownloadFileInfo(task));
            if (this.timer == null) {
                this.timer = new Timer("SpeedRegulatorTimer");
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SpeedRegulator.this.tick();
                    }
                }, 0L, 1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDownloading(DownloadFile file) {
        Object object = this.lock;
        synchronized (object) {
            this.downloading.remove(file);
            file.removePropertyChangeListener("state", this);
            file.setSpeed(0L);
            if (this.timer != null && this.downloading.isEmpty()) {
                this.fireSpeed(0L);
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    private void fireSpeed(long newSpeed) {
        long oldValue = this.speed;
        this.speed = newSpeed;
        this.pcs.firePropertyChange("speed", oldValue, this.speed);
    }

    private void fireAvgSpeed(float newSpeed) {
        float oldValue = this.averageSpeed;
        this.averageSpeed = newSpeed;
        this.pcs.firePropertyChange("averageSpeed", Float.valueOf(oldValue), Float.valueOf(this.averageSpeed));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        DownloadFile downloadFile = (DownloadFile)evt.getSource();
        if (downloadFile.getState() != DownloadState.DOWNLOADING) {
            this.removeDownloading(downloadFile);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public float getAverageSpeed() {
        return this.averageSpeed;
    }

    public long getSpeed() {
        return this.speed;
    }

    private static class DownloadFileInfo {
        private volatile long counter = 0L;
        private long lastSize = 0L;
        private int noDataTimeOut = 0;
        private short indexer = 0;
        private long[] avgSpeedArray;
        private final DownloadTask task;
        private final long startTime;
        private int avgSpeedMeasuredSeconds;
        private static final int NO_DATA_TIMEOUT_LIMIT = 120;
        private float avgSpeed;
        private static final int[] bufferSizes = new int[]{1024, 2048, 5120, 10240, 25600, 51200};
        private byte[][] buffers = new byte[bufferSizes.length][];
        private DownloadFile file;
        private long speed;
        private float averageSpeed;
        private long downloadedStart;

        DownloadFileInfo(DownloadTask task) {
            this.task = task;
            this.file = task.getDownloadFile();
            this.downloadedStart = this.file.getDownloaded();
            this.avgSpeedMeasuredSeconds = AppPrefs.getProperty("avgSpeedMeasuredSeconds", 10);
            this.avgSpeedArray = new long[this.avgSpeedMeasuredSeconds];
            Arrays.fill(this.avgSpeedArray, -1L);
            this.startTime = System.currentTimeMillis();
            this.avgSpeed = 0.0f;
            this.speed = 0L;
            this.averageSpeed = 0.0f;
        }

        private void updateShortAvgSpeed() {
            int i = 0;
            long sum = 0L;
            for (long l : this.avgSpeedArray) {
                if (l == -1L) continue;
                sum += l;
                ++i;
            }
            this.avgSpeed = i == 0 ? 0.0f : (float)sum / (float)i;
            this.file.setShortTimeAvgSpeed(this.avgSpeed);
        }

        void tick() {
            long time;
            float l;
            long localCounter = this.counter;
            this.speed = localCounter - this.lastSize;
            this.file.setSpeed(this.speed);
            if (this.speed == 0L) {
                if (++this.noDataTimeOut >= 120) {
                    logger.info("Cancelling download - no downloaded data during 120 seconds");
                    this.averageSpeed = 0.0f;
                    this.task.setConnectionTimeOut(true);
                    this.task.cancel(true);
                    return;
                }
            } else {
                this.noDataTimeOut = 0;
                this.lastSize = localCounter;
                this.file.setDownloaded(this.downloadedStart + localCounter);
            }
            this.averageSpeed = Float.compare(l = (float)(time = System.currentTimeMillis() - this.startTime) / 1000.0f, 0.0f) == 0 ? 0.0f : (float)localCounter / l;
            this.file.setAverageSpeed(this.averageSpeed);
            if (this.indexer == this.avgSpeedMeasuredSeconds) {
                this.indexer = 0;
            }
            short s = this.indexer;
            this.indexer = (short)(s + 1);
            this.avgSpeedArray[s] = this.speed;
            this.updateShortAvgSpeed();
            this.updateBufferSize(this.speed);
        }

        private void updateBufferSize(long speed) {
            int real = Math.min((int)((float)speed / 1024.0f), this.file.getTokensLimit() - Math.max(this.file.getTakenTokens(), 0));
            if (real < 0) {
                real = 10;
            }
            if (this.file.hasSpeedLimit() || globalSpeed > 0) {
                real /= 4;
            }
            int result = real > 50 ? (real >= 300 ? 5 : 4) : (real > 15 ? (real >= 31 ? 3 : 2) : (real >= 6 ? 1 : 0));
            byte[] buffer = this.buffers[result];
            if (buffer != null) {
                this.task.setBuffer(buffer);
            } else {
                buffer = new byte[bufferSizes[result]];
                this.task.setBuffer(buffer);
                this.buffers[result] = buffer;
            }
        }
    }
}

