/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.commons.httpclient.URIException;

public abstract class URLTransferHandler
extends TransferHandler {
    private static final Logger logger = Logger.getLogger(URLTransferHandler.class.getName());
    private static final Pattern REGEXP_URL = Pattern.compile("((http|https)://)?([a-zA-Z0-9\\.\\-]+(:[a-zA-Z0-9\\.:&%\\$\\-]+)*@)?((25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[0-9])|([a-zA-Z0-9\\-]+\\.)*[a-zA-Z0-9\\-]+\\.[a-zA-Z]{2,4})(:[0-9]+)?(/[^/][\\p{Lu}\\p{Ll}0-9\\[\\]\\.:,\\?\\(\\)'\\\\/\\+&%\\$#!\\|=~_\\-@]*)*", 8);
    private static final String URL_LIST_MIME_TYPE = "application/x-java-url; class=java.net.URL";
    private List<URL> urls;
    private PluginsManager pluginsManager;

    protected abstract void doDropAction(List<URL> var1);

    public URLTransferHandler(ManagerDirector director) {
        this.pluginsManager = director.getPluginsManager();
    }

    public static List<URL> textURIListToFileList(String data, PluginsManager pluginsManager, boolean clipboardMonitoring) {
        HashSet<URI> list = new HashSet<URI>();
        LinkedList<URL> result = new LinkedList<URL>();
        data = data.replaceAll("(\\p{Punct}|[\\t\\n\\x0B\\f\\r])http(s)?(?!%3A%2F%2F)", "  http$2");
        Matcher match = REGEXP_URL.matcher(data);
        int start = 0;
        String http = "http://";
        Pattern dotsEndPattern = Pattern.compile("(.+)\\.{3,}");
        while (match.find(start)) {
            try {
                int index;
                URL url;
                boolean supported;
                String spec = match.group();
                if (!spec.startsWith("http://") && !spec.startsWith("https://")) {
                    spec = "http://" + spec;
                }
                if (!(supported = pluginsManager.isSupported(url = new URL(URLTransferHandler.updateApostrophs(spec)), clipboardMonitoring)) && (index = spec.indexOf("http%3A%2F%2F")) >= 0) {
                    int endIndex = spec.indexOf(38, index);
                    spec = endIndex > 0 ? spec.substring(index, endIndex) : spec.substring(index);
                    spec = Utils.urlDecode(spec);
                    url = new URL(URLTransferHandler.updateApostrophs(spec));
                    supported = pluginsManager.isSupported(url, clipboardMonitoring);
                }
                if (!supported && (index = spec.toLowerCase(Locale.ENGLISH).indexOf("//:ptth")) >= 0) {
                    int startIndex = spec.indexOf("url=", 0);
                    if (startIndex != -1) {
                        if (startIndex < index) {
                            spec = Utils.reverseString(spec.substring(startIndex + 4, index));
                        } else {
                            startIndex = -1;
                        }
                    } else {
                        startIndex = spec.indexOf(63, 0);
                        if (startIndex != -1) {
                            if (startIndex < index) {
                                spec = Utils.reverseString(spec.substring(startIndex + 1, index));
                            } else {
                                startIndex = -1;
                            }
                        } else {
                            startIndex = spec.indexOf(61, 0);
                            if (startIndex != -1) {
                                if (startIndex < index) {
                                    spec = Utils.reverseString(spec.substring(startIndex + 1, index));
                                } else {
                                    startIndex = -1;
                                }
                            }
                        }
                    }
                    if (startIndex != -1) {
                        spec = Utils.urlDecode("http://" + spec);
                        url = new URL(URLTransferHandler.updateApostrophs(spec));
                        supported = pluginsManager.isSupported(url, clipboardMonitoring);
                    }
                }
                if (supported) {
                    URI uri;
                    String urlS = url.toExternalForm();
                    int i = urlS.indexOf("...");
                    Pattern patternMatcher = null;
                    Matcher dotsMatcher = dotsEndPattern.matcher(urlS);
                    boolean dotsEnd = dotsMatcher.matches();
                    if (i > 0 && !dotsEnd) {
                        String pattern = Pattern.quote(urlS.substring(0, i)) + ".+" + Pattern.quote(urlS.substring(i + 4));
                        patternMatcher = Pattern.compile(pattern);
                    }
                    boolean containable = false;
                    for (URI u : list) {
                        String previouslyAdded = u.toURL().toExternalForm();
                        if (previouslyAdded.length() <= urlS.length() || !previouslyAdded.startsWith(urlS) && (patternMatcher == null || !patternMatcher.matcher(previouslyAdded).matches()) && (!dotsEnd || !previouslyAdded.startsWith(dotsMatcher.group(1)))) continue;
                        containable = true;
                        break;
                    }
                    if (!containable && !list.contains(uri = Utils.convertToURI(urlS))) {
                        list.add(uri);
                        result.add(uri.toURL());
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            start = match.end();
        }
        return result;
    }

    private static String updateApostrophs(String spec) {
        if (spec.endsWith("'") && spec.length() > 2) {
            spec = spec.substring(0, spec.length() - 1);
        }
        return spec;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        return super.importData(comp, t);
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return super.canImport(comp, transferFlavors);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return super.canImport(support);
        }
        for (DataFlavor flavor : support.getDataFlavors()) {
            if (flavor.isFlavorTextType()) {
                return true;
            }
            if (!flavor.isMimeTypeEqual(URL_LIST_MIME_TYPE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        Transferable transferable = support.getTransferable();
        logger.info("Trying to import:" + transferable);
        DataFlavor urlFlavor = null;
        try {
            urlFlavor = new DataFlavor(URL_LIST_MIME_TYPE);
        }
        catch (ClassNotFoundException e) {
            LogUtils.processException(logger, e);
        }
        this.urls = new LinkedList<URL>();
        try {
            block28: {
                if (urlFlavor != null && transferable.isDataFlavorSupported(urlFlavor)) {
                    try {
                        Object transferData = transferable.getTransferData(urlFlavor);
                        if (!(transferData instanceof URL)) break block28;
                        URL url = (URL)transferData;
                        if (this.pluginsManager.isSupported(url, true)) {
                            this.urls.add(url);
                            break block28;
                        }
                        try {
                            String s = url.toExternalForm();
                            this.urls.addAll(URLTransferHandler.textURIListToFileList(s, this.pluginsManager, true));
                        }
                        catch (IllegalArgumentException e) {
                            LogUtils.processException(logger, e);
                        }
                    }
                    catch (UnsupportedFlavorException transferData) {
                    }
                    catch (IOException transferData) {
                    }
                    catch (NullPointerException e) {
                        LogUtils.processException(logger, e);
                    }
                } else {
                    DataFlavor xhtmlFavor = null;
                    try {
                        xhtmlFavor = new DataFlavor("application/xhtml+xml;class=java.lang.String");
                    }
                    catch (ClassNotFoundException e) {
                        LogUtils.processException(logger, e);
                    }
                    if (xhtmlFavor != null && transferable.isDataFlavorSupported(xhtmlFavor)) {
                        String data = (String)transferable.getTransferData(xhtmlFavor);
                        this.urls = URLTransferHandler.textURIListToFileList(data, this.pluginsManager, true);
                    } else {
                        DataFlavor htmlFavor = null;
                        try {
                            htmlFavor = new DataFlavor("text/html;class=java.lang.String");
                        }
                        catch (ClassNotFoundException e) {
                            LogUtils.processException(logger, e);
                        }
                        if (htmlFavor != null && transferable.isDataFlavorSupported(htmlFavor)) {
                            String data = (String)transferable.getTransferData(htmlFavor);
                            if (!Pattern.compile("<a\\s", 10).matcher(data).find()) {
                                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                                    data = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                                    this.urls = URLTransferHandler.textURIListToFileList(data, this.pluginsManager, true);
                                } else {
                                    this.urls = URLTransferHandler.textURIListToFileList(data, this.pluginsManager, true);
                                }
                            } else {
                                this.urls = URLTransferHandler.textURIListToFileList(data, this.pluginsManager, true);
                            }
                        } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            String data = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            this.urls = URLTransferHandler.textURIListToFileList(data, this.pluginsManager, true);
                        }
                    }
                }
            }
            if (this.urls.isEmpty()) {
                logger.info("Importing drag and drop failed or unsupported.");
                this.doDropAction(new LinkedList<URL>());
                return false;
            }
            logger.info("Imported files " + Arrays.toString(this.urls.toArray()));
            this.doDropAction(this.urls);
            return true;
        }
        catch (UnsupportedFlavorException e) {
            LogUtils.processException(logger, e);
        }
        catch (IOException e) {
            LogUtils.processException(logger, e);
        }
        return false;
    }

    public List<URL> getUrls() {
        return this.urls;
    }
}

