/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.dialogs.DownloadHistoryDialog;
import cz.vity.freerapid.gui.dialogs.SpeedMeterDialog;
import cz.vity.freerapid.gui.dialogs.ToolbarDialog;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.utilities.LogUtils;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.SwingUtilities;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Action;

public class ViewActions
extends AbstractBean {
    private final MainApp app = MainApp.getInstance(MainApp.class);
    private static final Logger logger = Logger.getLogger(ViewActions.class.getName());

    public ViewActions() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if ("autoshutdown".equals(evt.getKey())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ViewActions.this.updateSelectedAction();
                        }
                    });
                }
            }
        });
    }

    private void updateSelectedAction() {
        String action = this.app.getManagerDirector().getMenuManager().getSelectedShutDownAction();
        this.app.getContext().getActionMap().get(action).putValue("SwingSelectedKey", Boolean.TRUE);
    }

    @Action
    public void showStatusBar() {
        AppPrefs.negateProperty("showStatusbar", true);
    }

    @Action
    public void showToolbar() {
        AppPrefs.negateProperty("showToolbar", true);
    }

    @Action
    public void showToolbarEditorAction() {
        try {
            ToolbarDialog toolbarDialog = new ToolbarDialog(this.app.getMainFrame());
            this.app.show(toolbarDialog);
        }
        catch (Exception x) {
            LogUtils.processException(logger, x);
        }
    }

    @Action
    public void showDownloadHistoryAction() {
        ManagerDirector managerDirector = this.app.getManagerDirector();
        DownloadHistoryDialog dialog = new DownloadHistoryDialog(this.app.getMainFrame(), managerDirector);
        this.app.show(dialog);
    }

    @Action
    public void showSpeedMonitor() {
        ManagerDirector managerDirector = this.app.getManagerDirector();
        SpeedMeterDialog dialog = new SpeedMeterDialog(this.app.getMainFrame(), managerDirector);
        this.app.show(dialog);
    }

    @Action
    public void showCompletedAction() {
        AppPrefs.negateProperty("removeCompleted", true);
        ManagerDirector managerDirector = this.app.getManagerDirector();
        ContentPanel panel = managerDirector.getContentManager().getContentPanel();
        panel.updateFilters();
    }
}

