/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.gui.SearchField;
import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.actions.URLTransferHandler;
import cz.vity.freerapid.gui.content.AverageSpeedCellRenderer;
import cz.vity.freerapid.gui.content.CheckedCellRenderer;
import cz.vity.freerapid.gui.content.ConnectionCellRenderer;
import cz.vity.freerapid.gui.content.CustomTableModel;
import cz.vity.freerapid.gui.content.DateCellRenderer;
import cz.vity.freerapid.gui.content.DescriptionCellRenderer;
import cz.vity.freerapid.gui.content.EstTimeCellRenderer;
import cz.vity.freerapid.gui.content.NameURLCellRenderer;
import cz.vity.freerapid.gui.content.ProgressBarCellRenderer;
import cz.vity.freerapid.gui.content.ProgressCellRenderer;
import cz.vity.freerapid.gui.content.RenameFileNameEditor;
import cz.vity.freerapid.gui.content.ServiceCellRenderer;
import cz.vity.freerapid.gui.content.SizeCellRenderer;
import cz.vity.freerapid.gui.content.SpeedCellRenderer;
import cz.vity.freerapid.gui.content.TableModelTableSortController;
import cz.vity.freerapid.gui.content.comparators.AvgSpeedColumnComparator;
import cz.vity.freerapid.gui.content.comparators.CheckedColumnComparator;
import cz.vity.freerapid.gui.content.comparators.ConnectionColumnComparator;
import cz.vity.freerapid.gui.content.comparators.DateColumnComparator;
import cz.vity.freerapid.gui.content.comparators.DescriptionColumnComparator;
import cz.vity.freerapid.gui.content.comparators.EstTimeColumnComparator;
import cz.vity.freerapid.gui.content.comparators.NameColumnComparator;
import cz.vity.freerapid.gui.content.comparators.ProgressBarColumnComparator;
import cz.vity.freerapid.gui.content.comparators.ProgressColumnComparator;
import cz.vity.freerapid.gui.content.comparators.ServiceColumnComparator;
import cz.vity.freerapid.gui.content.comparators.SizeColumnComparator;
import cz.vity.freerapid.gui.content.comparators.SpeedColumnComparator;
import cz.vity.freerapid.gui.dialogs.InformationDialog;
import cz.vity.freerapid.gui.dialogs.MultipleSettingsDialog;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.MenuManager;
import cz.vity.freerapid.gui.managers.exceptions.NotSupportedDownloadServiceException;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.model.LocalConnectionSettingsType;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.FileState;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFile;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.components.FindTableAction;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.OSDesktop;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.sort.SortController;
import org.jdesktop.swingx.table.TableColumnExt;

public class ContentPanel
extends JPanel
implements ListSelectionListener,
ListDataListener,
PropertyChangeListener,
ClipboardOwner {
    private static final Logger logger = Logger.getLogger(ContentPanel.class.getName());
    private static final int COLUMN_CHECKED = 0;
    static final int COLUMN_NAME = 1;
    private static final int COLUMN_PROGRESSBAR = 2;
    private static final int COLUMN_PROGRESS = 3;
    private static final int COLUMN_STATE = 4;
    private static final int COLUMN_SIZE = 5;
    private static final int COLUMN_SPEED = 6;
    private static final int COLUMN_AVERAGE_SPEED = 7;
    private static final int COLUMN_SERVICE = 8;
    private static final int COLUMN_PROXY = 9;
    private static final int COLUMN_DESCRIPTION = 10;
    private static final int COLUMN_DATE_INSERTED = 11;
    private final ApplicationContext context;
    private final ManagerDirector director;
    private final DataManager manager;
    private final ClientManager clientManager;
    private boolean cancelActionEnabled = false;
    private static final String CANCEL_ACTION_ENABLED_PROPERTY = "cancelActionEnabled";
    private boolean resumeActionEnabled = false;
    private static final String RESUME_ACTION_ENABLED_PROPERTY = "resumeActionEnabled";
    private boolean removeCompletedActionEnabled = false;
    private static final String REMOVECOMPLETED_ACTION_ENABLED_PROPERTY = "removeCompletedActionEnabled";
    private boolean removeCompletedAndDeletedActionEnabled = false;
    private static final String REMOVECOMPLETEDANDDELETED_ACTION_ENABLED_PROPERTY = "removeCompletedAndDeletedActionEnabled";
    private boolean pauseActionEnabled = false;
    private static final String PAUSE_ACTION_ENABLED_PROPERTY = "pauseActionEnabled";
    private boolean completeWithFilesEnabled = false;
    private static final String COMPLETED_OK_ACTION_ENABLED_PROPERTY = "completeWithFilesEnabled";
    private boolean selectedEnabled = false;
    private static final String SELECTED_ACTION_ENABLED_PROPERTY = "selectedEnabled";
    private boolean nonEmptyEnabled = false;
    private static final String NONEMPTY_ACTION_ENABLED_PROPERTY = "nonEmptyEnabled";
    private boolean validateLinksEnabled = false;
    private static final String VALIDATELINKS_ACTION_ENABLED_PROPERTY = "validateLinksEnabled";
    private boolean removeInvalidLinksActionEnabled = false;
    private static final String REMOVEINVALID_ACTION_ENABLED_PROPERTY = "removeInvalidLinksActionEnabled";
    private JXTable table;
    private static String[] states;
    private static final NumberFormat integerInstance;
    private static final NumberFormat numberFormatInstance;
    private static final String MOVEENABLED_ACTION_ENABLED_PROPERTY = "moveEnabled";
    private boolean moveEnabled = false;

    public ContentPanel(ApplicationContext context, ManagerDirector director) {
        this.context = context;
        this.director = director;
        this.manager = director.getDataManager();
        this.clientManager = director.getClientManager();
        this.setName("contentPanel");
        this.readStates();
        Swinger.initActions(this, context);
        this.initComponents();
        this.setActions();
        this.manager.getDownloadFiles().addListDataListener(this);
        this.manager.addPropertyChangeListener(this);
    }

    private void readStates() {
        DownloadState[] downloadStates = DownloadState.values();
        states = new String[downloadStates.length];
        int i = 0;
        for (DownloadState state : downloadStates) {
            ContentPanel.states[i++] = this.context.getResourceMap().getString(state.name(), new Object[0]);
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void openFileAction() {
        if (AppPrefs.getProperty("openIncompleteFiles", false) && this.isSelectedEnabled()) {
            this.openFilesInSystem(true);
        } else {
            this.openFilesInSystem(false);
        }
    }

    private void openFilesInSystem(boolean storeFile) {
        int[] indexes = this.getSelectedRows();
        List<DownloadFile> files = this.manager.getSelectionToList(indexes);
        for (DownloadFile file : files) {
            if (storeFile) {
                if (file.getStoreFile() != null && file.getStoreFile().length() > 0L && FileUtils.getAbsolutFile(file.getStoreFile()).exists()) {
                    OSDesktop.openFile(file.getStoreFile());
                    continue;
                }
                OSDesktop.openFile(file.getOutputFile());
                continue;
            }
            OSDesktop.openFile(file.getOutputFile());
        }
    }

    public int[] getSelectedRows() {
        return Swinger.getSelectedRows(this.table);
    }

    @Action(enabledProperty="selectedEnabled")
    public void sortbyNameAction() {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        int[] indexes = this.getSelectedRows();
        if (indexes.length == 1) {
            this.table.selectAll();
            indexes = this.getSelectedRows();
        }
        int resultIndex = this.manager.sortByName(indexes);
        selectionModel.setValueIsAdjusting(false);
        if (resultIndex != -1) {
            int index = Swinger.convertRowIndexToView(this.table, resultIndex);
            selectionModel.setSelectionInterval(index, index + indexes.length - 1);
            this.scrollToVisible(true);
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void deleteFileAction() {
        int result;
        boolean showedDialog;
        int[] indexes = this.getSelectedRows();
        List<DownloadFile> files = this.manager.getSelectionToList(indexes);
        String s = this.getFileList(files);
        boolean confirm = AppPrefs.getProperty("confirmFileDelete", true);
        if (s.isEmpty() || !confirm) {
            showedDialog = false;
            result = 0;
        } else {
            result = Swinger.getChoiceOKCancel("message.areyousuredelete", s);
            showedDialog = true;
        }
        if (result == 0) {
            for (DownloadFile file : files) {
                File outputFile = file.getOutputFile();
                if (outputFile != null) {
                    FileUtils.deleteFileWithRecycleBin(outputFile);
                }
                if ((outputFile = file.getStoreFile()) == null) continue;
                FileUtils.deleteFileWithRecycleBin(outputFile);
            }
            this.removeSelected(files, indexes, showedDialog);
            if (indexes.length > 0) {
                Arrays.sort(indexes);
                this.renewSelection(new int[]{indexes[0]});
            } else {
                this.selectFirstIfNoSelection();
            }
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void downloadInformationAction() throws Exception {
        int[] indexes = this.getSelectedRows();
        List<DownloadFile> files = this.manager.getSelectionToList(indexes);
        if (files.isEmpty()) {
            return;
        }
        MainApp app = (MainApp)this.context.getApplication();
        JFrame owner = app.getMainFrame();
        if (files.size() == 1) {
            InformationDialog dialog = new InformationDialog(owner, this.director, files.get(0));
            app.show(dialog);
        } else {
            MultipleSettingsDialog dialog = new MultipleSettingsDialog(owner, files);
            app.show(dialog);
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void openDirectoryAction() {
        int[] indexes = this.getSelectedRows();
        List<DownloadFile> files = this.manager.getSelectionToList(indexes);
        for (DownloadFile file : files) {
            OSDesktop.openDirectoryForFile(file.getOutputFile());
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void searchSubtitlesAction() {
        int[] indexes = this.getSelectedRows();
        List<DownloadFile> files = this.manager.getSelectionToList(indexes);
        String subLanguage = AppPrefs.getProperty("searchSubtitlesLanguage", Locale.getDefault().getISO3Language());
        HashMap<String, String> remapLang = new HashMap<String, String>();
        remapLang.put("ces", "cze");
        remapLang.put("fra", "fre");
        remapLang.put("nld", "dut");
        remapLang.put("fas", "per");
        remapLang.put("slk", "slo");
        if (remapLang.containsKey(subLanguage)) {
            subLanguage = (String)remapLang.get(subLanguage);
        }
        String weblanguage = Locale.getDefault().getLanguage();
        for (DownloadFile file : files) {
            long fs = file.getFileSize();
            if (fs <= 0L) continue;
            String url = String.format("http://www.opensubtitles.org/%s/search/moviebytesize-%s/sublanguageid-%s", weblanguage, fs, subLanguage);
            Browser.openBrowser(url);
        }
    }

    @Action(enabledProperty="resumeActionEnabled")
    public void resumeAction() {
        if (this.isResumeActionEnabled()) {
            this.manager.resumeSelected(this.getSelectedRows());
        }
    }

    @Action(enabledProperty="pauseActionEnabled")
    public void pauseAction() {
        this.manager.pauseSelected(this.getSelectedRows());
    }

    @Action(enabledProperty="cancelActionEnabled")
    public void cancelAction() {
        boolean deleteFiles;
        int result;
        if (!this.isCancelActionEnabled()) {
            return;
        }
        int[] indexes = this.getSelectedRows();
        List<DownloadFile> files = this.manager.getSelectionToList(indexes);
        String s = this.getFileList(files);
        boolean confirm = AppPrefs.getProperty("confirmFileDelete", true);
        if (confirm && !s.isEmpty()) {
            result = Swinger.getChoiceYesNoCancel("message.areyousuredelete", s);
            deleteFiles = result == 0;
        } else {
            result = 0;
            deleteFiles = true;
        }
        if (result == 0 || result == 1) {
            this.manager.cancelSelected(this.getSelectedRows(), deleteFiles);
        }
    }

    @Action(enabledProperty="nonEmptyEnabled")
    public void retryAllErrorAction() {
        if (this.isResumeActionEnabled()) {
            this.manager.retryAllError();
        }
    }

    private String getFileList(List<DownloadFile> files) {
        ArrayList<DownloadFile> existingFiles = new ArrayList<DownloadFile>();
        for (DownloadFile file : files) {
            if (file.getOutputFile() == null || file.getDownloaded() <= 0L || !file.getOutputFile().exists()) continue;
            existingFiles.add(file);
        }
        StringBuilder builder = new StringBuilder();
        int n = Math.min(existingFiles.size(), 20);
        for (int i = 0; i < n; ++i) {
            builder.append('\n').append(Utils.shortenFileName(((DownloadFile)existingFiles.get(i)).getOutputFile()));
        }
        if (existingFiles.size() > 20) {
            builder.append('\n').append(this.context.getResourceMap().getString("andOtherFiles", existingFiles.size() - 20));
        }
        return builder.toString();
    }

    @Action(enabledProperty="removeCompletedActionEnabled")
    public void removeCompletedAction() {
        int[] rows = this.getSelectedRows();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        this.manager.removeCompleted();
        this.renewSelection(rows);
        selectionModel.setValueIsAdjusting(false);
    }

    @Action(enabledProperty="removeCompletedAndDeletedActionEnabled")
    public void removeCompletedAndDeletedAction() {
        int[] rows = this.getSelectedRows();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        this.manager.removeCompletedAndDeleted();
        this.renewSelection(rows);
        selectionModel.setValueIsAdjusting(false);
    }

    private void selectFirstIfNoSelection() {
        int[] rows = this.getSelectedRows();
        if (rows.length == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ContentPanel.this.getVisibleRowCount() > 0) {
                        ContentPanel.this.table.getSelectionModel().setSelectionInterval(0, 0);
                    }
                }
            });
        }
    }

    @Action(enabledProperty="nonEmptyEnabled")
    public void selectAllAction() {
        this.table.selectAll();
    }

    @Action(enabledProperty="nonEmptyEnabled")
    public void invertSelectionAction() {
        int[] indexes = this.getSelectedRows();
        int count = this.table.getModel().getRowCount();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        if (indexes.length > 1) {
            Arrays.sort(indexes);
        }
        for (int i = 0; i < count; ++i) {
            if (Arrays.binarySearch(indexes, i) >= 0) continue;
            int index = Swinger.convertRowIndexToView(this.table, i);
            selectionModel.addSelectionInterval(index, index);
        }
        selectionModel.setValueIsAdjusting(false);
        this.scrollToVisible(true);
    }

    @Action(enabledProperty="selectedEnabled")
    public void removeSelectedAction() {
        int[] indexes = this.getSelectedRows();
        List<DownloadFile> files = this.manager.getSelectionToList(indexes);
        this.removeSelected(files, indexes, false);
    }

    @Action(enabledProperty="removeInvalidLinksActionEnabled")
    public void removeInvalidLinksAction() {
        int[] rows = this.getSelectedRows();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        this.manager.removeInvalidLinks();
        this.renewSelection(rows);
        selectionModel.setValueIsAdjusting(false);
    }

    private void renewSelection(final int[] rows) {
        this.table.clearSelection();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int visibleRowCount = ContentPanel.this.getVisibleRowCount();
                if (visibleRowCount <= 0) {
                    return;
                }
                for (int row : rows) {
                    int i = Swinger.convertRowIndexToView(ContentPanel.this.table, row);
                    if (i == -1) continue;
                    if (i >= visibleRowCount) {
                        i = visibleRowCount - 1;
                    }
                    ContentPanel.this.table.getSelectionModel().addSelectionInterval(i, i);
                }
                ContentPanel.this.selectFirstIfNoSelection();
                ContentPanel.this.scrollToVisible(true);
            }
        });
    }

    private void removeSelected(List<DownloadFile> files, int[] indexes, boolean quiet) {
        boolean confirmRemove;
        final ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        if (!quiet && (confirmRemove = AppPrefs.getProperty("confirmRemove", true))) {
            int result;
            boolean confirmDownloadingOnly = AppPrefs.getProperty("confirmDownloadingRemove", false);
            boolean showDialog = false;
            if (confirmDownloadingOnly) {
                for (DownloadFile file : files) {
                    if (DownloadState.DOWNLOADING != file.getState()) continue;
                    showDialog = true;
                    break;
                }
            } else {
                showDialog = true;
            }
            if (showDialog && (result = Swinger.getChoiceOKCancel("areYouSureYouWantToRemove", new Object[0])) != 0) {
                return;
            }
        }
        this.manager.removeSelected(files);
        selectionModel.setValueIsAdjusting(false);
        final int min = this.getArrayMin(indexes);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int count = ContentPanel.this.getVisibleRowCount();
                if (count > 0) {
                    int index = count - 1;
                    if (min < index && (index = min) == -1) {
                        index = count - 1;
                    }
                    selectionModel.addSelectionInterval(index, index);
                    ContentPanel.this.scrollToVisible(true);
                }
            }
        });
    }

    private int getVisibleRowCount() {
        return this.table.getRowSorter().getViewRowCount();
    }

    private int getArrayMin(int[] indexes) {
        int min = Integer.MAX_VALUE;
        for (int i : indexes) {
            if (min <= (i = Swinger.convertRowIndexToView(this.table, i)) || i == -1) continue;
            min = i;
        }
        return min;
    }

    @Action(enabledProperty="validateLinksEnabled")
    public void validateLinksAction() {
        this.manager.validateLinks(this.getSelectedRows());
    }

    @Action(enabledProperty="moveEnabled")
    public void topAction() {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        int[] indexes = this.getSelectedRows();
        this.manager.moveTop(indexes);
        selectionModel.setValueIsAdjusting(false);
        selectionModel.setSelectionInterval(0, indexes.length - 1);
        this.scrollToVisible(true);
    }

    @Action(enabledProperty="moveEnabled")
    public void upAction() {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        int[] indexes = this.getSelectedRows();
        this.manager.moveUp(indexes);
        selectionModel.clearSelection();
        for (int index : indexes) {
            index = Swinger.convertRowIndexToView(this.table, index);
            selectionModel.addSelectionInterval(index, index);
        }
        selectionModel.setValueIsAdjusting(false);
        this.scrollToVisible(true);
    }

    private void scrollToVisible(final boolean up) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int[] rows = ContentPanel.this.table.getSelectedRows();
                int length = rows.length;
                if (length > 0) {
                    ContentPanel.this.table.scrollRowToVisible(up ? rows[0] : rows[length - 1]);
                }
            }
        });
    }

    @Action(enabledProperty="moveEnabled")
    public void downAction() {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        int[] indexes = this.getSelectedRows();
        this.manager.moveDown(indexes);
        selectionModel.clearSelection();
        for (int index : indexes) {
            index = Swinger.convertRowIndexToView(this.table, index);
            selectionModel.addSelectionInterval(index, index);
        }
        selectionModel.setValueIsAdjusting(false);
        this.scrollToVisible(false);
    }

    @Action(enabledProperty="moveEnabled")
    public void bottomAction() {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        int[] indexes = this.getSelectedRows();
        this.manager.moveBottom(indexes);
        selectionModel.setValueIsAdjusting(false);
        int rowCount = this.table.getRowCount();
        selectionModel.setSelectionInterval(rowCount - indexes.length, rowCount - 1);
        this.scrollToVisible(false);
    }

    @Action(enabledProperty="selectedEnabled")
    public void openInBrowser() {
        List<DownloadFile> files = this.manager.getSelectionToList(this.getSelectedRows());
        for (HttpFile httpFile : files) {
            Browser.openBrowser(httpFile.getFileUrl().toExternalForm().replaceAll("%23", "#"));
        }
    }

    private void setActions() {
        this.initTable();
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(final PreferenceChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ContentPanel.this.updateTableFromPreferences(evt);
                    }
                });
            }
        });
        this.updateGridLines();
    }

    private void updateTableFromPreferences(PreferenceChangeEvent evt) {
        if ("showHorizontalGridLines".equals(evt.getKey()) || "showVerticalGridLines".equals(evt.getKey())) {
            this.updateGridLines();
        } else if ("showServicesAsIcons".equals(evt.getKey())) {
            this.table.repaint();
            this.table.packAll();
        }
    }

    private void updateGridLines() {
        boolean horizontal = AppPrefs.getProperty("showHorizontalGridLines", false);
        boolean vertical = AppPrefs.getProperty("showVerticalGridLines", false);
        this.table.setShowGrid(horizontal, vertical);
    }

    public void updateFilters() {
        SortController rowSorter = (SortController)((Object)this.table.getRowSorter());
        if (!AppPrefs.getProperty("removeCompleted", true)) {
            rowSorter.setRowFilter(new StateFilter());
        } else {
            rowSorter.setRowFilter(null);
        }
    }

    private boolean isCancelledExisting() {
        int[] indexes = this.getSelectedRows();
        List<DownloadFile> files = this.manager.getSelectionToList(indexes);
        for (DownloadFile file : files) {
            File outputFile = file.getOutputFile();
            if (outputFile.exists() && outputFile.length() == file.getFileSize() && file.getFileSize() > 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isPauseActionEnabled() {
        return this.pauseActionEnabled;
    }

    public void setPauseActionEnabled(boolean pauseActionEnabled) {
        boolean oldValue = this.pauseActionEnabled;
        this.pauseActionEnabled = pauseActionEnabled;
        this.firePropertyChange(PAUSE_ACTION_ENABLED_PROPERTY, oldValue, pauseActionEnabled);
    }

    public boolean isValidateLinksEnabled() {
        return this.validateLinksEnabled;
    }

    public void setValidateLinksEnabled(boolean validateLinksEnabled) {
        boolean oldValue = this.validateLinksEnabled;
        this.validateLinksEnabled = validateLinksEnabled;
        this.firePropertyChange(VALIDATELINKS_ACTION_ENABLED_PROPERTY, oldValue, validateLinksEnabled);
    }

    public boolean isCancelActionEnabled() {
        return this.cancelActionEnabled;
    }

    public void setCancelActionEnabled(boolean cancelActionEnabled) {
        boolean oldValue = this.cancelActionEnabled;
        this.cancelActionEnabled = cancelActionEnabled;
        this.firePropertyChange(CANCEL_ACTION_ENABLED_PROPERTY, oldValue, cancelActionEnabled);
    }

    public boolean isResumeActionEnabled() {
        return this.resumeActionEnabled;
    }

    public void setResumeActionEnabled(boolean resumeActionEnabled) {
        boolean oldValue = this.resumeActionEnabled;
        this.resumeActionEnabled = resumeActionEnabled;
        this.firePropertyChange(RESUME_ACTION_ENABLED_PROPERTY, oldValue, resumeActionEnabled);
    }

    public boolean isRemoveCompletedActionEnabled() {
        return this.removeCompletedActionEnabled;
    }

    public void setRemoveCompletedActionEnabled(boolean removeCompletedActionEnabled) {
        boolean oldValue = this.removeCompletedActionEnabled;
        this.removeCompletedActionEnabled = removeCompletedActionEnabled;
        this.firePropertyChange(REMOVECOMPLETED_ACTION_ENABLED_PROPERTY, oldValue, removeCompletedActionEnabled);
    }

    public boolean isRemoveCompletedAndDeletedActionEnabled() {
        return this.removeCompletedAndDeletedActionEnabled;
    }

    public void setRemoveCompletedAndDeletedActionEnabled(boolean removeCompletedAndDeletedActionEnabled) {
        boolean oldValue = this.removeCompletedAndDeletedActionEnabled;
        this.removeCompletedAndDeletedActionEnabled = removeCompletedAndDeletedActionEnabled;
        this.firePropertyChange(REMOVECOMPLETEDANDDELETED_ACTION_ENABLED_PROPERTY, oldValue, removeCompletedAndDeletedActionEnabled);
    }

    public boolean isRemoveInvalidLinksActionEnabled() {
        return this.removeInvalidLinksActionEnabled;
    }

    public void setRemoveInvalidLinksActionEnabled(boolean removeInvalidLinksActionEnabled) {
        boolean oldValue = this.removeInvalidLinksActionEnabled;
        this.removeInvalidLinksActionEnabled = removeInvalidLinksActionEnabled;
        this.firePropertyChange(REMOVEINVALID_ACTION_ENABLED_PROPERTY, oldValue, removeInvalidLinksActionEnabled);
    }

    public boolean isCompleteWithFilesEnabled() {
        return this.completeWithFilesEnabled;
    }

    public void setCompletedWithFilesEnabled(boolean completedEnabled) {
        boolean oldValue = this.completeWithFilesEnabled;
        this.completeWithFilesEnabled = completedEnabled;
        this.firePropertyChange(COMPLETED_OK_ACTION_ENABLED_PROPERTY, oldValue, completedEnabled);
    }

    public boolean isSelectedEnabled() {
        return this.selectedEnabled;
    }

    public void setSelectedEnabled(boolean selectedEnabled) {
        boolean oldValue = this.selectedEnabled;
        this.selectedEnabled = selectedEnabled;
        this.firePropertyChange(SELECTED_ACTION_ENABLED_PROPERTY, oldValue, selectedEnabled);
    }

    public boolean isMoveEnabled() {
        return this.moveEnabled;
    }

    public void setMoveEnabled(boolean moveEnabled) {
        boolean oldValue = this.moveEnabled;
        this.moveEnabled = moveEnabled;
        this.firePropertyChange(MOVEENABLED_ACTION_ENABLED_PROPERTY, oldValue, moveEnabled);
    }

    public boolean isNonEmptyEnabled() {
        return this.nonEmptyEnabled;
    }

    public void setNonEmptyEnabled(boolean nonEmptyEnabled) {
        boolean oldValue = this.nonEmptyEnabled;
        this.nonEmptyEnabled = nonEmptyEnabled;
        this.firePropertyChange(NONEMPTY_ACTION_ENABLED_PROPERTY, oldValue, nonEmptyEnabled);
    }

    private boolean isSorted() {
        List<RowSorter.SortKey> keys;
        if (this.table.isSortable() && !(keys = this.table.getRowSorter().getSortKeys()).isEmpty()) {
            for (RowSorter.SortKey key : keys) {
                if (key.getSortOrder() == SortOrder.UNSORTED) continue;
                return true;
            }
        }
        return false;
    }

    private void updateActions() {
        int[] indexes = this.getSelectedRows();
        boolean enabledCancel = this.manager.hasDownloadFilesStates(indexes, DownloadsActions.cancelEnabledStates);
        this.setCancelActionEnabled(enabledCancel);
        this.setSelectedEnabled(indexes.length > 0);
        this.setMoveEnabled(this.isSelectedEnabled() && !this.isSorted());
        boolean allCompleted = this.manager.hasDownloadFilesStates(indexes, DownloadsActions.completedStates);
        if (allCompleted) {
            boolean valid = true;
            List<DownloadFile> files = this.manager.getSelectionToList(indexes);
            for (DownloadFile file : files) {
                if (file.getOutputFile().exists()) continue;
                valid = false;
                break;
            }
            this.setCompletedWithFilesEnabled(valid);
            this.setResumeActionEnabled(false);
            this.setPauseActionEnabled(false);
            this.setValidateLinksEnabled(false);
        } else {
            boolean enabledResume = this.manager.hasAnyDownloadFilesStates(indexes, DownloadsActions.resumeEnabledStates);
            this.setResumeActionEnabled(enabledResume);
            boolean enabledPause = this.manager.isPausable(indexes);
            this.setPauseActionEnabled(enabledPause);
            this.setValidateLinksEnabled(this.manager.hasAnyDownloadFilesStates(indexes, DownloadsActions.recheckExistingStates));
            this.setCompletedWithFilesEnabled(false);
        }
        this.setNonEmptyEnabled(this.table.getModel().getRowCount() > 0);
    }

    private void initTable() {
        this.table.setName("mainTable");
        String[] columns = Swinger.getList(this.context.getResourceMap(), "mainTableColumns", 12);
        this.table.setModel(new CustomTableModel(this.manager.getDownloadFiles(), columns));
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setAutoResizeMode(AppPrefs.getProperty("tableColumnsResize", 2));
        this.table.setEditable(true);
        this.table.setAutoStartEditOnKeyStroke(false);
        this.table.setColumnControlVisible(true);
        this.table.setColumnSelectionAllowed(false);
        WinampMoveStyle w = new WinampMoveStyle();
        this.table.addMouseListener(w);
        this.table.addMouseMotionListener(w);
        this.table.setSortsOnUpdates(true);
        this.table.setTransferHandler(new URLTransferHandler(this.director){

            @Override
            protected void doDropAction(final List<URL> files) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Swinger.getAction("addNewLinksAction").actionPerformed(new ActionEvent(files, 0, null));
                    }
                });
            }
        });
        ColorHighlighter highlighter = new ColorHighlighter(new HighlightPredicate(){

            @Override
            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                return FileState.FILE_NOT_FOUND.equals((Object)((DownloadFile)adapter.getValue(0)).getFileState());
            }
        }, new Color(0xFFD2D2), Color.BLACK);
        this.table.getSelectionModel().addListSelectionListener(this);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        this.table.createDefaultColumnsFromModel();
        TableColumnExt colName = (TableColumnExt)tableColumnModel.getColumn(1);
        colName.setCellEditor(new RenameFileNameEditor(this.director.getFileTypeIconProvider()));
        colName.setCellRenderer(new NameURLCellRenderer(this.director.getFileTypeIconProvider()));
        colName.setComparator(new NameColumnComparator());
        colName.setWidth(150);
        colName.setMinWidth(50);
        this.initColumn(2, new ProgressBarCellRenderer(this.context), new ProgressBarColumnComparator());
        TableColumnExt column = (TableColumnExt)tableColumnModel.getColumn(0);
        column.setComparator(new CheckedColumnComparator());
        column.setMaxWidth(30);
        column.setWidth(30);
        column.setCellRenderer(new CheckedCellRenderer(this.context));
        TableColumnExt columnExt = (TableColumnExt)tableColumnModel.getColumn(0);
        columnExt.setToolTipText(this.context.getResourceMap().getString("checkedColumnTooltip", new Object[0]));
        this.initColumn(3, new ProgressCellRenderer(), new ProgressColumnComparator());
        this.initColumn(4, new EstTimeCellRenderer(this.context), new EstTimeColumnComparator());
        this.initColumn(5, new SizeCellRenderer(this.context), new SizeColumnComparator());
        this.initColumn(6, new SpeedCellRenderer(this.context), new SpeedColumnComparator());
        this.initColumn(7, new AverageSpeedCellRenderer(), new AvgSpeedColumnComparator());
        this.initColumn(8, new ServiceCellRenderer(this.director), new ServiceColumnComparator());
        this.initColumn(9, new ConnectionCellRenderer(this.context), new ConnectionColumnComparator());
        TableColumnExt columnDescription = this.initColumn(10, new DescriptionCellRenderer(this.context), new DescriptionColumnComparator());
        TableColumnExt columnDate = this.initColumn(11, new DateCellRenderer(), new DateColumnComparator());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ContentPanel.this.showPopMenu(e);
                } else if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() >= 2) {
                    ContentPanel.this.smartEnterAction();
                }
            }
        });
        this.setSorterComparator();
        columnDescription.setVisible(false);
        columnDate.setVisible(false);
        this.table.packAll();
        InputMap inputMap = this.table.getInputMap();
        ActionMap actionMap = this.table.getActionMap();
        inputMap.put(SwingUtils.getCtrlKeyStroke(75), "searchFieldAction");
        actionMap.put("searchFieldAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchField field = ContentPanel.this.director.getToolbarManager().getSearchField();
                if (field.isVisible()) {
                    Swinger.inputFocus(field);
                }
            }
        });
        inputMap.put(SwingUtils.getCtrlKeyStroke(67), "copy");
        inputMap.put(SwingUtils.getCtrlAltKeyStroke(67), "copy");
        actionMap.put("copy", Swinger.getAction("copyContent"));
        if (AppPrefs.getProperty("cancelOnEscape", true)) {
            inputMap.put(SwingUtils.getKeyStroke(27), "deleteItem");
            actionMap.put("deleteItem", Swinger.getAction("cancelAction"));
        }
        inputMap.put(SwingUtils.getShiftKeyStroke(127), "deleteFileAction");
        actionMap.put("deleteFileAction", Swinger.getAction("deleteFileAction"));
        inputMap.put(SwingUtils.getKeyStroke(32), "resumeAction");
        actionMap.put("resumeAction", Swinger.getAction("resumeAction"));
        inputMap.put(SwingUtils.getKeyStroke(525), "contextMenu");
        actionMap.put("contextMenu", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point point = new Point();
                Rectangle rect = ContentPanel.this.table.getVisibleRect();
                if (Swinger.getSelectedRows(ContentPanel.this.table).length > 0) {
                    int row = ContentPanel.this.table.getSelectionModel().getLeadSelectionIndex();
                    Rectangle cellRect = ContentPanel.this.table.getCellRect(row, 0, true);
                    cellRect.y += cellRect.height - 1;
                    point.y = cellRect.y > rect.y && rect.y + rect.height > cellRect.y ? cellRect.y : (cellRect.y < rect.y ? rect.y : rect.y + rect.height);
                    point.x = cellRect.x;
                } else {
                    point.x = ((ContentPanel)ContentPanel.this).table.getCellRect((int)0, (int)0, (boolean)true).x;
                }
                ContentPanel.this.showPopMenu(new MouseEvent(ContentPanel.this.table, 0, 0L, 0, point.x, point.y, 1, true));
            }
        });
        inputMap.put(SwingUtils.getKeyStroke(10), "smartEnterAction");
        actionMap.put("smartEnterAction", Swinger.getAction("smartEnterAction"));
        inputMap.put(SwingUtils.getKeyStroke(36), "selectFirstRow");
        inputMap.put(SwingUtils.getKeyStroke(35), "selectLastRow");
        inputMap.put(SwingUtils.getCtrlKeyStroke(36), "selectFirstColumn");
        inputMap.put(SwingUtils.getCtrlKeyStroke(35), "selectLastColumn");
        inputMap.put(SwingUtils.getShiftKeyStroke(36), "selectFirstRowExtendSelection");
        inputMap.put(SwingUtils.getShiftKeyStroke(35), "selectLastRowExtendSelection");
        inputMap.put(SwingUtils.getKeyStroke(113), "renameAction");
        actionMap.put("renameAction", Swinger.getAction("renameAction"));
        inputMap.remove(KeyStroke.getKeyStroke("F8"));
        actionMap.remove("find");
        actionMap.remove("focusHeader");
        this.updateFilters();
        this.table.addHighlighter(highlighter);
        new FindTableAction(Swinger.getResourceMap(), 1){

            @Override
            protected Object getObject(int index, int column) {
                DownloadFile downloadFile = (DownloadFile)ContentPanel.this.table.getModel().getValueAt(index, column);
                if (downloadFile == null) {
                    logger.warning("Download File is null");
                    return null;
                }
                String fn = downloadFile.getFileNameRenameTo() != null ? downloadFile.getFileNameRenameTo() : downloadFile.getFileName();
                String url = downloadFile.getFileUrl().toString();
                String value = fn != null && !fn.isEmpty() ? fn : url;
                return value;
            }
        }.install(this.table);
        Swinger.inputFocus(this.table);
    }

    private void setSorterComparator() {
        boolean b = AppPrefs.getProperty("tableSortable", true);
        this.table.setSortable(b);
        if (b) {
            TableModelTableSortController tableSortController = new TableModelTableSortController(this.table);
            tableSortController.setMaxSortKeys(1);
            this.table.setRowSorter(tableSortController);
            this.table.setSortOrderCycle(SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED);
        }
        this.table.setUpdateSelectionOnSort(b);
    }

    private TableColumnExt initColumn(int columnIndex, TableCellRenderer tableCellRenderer, Comparator comparator) {
        TableColumnExt column = (TableColumnExt)this.table.getColumn(columnIndex);
        column.setCellRenderer(tableCellRenderer);
        column.setComparator(comparator);
        return column;
    }

    @Action
    public void smartEnterAction() {
        if (AppPrefs.getProperty("openIncompleteFiles", false) && this.isSelectedEnabled()) {
            this.openFilesInSystem(true);
            return;
        }
        if (this.isCompleteWithFilesEnabled() || this.isSelectedEnabled() && this.isCancelledExisting()) {
            this.openFileAction();
        } else if (this.isSelectedEnabled()) {
            try {
                this.downloadInformationAction();
            }
            catch (Exception ex) {
                LogUtils.processException(logger, ex);
            }
        }
    }

    public void paste() {
        javax.swing.Action action = this.table.getActionMap().get("paste");
        action.actionPerformed(new ActionEvent(this.table, 0, "paste"));
    }

    @Action(enabledProperty="selectedEnabled")
    public void renameAction() {
        int[] selectedRows = this.table.getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        final int selectedRow = selectedRows[0];
        int selectedColumn = this.table.convertColumnIndexToView(1);
        DownloadFile valueAt = (DownloadFile)this.table.getValueAt(selectedRow, selectedColumn);
        if (valueAt.getFileNameRenameTo() == null && valueAt.getFileName() == null) {
            return;
        }
        final String backup = valueAt.getFileNameRenameTo() != null ? valueAt.getFileNameRenameTo() : valueAt.getFileName();
        final boolean isRenameToNull = valueAt.getFileNameRenameTo() == null;
        final File originalOuputFile = valueAt.getOutputFile();
        final boolean wasExisting = originalOuputFile.exists();
        boolean result = this.table.editCellAt(selectedRow, selectedColumn);
        if (!result) {
            return;
        }
        final TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingStopped(ChangeEvent e) {
                    final RenameFileNameEditor source = (RenameFileNameEditor)e.getSource();
                    cellEditor.removeCellEditorListener(this);
                    DownloadFile resultDownloadFile = (DownloadFile)source.getCellEditorValue();
                    File out = resultDownloadFile.getOutputFile();
                    if (backup.equals(out.getName())) {
                        return;
                    }
                    if (wasExisting) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ContentPanel.this.renameFile(source, originalOuputFile, backup, selectedRow, isRenameToNull);
                            }
                        });
                    } else {
                        ContentPanel.this.scrollToVisible(true);
                    }
                }

                @Override
                public void editingCanceled(ChangeEvent e) {
                    cellEditor.removeCellEditorListener(this);
                }
            });
        }
    }

    private void renameFile(RenameFileNameEditor source, File originalOuputFile, String backupFileName, int selectedRow, boolean isRenameToNull) {
        boolean succeeded;
        DownloadFile resultDownloadFile = (DownloadFile)source.getCellEditorValue();
        File out = resultDownloadFile.getOutputFile();
        if (out.exists()) {
            int answer = Swinger.showOptionDialog(this.context.getResourceMap(), true, 3, "confirmMessage", "targetFileAlreadyExists", new String[]{"message.button.overwrite", "message.button.cancel"}, out);
            if (answer == 0) {
                succeeded = FileUtils.deleteFileWithRecycleBin(out);
                if (succeeded) {
                    succeeded = originalOuputFile.renameTo(out);
                }
            } else {
                succeeded = false;
            }
        } else {
            succeeded = originalOuputFile.renameTo(out);
        }
        if (!succeeded) {
            if (!isRenameToNull) {
                resultDownloadFile.setFileNameRenameTo(backupFileName);
            } else {
                resultDownloadFile.setFileName(backupFileName);
            }
            this.table.setValueAt(resultDownloadFile, selectedRow, this.table.convertColumnIndexToView(1));
        } else {
            this.scrollToVisible(true);
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void copyContent() {
        List<DownloadFile> files = this.manager.getSelectionToList(this.getSelectedRows());
        StringBuilder builder = new StringBuilder();
        for (DownloadFile file : files) {
            builder.append(file.toString().replaceAll("%23", "#")).append('\n');
        }
        SwingUtils.copyToClipboard(builder.toString().trim(), this);
    }

    private JMenuItem getPluginOptions(int[] selectedRows) {
        if (selectedRows.length == 0) {
            return null;
        }
        List<DownloadFile> downloadFileList = this.manager.getSelectionToList(selectedRows);
        DownloadFile httpFile = downloadFileList.get(0);
        if (httpFile.getState() == DownloadState.COMPLETED || httpFile.getState() == DownloadState.DELETED) {
            return null;
        }
        String pluginID = httpFile.getPluginID();
        try {
            if (!this.director.getPluginsManager().getPluginMetadata(pluginID).isOptionable()) {
                return null;
            }
        }
        catch (Exception x) {
            return null;
        }
        JMenuItem pluginOptions = new JMenuItem(new PluginOptionsAction(downloadFileList));
        pluginOptions.setText(this.context.getResourceMap().getString("textPluginOptions", pluginID));
        if (this.director.getPluginsManager().getPluginMetadata(pluginID).hasFavicon()) {
            try {
                pluginOptions.setIcon(this.director.getPluginsManager().getPluginInstance(pluginID).getFaviconImage());
            }
            catch (NotSupportedDownloadServiceException e) {
                return null;
            }
        }
        return pluginOptions;
    }

    private void showPopMenu(MouseEvent e) {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        int rowNumber = this.table.rowAtPoint(e.getPoint());
        if (rowNumber != -1) {
            if (selectedRows.length <= 0) {
                if (this.getVisibleRowCount() > 0) {
                    selectionModel.setSelectionInterval(rowNumber, rowNumber);
                }
            } else {
                Arrays.sort(selectedRows);
                if (Arrays.binarySearch(selectedRows, this.table.convertRowIndexToModel(rowNumber)) < 0) {
                    selectionModel.setValueIsAdjusting(true);
                    this.table.clearSelection();
                    selectionModel.setSelectionInterval(rowNumber, rowNumber);
                    selectionModel.setValueIsAdjusting(false);
                }
            }
        } else {
            this.table.clearSelection();
        }
        selectedRows = this.getSelectedRows();
        JPopupMenu popup = new JPopupMenu();
        ApplicationActionMap map = this.context.getActionMap();
        MenuManager mm = this.director.getMenuManager();
        JMenu removeMenu = mm.createMenu("removeMenu", map, "removeCompletedAction", "removeCompletedAndDeletedAction", "removeInvalidLinksAction", "removeSelectedAction");
        boolean removeEnabled = map.get("removeCompletedAction").isEnabled() || map.get("removeCompletedAndDeletedAction").isEnabled() || map.get("removeInvalidLinksAction").isEnabled() || map.get("removeSelectedAction").isEnabled();
        removeMenu.setEnabled(removeEnabled);
        ResourceMap rMap = this.context.getResourceMap();
        rMap.injectComponent(removeMenu);
        JMenu speedLimitMenu = new JMenu();
        speedLimitMenu.setName("speedLimitMenu");
        rMap.injectComponent(speedLimitMenu);
        popup.add(map.get("downloadInformationAction"));
        JMenuItem pluginOptions = this.getPluginOptions(selectedRows);
        if (pluginOptions != null) {
            popup.add(pluginOptions);
        }
        popup.addSeparator();
        popup.add(map.get("openFileAction"));
        popup.add(map.get("deleteFileAction"));
        popup.add(map.get("openDirectoryAction"));
        popup.add(map.get("renameAction"));
        popup.addSeparator();
        popup.add(map.get("resumeAction"));
        popup.add(map.get("pauseAction"));
        popup.add(map.get("cancelAction"));
        popup.addSeparator();
        popup.add(removeMenu);
        popup.addSeparator();
        popup.add(map.get("validateLinksAction"));
        popup.add(speedLimitMenu);
        popup.addSeparator();
        popup.add(map.get("selectAllAction"));
        popup.add(map.get("invertSelectionAction"));
        JMenu forceMenu = new JMenu();
        forceMenu.setName("forceDownloadMenu");
        forceMenu.setIcon(rMap.getIcon("forceDownloadMenu_smallIcon"));
        rMap.injectComponent(forceMenu);
        String[] speedStrings = AppPrefs.getProperty("speedLimitSpeeds", "0,,10,15,20,30,40,50,100,150,200,300").split(",");
        ArrayList<Integer> speeds = new ArrayList<Integer>(speedStrings.length);
        for (String s : speedStrings) {
            try {
                int num;
                int n = num = s.trim().isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(s.trim());
                if (num == 0) {
                    num = -1;
                }
                if (num < -1) continue;
                speeds.add(num);
            }
            catch (NumberFormatException num) {
                // empty catch block
            }
        }
        ButtonGroup group = new ButtonGroup();
        List<DownloadFile> files = this.manager.getSelectionToList(selectedRows);
        if (!files.isEmpty() && !speeds.contains(files.get(0).getSpeedLimit())) {
            speeds.add(files.get(0).getSpeedLimit());
        }
        Iterator iterator = speeds.iterator();
        while (iterator.hasNext()) {
            int limit = (Integer)iterator.next();
            if (limit == Integer.MAX_VALUE) {
                speedLimitMenu.addSeparator();
                continue;
            }
            String stValue = limit == -1 ? rMap.getString("unlimitedSpeed", new Object[0]) : rMap.getString("limitSpeed", limit);
            JRadioButtonMenuItem radio = new JRadioButtonMenuItem(new SpeedLimitAction(stValue, limit));
            group.add(radio);
            radio.setAlignmentX(0.0f);
            speedLimitMenu.add(radio);
            if (files.isEmpty()) continue;
            radio.setSelected(files.get(0).getSpeedLimit() == limit);
        }
        boolean forceEnabled = this.isSelectedEnabled() && this.manager.hasDownloadFilesStates(selectedRows, DownloadsActions.forceEnabledStates);
        forceMenu.setEnabled(forceEnabled);
        ArrayList<ConnectionSettings> connectionSettingses = new ArrayList<ConnectionSettings>();
        connectionSettingses.addAll(this.director.getClientManager().getAvailableConnections());
        boolean useProxyForPlugin = AppPrefs.getProperty("useProxyForPlugin", false);
        for (DownloadFile downloadFile : files) {
            ConnectionSettings proxy;
            if (downloadFile.getLocalConnectionSettingsType() == LocalConnectionSettingsType.DIRECT) {
                ConnectionSettings direct = new ConnectionSettings();
                if (!connectionSettingses.contains(direct)) {
                    connectionSettingses.add(direct);
                }
            } else if (downloadFile.getLocalConnectionSettingsType() == LocalConnectionSettingsType.LOCAL_PROXY && (proxy = this.director.getClientManager().getProxyConnection(downloadFile.getLocalProxy(), false)) != null && !connectionSettingses.contains(proxy)) {
                connectionSettingses.add(proxy);
            }
            if (!useProxyForPlugin) continue;
            List<ConnectionSettings> proxyForPluginConnections = this.clientManager.getProxyForPluginConnections(downloadFile.getPluginID());
            for (ConnectionSettings connectionSettings : proxyForPluginConnections) {
                if (connectionSettingses.contains(connectionSettings)) continue;
                connectionSettingses.add(connectionSettings);
            }
        }
        boolean anyEnabled = false;
        for (ConnectionSettings settings : connectionSettingses) {
            ForceDownloadAction action = new ForceDownloadAction(settings);
            forceMenu.add(action);
            action.setEnabled(forceEnabled);
            if (!settings.isEnabled()) continue;
            anyEnabled = true;
        }
        forceMenu.setEnabled(forceEnabled && anyEnabled);
        popup.addSeparator();
        popup.add(forceMenu);
        popup.addSeparator();
        popup.add(map.get("copyContent"));
        popup.add(map.get("openInBrowser"));
        if (AppPrefs.getProperty("searchSubtitlesEnabled", false)) {
            popup.add(map.get("searchSubtitlesAction"));
        }
        MouseEvent mouseEvent = SwingUtilities.convertMouseEvent(this.table, e, this);
        popup.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    private void initComponents() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setName("contentScrollPane");
        this.table = new JXTable();
        this.table.setName("mainTable");
        this.setLayout(new BorderLayout());
        scrollPane.setViewportView(this.table);
        this.add((Component)scrollPane, "Center");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContentPanel.this.updateActions();
            }
        });
    }

    @Override
    public void intervalAdded(final ListDataEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ContentPanel.this.isInInterval(ContentPanel.this.getSelectedRows(), e.getIndex0(), e.getIndex1())) {
                    ContentPanel.this.updateActions();
                }
            }
        });
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.intervalAdded(e);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.intervalAdded(e);
    }

    private boolean isInInterval(int[] indexes, int index0, int index1) {
        for (int i : indexes) {
            if (index0 < i || i > index1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("completed".equals(propertyName)) {
            this.setRemoveCompletedActionEnabled((Integer)evt.getNewValue() > 0);
            this.setRemoveCompletedAndDeletedActionEnabled((Integer)evt.getNewValue() > 0);
        } else if ("notFound".equals(propertyName)) {
            this.setRemoveInvalidLinksActionEnabled((Integer)evt.getNewValue() > 0);
        }
    }

    public void selectAdded(List<DownloadFile> files) {
        assert (!files.isEmpty());
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        int index = this.manager.getDownloadFiles().indexOf(files.get(0));
        int viewIndex = Swinger.convertRowIndexToView(this.table, index);
        selectionModel.setSelectionInterval(viewIndex, viewIndex + files.size() - 1);
        this.scrollToVisible(true);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public static int getProgress(DownloadFile downloadFile) {
        long downloaded = downloadFile.getDownloaded();
        long fileSize = downloadFile.getFileSize();
        if (downloaded <= 0L || fileSize <= 0L) {
            return 0;
        }
        int i = (int)((float)downloaded / (float)fileSize * 100.0f);
        if (i < 0) {
            i = 0;
        } else if (i > 100) {
            i = 100;
        }
        return i;
    }

    static int getProgress(int max, int timeToQueued) {
        return (int)((float)timeToQueued / (float)max * 100.0f);
    }

    public static String secondsToHMin(long seconds) {
        long min = seconds / 60L;
        long hours = min / 60L;
        seconds = seconds - (min -= hours * 60L) * 60L - hours * 3600L;
        if (hours > 0L) {
            return String.format("%02dh:%02dm", hours, min);
        }
        if (min > 0L) {
            return String.format("%02dm:%02ds", min, seconds);
        }
        return String.format("%ds", seconds);
    }

    public static String bytesToAnother(long bytes) {
        if (bytes > 0x40000000L) {
            return numberFormatInstance.format((float)bytes / 1.0737418E9f) + " GB";
        }
        if (bytes > 0x100000L) {
            return numberFormatInstance.format((float)bytes / 1048576.0f) + " MB";
        }
        if (bytes >= 1024L) {
            return numberFormatInstance.format((float)bytes / 1024.0f) + " kB";
        }
        return String.format("%s B", integerInstance.format(bytes));
    }

    public static String stateToString(DownloadState state) {
        return states[state.ordinal()];
    }

    private boolean isSelectedRow(int row) {
        int[] ints;
        for (int i : ints = this.getSelectedRows()) {
            if (i != row) continue;
            return true;
        }
        return false;
    }

    static {
        integerInstance = NumberFormat.getIntegerInstance();
        numberFormatInstance = NumberFormat.getInstance();
        numberFormatInstance.setMaximumFractionDigits(2);
        numberFormatInstance.setMinimumFractionDigits(1);
    }

    private class WinampMoveStyle
    extends MouseAdapter {
        private boolean active = false;
        private int rowPosition;

        private WinampMoveStyle() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                if (!ContentPanel.this.table.getRowSorter().getSortKeys().isEmpty() && ContentPanel.this.isSorted()) {
                    return;
                }
                if (AppPrefs.getProperty("dragOnRightMouse", true)) {
                    this.rowPosition = ContentPanel.this.table.rowAtPoint(e.getPoint());
                    if (this.rowPosition != -1 && ContentPanel.this.isSelectedRow(this.rowPosition)) {
                        this.active = true;
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) && this.active) {
                ContentPanel.this.table.setCursor(Cursor.getDefaultCursor());
                this.active = false;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.active) {
                return;
            }
            try {
                ContentPanel.this.table.setCursor(DragSource.DefaultMoveDrop);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int position = ContentPanel.this.table.rowAtPoint(e.getPoint());
            if (position == -1) {
                return;
            }
            if (this.rowPosition - position >= 1) {
                for (int i = this.rowPosition - position; i > 0; --i) {
                    ContentPanel.this.upAction();
                }
                this.rowPosition = position;
            } else if (this.rowPosition - position <= -1) {
                for (int i = -1 * (this.rowPosition - position); i > 0; --i) {
                    ContentPanel.this.downAction();
                }
                this.rowPosition = position;
            }
        }
    }

    private class SpeedLimitAction
    extends AbstractAction {
        private final int value;

        public SpeedLimitAction(String stringValue, int value) {
            this.value = value;
            this.putValue("Name", stringValue);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContentPanel.this.manager.setSpeedLimit(ContentPanel.this.getSelectedRows(), this.value);
        }
    }

    private class ForceDownloadAction
    extends AbstractAction {
        private final ConnectionSettings settings;

        public ForceDownloadAction(ConnectionSettings settings) {
            this.settings = settings;
            this.putValue("Name", settings.toString());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContentPanel.this.manager.forceDownload(this.settings, ContentPanel.this.getSelectedRows());
        }
    }

    private class PluginOptionsAction
    extends AbstractAction {
        private final String pluginID;
        private final List<DownloadFile> downloadFileList;
        private final DownloadFile downloadFile;

        public PluginOptionsAction(List<DownloadFile> downloadFileList) {
            this.downloadFileList = downloadFileList;
            this.downloadFile = downloadFileList.get(0);
            this.pluginID = this.downloadFile.getPluginID();
            this.putValue("Name", this.pluginID);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ContentPanel.this.director.getPluginsManager().getPluginInstance(this.pluginID).showLocalOptions(this.downloadFile);
            }
            catch (Exception x) {
                LogUtils.processException(logger, x);
                try {
                    ContentPanel.this.director.getPluginsManager().getPluginInstance(this.pluginID).showOptions();
                }
                catch (Exception e1) {
                    LogUtils.processException(logger, e1);
                }
            }
            this.setLocalPluginConfig();
        }

        private void setLocalPluginConfig() {
            if (this.downloadFile.getLocalPluginConfig() == null) {
                return;
            }
            String localPluginConfig = this.downloadFile.getLocalPluginConfig();
            for (DownloadFile file : this.downloadFileList) {
                if (!file.getPluginID().equals(this.pluginID)) continue;
                file.setLocalPluginConfig(localPluginConfig);
            }
        }
    }

    private static class StateFilter
    extends RowFilter<Object, Object> {
        private StateFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            DownloadFile file = (DownloadFile)entry.getValue(4);
            return file != null && file.getState() != DownloadState.COMPLETED;
        }
    }
}

