/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.core.FileTypeIconProvider;
import cz.vity.freerapid.model.DownloadFile;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

final class NameURLCellRenderer
extends DefaultTableCellRenderer {
    private final FileTypeIconProvider iconProvider;
    private static final Logger logger = Logger.getLogger(NameURLCellRenderer.class.getName());

    NameURLCellRenderer(FileTypeIconProvider iconProvider) {
        this.iconProvider = iconProvider;
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        DownloadFile downloadFile;
        if (value == null) {
            value = table.getValueAt(row, column);
        }
        String fn = (downloadFile = (DownloadFile)value).getFileNameRenameTo() != null ? downloadFile.getFileNameRenameTo() : downloadFile.getFileName();
        String url = downloadFile.getFileUrl().toString();
        value = fn != null && !fn.isEmpty() ? fn : url;
        super.getTableCellRendererComponent(table, " " + value, isSelected, hasFocus, row, column);
        this.getAccessibleContext().setAccessibleName(table.getColumnName(column) + "   " + value);
        if (value != null) {
            this.setToolTipText(url);
            this.setIcon(this.iconProvider.getIconImageByFileType(downloadFile.getFileType(), false));
        }
        return this;
    }
}

