/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

final class ProgressBarCellRenderer
extends JProgressBar
implements TableCellRenderer {
    private static final Color BG_RED = new Color(0xFFD0D0);
    private static final Color BG_ORANGE = new Color(16772560);
    private static final Color BG_GREEN = new Color(13697001);
    private static final Color BG_BLUE = new Color(11987455);
    private static final Color BG_BLACK = new Color(16764571);
    private static final Color BG_PINK = Color.PINK;
    private static final Color BG_GREY = new Color(0xAAAAAA);
    private static final Color BG_PURPLE = new Color(0xDD99EE);
    private final Color defaultColor;
    private String autoReconnectIn;
    private String attemptForDownloading;

    public ProgressBarCellRenderer(ApplicationContext context) {
        super(0, 100);
        ResourceMap map = context.getResourceMap();
        this.autoReconnectIn = map.getString("autoreconnectIn", new Object[0]);
        this.attemptForDownloading = map.getString("attemptForDownloading", new Object[0]);
        int h = this.getPreferredSize().height;
        this.setPreferredSize(new Dimension(70, h));
        this.defaultColor = this.getBackground();
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            value = table.getValueAt(row, column);
        }
        DownloadFile downloadFile = (DownloadFile)value;
        DownloadState state = downloadFile.getState();
        switch (state) {
            case DOWNLOADING: 
            case GETTING: 
            case WAITING: {
                this.setBackground(BG_GREEN);
                break;
            }
            case CANCELLED: 
            case ERROR: 
            case DELETED: {
                this.setBackground(BG_RED);
                break;
            }
            case PAUSED: 
            case DISABLED: {
                this.setBackground(BG_PINK);
                break;
            }
            case QUEUED: {
                this.setBackground(BG_ORANGE);
                break;
            }
            case SLEEPING: 
            case HOLD_ON: {
                this.setBackground(BG_BLUE);
                break;
            }
            case SKIPPED: {
                this.setBackground(BG_GREY);
                break;
            }
            case COMPLETED: {
                this.setBackground(this.defaultColor);
                break;
            }
            case TESTING: {
                this.setBackground(BG_PURPLE);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        int toQueued = downloadFile.getTimeToQueued();
        if ((state == DownloadState.ERROR || state == DownloadState.SLEEPING) && toQueued >= 0) {
            int max = downloadFile.getTimeToQueuedMax();
            this.setStringPainted(true);
            this.setString(ContentPanel.secondsToHMin(toQueued));
            this.setValue(ContentPanel.getProgress(max, toQueued));
            this.setToolTipText(String.format(this.autoReconnectIn, toQueued));
        } else {
            int sleep = downloadFile.getSleep();
            if (state == DownloadState.WAITING && sleep >= 0) {
                int max = downloadFile.getTimeToQueuedMax();
                this.setStringPainted(true);
                this.setString(ContentPanel.secondsToHMin(sleep));
                this.setValue(ContentPanel.getProgress(max, sleep));
                this.setToolTipText(String.format(this.attemptForDownloading, sleep));
            } else {
                this.setToolTipText(null);
                int progress = ContentPanel.getProgress(downloadFile);
                if (AppPrefs.getProperty("showPercentProgress", false)) {
                    this.setStringPainted(true);
                    this.setString(progress + "%");
                } else {
                    this.setStringPainted(false);
                }
                this.setValue(progress);
            }
        }
        this.getAccessibleContext().setAccessibleName(this.getString());
        return this;
    }
}

