/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.gui.managers.exceptions.NotSupportedDownloadServiceException;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.java.plugin.Plugin;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginDescriptor;

final class ServiceCellRenderer
extends DefaultTableCellRenderer {
    private final PluginsManager manager;
    private final Map<String, Icon> iconCache = new HashMap<String, Icon>();

    ServiceCellRenderer(ManagerDirector director) {
        this.manager = director.getPluginsManager();
        Icon icon = director.getContext().getResourceMap().getIcon("serviceWithNoIcon");
        this.iconCache.put("default", icon);
        this.manager.getPluginManager().registerListener(new PluginManager.EventListenerAdapter(){

            @Override
            public void pluginActivated(Plugin plugin) {
                ServiceCellRenderer.this.iconCache.remove(plugin.getDescriptor().getId());
            }

            @Override
            public void pluginEnabled(PluginDescriptor descriptor) {
                ServiceCellRenderer.this.iconCache.remove(descriptor.getId());
            }
        });
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            value = table.getValueAt(row, column);
        }
        DownloadFile downloadFile = (DownloadFile)value;
        String pluginId = downloadFile.getPluginID();
        assert (pluginId != null);
        String serviceName = downloadFile.getServiceName();
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Icon faviconImage = this.iconCache.get(pluginId);
        if (faviconImage == null) {
            try {
                ShareDownloadService service;
                if (this.manager.hasPlugin(pluginId) && !this.manager.isPluginDisabled(pluginId) && this.manager.getPluginMetadata(pluginId).hasFavicon() && (faviconImage = (service = this.manager.getPluginInstance(pluginId)).getFaviconImage()) != null) {
                    this.iconCache.put(pluginId, faviconImage);
                }
            }
            catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
                // empty catch block
            }
            if (faviconImage == null) {
                faviconImage = this.iconCache.get("default");
                this.iconCache.put(pluginId, faviconImage);
            }
        }
        if (faviconImage != null) {
            this.setIcon(faviconImage);
        }
        if (!AppPrefs.getProperty("showServicesAsIcons", true)) {
            this.setHorizontalAlignment(2);
            this.setText(serviceName);
            this.setToolTipText(null);
        } else {
            this.setToolTipText(serviceName);
            this.setText(null);
            this.setHorizontalAlignment(0);
        }
        this.getAccessibleContext().setAccessibleName(table.getColumnName(column) + " " + serviceName);
        return this;
    }
}

