/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.dialogs.abouteffect.VolleyExplosion;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.application.Action;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TimelineScenario;
import org.pushingpixels.trident.callback.TimelineScenarioCallback;
import org.pushingpixels.trident.swing.SwingRepaintTimeline;

public class AboutDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(AboutDialog.class.getName());
    private JLabel xImagePanel;
    private JLabel infoLabel;
    private AudioClip audioClip;
    private final Set<VolleyExplosion> volleys;
    private final Map<VolleyExplosion, TimelineScenario> volleyScenarios;
    private JButton btnOK;

    public AboutDialog(Frame owner) throws HeadlessException {
        super(owner, true);
        this.setName("AboutDialog");
        this.volleys = new HashSet<VolleyExplosion>();
        this.volleyScenarios = new HashMap<VolleyExplosion, TimelineScenario>();
        try {
            this.initComponents();
            this.build();
            String title = this.getTitle();
            title = title + ' ' + "1.0beta";
            String buildNumber = this.readBuildNumber();
            if (buildNumber != null) {
                title = title + "  build #" + buildNumber;
            }
            this.setTitle(title);
            SwingRepaintTimeline repaint = new SwingRepaintTimeline(this);
            repaint.playLoop(Timeline.RepeatBehavior.LOOP);
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnOK;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnOK;
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.setAction(this.btnOK, "okBtnAction");
        this.pack();
        this.setResizable(false);
        AboutDialog.locateOnOpticalScreenCenter(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (AboutDialog.this.getWidth() == 0 || AboutDialog.this.getHeight() == 0) {
                    return;
                }
                new Thread(){

                    @Override
                    public void run() {
                        for (int i = 10; i >= 0; --i) {
                            AboutDialog.this.addExplosions(5);
                        }
                    }
                }.start();
            }
        });
    }

    private String readBuildNumber() {
        try {
            String classContainer = AboutDialog.class.getProtectionDomain().getCodeSource().getLocation().toString();
            URL manifestUrl = new URL("jar:" + classContainer + "!/META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(manifestUrl.openStream());
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue("Build");
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            return null;
        }
    }

    private void buildGUI() {
        Icon imageIcon = Swinger.getResourceMap().getIcon("splash.iconImage");
        this.xImagePanel.setIcon(imageIcon);
        Dimension pref = new Dimension(imageIcon.getIconWidth() + 2, imageIcon.getIconHeight() + 2);
        this.xImagePanel.setPreferredSize(pref);
        this.xImagePanel.setBorder(BorderFactory.createEtchedBorder());
        this.xImagePanel.setLayout(new BoxLayout(this.xImagePanel, 1));
        this.xImagePanel.add(this.infoLabel);
        this.xImagePanel.setCursor(Cursor.getPredefinedCursor(12));
        this.xImagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Browser.showHomepage();
            }
        });
        this.infoLabel.setBorder(BorderFactory.createEmptyBorder(15, 20, 20, 30));
        this.infoLabel.setLocation(30, 30);
    }

    @Override
    protected void windowIsClosing() {
        this.stopSound();
    }

    private void stopSound() {
        if (this.audioClip != null) {
            this.audioClip.stop();
            this.audioClip = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExplosions(int count) {
        final CountDownLatch latch = new CountDownLatch(count);
        for (int i = 0; i < count; ++i) {
            int r = (int)(255.0 * Math.random());
            int g = (int)(100.0 + 155.0 * Math.random());
            int b = (int)(50.0 + 205.0 * Math.random());
            Color color = new Color(r, g, b);
            int x = 60 + (int)((double)(this.xImagePanel.getWidth() - 120) * Math.random());
            int y = 60 + (int)((double)(this.xImagePanel.getHeight() - 120) * Math.random());
            final VolleyExplosion exp = new VolleyExplosion(x, y, color);
            Set<VolleyExplosion> set = this.volleys;
            synchronized (set) {
                this.volleys.add(exp);
                TimelineScenario scenario = exp.getExplosionScenario();
                scenario.addCallback(new TimelineScenarioCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onTimelineScenarioDone() {
                        Set set = AboutDialog.this.volleys;
                        synchronized (set) {
                            AboutDialog.this.volleys.remove(exp);
                            AboutDialog.this.volleyScenarios.remove(exp);
                            latch.countDown();
                        }
                    }
                });
                this.volleyScenarios.put(exp, scenario);
                scenario.play();
                continue;
            }
        }
        try {
            latch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Action
    public void okBtnAction() {
        this.stopSound();
        this.doClose();
    }

    private void initComponents() {
        this.infoLabel = new JLabel();
        this.infoLabel.setName("infoLabel");
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        this.xImagePanel = new JLabel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Set set = AboutDialog.this.volleys;
                synchronized (set) {
                    for (VolleyExplosion exp : AboutDialog.this.volleys) {
                        exp.paint(g);
                    }
                }
            }
        };
        JPanel buttonBar = new JPanel();
        this.btnOK = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setName("AboutDialog");
        Container aboutDialogContentPane = this.getContentPane();
        aboutDialogContentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(Borders.DIALOG);
        dialogPane.setName("dialogPane");
        dialogPane.setLayout(new BorderLayout());
        contentPanel.setName("contentPanel");
        this.xImagePanel.setName("xImagePanel");
        contentPanel.add((Component)this.xImagePanel, "Center");
        contentPanel.add(this.infoLabel);
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(Borders.BUTTON_BAR_PAD);
        buttonBar.setName("buttonBar");
        this.btnOK.setName("btnOK");
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout("default:grow, max(pref;42dlu), default:grow", "pref"), buttonBar);
        buttonBarBuilder.add((Component)this.btnOK, cc.xy(2, 1));
        dialogPane.add((Component)buttonBar, "South");
        aboutDialogContentPane.add((Component)dialogPane, "Center");
    }
}

