/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.plugins.webclient.hoster.PremiumAccount;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.application.Action;

public class AccountDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(AccountDialog.class.getName());
    private PresentationModel<PremiumAccount> model;
    private PremiumAccount account;
    private boolean emptyAllowed;
    private JTextField fieldUserName;
    private JPasswordField fieldPassword;
    private JButton btnOK;
    private JButton btnCancel;

    public AccountDialog(Frame owner, String title, PremiumAccount account, boolean emptyAllowed) throws HeadlessException {
        super(owner, true);
        this.setName("AccountDialog");
        this.account = account == null ? new PremiumAccount() : account;
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
        }
        if (title != null) {
            this.setTitle(this.getTitle() + " - " + title);
        }
        this.emptyAllowed = emptyAllowed;
    }

    public AccountDialog(Frame owner, String title, PremiumAccount account) throws HeadlessException {
        this(owner, title, account, false);
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnOK;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnCancel;
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.buildModels();
        this.setAction(this.btnOK, "okBtnAction");
        this.setAction(this.btnCancel, "cancelBtnAction");
        this.pack();
        AccountDialog.locateOnOpticalScreenCenter(this);
    }

    private void buildModels() {
        this.model = new PresentationModel<PremiumAccount>(this.account);
        Bindings.bind(this.fieldUserName, (ValueModel)this.model.getBufferedModel("username"));
        Bindings.bind(this.fieldPassword, (ValueModel)this.model.getBufferedModel("password"));
    }

    private void buildGUI() {
    }

    @Action
    public void okBtnAction() {
        if (!this.emptyAllowed && !this.validated()) {
            return;
        }
        if (this.model != null) {
            this.model.triggerCommit();
        }
        this.setResult(0);
        this.doClose();
    }

    private boolean validated() {
        if (!Utils.hasValue(this.fieldUserName.getText())) {
            Swinger.showErrorMessage(this.getResourceMap(), "message_noUserName", new Object[0]);
            Swinger.inputFocus(this.fieldUserName);
            return false;
        }
        if (this.fieldPassword.getPassword().length == 0) {
            Swinger.showErrorMessage(this.getResourceMap(), "message_noPassword", new Object[0]);
            Swinger.inputFocus(this.fieldPassword);
            return false;
        }
        return true;
    }

    @Action
    public void cancelBtnAction() {
        if (this.model != null) {
            this.model.triggerFlush();
        }
        this.setResult(1);
        this.doClose();
    }

    public PremiumAccount getAccount() {
        return this.account;
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JLabel labelIcon = new JLabel();
        JLabel labelUserName = new JLabel();
        this.fieldUserName = ComponentFactory.getTextField();
        JLabel labelPassword = new JLabel();
        this.fieldPassword = ComponentFactory.getPasswordField();
        JPanel buttonBar = new JPanel();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        CellConstraints cc = new CellConstraints();
        labelIcon.setName("labelIcon");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)dialogPane, "Center");
        dialogPane.setBorder(Borders.DIALOG);
        dialogPane.setLayout(new BorderLayout());
        labelUserName.setName("labelUserName");
        labelUserName.setLabelFor(this.fieldUserName);
        labelPassword.setName("labelPassword");
        labelPassword.setLabelFor(this.fieldPassword);
        PanelBuilder contentPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{ColumnSpec.decode("max(pref;35dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("min(pref;40dlu):grow"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC}), contentPanel);
        contentPanelBuilder.add((Component)labelIcon, cc.xywh(1, 1, 2, 7, CellConstraints.FILL, CellConstraints.CENTER));
        contentPanelBuilder.add((Component)labelUserName, cc.xy(3, 1));
        contentPanelBuilder.add((Component)this.fieldUserName, cc.xywh(3, 3, 3, 1));
        contentPanelBuilder.add((Component)labelPassword, cc.xy(3, 5));
        contentPanelBuilder.add((Component)this.fieldPassword, cc.xywh(3, 7, 3, 1));
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(Borders.BUTTON_BAR_PAD);
        this.btnOK.setName("btnOK");
        this.btnCancel.setName("btnCancel");
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{ColumnSpec.decode("55px:grow"), ComponentFactory.BUTTON_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ComponentFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs("default")), buttonBar);
        buttonBarBuilder.add((Component)this.btnOK, cc.xy(2, 1));
        buttonBarBuilder.add((Component)this.btnCancel, cc.xy(4, 1));
        dialogPane.add((Component)buttonBar, "South");
    }
}

