/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import com.l2fprod.common.swing.JDirectoryChooser;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.dialogs.AppFrame;
import cz.vity.freerapid.gui.dialogs.CompoundUndoManager;
import cz.vity.freerapid.gui.dialogs.LocalConnectionSettingsDialog;
import cz.vity.freerapid.gui.dialogs.NewLinksDialog;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.components.EditorPaneLinkDetector;
import cz.vity.freerapid.swing.models.RecentsFilesComboModel;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;

public class InformationDialog
extends AppFrame
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(InformationDialog.class.getName());
    private final ManagerDirector director;
    private final DownloadFile file;
    private final boolean fileUrlEditable;
    private PresentationModel<DownloadFile> model;
    private JLabel iconLabel;
    private JLabel pathLabel;
    private EditorPaneLinkDetector fieldFrom;
    private JTextField fieldSize;
    private JTextArea descriptionArea;
    private JComboBox comboPath;
    private JButton btnSelectPath;
    private JProgressBar progressBar;
    private JLabel remainingLabel;
    private JLabel currentSpeedLabel;
    private JLabel avgSpeedLabel;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel estTimeLabel;
    private JTextField connectionField;
    private JButton btnConnectionSettings;

    public InformationDialog(Frame owner, ManagerDirector director, DownloadFile file) throws Exception {
        super(owner);
        this.director = director;
        this.file = file;
        this.fileUrlEditable = AppPrefs.getProperty("fileUrlEditable", false);
        this.setName("InformationDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            this.doClose();
            throw e;
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.okButton;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.cancelButton;
    }

    @Action
    public void cancelBtnAction() {
        this.setResult(1);
        if (this.model != null) {
            this.model.triggerFlush();
        }
        this.doClose();
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.buildModels();
        this.setAction(this.okButton, "okBtnAction");
        this.setAction(this.cancelButton, "cancelBtnAction");
        this.setAction(this.btnSelectPath, "btnSelectPathAction");
        this.setAction(this.btnConnectionSettings, "btnConnectionSettingsAction");
        this.updateInit();
    }

    private void buildModels() {
        this.model = new PresentationModel<DownloadFile>(this.file);
        Bindings.bind(this.descriptionArea, (ValueModel)this.model.getBufferedModel("description"));
        this.file.addPropertyChangeListener(this);
    }

    private void buildGUI() {
        new CompoundUndoManager(this.descriptionArea);
        this.comboPath.setModel(new RecentsFilesComboModel("lastUsedSavedPaths", true));
        File absolutFile = FileUtils.getAbsolutFile(this.file.getSaveToDirectory());
        this.comboPath.setSelectedItem(absolutFile.toString());
        this.progressBar.setFont(this.progressBar.getFont().deriveFont(1, 16.0f));
        this.progressBar.setStringPainted(true);
        Swinger.inputFocus(this.descriptionArea);
        this.fieldFrom.setOpaque(false);
        this.fieldSize.setOpaque(false);
        this.fieldFrom.setBackground(this.getBackground());
        this.fieldSize.setBackground(this.getBackground());
        this.fieldSize.setEditable(false);
        this.fieldFrom.setEditable(this.fileUrlEditable);
        this.descriptionArea.setFont(this.descriptionArea.getFont().deriveFont(11.0f));
        this.connectionField.setEditable(false);
    }

    @Action
    public void okBtnAction() {
        if (!this.validateChanges()) {
            return;
        }
        AppPrefs.storeProperty("lastComboPath", this.comboPath.getSelectedItem().toString());
        File outputDir = new File(this.comboPath.getEditor().getItem().toString());
        this.file.setSaveToDirectory(outputDir);
        if (this.fileUrlEditable) {
            try {
                URL newURL = new URL(this.fieldFrom.getText());
                this.file.setPluginID(this.director.getPluginsManager().getServiceIDForURL(newURL));
                this.file.setFileUrl(newURL);
            }
            catch (Exception e) {
                Swinger.showErrorMessage(this.getResourceMap(), "Invalid URL", new Object[0]);
                Swinger.inputFocus(this.fieldFrom);
                return;
            }
        }
        this.setResult(0);
        if (this.model != null) {
            this.model.triggerCommit();
        }
        this.doClose();
    }

    @Override
    public void doClose() {
        this.file.removePropertyChangeListener(this);
        super.doClose();
        if (this.model != null) {
            this.model.setBean(null);
        }
        if (this.getModalResult() == 0) {
            this.comboPath.addItem(this.comboPath.getSelectedItem());
            ((RecentsFilesComboModel)this.comboPath.getModel()).setAsMRU(this.comboPath.getSelectedItem());
        }
    }

    private boolean validateChanges() {
        String dir = (String)this.comboPath.getEditor().getItem();
        if (dir == null || dir.isEmpty()) {
            Swinger.showErrorMessage(this.getResourceMap(), "noDirectoryMessage", new Object[0]);
            this.btnSelectPathAction();
            return false;
        }
        ResourceMap linksDialogMap = Swinger.getResourceMap(NewLinksDialog.class);
        File outputDir = new File(Utils.isWindows() ? dir.trim() : dir);
        if (!outputDir.isDirectory()) {
            int choiceYesNo = Swinger.getChoiceYesNo(linksDialogMap.getString("directoryCreateMessage", new Object[0]));
            if (choiceYesNo == 0) {
                if (!outputDir.mkdirs()) {
                    Swinger.showErrorMessage(linksDialogMap, "directoryCreatingFailed", outputDir.getAbsolutePath());
                    this.btnSelectPathAction();
                    return false;
                }
                if (!outputDir.isDirectory()) {
                    Swinger.showErrorMessage(linksDialogMap, "itsNotDirectory", outputDir.getAbsolutePath());
                    this.btnSelectPathAction();
                    return false;
                }
            } else {
                this.btnSelectPathAction();
                return false;
            }
        }
        return true;
    }

    @Action
    public void btnSelectPathAction() {
        JDirectoryChooser directoryChooser = new JDirectoryChooser(this.comboPath.getEditor().getItem().toString());
        if (directoryChooser.showDialog(this, this.getResourceMap().getString("SelectDirectory", new Object[0])) != 1) {
            this.comboPath.getEditor().setItem(directoryChooser.getSelectedFile().getAbsolutePath());
            Swinger.inputFocus(this.comboPath);
        }
    }

    @Action
    public void btnConnectionSettingsAction() throws Exception {
        LocalConnectionSettingsDialog dialog = new LocalConnectionSettingsDialog((Frame)this, this.model);
        this.getApp().show(dialog);
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        this.iconLabel = new JLabel();
        this.pathLabel = new JLabel();
        JLabel labelFrom = new JLabel();
        this.fieldFrom = ComponentFactory.getURLsEditorPane();
        if (!this.fileUrlEditable) {
            MouseListener[] mouseListeners;
            for (MouseListener mouseListener : mouseListeners = this.fieldFrom.getMouseListeners()) {
                this.fieldFrom.removeMouseListener(mouseListener);
            }
        }
        JLabel labelSize = new JLabel();
        this.fieldSize = new JTextField();
        JLabel labelDescription = new JLabel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.descriptionArea = ComponentFactory.getTextArea();
        JPanel optionsPanel = new JPanel();
        JLabel saveToLabel = new JLabel();
        this.comboPath = new JComboBox();
        this.btnSelectPath = new JButton();
        this.progressBar = new JProgressBar();
        JLabel labelRemaining = new JLabel();
        this.remainingLabel = new JLabel();
        JLabel labelEstimateTime = new JLabel();
        this.estTimeLabel = new JLabel();
        JLabel labelCurrentSpeed = new JLabel();
        labelCurrentSpeed.setPreferredSize(new Dimension(90, 20));
        this.currentSpeedLabel = new JLabel();
        JLabel labelAverageSpeed = new JLabel();
        this.avgSpeedLabel = new JLabel();
        JPanel connectionPanel = new JPanel();
        JLabel connectionLabel = new JLabel();
        this.connectionField = new JTextField();
        this.btnConnectionSettings = new JButton();
        JXButtonPanel buttonBar = new JXButtonPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(Borders.DIALOG);
        dialogPane.setLayout(new BorderLayout());
        this.iconLabel.setName("iconLabel");
        this.pathLabel.setName("pathLabel");
        this.pathLabel.setFont(new Font("Tahoma", 1, 12));
        labelFrom.setName("labelFrom");
        this.fieldFrom.setBorder(null);
        this.fieldFrom.setOpaque(false);
        this.fieldFrom.setName("fieldFrom");
        labelSize.setName("labelSize");
        this.fieldSize.setBorder(null);
        this.fieldSize.setOpaque(false);
        labelDescription.setName("labelDescription");
        scrollPane1.setViewportView(this.descriptionArea);
        saveToLabel.setName("saveToLabel");
        saveToLabel.setLabelFor(this.comboPath);
        this.comboPath.setEditable(true);
        this.btnSelectPath.setName("btnSelectPath");
        PanelBuilder optionsPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, RowSpec.decodeSpecs("default")), optionsPanel);
        optionsPanelBuilder.add((Component)saveToLabel, cc.xy(1, 1));
        optionsPanelBuilder.add((Component)this.comboPath, cc.xy(3, 1));
        optionsPanelBuilder.add((Component)this.btnSelectPath, cc.xy(5, 1));
        this.progressBar.setFont(new Font("Tahoma", 1, 16));
        labelRemaining.setName("labelRemaining");
        this.remainingLabel.setName("remainingLabel");
        this.remainingLabel.setFont(new Font("Tahoma", 1, 12));
        labelEstimateTime.setName("labelEstimateTime");
        this.estTimeLabel.setName("estTimeLabel");
        this.estTimeLabel.setFont(new Font("Tahoma", 1, 12));
        labelCurrentSpeed.setName("labelCurrentSpeed");
        this.currentSpeedLabel.setName("currentSpeedLabel");
        this.currentSpeedLabel.setFont(new Font("Tahoma", 1, 12));
        labelAverageSpeed.setName("labelAverageSpeed");
        connectionLabel.setName("connectionLabel");
        connectionLabel.setLabelFor(this.connectionField);
        this.btnConnectionSettings.setName("btnConnectionSettings");
        PanelBuilder connectionPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, RowSpec.decodeSpecs("default")), connectionPanel);
        connectionPanelBuilder.add((Component)connectionLabel, cc.xy(1, 1));
        connectionPanelBuilder.add((Component)this.connectionField, cc.xy(3, 1));
        connectionPanelBuilder.add((Component)this.btnConnectionSettings, cc.xy(5, 1));
        this.avgSpeedLabel.setName("avgSpeedLabel");
        this.avgSpeedLabel.setFont(new Font("Tahoma", 1, 12));
        PanelBuilder contentPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(54)), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("max(min;70dlu)")}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.bounded(Sizes.PREFERRED, Sizes.dluY(40), Sizes.dluY(50)), 1.0), FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode("fill:max(pref;20dlu)"), FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), contentPanel);
        contentPanelBuilder.add((Component)this.iconLabel, cc.xywh(1, 1, 1, 5));
        contentPanelBuilder.add((Component)this.pathLabel, cc.xywh(3, 1, 7, 1));
        contentPanelBuilder.add((Component)labelFrom, cc.xy(3, 3));
        contentPanelBuilder.add((Component)this.fieldFrom, cc.xywh(5, 3, 5, 1));
        contentPanelBuilder.add((Component)labelSize, cc.xy(3, 5));
        contentPanelBuilder.add((Component)this.fieldSize, cc.xywh(5, 5, 3, 1));
        contentPanelBuilder.add((Component)labelDescription, cc.xy(1, 7));
        contentPanelBuilder.add((Component)scrollPane1, cc.xywh(1, 9, 9, 1));
        contentPanelBuilder.add((Component)optionsPanel, cc.xywh(1, 11, 9, 1));
        contentPanelBuilder.add((Component)this.progressBar, cc.xywh(1, 13, 9, 1));
        contentPanelBuilder.add((Component)labelRemaining, cc.xy(1, 15));
        contentPanelBuilder.add((Component)this.remainingLabel, cc.xywh(3, 15, 3, 1));
        contentPanelBuilder.add((Component)labelEstimateTime, cc.xy(7, 15));
        contentPanelBuilder.add((Component)this.estTimeLabel, cc.xy(9, 15));
        contentPanelBuilder.add((Component)labelCurrentSpeed, cc.xy(1, 17));
        contentPanelBuilder.add((Component)this.currentSpeedLabel, cc.xywh(3, 17, 3, 1));
        contentPanelBuilder.add((Component)labelAverageSpeed, cc.xy(7, 17));
        contentPanelBuilder.add((Component)this.avgSpeedLabel, cc.xy(9, 17));
        contentPanelBuilder.add((Component)connectionPanel, cc.xywh(1, 19, 9, 1));
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.okButton.setName("okButton");
        this.cancelButton.setName("cancelButton");
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.UNRELATED_GAP_COLSPEC, ColumnSpec.decode("max(pref;42dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, RowSpec.decodeSpecs("fill:pref")), buttonBar);
        ((FormLayout)buttonBar.getLayout()).setColumnGroups(new int[][]{{3, 5}});
        buttonBarBuilder.add((Component)this.okButton, cc.xy(3, 1));
        buttonBarBuilder.add((Component)this.cancelButton, cc.xy(5, 1));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
    }

    private void updateInit() {
        this.updateFrom();
        this.updateSize();
        this.updateFileName();
        this.updateState();
    }

    private void updateState() {
        this.updateAvgSpeed();
        this.updateSpeed();
        this.updateDurationTime();
        this.updateEstimateTime();
        this.updateDownloaded();
        this.updateEnabled();
        this.updateConnection();
    }

    private void updateEnabled() {
        DownloadState state = this.file.getState();
        javax.swing.Action okAction = this.getActionMap().get("okBtnAction");
        javax.swing.Action selectAction = this.getActionMap().get("btnSelectPathAction");
        javax.swing.Action connectionSettingsAction = this.getActionMap().get("btnConnectionSettingsAction");
        boolean enabled = state != DownloadState.COMPLETED && state != DownloadState.DELETED;
        okAction.setEnabled(enabled);
        selectAction.setEnabled(enabled);
        connectionSettingsAction.setEnabled(enabled);
        this.descriptionArea.setEditable(enabled);
        this.comboPath.setEditable(enabled);
        this.comboPath.setEnabled(enabled);
        this.fieldFrom.setEnabled(enabled);
        this.fieldFrom.setEditable(enabled && this.fileUrlEditable);
    }

    private void updateDownloaded() {
        int n = ContentPanel.getProgress(this.file);
        this.progressBar.setString(n + "%");
        this.progressBar.setValue(n);
    }

    private void updateSpeeds() {
        this.updateAvgSpeed();
        this.updateSpeed();
        this.updateEstimateTime();
        this.updateDurationTime();
    }

    private void updateSize() {
        String value;
        long fs = this.file.getFileSize();
        if (fs >= 0L) {
            value = ContentPanel.bytesToAnother(fs);
            if (fs >= 1024L) {
                value = value + "  (" + NumberFormat.getIntegerInstance().format(fs) + " B)";
            }
        } else {
            value = this.getResourceMap().getString("unknown", new Object[0]);
        }
        this.fieldSize.setText(value);
    }

    private void updateAvgSpeed() {
        DownloadState state = this.file.getState();
        String value = "";
        if (state == DownloadState.DOWNLOADING) {
            value = this.file.getAverageSpeed() >= 0.0f ? ContentPanel.bytesToAnother((long)this.file.getAverageSpeed()) + "/s" : "0 B/s";
        } else if (state == DownloadState.COMPLETED && this.file.getAverageSpeed() > 0.0f) {
            value = ContentPanel.bytesToAnother((long)this.file.getAverageSpeed()) + "/s";
        }
        this.avgSpeedLabel.setText(this.getResourceMap().getString("textBold", value));
    }

    private void updateSpeed() {
        String value = this.file.getState() == DownloadState.DOWNLOADING ? (this.file.getSpeed() >= 0L ? ContentPanel.bytesToAnother(this.file.getSpeed()) + "/s" : "0 B/s") : "";
        this.currentSpeedLabel.setText(this.getResourceMap().getString("textBold", value));
    }

    private void updateDurationTime() {
        String value;
        if (DownloadsActions.isProcessState(this.file.getState())) {
            DownloadTask task = this.file.getTask();
            value = task != null ? ContentPanel.secondsToHMin(task.getExecutionDuration(TimeUnit.SECONDS)) : "";
        } else {
            long taskDuration = this.file.getCompleteTaskDuration();
            value = this.file.getState() == DownloadState.COMPLETED && taskDuration > 0L ? ContentPanel.secondsToHMin(taskDuration) : "";
        }
        this.estTimeLabel.setText(this.getResourceMap().getString("textBold", value));
    }

    private void updateEstimateTime() {
        String value = "";
        DownloadState state = this.file.getState();
        if (state == DownloadState.DOWNLOADING) {
            long hasToBeDownloaded = this.file.getFileSize() - this.file.getDownloaded();
            float speed = this.file.getAverageSpeed();
            value = Float.compare(0.0f, speed) != 0 ? ContentPanel.secondsToHMin(Math.round((float)hasToBeDownloaded / speed)) : this.getResourceMap().getString("estimating", new Object[0]);
        } else if (state == DownloadState.WAITING) {
            value = this.getResourceMap().getString("waiting", ContentPanel.secondsToHMin(this.file.getSleep()));
        }
        this.remainingLabel.setText(this.getResourceMap().getString("textBold", value));
    }

    private void updateFileName() {
        Icon icon = this.director.getFileTypeIconProvider().getIconImageByFileType(this.file.getFileType(), true);
        this.iconLabel.setIcon(icon);
        this.iconLabel.setHorizontalAlignment(0);
        this.pathLabel.setText(this.getResourceMap().getString("textBold", FileUtils.getAbsolutPath(this.file.getOutputFile())));
    }

    private void updateFrom() {
        this.fieldFrom.setText(this.file.getFileUrl().toExternalForm());
    }

    private void updateConnection() {
        ConnectionSettings cs = this.file.getConnectionSettings();
        this.connectionField.setText(cs == null ? "" : cs.toString());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("speed".equals(propName)) {
            this.updateSpeeds();
        } else if ("averageSpeed".equals(propName)) {
            this.updateSpeeds();
        } else if ("state".equals(propName)) {
            this.updateState();
        } else if ("fileName".equals(propName)) {
            this.updateFileName();
        } else if ("fileSize".equals(propName)) {
            this.updateSize();
        } else if ("sleep".equals(propName)) {
            this.updateEstimateTime();
            this.updateDurationTime();
        } else if ("downloaded".equals(propName)) {
            this.updateDownloaded();
        } else if ("connectionSettings".equals(propName)) {
            this.updateConnection();
        }
    }
}

