/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.model.LocalConnectionSettingsType;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;

public class LocalConnectionSettingsDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(LocalConnectionSettingsDialog.class.getName());
    private static final Pattern PROXY_REGEX_PATTERN = Pattern.compile("((\\w*)(:(.*?))?@)?(.*?):(\\d{2,5})");
    private static final Pattern SOCKS_REGEX_PATTERN = Pattern.compile("(?i)^(\\$SOCKS\\$|SOCKS\\:)");
    private PresentationModel<DownloadFile> model;
    private JRadioButton rbApplication;
    private JRadioButton rbDirect;
    private JRadioButton rbLocalProxy;
    private JTextField fldLocalProxy;
    private JButton okButton;
    private JButton cancelButton;

    public LocalConnectionSettingsDialog(Frame owner, PresentationModel<DownloadFile> model) {
        super(owner, false);
        this.model = model;
        this.setName("LocalConnectionSettingsDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            this.doClose();
        }
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.cancelButton;
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.okButton;
    }

    @Action
    public void cancelBtnAction() {
        this.model.getBufferedModel("localConnectionSettingsType").setValue((Object)this.model.getBean().getLocalConnectionSettingsType());
        this.model.getBufferedModel("localProxy").setValue(this.model.getBean().getLocalProxy());
        this.setResult(1);
        this.doClose();
    }

    @Action
    public void okBtnAction() {
        if (!this.validateChanges()) {
            return;
        }
        this.setResult(0);
        this.doClose();
    }

    @Override
    public void doClose() {
        super.doClose();
    }

    private void build() {
        this.inject();
        this.buildModels();
        this.buildGUI();
        this.setAction(this.okButton, "okBtnAction");
        this.setAction(this.cancelButton, "cancelBtnAction");
    }

    private void buildModels() {
        Bindings.bind(this.rbApplication, (ValueModel)this.model.getBufferedModel("localConnectionSettingsType"), (Object)LocalConnectionSettingsType.APPLICATION);
        Bindings.bind(this.rbDirect, (ValueModel)this.model.getBufferedModel("localConnectionSettingsType"), (Object)LocalConnectionSettingsType.DIRECT);
        Bindings.bind(this.rbLocalProxy, (ValueModel)this.model.getBufferedModel("localConnectionSettingsType"), (Object)LocalConnectionSettingsType.LOCAL_PROXY);
        Bindings.bind(this.fldLocalProxy, (ValueModel)this.model.getBufferedModel("localProxy"));
    }

    private void buildGUI() {
        this.rbApplication.setActionCommand(this.rbApplication.getName());
        this.rbDirect.setActionCommand(this.rbDirect.getName());
        this.rbLocalProxy.setActionCommand(this.rbLocalProxy.getName());
        ActionListener rbActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isLocalProxy = e.getActionCommand().equals(LocalConnectionSettingsDialog.this.rbLocalProxy.getActionCommand());
                LocalConnectionSettingsDialog.this.fldLocalProxy.setEnabled(isLocalProxy);
                LocalConnectionSettingsDialog.this.fldLocalProxy.setEditable(isLocalProxy);
            }
        };
        this.rbApplication.addActionListener(rbActionListener);
        this.rbDirect.addActionListener(rbActionListener);
        this.rbLocalProxy.addActionListener(rbActionListener);
        boolean isLocalProxy = this.rbLocalProxy.isSelected();
        this.fldLocalProxy.setEnabled(isLocalProxy);
        this.fldLocalProxy.setEditable(isLocalProxy);
    }

    private boolean validateChanges() {
        if (this.rbLocalProxy.isSelected() && !this.validateProxy(this.fldLocalProxy.getText())) {
            Swinger.showErrorMessage(this.getResourceMap(), "invalidProxyMessage", new Object[0]);
            Swinger.inputFocus(this.fldLocalProxy);
            this.fldLocalProxy.selectAll();
            return false;
        }
        return true;
    }

    private boolean validateProxy(String strProxy) {
        Matcher matcherSocks = SOCKS_REGEX_PATTERN.matcher(strProxy);
        if (matcherSocks.find()) {
            strProxy = strProxy.substring(matcherSocks.group(1).length());
        }
        Matcher matcher = PROXY_REGEX_PATTERN.matcher(strProxy);
        return matcher.matches();
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        this.rbApplication = new JRadioButton();
        this.rbDirect = new JRadioButton();
        this.rbLocalProxy = new JRadioButton();
        this.fldLocalProxy = new JTextField();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbApplication);
        buttonGroup.add(this.rbDirect);
        buttonGroup.add(this.rbLocalProxy);
        JLabel lblProxyDesc = new JLabel();
        JXButtonPanel buttonBar = new JXButtonPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(Borders.DIALOG);
        dialogPane.setLayout(new BorderLayout());
        this.rbApplication.setName("rbApplication");
        this.rbDirect.setName("rbDirect");
        this.rbLocalProxy.setName("rbLocalProxy");
        this.fldLocalProxy.setName("fldLocalProxy");
        lblProxyDesc.setName("lblProxyDesc");
        PanelBuilder contentPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), contentPanel);
        contentPanelBuilder.add((Component)this.rbApplication, cc.xy(1, 1));
        contentPanelBuilder.add((Component)this.rbDirect, cc.xy(1, 3));
        contentPanelBuilder.add((Component)this.rbLocalProxy, cc.xy(1, 5));
        contentPanelBuilder.add((Component)this.fldLocalProxy, cc.xy(1, 7));
        contentPanelBuilder.add((Component)lblProxyDesc, cc.xy(1, 9));
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.okButton.setName("okButton");
        this.cancelButton.setName("cancelButton");
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.UNRELATED_GAP_COLSPEC, ColumnSpec.decode("max(pref;42dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, RowSpec.decodeSpecs("fill:pref")), buttonBar);
        ((FormLayout)buttonBar.getLayout()).setColumnGroups(new int[][]{{3, 5}});
        buttonBarBuilder.add((Component)this.okButton, cc.xy(3, 1));
        buttonBarBuilder.add((Component)this.cancelButton, cc.xy(5, 1));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
    }
}

