/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import com.l2fprod.common.swing.JDirectoryChooser;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.gui.FRDUtils;
import cz.vity.freerapid.gui.actions.URLTransferHandler;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.dialogs.CompoundUndoManager;
import cz.vity.freerapid.gui.dialogs.filechooser.OpenSaveDialogFactory;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.FileHistoryItem;
import cz.vity.freerapid.gui.managers.FileHistoryManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.components.EditorPaneLinkDetector;
import cz.vity.freerapid.swing.models.RecentsFilesComboModel;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;

public class NewLinksDialog
extends AppDialog
implements ClipboardOwner {
    private static final Logger logger = Logger.getLogger(NewLinksDialog.class.getName());
    private final ManagerDirector director;
    private final DataManager dataManager;
    private FileHistoryManager historyManager;
    private final PluginsManager pluginsManager;
    private EditorPaneLinkDetector urlsArea;
    private boolean startPaused = false;
    private JComboBox comboPath;
    private JButton btnSelectPath;
    private JButton btnPasteFromClipboard;
    private JButton okButton;
    private JButton btnStartPaused;
    private JButton cancelButton;
    private JTextArea descriptionArea;

    public NewLinksDialog(ManagerDirector director, Frame owner) throws HeadlessException {
        super(owner, true);
        this.director = director;
        this.dataManager = director.getDataManager();
        this.historyManager = director.getFileHistoryManager();
        this.pluginsManager = director.getPluginsManager();
        this.setName("NewLinksDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.okButton;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.cancelButton;
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.setAction(this.okButton, "okBtnAction");
        this.setAction(this.cancelButton, "cancelBtnAction");
        this.setAction(this.btnPasteFromClipboard, "btnPasteFromClipboardAction");
        this.setAction(this.btnSelectPath, "btnSelectPathAction");
        this.setAction(this.btnStartPaused, "btnStartPausedAction");
        String desc = this.getResourceMap().getString("btnSelectPathAction.description", new Object[0]);
        this.btnSelectPath.getAccessibleContext().setAccessibleName(desc);
        this.btnSelectPath.getAccessibleContext().setAccessibleDescription(desc);
        this.btnSelectPath.setToolTipText(desc);
        this.pack();
        NewLinksDialog.locateOnOpticalScreenCenter(this);
    }

    @Action
    public void btnPasteFromClipboardAction() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            try {
                String data = (String)clipboard.getData(DataFlavor.stringFlavor);
                List<URL> urlList = URLTransferHandler.textURIListToFileList(data, this.getApp().getManagerDirector().getPluginsManager(), false);
                LinkedList<String> result = new LinkedList<String>();
                for (URL url : urlList) {
                    result.add(url.toExternalForm());
                }
                this.urlsArea.setURLs(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Action
    public void cancelBtnAction() {
        this.doClose();
    }

    @Action
    public void btnSelectPathAction() {
        String item = (String)this.comboPath.getEditor().getItem();
        File dir = null;
        String directoryChooserTitle = this.getResourceMap().getString("directoryChooserTitle", new Object[0]);
        if (AppPrefs.getProperty("selectDirDialogOverride", false)) {
            dir = OpenSaveDialogFactory.getInstance(MainApp.getAContext()).getDirChooser(item == null ? null : new File(item), directoryChooserTitle);
        } else {
            JDirectoryChooser directoryChooser = new JDirectoryChooser(item);
            directoryChooser.setDialogTitle(directoryChooserTitle);
            directoryChooser.setControlButtonsAreShown(true);
            if (directoryChooser.showDialog(this, this.getResourceMap().getString("SelectDirectory", new Object[0])) != 1) {
                dir = directoryChooser.getSelectedFile();
            }
        }
        if (dir != null) {
            this.comboPath.getEditor().setItem(dir.getAbsolutePath());
            Swinger.inputFocus(this.comboPath);
        }
    }

    @Action
    public void btnStartPausedAction() {
        if (!this.validateStart()) {
            return;
        }
        this.setResult(0);
        this.saveLastSaveToPath();
        this.startPaused = true;
        this.doClose();
    }

    @Override
    public void doClose() {
        super.doClose();
        if (this.getModalResult() == 0) {
            this.comboPath.addItem(this.comboPath.getSelectedItem());
            ((RecentsFilesComboModel)this.comboPath.getModel()).setAsMRU(this.comboPath.getSelectedItem());
        }
    }

    private void buildGUI() {
        new CompoundUndoManager(this.urlsArea);
        new CompoundUndoManager(this.descriptionArea);
        this.urlsArea.setPreferredSize(new Dimension(230, 100));
        this.urlsArea.getParent().setPreferredSize(new Dimension(230, 100));
        this.comboPath.setModel(new RecentsFilesComboModel("lastUsedSavedPaths", true));
        this.comboPath.setSelectedItem(AppPrefs.getProperty("lastComboPath", ""));
        this.descriptionArea.setFont(this.descriptionArea.getFont().deriveFont(11.0f));
        this.descriptionArea.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        KeyAdapter adapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    if (!e.isShiftDown()) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    } else {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                    }
                    e.consume();
                }
            }
        };
        this.urlsArea.addKeyListener(adapter);
        this.descriptionArea.addKeyListener(adapter);
        this.setTransferHandler(new URLTransferHandler(this.director){

            @Override
            protected void doDropAction(List<URL> files) {
                NewLinksDialog.this.urlsArea.setURLList(files);
            }
        });
    }

    @Action
    public void okBtnAction() {
        if (!this.validateStart()) {
            return;
        }
        this.saveLastSaveToPath();
        this.setResult(0);
        this.doClose();
    }

    private void saveLastSaveToPath() {
        AppPrefs.storeProperty("lastComboPath", this.comboPath.getSelectedItem().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateStart() {
        List<URL> newList;
        int result;
        List<URL> urlList = this.urlsArea.getURLs();
        if (this.isValidateListEmpty(urlList)) {
            return false;
        }
        String dir = (String)this.comboPath.getEditor().getItem();
        if (dir == null || dir.isEmpty()) {
            Swinger.showErrorMessage(this.getResourceMap(), "noDirectoryMessage", new Object[0]);
            this.btnSelectPathAction();
            return false;
        }
        File outputDir = new File(Utils.isWindows() ? dir.trim() : dir);
        if (!outputDir.isDirectory()) {
            int choiceYesNo = Swinger.getChoiceYesNo(this.getResourceMap().getString("directoryCreateMessage", new Object[0]));
            if (choiceYesNo == 0) {
                if (!outputDir.mkdirs()) {
                    Swinger.showErrorMessage(this.getResourceMap(), "directoryCreatingFailed", outputDir.getAbsolutePath());
                    this.btnSelectPathAction();
                    return false;
                }
                if (!outputDir.isDirectory()) {
                    Swinger.showErrorMessage(this.getResourceMap(), "itsNotDirectory", outputDir.getAbsolutePath());
                    this.btnSelectPathAction();
                    return false;
                }
            } else {
                this.btnSelectPathAction();
                return false;
            }
        }
        ArrayList<URL> notSupportedList = new ArrayList<URL>();
        for (URL url : urlList) {
            if (this.pluginsManager.isSupported(url)) continue;
            notSupportedList.add(url);
        }
        if (!notSupportedList.isEmpty() && (result = Swinger.getChoiceYesNo(this.getResourceMap().getString("notSupportedByPlugins", this.urlListToString(notSupportedList)))) == 0) {
            newList = NewLinksDialog.removeAll(urlList, notSupportedList);
            this.urlsArea.setText("");
            this.urlsArea.setURLList(newList);
            if (this.isValidateListEmpty(newList)) {
                return false;
            }
            urlList = this.urlsArea.getURLs();
        }
        ArrayList<URL> alreadyOnList = new ArrayList<URL>();
        newList = this.dataManager.getLock();
        synchronized (newList) {
            for (DownloadFile file : this.dataManager.getDownloadFiles()) {
                alreadyOnList.add(file.getFileUrl());
            }
        }
        List<URL> removeList = NewLinksDialog.getCommonElements(alreadyOnList, urlList);
        if (!removeList.isEmpty()) {
            int result2 = Swinger.getChoiceYesNoCancel(this.getResourceMap().getString("alreadyContainsMessage", this.urlListToString(removeList)));
            switch (result2) {
                case 0: {
                    break;
                }
                case 1: {
                    List<URL> newList2 = NewLinksDialog.removeAll(urlList, removeList);
                    this.urlsArea.setText("");
                    this.urlsArea.setURLList(newList2);
                    if (this.isValidateListEmpty(newList2)) {
                        return false;
                    }
                    urlList = this.urlsArea.getURLs();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (AppPrefs.getProperty("enableNewLinkCheckDownloadHistory", false)) {
            ArrayList<URL> alreadyDownloadedList = new ArrayList<URL>();
            for (FileHistoryItem file : this.historyManager.getItems()) {
                alreadyDownloadedList.add(file.getUrl());
            }
            List<URL> downloadedList = NewLinksDialog.getCommonElements(alreadyDownloadedList, urlList);
            if (!downloadedList.isEmpty()) {
                int result3 = Swinger.getChoiceYesNoCancel(this.getResourceMap().getString("alreadyDownloadedMessage", this.urlListToString(downloadedList)));
                switch (result3) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        List<URL> newList3 = NewLinksDialog.removeAll(urlList, downloadedList);
                        this.urlsArea.setText("");
                        this.urlsArea.setURLList(newList3);
                        if (this.isValidateListEmpty(newList3)) {
                            return false;
                        }
                        urlList = this.urlsArea.getURLs();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean isValidateListEmpty(List<URL> aList) {
        if (aList.isEmpty()) {
            Swinger.showErrorMessage(this.getResourceMap(), "noURLMessage", new Object[0]);
            Swinger.inputFocus(this.urlsArea);
            return true;
        }
        return false;
    }

    public List<DownloadFile> getDownloadFiles() {
        File saveToDirectory = FRDUtils.getAbsRelPath(this.getDirectory());
        String description = this.descriptionArea.getText();
        ArrayList<DownloadFile> result = new ArrayList<DownloadFile>();
        for (URL url : this.urlsArea.getURLs()) {
            result.add(new DownloadFile(url, saveToDirectory, description));
        }
        return result;
    }

    private File getDirectory() {
        String o = (String)this.comboPath.getEditor().getItem();
        return new File(Utils.isWindows() ? o.trim() : o);
    }

    public boolean isStartPaused() {
        return this.startPaused;
    }

    public void setURLs(List<URL> urlList) {
        this.urlsArea.setURLList(urlList);
    }

    private static List<URL> removeAll(List<URL> target, List<URL> toRemove) {
        LinkedHashMap<String, URL> map = new LinkedHashMap<String, URL>(target.size());
        for (URL u : target) {
            map.put(u.toString(), u);
        }
        for (URL u : toRemove) {
            map.remove(u.toString());
        }
        ArrayList<URL> result = new ArrayList<URL>(map.size());
        result.addAll(map.values());
        return result;
    }

    private static List<URL> getCommonElements(List<URL> list1, List<URL> list2) {
        HashMap<String, URL> map = new HashMap<String, URL>(list1.size());
        ArrayList<URL> commonElements = new ArrayList<URL>();
        for (URL u : list1) {
            map.put(u.toString(), u);
        }
        for (URL u : list2) {
            if (!map.containsKey(u.toString())) continue;
            commonElements.add(u);
        }
        return commonElements;
    }

    private String urlListToString(List<URL> urls) {
        StringBuilder builder = new StringBuilder();
        int n = Math.min(urls.size(), 20);
        for (int i = 0; i < n; ++i) {
            builder.append('\n').append(urls.get(i));
        }
        if (urls.size() > 20) {
            builder.append('\n').append(this.getResourceMap().getString("andOtherURLs", urls.size() - 20));
        }
        return builder.toString();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JLabel labelLinks = new JLabel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.urlsArea = ComponentFactory.getURLsEditorPane();
        JLabel labelSaveTo = new JLabel();
        this.comboPath = new JComboBox();
        this.btnSelectPath = new JButton();
        JLabel labelDescription = new JLabel();
        JScrollPane scrollPane2 = new JScrollPane();
        this.descriptionArea = ComponentFactory.getTextArea();
        JXButtonPanel buttonBar = new JXButtonPanel();
        this.btnPasteFromClipboard = new JButton();
        this.okButton = new JButton();
        this.btnStartPaused = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(Borders.DIALOG);
        dialogPane.setLayout(new BorderLayout());
        labelLinks.setName("labelLinks");
        labelLinks.setLabelFor(this.urlsArea);
        scrollPane1.setViewportView(this.urlsArea);
        labelSaveTo.setName("labelSaveTo");
        labelSaveTo.setLabelFor(this.comboPath);
        this.comboPath.setEditable(true);
        this.btnSelectPath.setName("btnSelectPath");
        labelDescription.setName("labelDescription");
        labelDescription.setLabelFor(this.descriptionArea);
        scrollPane2.setViewportView(this.descriptionArea);
        PanelBuilder contentPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.PREFERRED, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.MIN_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.PREFERRED, 1.0), FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.bounded(Sizes.PREFERRED, Sizes.dluY(40), Sizes.dluY(55)), 1.0)}), contentPanel);
        contentPanelBuilder.add((Component)labelLinks, cc.xy(1, 1));
        contentPanelBuilder.add((Component)scrollPane1, cc.xywh(1, 3, 5, 1));
        contentPanelBuilder.add((Component)labelSaveTo, cc.xy(1, 5));
        contentPanelBuilder.add((Component)this.comboPath, cc.xy(3, 5));
        contentPanelBuilder.add((Component)this.btnSelectPath, cc.xy(5, 5));
        contentPanelBuilder.add((Component)labelDescription, cc.xy(1, 7));
        contentPanelBuilder.add((Component)scrollPane2, cc.xywh(3, 7, 3, 1));
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.btnPasteFromClipboard.setName("btnPasteFromClipboard");
        this.okButton.setName("okButton");
        this.btnStartPaused.setName("btnStartPaused");
        this.cancelButton.setName("cancelButton");
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.PREF_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.UNRELATED_GAP_COLSPEC, FormSpecs.PREF_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("max(pref;50dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("max(pref;50dlu)")}, RowSpec.decodeSpecs("fill:pref")), buttonBar);
        ((FormLayout)buttonBar.getLayout()).setColumnGroups(new int[][]{{5, 9}});
        buttonBarBuilder.add((Component)this.btnPasteFromClipboard, cc.xy(1, 1));
        buttonBarBuilder.add((Component)this.okButton, cc.xy(5, 1));
        buttonBarBuilder.add((Component)this.btnStartPaused, cc.xy(7, 1));
        buttonBarBuilder.add((Component)this.cancelButton, cc.xy(9, 1));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
    }
}

