/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.dialogs.ProxyForPluginManipDialog;
import cz.vity.freerapid.gui.dialogs.ProxySetDialog;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.ProxyForPluginManager;
import cz.vity.freerapid.model.ProxyForPlugin;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.components.FindTableAction;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.jdesktop.application.Action;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class ProxyForPluginDialog
extends AppDialog
implements PropertyChangeListener,
ListSelectionListener {
    private static final Logger logger = Logger.getLogger(ProxyForPluginDialog.class.getName());
    private static final String DATA_ADDED_PROPERTY = "dataAdded";
    private static final String DATA_MODIFIED_PROPERTY = "dataModified";
    private static final int COLUMN_ACTIVE = 0;
    private static final int COLUMN_PLUGIN = 1;
    private static final int COLUMN_SERVICES = 2;
    private static final int COLUMN_PROXY_SET = 3;
    private static final int MIN_FIRST_COLUMN_WIDTH = 26;
    private static final String SELECTED_ACTION_ENABLED_PROPERTY = "selectedEnabled";
    private boolean selectedEnabled;
    private final ManagerDirector director;
    private final ProxyForPluginManager manager;
    private JXTable table;
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnDelete;
    private JButton btnProxySet;
    private JButton btnClose;

    public ProxyForPluginDialog(JDialog owner, ManagerDirector director) throws HeadlessException {
        super((Dialog)owner, true);
        this.director = director;
        this.manager = director.getProxyForPluginManager();
        this.setName("ProxyForPluginDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            this.doClose();
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnClose;
    }

    @Override
    public void doClose() {
        this.manager.removePropertyChangeListener(DATA_ADDED_PROPERTY, this);
        this.director.getProxySetManager().removePropertyChangeListener(DATA_MODIFIED_PROPERTY, this);
        this.table.getSelectionModel().removeListSelectionListener(this);
        CustomTableModel tableModel = (CustomTableModel)this.table.getModel();
        tableModel.model.removeListDataListener(tableModel);
        super.doClose();
    }

    private void build() {
        this.inject();
        this.buildModels();
        this.buildGUI();
        this.setAction(this.btnAdd, "btnAddAction");
        this.setAction(this.btnEdit, "btnEditAction");
        this.setAction(this.btnDelete, "btnDeleteAction");
        this.setAction(this.btnProxySet, "btnProxySetAction");
        this.setAction(this.btnClose, "btnCloseAction");
        this.updateActions();
        this.manager.addPropertyChangeListener(DATA_ADDED_PROPERTY, this);
        this.director.getProxySetManager().addPropertyChangeListener(DATA_MODIFIED_PROPERTY, this);
        this.pack();
        this.setResizable(true);
        ProxyForPluginDialog.locateOnOpticalScreenCenter(this);
    }

    private void buildModels() {
    }

    private void buildGUI() {
        this.initTable();
    }

    private void initTable() {
        this.table.setName("table");
        this.table.setModel(new CustomTableModel(new ArrayListModel<ProxyForPlugin>(this.manager.getItems()), this.getList("columns", 4)));
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setEditable(true);
        this.table.setHorizontalScrollEnabled(true);
        this.table.setColumnControlVisible(true);
        this.table.setSortable(true);
        this.table.setColumnMargin(10);
        this.table.setRolloverEnabled(true);
        this.table.setShowGrid(true, true);
        this.table.setColumnSelectionAllowed(false);
        this.table.createDefaultColumnsFromModel();
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ProxyForPluginDialog.this.table.hasFocus()) {
                    Swinger.inputFocus(ProxyForPluginDialog.this.table);
                }
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() >= 2) {
                    ProxyForPluginDialog.this.btnEditAction();
                }
            }
        });
        Component comp = this.table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(this.table, this.getList("columns", 4)[0], false, false, 0, 0);
        int width = Math.max(comp.getPreferredSize().width + 2 * this.table.getColumnMargin(), 26);
        TableColumn tableColumn = Swinger.updateColumn(this.table, "Active", 0, width, width, null);
        tableColumn.setWidth(width);
        tableColumn.setMaxWidth(width);
        ColorHighlighter highlighter = new ColorHighlighter(new HighlightPredicate(){

            @Override
            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                return Boolean.FALSE.equals(adapter.getValue(0));
            }
        }, HighlighterFactory.GENERIC_GRAY, Color.BLACK);
        this.table.addHighlighter(highlighter);
        this.table.setSortOrder(1, SortOrder.ASCENDING);
        InputMap tableInputMap = this.table.getInputMap();
        tableInputMap.put(SwingUtils.getShiftKeyStroke(36), "selectFirstRowExtendSelection");
        tableInputMap.put(SwingUtils.getShiftKeyStroke(35), "selectLastRowExtendSelection");
        new FindTableAction(Swinger.getResourceMap(), 1){

            @Override
            protected Object getObject(int index, int column) {
                return ProxyForPluginDialog.this.table.getModel().getValueAt(index, column);
            }
        }.install(this.table);
        this.table.getParent().setPreferredSize(new Dimension(600, 200));
    }

    private void reloadModel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProxyForPluginDialog.this.table.getModel() instanceof CustomTableModel) {
                    CustomTableModel tableModel = (CustomTableModel)ProxyForPluginDialog.this.table.getModel();
                    tableModel.model.removeListDataListener(tableModel);
                }
                int col = ProxyForPluginDialog.this.table.getSortedColumnIndex();
                SortOrder order = ProxyForPluginDialog.this.table.getSortOrder(col);
                ProxyForPluginDialog.this.table.setModel(new CustomTableModel(new ArrayListModel<ProxyForPlugin>(ProxyForPluginDialog.this.manager.getItems()), ProxyForPluginDialog.this.getList("columns", 4)));
                ProxyForPluginDialog.this.table.setSortOrder(col, order);
            }
        });
    }

    @Action
    public void btnAddAction() {
        ProxyForPluginManipDialog dialog = new ProxyForPluginManipDialog(this, this.director, ProxyForPluginManipDialog.ManipType.ADD, null);
        this.getApp().show(dialog);
    }

    @Action(enabledProperty="selectedEnabled")
    public void btnEditAction() {
        int[] indexes = this.getSelectedRows();
        if (indexes.length > 0) {
            int index = indexes[0];
            ProxyForPlugin ProxyForPlugin2 = (ProxyForPlugin)this.table.getModel().getValueAt(index, -1);
            ProxyForPluginManipDialog dialog = new ProxyForPluginManipDialog(this, this.director, ProxyForPluginManipDialog.ManipType.EDIT, ProxyForPlugin2);
            this.getApp().show(dialog);
            if (dialog.getModalResult() == 0) {
                this.reloadModel();
            }
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void btnDeleteAction() {
        int[] indexes = this.getSelectedRows();
        this.removeSelected(indexes);
    }

    @Action
    public void btnProxySetAction() {
        ProxySetDialog proxySetDialog = new ProxySetDialog(this, this.director);
        this.getApp().show(proxySetDialog);
    }

    @Action
    public void btnCloseAction() {
        super.doClose();
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.table = new JXTable();
        JXButtonPanel actionButtonPanel = new JXButtonPanel();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnDelete = new JButton();
        this.btnProxySet = new JButton();
        this.btnAdd.setName("btnAdd");
        this.btnEdit.setName("btnEdit");
        this.btnDelete.setName("btnDelete");
        this.btnProxySet.setName("btnProxySet");
        JXButtonPanel buttonBar = new JXButtonPanel();
        this.btnClose = new JButton();
        this.btnClose.setName("btnClose");
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(Borders.DIALOG);
        dialogPane.setLayout(new BorderLayout());
        contentPanel.setBorder(new CompoundBorder(new EmptyBorder(4, 4, 4, 4), new EtchedBorder()));
        contentPanel.setLayout(new BorderLayout());
        scrollPane1.setViewportView(this.table);
        contentPanel.add((Component)scrollPane1, "Center");
        actionButtonPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        PanelBuilder actionButtonPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{ColumnSpec.decode("max(pref;42dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), ColumnSpec.decode("max(pref;42dlu)")}, RowSpec.decodeSpecs("default")), actionButtonPanel);
        ((FormLayout)actionButtonPanel.getLayout()).setColumnGroups(new int[][]{{1, 3, 5}});
        actionButtonPanelBuilder.add((Component)this.btnAdd, cc.xy(1, 1));
        actionButtonPanelBuilder.add((Component)this.btnEdit, cc.xy(3, 1));
        actionButtonPanelBuilder.add((Component)this.btnDelete, cc.xy(5, 1));
        actionButtonPanelBuilder.add((Component)this.btnProxySet, cc.xy(7, 1));
        contentPanel.add((Component)actionButtonPanel, "South");
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.UNRELATED_GAP_COLSPEC, ColumnSpec.decode("max(pref;42dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, RowSpec.decodeSpecs("fill:pref")), buttonBar);
        ((FormLayout)buttonBar.getLayout()).setColumnGroups(new int[][]{{3, 5}});
        buttonBarBuilder.add((Component)this.btnClose, cc.xy(5, 1));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
    }

    private ArrayListModel<ProxyForPlugin> getItems() {
        return ((CustomTableModel)this.table.getModel()).model;
    }

    private int[] getSelectedRows() {
        return Swinger.getSelectedRows(this.table);
    }

    public List<ProxyForPlugin> getSelectionToList(int[] selectedRows) {
        return this.selectionToList(selectedRows);
    }

    private List<ProxyForPlugin> selectionToList(int[] indexes) {
        ArrayList<ProxyForPlugin> list = new ArrayList<ProxyForPlugin>();
        ArrayListModel<ProxyForPlugin> items = this.getItems();
        for (int index : indexes) {
            list.add((ProxyForPlugin)items.get(index));
        }
        return list;
    }

    private void updateActions() {
        int[] indexes = this.getSelectedRows();
        this.setSelectedEnabled(indexes.length > 0);
    }

    public boolean isSelectedEnabled() {
        return this.selectedEnabled;
    }

    public void setSelectedEnabled(boolean selectedEnabled) {
        boolean oldValue = this.selectedEnabled;
        this.selectedEnabled = selectedEnabled;
        this.firePropertyChange(SELECTED_ACTION_ENABLED_PROPERTY, oldValue, selectedEnabled);
    }

    private void removeSelected(int[] indexes) {
        int result = Swinger.getChoiceOKCancel("msgDeleteProxyForPluginConfirmation", new Object[0]);
        if (result != 0) {
            return;
        }
        final ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        ArrayListModel<ProxyForPlugin> items = this.getItems();
        List<ProxyForPlugin> toRemoveList = this.getSelectionToList(indexes);
        this.manager.removeItems(toRemoveList);
        items.removeAll(toRemoveList);
        selectionModel.setValueIsAdjusting(false);
        final int min = this.getArrayMin(indexes);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int count = ProxyForPluginDialog.this.table.getRowCount();
                if (ProxyForPluginDialog.this.table.getRowCount() > 0) {
                    int index = Math.min(count - 1, min);
                    index = ProxyForPluginDialog.this.table.convertRowIndexToView(index);
                    selectionModel.addSelectionInterval(index, index);
                    ProxyForPluginDialog.this.scrollToVisible(true);
                }
            }
        });
        this.updateActions();
    }

    private void scrollToVisible(boolean up) {
        int[] rows = this.table.getSelectedRows();
        int length = rows.length;
        if (length > 0) {
            this.table.scrollRowToVisible(up ? rows[0] : rows[length - 1]);
        }
    }

    private int getArrayMin(int[] indexes) {
        int min = Integer.MAX_VALUE;
        for (int i : indexes) {
            if (min <= i) continue;
            min = i;
        }
        return min;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.reloadModel();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.updateActions();
    }

    private class CustomTableModel
    extends AbstractTableModel
    implements ListDataListener {
        private final ArrayListModel<ProxyForPlugin> model;
        private final String[] columns;

        public CustomTableModel(ArrayListModel<ProxyForPlugin> model, String[] columns) {
            this.model = model;
            this.columns = columns;
            model.addListDataListener(this);
        }

        @Override
        public int getRowCount() {
            return this.model.getSize();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return 0 == columnIndex;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ProxyForPlugin proxyForPlugin = (ProxyForPlugin)this.model.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return proxyForPlugin.isEnabled();
                }
                case 1: {
                    return proxyForPlugin.getPluginId();
                }
                case 2: {
                    return proxyForPlugin.getPluginServices();
                }
                case 3: {
                    return proxyForPlugin.getProxySetName();
                }
                case -1: {
                    return proxyForPlugin;
                }
            }
            assert (false);
            return proxyForPlugin;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ProxyForPlugin data = (ProxyForPlugin)this.model.get(rowIndex);
            if (columnIndex == 0) {
                data.setEnabled((Boolean)aValue);
                ProxyForPluginDialog.this.manager.updateProxyForPluginItem(data);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.fireTableRowsUpdated(e.getIndex0(), e.getIndex1());
        }
    }
}

