/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.ProxyForPluginManager;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.model.ProxyForPlugin;
import cz.vity.freerapid.model.ProxySet;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.components.FindTableAction;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SortOrder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.jdesktop.application.Action;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;
import org.jdesktop.swingx.JXTable;

public class ProxyForPluginManipDialog
extends AppDialog
implements ListSelectionListener {
    private static final Logger logger = Logger.getLogger(ProxyForPluginManipDialog.class.getName());
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_SERVICES = 1;
    private static final String SELECTED_ACTION_ENABLED_PROPERTY = "selectedEnabled";
    private boolean selectedEnabled;
    private final ManagerDirector director;
    private final ProxyForPluginManager manager;
    private final ProxyForPlugin proxyForPlugin;
    private final ManipType manipType;
    private JXTable pluginTable;
    private JComboBox<ProxySet> cbbProxySet;
    private JButton btnOk;
    private JButton btnCancel;

    public ProxyForPluginManipDialog(JDialog owner, ManagerDirector director, ManipType manipType, ProxyForPlugin proxyForPlugin) throws HeadlessException {
        super((Dialog)owner, true);
        this.director = director;
        this.manager = director.getProxyForPluginManager();
        this.proxyForPlugin = proxyForPlugin;
        this.manipType = manipType;
        this.setName("ProxyForPluginManipDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            this.doClose();
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnOk;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnCancel;
    }

    private void build() {
        this.inject();
        this.buildModels();
        this.buildGUI();
        this.setAction(this.btnOk, "btnOkAction");
        this.setAction(this.btnCancel, "btnCancelAction");
        this.setTitle(this.getTitle() + " - " + (this.manipType == ManipType.ADD ? this.getResourceMap().getString("titleAdd", new Object[0]) : this.getResourceMap().getString("titleEdit", new Object[0])));
        MnemonicUtils.configure(this.btnOk, this.manipType == ManipType.ADD ? this.getResourceMap().getString("btnOkAddText", new Object[0]) : this.getResourceMap().getString("btnOkEditText", new Object[0]));
        this.pack();
        this.setResizable(true);
        ProxyForPluginManipDialog.locateOnOpticalScreenCenter(this);
    }

    private void buildModels() {
    }

    private void buildGUI() {
        this.initTable();
        LinkedList<ProxySet> items = new LinkedList<ProxySet>(this.director.getProxySetManager().getItems());
        Collections.sort(items, new Comparator<ProxySet>(){

            @Override
            public int compare(ProxySet o1, ProxySet o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.cbbProxySet.setModel(new DefaultComboBoxModel<ProxySet>(new Vector<ProxySet>(items)));
        this.cbbProxySet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyForPluginManipDialog.this.updateActions();
            }
        });
        if (this.manipType == ManipType.EDIT) {
            int selectedIndex = -1;
            String pluginName = this.proxyForPlugin.getPluginId();
            ArrayListModel<PluginMetaData> tableItems = this.getItems();
            for (int i = 0; i < tableItems.size(); ++i) {
                PluginMetaData plugin = (PluginMetaData)tableItems.get(i);
                if (!pluginName.equals(plugin.getId())) continue;
                selectedIndex = this.pluginTable.convertRowIndexToView(i);
                break;
            }
            this.pluginTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
            this.pluginTable.scrollRowToVisible(selectedIndex);
            selectedIndex = -1;
            String proxySetName = this.proxyForPlugin.getProxySetName();
            ComboBoxModel<ProxySet> comboBoxModel = this.cbbProxySet.getModel();
            for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                ProxySet proxySet = (ProxySet)comboBoxModel.getElementAt(i);
                if (!proxySetName.equals(proxySet.getName())) continue;
                selectedIndex = i;
                break;
            }
            this.cbbProxySet.setSelectedIndex(selectedIndex);
        }
    }

    private void initTable() {
        ArrayListModel<PluginMetaData> plugins = new ArrayListModel<PluginMetaData>(this.director.getPluginsManager().getSupportedPlugins());
        this.pluginTable.setName("pluginTable");
        this.pluginTable.setModel(new CustomTableModel(plugins, this.getList("columns", 2)));
        this.pluginTable.setAutoCreateColumnsFromModel(false);
        this.pluginTable.setEditable(false);
        this.pluginTable.setColumnControlVisible(true);
        this.pluginTable.setSortable(true);
        this.pluginTable.setColumnMargin(10);
        this.pluginTable.setRolloverEnabled(true);
        this.pluginTable.setShowGrid(true, true);
        this.pluginTable.setColumnSelectionAllowed(false);
        this.pluginTable.setSelectionMode(0);
        this.pluginTable.createDefaultColumnsFromModel();
        this.pluginTable.getSelectionModel().addListSelectionListener(this);
        this.pluginTable.setSortOrder(0, SortOrder.ASCENDING);
        new FindTableAction(Swinger.getResourceMap(), 0){

            @Override
            protected Object getObject(int index, int column) {
                return ProxyForPluginManipDialog.this.pluginTable.getModel().getValueAt(index, column);
            }
        }.install(this.pluginTable);
        this.pluginTable.getParent().setPreferredSize(new Dimension(600, 400));
    }

    @Override
    public void doClose() {
        super.doClose();
    }

    @Action(enabledProperty="selectedEnabled")
    public void btnOkAction() {
        if (!this.validateChanges()) {
            return;
        }
        this.setResult(0);
        int[] indexes = this.getSelectedRows();
        int index = indexes[0];
        PluginMetaData pluginMetaData = (PluginMetaData)this.getItems().get(index);
        ProxySet proxySet = this.cbbProxySet.getItemAt(this.cbbProxySet.getSelectedIndex());
        Long proxySetDbId = proxySet.getIdentificator();
        String pluginName = pluginMetaData.getId();
        if (this.manipType == ManipType.ADD) {
            this.manager.addProxyForPluginItem(new ProxyForPlugin(pluginName, proxySetDbId));
        } else {
            this.proxyForPlugin.setPluginId(pluginName);
            this.proxyForPlugin.setProxySetId(proxySetDbId);
            this.manager.updateProxyForPluginItem(this.proxyForPlugin);
        }
        this.doClose();
    }

    @Action
    public void btnCancelAction() {
        this.setResult(1);
        this.doClose();
    }

    private boolean validateChanges() {
        if (this.getSelectedRows().length <= 0) {
            Swinger.showErrorMessage(this.getResourceMap(), "noPluginSelected", new Object[0]);
            Swinger.inputFocus(this.pluginTable);
            return false;
        }
        int[] indexes = this.getSelectedRows();
        int index = indexes[0];
        PluginMetaData pluginMetaData = (PluginMetaData)this.getItems().get(index);
        String name = pluginMetaData.getId();
        if (this.manipType == ManipType.EDIT && !name.equals(this.proxyForPlugin.getPluginId()) && this.manager.isPluginExists(name) || this.manipType == ManipType.ADD && this.manager.isPluginExists(name)) {
            Swinger.showErrorMessage(this.getResourceMap(), "pluginExists", name);
            Swinger.inputFocus(this.pluginTable);
            return false;
        }
        if (this.cbbProxySet.getSelectedIndex() == -1) {
            Swinger.showErrorMessage(this.getResourceMap(), "noProxySetSelected", new Object[0]);
            Swinger.inputFocus(this.cbbProxySet);
            return false;
        }
        return true;
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JLabel lblProxySet = new JLabel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.pluginTable = new JXTable();
        this.cbbProxySet = new JComboBox();
        lblProxySet.setName("lblProxySet");
        lblProxySet.setLabelFor(this.cbbProxySet);
        JXButtonPanel buttonBar = new JXButtonPanel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.btnOk.setName("btnOk");
        this.btnCancel.setName("btnCancel");
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(Borders.DIALOG);
        dialogPane.setLayout(new BorderLayout());
        scrollPane1.setViewportView(this.pluginTable);
        PanelBuilder contentPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.bounded(Sizes.PREFERRED, Sizes.dluX(140), Sizes.dluX(255)), 1.0)}, new RowSpec[]{new RowSpec(RowSpec.FILL, Sizes.bounded(Sizes.PREFERRED, Sizes.dluY(140), Sizes.dluY(255)), 1.0), FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), contentPanel);
        contentPanelBuilder.add((Component)scrollPane1, cc.xyw(1, 1, 3));
        contentPanelBuilder.add((Component)lblProxySet, cc.xy(1, 3));
        contentPanelBuilder.add(this.cbbProxySet, cc.xy(3, 3));
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.UNRELATED_GAP_COLSPEC, ColumnSpec.decode("max(pref;42dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, RowSpec.decodeSpecs("fill:pref")), buttonBar);
        ((FormLayout)buttonBar.getLayout()).setColumnGroups(new int[][]{{3, 5}});
        buttonBarBuilder.add((Component)this.btnOk, cc.xy(3, 1));
        buttonBarBuilder.add((Component)this.btnCancel, cc.xy(5, 1));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
    }

    private ArrayListModel<PluginMetaData> getItems() {
        return ((CustomTableModel)this.pluginTable.getModel()).model;
    }

    private int[] getSelectedRows() {
        return Swinger.getSelectedRows(this.pluginTable);
    }

    private void updateActions() {
        int[] indexes = this.getSelectedRows();
        this.setSelectedEnabled(indexes.length > 0);
    }

    public boolean isSelectedEnabled() {
        return this.selectedEnabled;
    }

    public void setSelectedEnabled(boolean selectedEnabled) {
        boolean oldValue = this.selectedEnabled;
        this.selectedEnabled = selectedEnabled;
        this.firePropertyChange(SELECTED_ACTION_ENABLED_PROPERTY, oldValue, selectedEnabled);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.updateActions();
    }

    private static class CustomTableModel
    extends AbstractTableModel {
        private final ArrayListModel<PluginMetaData> model;
        private final String[] columns;

        public CustomTableModel(ArrayListModel<PluginMetaData> model, String[] columns) {
            this.model = model;
            this.columns = columns;
        }

        @Override
        public int getRowCount() {
            return this.model.getSize();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PluginMetaData plugin = (PluginMetaData)this.model.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return plugin.getId();
                }
                case 1: {
                    return plugin.getServices();
                }
                case -1: {
                    return plugin;
                }
            }
            assert (false);
            return plugin;
        }
    }

    static enum ManipType {
        ADD,
        EDIT;

    }
}

