/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.ProxySetManager;
import cz.vity.freerapid.model.ProxySet;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.components.EditorPaneProxyDetector;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;

public class ProxySetManipDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(ProxySetManipDialog.class.getName());
    private final ManagerDirector director;
    private final ProxySetManager manager;
    private final ManipType manipType;
    private final ProxySet proxySet;
    private PresentationModel<ProxySet> model;
    private JTextField fldName;
    private EditorPaneProxyDetector proxyEditorPane;
    private JButton btnOk;
    private JButton btnCancel;

    public ProxySetManipDialog(JDialog owner, ManagerDirector director, ManipType manipType, ProxySet proxySet) throws HeadlessException {
        super((Dialog)owner, true);
        this.director = director;
        this.manager = director.getProxySetManager();
        this.manipType = manipType;
        this.proxySet = proxySet;
        this.setName("ProxySetManipDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            this.doClose();
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnOk;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnCancel;
    }

    private void build() {
        this.inject();
        this.buildModels();
        this.buildGUI();
        this.setAction(this.btnOk, "btnOkAction");
        this.setAction(this.btnCancel, "btnCancelAction");
        this.setTitle(this.getTitle() + " - " + (this.manipType == ManipType.ADD ? this.getResourceMap().getString("titleAdd", new Object[0]) : this.getResourceMap().getString("titleEdit", new Object[0])));
        MnemonicUtils.configure(this.btnOk, this.manipType == ManipType.ADD ? this.getResourceMap().getString("btnOkAddText", new Object[0]) : this.getResourceMap().getString("btnOkEditText", new Object[0]));
        this.pack();
        this.setResizable(true);
        ProxySetManipDialog.locateOnOpticalScreenCenter(this);
    }

    private void buildModels() {
        if (this.manipType == ManipType.EDIT) {
            this.model = new PresentationModel<ProxySet>(this.proxySet);
            Bindings.bind(this.fldName, (ValueModel)this.model.getBufferedModel("name"));
            this.proxyEditorPane.setProxies((List)this.model.getBufferedModel("proxies").getValue());
        }
    }

    private void buildGUI() {
    }

    @Override
    public void doClose() {
        super.doClose();
        if (this.model != null) {
            this.model.setBean(null);
        }
    }

    @Action
    public void btnOkAction() {
        if (!this.validateChanges()) {
            return;
        }
        this.setResult(0);
        String name = this.fldName.getText().trim();
        List<String> proxies = this.proxyEditorPane.getProxies();
        if (this.manipType == ManipType.ADD) {
            this.manager.addProxySetItem(new ProxySet(name, proxies));
        } else if (this.model != null) {
            this.model.getBufferedModel("proxies").setValue(this.proxyEditorPane.getProxies());
            this.model.triggerCommit();
            this.manager.updateProxySetItem(this.model.getBean());
        }
        this.doClose();
    }

    @Action
    public void btnCancelAction() {
        this.setResult(1);
        if (this.manipType == ManipType.EDIT && this.model != null) {
            this.model.triggerFlush();
        }
        this.doClose();
    }

    private boolean validateChanges() {
        String name = this.fldName.getText().trim();
        if (name.isEmpty()) {
            Swinger.showErrorMessage(this.getResourceMap(), "noNameMessage", new Object[0]);
            Swinger.inputFocus(this.fldName);
            return false;
        }
        if (this.manipType == ManipType.EDIT && !name.equals(this.model.getBean().getName()) && this.manager.isNameExists(name) || this.manipType == ManipType.ADD && this.manager.isNameExists(name)) {
            Swinger.showErrorMessage(this.getResourceMap(), "nameExists", name);
            Swinger.inputFocus(this.fldName);
            return false;
        }
        List<String> proxies = this.proxyEditorPane.getProxies();
        return !this.isValidateListEmpty(proxies);
    }

    private boolean isValidateListEmpty(List<String> proxies) {
        if (proxies.isEmpty()) {
            Swinger.showErrorMessage(this.getResourceMap(), "noProxyMessage", new Object[0]);
            Swinger.inputFocus(this.proxyEditorPane);
            return true;
        }
        return false;
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JLabel lblName = new JLabel();
        JLabel lblProxies = new JLabel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.fldName = new JTextField();
        this.proxyEditorPane = ComponentFactory.getProxiesEditorPane();
        JLabel lblProxyDesc = new JLabel();
        lblName.setName("lblName");
        lblProxies.setName("lblProxies");
        lblProxyDesc.setName("lblProxyDesc");
        lblName.setLabelFor(this.fldName);
        lblProxies.setLabelFor(this.proxyEditorPane);
        JXButtonPanel buttonBar = new JXButtonPanel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.btnOk.setName("btnOk");
        this.btnCancel.setName("btnCancel");
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(Borders.DIALOG);
        dialogPane.setLayout(new BorderLayout());
        scrollPane1.setViewportView(this.proxyEditorPane);
        PanelBuilder contentPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.bounded(Sizes.PREFERRED, Sizes.dluX(140), Sizes.dluX(255)), 1.0)}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.bounded(Sizes.PREFERRED, Sizes.dluY(55), Sizes.dluY(75)), 1.0), FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), contentPanel);
        contentPanelBuilder.add((Component)lblName, cc.xy(1, 1));
        contentPanelBuilder.add((Component)this.fldName, cc.xy(3, 1));
        contentPanelBuilder.add((Component)lblProxies, cc.xy(1, 3));
        contentPanelBuilder.add((Component)scrollPane1, cc.xyw(1, 5, 3));
        contentPanelBuilder.add((Component)lblProxyDesc, cc.xyw(1, 7, 3));
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.UNRELATED_GAP_COLSPEC, ColumnSpec.decode("max(pref;42dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, RowSpec.decodeSpecs("fill:pref")), buttonBar);
        ((FormLayout)buttonBar.getLayout()).setColumnGroups(new int[][]{{3, 5}});
        buttonBarBuilder.add((Component)this.btnOk, cc.xy(3, 1));
        buttonBarBuilder.add((Component)this.btnCancel, cc.xy(5, 1));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
    }

    static enum ManipType {
        ADD,
        EDIT;

    }
}

