/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.managers.ToolbarManager;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;

public class ToolbarDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(ToolbarDialog.class.getName());
    private String defaultToolbarString = "A-BCD-EFGH";
    private String currentToolbarString;
    private String newToolbarString = this.currentToolbarString = AppPrefs.getProperty("customToolbarButtons", "A-BCD-EFGH");
    private DefaultListModel toolbarModel;
    private DefaultListModel functionModel;
    private ToolbarManager toolbarManager;
    private boolean toolbarListSelected = false;
    private static final String TOOLBAR_LIST_SELECTED_ACTION_ENABLED_PROPERTY = "toolbarListSelected";
    private boolean functionListSelected = false;
    private static final String FUNCTION_LIST_SELECTED_ACTION_ENABLED_PROPERTY = "functionListSelected";
    private JList toolbarList;
    private JList functionsList;
    private JButton addButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private JButton defaultButton;
    private JButton resetButton;
    private JButton okButton;
    private JButton cancelButton;

    public ToolbarDialog(JFrame owner) throws Exception {
        super((Frame)owner, true);
        this.setName("ToolbarDialog");
        this.toolbarManager = MainApp.getInstance(MainApp.class).getManagerDirector().getToolbarManager();
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            this.doClose();
            throw e;
        }
    }

    private void build() {
        this.inject();
        this.loadFunctionModel();
        this.loadToolbarModel();
        this.setAction(this.okButton, "okBtnAction");
        this.setAction(this.cancelButton, "cancelBtnAction");
        this.setAction(this.defaultButton, "defaultBtnAction");
        this.setAction(this.resetButton, "resetBtnAction");
        this.setAction(this.addButton, "addBtnAction");
        this.setAction(this.removeButton, "removeBtnAction");
        this.setAction(this.upButton, "upBtnAction");
        this.setAction(this.downButton, "downBtnAction");
        this.toolbarList.getSelectionModel().addListSelectionListener(new ToolbarListSelectionListener());
        this.functionsList.getSelectionModel().addListSelectionListener(new ToolbarListSelectionListener());
    }

    void loadFunctionModel() {
        this.functionModel = new DefaultListModel();
        for (String btn : this.toolbarManager.getToolbarButtonList()) {
            this.functionModel.addElement(btn);
        }
        this.functionsList.setModel(this.functionModel);
    }

    void loadToolbarModel() {
        this.toolbarModel = new DefaultListModel();
        for (char btn : this.newToolbarString.toCharArray()) {
            this.toolbarModel.addElement("" + btn);
        }
        this.toolbarModel.addElement(" ");
        this.toolbarList.setModel(this.toolbarModel);
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.okButton;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.cancelButton;
    }

    @Action
    public void okBtnAction() {
        this.determineToolbarString();
        AppPrefs.storeProperty("customToolbarButtons", this.newToolbarString);
        this.setResult(0);
        this.toolbarManager.reloadToolbar();
        this.doClose();
    }

    @Action
    public void cancelBtnAction() {
        this.setResult(1);
        this.doClose();
    }

    @Action
    public void defaultBtnAction() {
        this.newToolbarString = this.defaultToolbarString;
        this.loadToolbarModel();
    }

    @Action
    public void resetBtnAction() {
        this.newToolbarString = this.currentToolbarString;
        this.loadToolbarModel();
    }

    @Action(enabledProperty="functionListSelected")
    public void addBtnAction() {
        String btn = (String)this.functionsList.getSelectedValue();
        if (btn != null) {
            int index = this.toolbarList.getSelectedIndex();
            if (index >= 0) {
                this.toolbarModel.add(index, btn);
                this.toolbarList.setSelectedIndex(index + 1);
            } else {
                this.toolbarModel.add(this.toolbarModel.size() - 1, btn);
                this.toolbarList.setSelectedIndex(-1);
            }
        }
    }

    @Action(enabledProperty="toolbarListSelected")
    public void removeBtnAction() {
        int index = this.toolbarList.getSelectedIndex();
        if (index >= 0 && index < this.toolbarModel.size() - 1) {
            this.toolbarModel.remove(index);
        }
    }

    @Action(enabledProperty="toolbarListSelected")
    public void upBtnAction() {
        int index;
        String btn = (String)this.toolbarList.getSelectedValue();
        if (btn != null && (index = this.toolbarList.getSelectedIndex()) > 0 && index < this.toolbarModel.size() - 1) {
            this.toolbarModel.remove(index);
            this.toolbarModel.add(index - 1, btn);
            this.toolbarList.setSelectedIndex(index - 1);
        }
    }

    @Action(enabledProperty="toolbarListSelected")
    public void downBtnAction() {
        int index;
        String btn = (String)this.toolbarList.getSelectedValue();
        if (btn != null && (index = this.toolbarList.getSelectedIndex()) + 1 < this.toolbarModel.size() - 1) {
            this.toolbarModel.remove(index);
            this.toolbarModel.add(index + 1, btn);
            this.toolbarList.setSelectedIndex(index + 1);
        }
    }

    private void determineToolbarString() {
        String out = "";
        for (int ii = 0; ii < this.functionModel.size(); ++ii) {
            try {
                out = out + (String)this.toolbarModel.get(ii);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.newToolbarString = out.trim();
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JPanel toolbarPanel = new JPanel();
        JPanel movementPanel = new JPanel();
        JPanel functionsPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        JLabel toolbarListLabel = new JLabel();
        this.toolbarList = new JList();
        JScrollPane toolbarScrollPane = new JScrollPane();
        JLabel functionsListLabel = new JLabel();
        this.functionsList = new JList();
        JScrollPane functionsScrollPane = new JScrollPane();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.defaultButton = new JButton();
        this.resetButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(Borders.DIALOG);
        dialogPane.setLayout(new BorderLayout());
        toolbarPanel.setLayout(new BoxLayout(toolbarPanel, 3));
        toolbarListLabel.setName("toolbarListLabel");
        toolbarScrollPane.setViewportView(this.toolbarList);
        toolbarScrollPane.setPreferredSize(new Dimension(150, 150));
        this.toolbarList.setLayoutOrientation(0);
        this.toolbarList.setSelectionMode(0);
        this.toolbarList.setCellRenderer(new ToolbarListCellRenderer());
        toolbarPanel.add(toolbarListLabel);
        toolbarPanel.add(toolbarScrollPane);
        movementPanel.setBorder(new EmptyBorder(30, 10, 0, 10));
        PanelBuilder movementPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), movementPanel);
        movementPanelBuilder.add((Component)this.addButton, cc.xy(1, 1));
        movementPanelBuilder.add((Component)this.removeButton, cc.xy(1, 3));
        movementPanelBuilder.add(Box.createRigidArea(new Dimension(30, 30)), cc.xy(1, 5));
        movementPanelBuilder.add((Component)this.upButton, cc.xy(1, 7));
        movementPanelBuilder.add((Component)this.downButton, cc.xy(1, 9));
        functionsPanel.setLayout(new BoxLayout(functionsPanel, 3));
        functionsListLabel.setName("functionsListLabel");
        functionsScrollPane.setViewportView(this.functionsList);
        functionsScrollPane.setPreferredSize(new Dimension(150, 150));
        this.functionsList.setLayoutOrientation(0);
        this.functionsList.setSelectionMode(0);
        this.functionsList.setCellRenderer(new ToolbarListCellRenderer());
        functionsPanel.add(functionsListLabel);
        functionsPanel.add(functionsScrollPane);
        PanelBuilder contentPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, Sizes.PREFERRED, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.PREF_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.PREFERRED, 1.0)}, new RowSpec[]{new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 1.0)}), contentPanel);
        contentPanelBuilder.add((Component)toolbarPanel, cc.xy(1, 1));
        contentPanelBuilder.add((Component)movementPanel, cc.xy(3, 1));
        contentPanelBuilder.add((Component)functionsPanel, cc.xy(5, 1));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.defaultButton.setPreferredSize(new Dimension(80, 25));
        this.resetButton.setPreferredSize(this.defaultButton.getPreferredSize());
        this.okButton.setPreferredSize(this.defaultButton.getPreferredSize());
        this.cancelButton.setPreferredSize(this.defaultButton.getPreferredSize());
        this.defaultButton.setName("defaultButton");
        this.resetButton.setName("resetButton");
        this.okButton.setName("okButton");
        this.cancelButton.setName("cancelButton");
        buttonPanel.add(this.defaultButton);
        buttonPanel.add(this.resetButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        dialogPane.add((Component)contentPanel, "Center");
        dialogPane.add((Component)buttonPanel, "South");
        contentPane.add((Component)dialogPane, "Center");
    }

    public boolean isToolbarListSelected() {
        return this.toolbarListSelected;
    }

    public void setToolbarListSelected(boolean enabled) {
        boolean oldValue = this.toolbarListSelected;
        this.toolbarListSelected = enabled;
        this.firePropertyChange(TOOLBAR_LIST_SELECTED_ACTION_ENABLED_PROPERTY, oldValue, this.toolbarListSelected);
    }

    public boolean isFunctionListSelected() {
        return this.functionListSelected;
    }

    public void setFunctionListSelected(boolean enabled) {
        boolean oldValue = this.functionListSelected;
        this.functionListSelected = enabled;
        this.firePropertyChange(FUNCTION_LIST_SELECTED_ACTION_ENABLED_PROPERTY, oldValue, this.functionListSelected);
    }

    private class ToolbarListSelectionListener
    implements ListSelectionListener {
        private ToolbarListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ToolbarDialog.this.setToolbarListSelected(ToolbarDialog.this.toolbarList.getSelectedIndex() >= 0 && ToolbarDialog.this.toolbarList.getSelectedIndex() < ToolbarDialog.this.toolbarModel.size() - 1);
            ToolbarDialog.this.setFunctionListSelected(ToolbarDialog.this.functionsList.getSelectedIndex() >= 0 && ToolbarDialog.this.functionsList.getSelectedIndex() < ToolbarDialog.this.functionModel.size());
        }
    }

    private class ToolbarListCellRenderer
    extends DefaultListCellRenderer {
        private ToolbarListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                String btn = (String)value;
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, ToolbarDialog.this.toolbarManager.getToolbarButtonName(btn), index, isSelected, cellHasFocus);
                label.setIcon(ToolbarDialog.this.toolbarManager.getToolbarButtonSmallIcon(btn));
                return label;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

