/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.userprefs;

import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.gui.FRDUtils;
import cz.vity.freerapid.gui.dialogs.ConnectDialog;
import cz.vity.freerapid.gui.dialogs.ProxyForPluginDialog;
import cz.vity.freerapid.gui.dialogs.filechooser.OpenSaveDialogFactory;
import cz.vity.freerapid.gui.dialogs.userprefs.UserPreferencesDialog;
import cz.vity.freerapid.gui.dialogs.userprefs.UserPreferencesTab;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.FileUtils;
import java.awt.Component;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.application.Action;

public class ConnectionsTab
extends UserPreferencesTab {
    private final ManagerDirector managerDirector;
    private boolean updateDefaultConnection = false;
    private JSpinner spinnerMaxConcurrentDownloads;
    private JCheckBox checkUseDefaultConnection;
    private JButton btnSelectConnectionProxy;
    private JCheckBox checkUseProxyList;
    private JTextField fieldProxyListPath;
    private JButton btnProxyListPathSelect;
    private JCheckBox checkUseProxyForPlugin;
    private JButton btnProxyForPluginConfigure;
    private JSpinner spinnerErrorAttemptsCount;
    private JSpinner spinnerAutoReconnectTime;
    private JSpinner spinnerGlobalSpeedSliderMin;
    private JSpinner spinnerGlobalSpeedSliderMax;
    private JSpinner spinnerGlobalSpeedSliderStep;
    private JTextField fieldFileSpeedLimiterValues;

    ConnectionsTab(UserPreferencesDialog dialog, ManagerDirector managerDirector) {
        super(dialog);
        this.managerDirector = managerDirector;
    }

    @Override
    public void init() {
        ValueModel useProxyList = this.bind(this.checkUseProxyList, "useProxyList", (Object)false);
        PropertyConnector.connectAndUpdate(useProxyList, this.fieldProxyListPath, "enabled");
        PropertyConnector.connectAndUpdate(useProxyList, this.actionMap.get("btnSelectProxyListAction"), "enabled");
        String property = AppPrefs.getProperty("proxyListPath", "");
        if (!property.isEmpty()) {
            property = FileUtils.getAbsolutPath(property);
        }
        this.fieldProxyListPath.setText(property);
        this.fieldProxyListPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ConnectionsTab.this.dialog.getModel().setBuffering(true);
            }
        });
        ValueModel useDefault = this.bind(this.checkUseDefaultConnection, "useDefaultConnection", (Object)true);
        PropertyConnector.connectAndUpdate(useDefault, this.actionMap.get("btnSelectConnectionProxy"), "enabled");
        ValueModel useProxyForPlugin = this.bind(this.checkUseProxyForPlugin, "useProxyForPlugin", (Object)false);
        PropertyConnector.connectAndUpdate(useProxyForPlugin, this.actionMap.get("btnProxyForPluginConfigure"), "enabled");
        this.bind(this.spinnerMaxConcurrentDownloads, "maxDownloadsAtATime", 5, 1, 1000000, 1);
        this.bind(this.spinnerErrorAttemptsCount, "errorAttemptsCount", 5, -1, 999, 1);
        this.bind(this.spinnerAutoReconnectTime, "autoReconnectTime", 120, 1, 10000, 10);
        this.bind(this.spinnerGlobalSpeedSliderMin, "globalSpeedMin", 50, 1, Integer.MAX_VALUE, 5);
        this.bind(this.spinnerGlobalSpeedSliderMax, "globalSpeedMax", 250, 1, Integer.MAX_VALUE, 5);
        int intSpeedSliderStepMax = (Integer)this.spinnerGlobalSpeedSliderMax.getValue() - (Integer)this.spinnerGlobalSpeedSliderMin.getValue();
        this.bind(this.spinnerGlobalSpeedSliderStep, "globalSpeedSliderStep", 10, 1, intSpeedSliderStepMax < 1 ? 1 : intSpeedSliderStepMax, 1);
        ChangeListener changeListenerSpeedSlider = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerNumberModel spinnerModel = (SpinnerNumberModel)ConnectionsTab.this.spinnerGlobalSpeedSliderStep.getModel();
                spinnerModel.setMaximum(Integer.valueOf((Integer)ConnectionsTab.this.spinnerGlobalSpeedSliderMax.getValue() - (Integer)ConnectionsTab.this.spinnerGlobalSpeedSliderMin.getValue()));
                if ((Integer)spinnerModel.getMaximum() < 1) {
                    spinnerModel.setMaximum(Integer.valueOf(1));
                }
                if ((Integer)spinnerModel.getMaximum() < (Integer)spinnerModel.getValue()) {
                    spinnerModel.setValue(spinnerModel.getMaximum());
                }
            }
        };
        this.spinnerGlobalSpeedSliderMin.addChangeListener(changeListenerSpeedSlider);
        this.spinnerGlobalSpeedSliderMax.addChangeListener(changeListenerSpeedSlider);
        this.spinnerGlobalSpeedSliderMin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if ((Integer)ConnectionsTab.this.spinnerGlobalSpeedSliderMin.getValue() > (Integer)ConnectionsTab.this.spinnerGlobalSpeedSliderMax.getValue()) {
                    ConnectionsTab.this.spinnerGlobalSpeedSliderMax.setValue(ConnectionsTab.this.spinnerGlobalSpeedSliderMin.getValue());
                }
            }
        });
        this.spinnerGlobalSpeedSliderMax.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if ((Integer)ConnectionsTab.this.spinnerGlobalSpeedSliderMin.getValue() > (Integer)ConnectionsTab.this.spinnerGlobalSpeedSliderMax.getValue()) {
                    ConnectionsTab.this.spinnerGlobalSpeedSliderMin.setValue(ConnectionsTab.this.spinnerGlobalSpeedSliderMax.getValue());
                }
            }
        });
        this.fieldFileSpeedLimiterValues.setText(AppPrefs.getProperty("speedLimitSpeeds", "0,,10,15,20,30,40,50,100,150,200,300"));
        this.fieldFileSpeedLimiterValues.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ConnectionsTab.this.dialog.getModel().setBuffering(true);
            }
        });
        this.setAction(this.btnSelectConnectionProxy, "btnSelectConnectionProxy");
        this.setAction(this.btnProxyListPathSelect, "btnSelectProxyListAction");
        this.setAction(this.btnProxyForPluginConfigure, "btnProxyForPluginConfigure");
    }

    @Action
    public void btnSelectConnectionProxy() {
        ConnectDialog connectDialog = new ConnectDialog(this.dialog);
        MainApp.getInstance(MainApp.class).prepareDialog(connectDialog, true);
        if (connectDialog.getModalResult() == 0) {
            this.dialog.getModel().setBuffering(true);
            this.updateDefaultConnection = true;
        }
    }

    @Action
    public void btnSelectProxyListAction() {
        File[] files = OpenSaveDialogFactory.getInstance(MainApp.getAContext()).getChooseProxyList();
        if (files.length > 0) {
            this.fieldProxyListPath.setText(files[0].getAbsolutePath());
            Swinger.inputFocus(this.fieldProxyListPath);
        }
    }

    @Action
    public void btnProxyForPluginConfigure() {
        ProxyForPluginDialog proxyForPluginDialog = new ProxyForPluginDialog(this.dialog, this.managerDirector);
        MainApp.getInstance(MainApp.class).show(proxyForPluginDialog);
        this.dialog.getModel().setBuffering(true);
    }

    @Override
    public void apply() {
        boolean updateProxyConnectionList = this.isBuffering("useProxyList") || this.isBuffering("proxyListPath") || !AppPrefs.getProperty("proxyListPath", "").equals(this.fieldProxyListPath.getText());
        this.updateDefaultConnection = this.updateDefaultConnection || this.isBuffering("useDefaultConnection");
        AppPrefs.storeProperty("speedLimitSpeeds", this.fieldFileSpeedLimiterValues.getText());
        String property = this.fieldProxyListPath.getText();
        if (!property.isEmpty()) {
            property = FRDUtils.getAbsRelPath(property).getPath();
        }
        AppPrefs.storeProperty("proxyListPath", property);
        AppPrefs.storeProperty("useProxyList", this.checkUseProxyList.isSelected());
        AppPrefs.storeProperty("useDefaultConnection", this.checkUseDefaultConnection.isSelected());
        if (this.updateDefaultConnection || updateProxyConnectionList) {
            this.managerDirector.getClientManager().updateConnectionSettings();
            this.dialog.setUpdateQueue();
        }
    }

    private boolean isBuffering(String property) {
        return this.dialog.getModel().getBufferedModel(property).isBuffering();
    }

    @Override
    public void build(CellConstraints cc) {
        JPanel panelConnections1 = new JPanel();
        JPanel panelProxySettings = new JPanel();
        JPanel panelProxyForPlugin = new JPanel();
        JPanel panelErrorHandling = new JPanel();
        JPanel panelGlobalSpeedLimiter = new JPanel();
        JPanel panelFileSpeedLimiter = new JPanel();
        JLabel labelMaxConcurrentDownloads = new JLabel();
        labelMaxConcurrentDownloads.setName("labelMaxConcurrentDownloads");
        this.spinnerMaxConcurrentDownloads = new JSpinner();
        this.spinnerMaxConcurrentDownloads.setModel(new SpinnerNumberModel(0, 0, 5, 1));
        this.checkUseDefaultConnection = new JCheckBox();
        this.checkUseDefaultConnection.setName("checkUseDefaultConnection");
        this.btnSelectConnectionProxy = new JButton();
        this.btnSelectConnectionProxy.setName("btnSelectConnectionProxy");
        this.checkUseProxyList = new JCheckBox();
        this.checkUseProxyList.setName("checkUseProxyList");
        this.fieldProxyListPath = new JTextField();
        this.btnProxyListPathSelect = new JButton();
        this.btnProxyListPathSelect.setName("btnProxyListPathSelect");
        JLabel labelTextFileFormat = new JLabel();
        labelTextFileFormat.setName("labelTextFileFormat");
        this.checkUseProxyForPlugin = new JCheckBox();
        this.checkUseProxyForPlugin.setName("checkUseProxyForPlugin");
        this.btnProxyForPluginConfigure = new JButton();
        this.btnProxyForPluginConfigure.setName("btnProxyForPluginConfigure");
        JLabel labelErrorAttemptsCount = new JLabel();
        labelErrorAttemptsCount.setName("labelErrorAttemptsCount");
        this.spinnerErrorAttemptsCount = new JSpinner();
        this.spinnerErrorAttemptsCount.setModel(new SpinnerNumberModel(0, 0, 10, 1));
        JLabel labelNoAutoreconnect = new JLabel();
        labelNoAutoreconnect.setName("labelNoAutoreconnect");
        JLabel labelAutoReconnectTime = new JLabel();
        labelAutoReconnectTime.setName("labelAutoReconnectTime");
        this.spinnerAutoReconnectTime = new JSpinner();
        this.spinnerAutoReconnectTime.setModel(new SpinnerNumberModel(0, 0, 1000, 5));
        JLabel labelSeconds = new JLabel();
        labelSeconds.setName("labelSeconds");
        JLabel labelSpeedSliderMinValue = new JLabel();
        labelSpeedSliderMinValue.setName("labelSpeedSliderMinValue");
        JLabel labelSpeedSliderMaxValue = new JLabel();
        labelSpeedSliderMaxValue.setName("labelSpeedSliderMaxValue");
        JLabel labelSpeedSliderStep = new JLabel();
        labelSpeedSliderStep.setName("labelSpeedSliderStep");
        this.spinnerGlobalSpeedSliderMin = new JSpinner();
        this.spinnerGlobalSpeedSliderMin.setModel(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 5));
        this.spinnerGlobalSpeedSliderMax = new JSpinner();
        this.spinnerGlobalSpeedSliderMax.setModel(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 5));
        this.spinnerGlobalSpeedSliderStep = new JSpinner();
        this.spinnerGlobalSpeedSliderStep.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        JLabel labelSpeedSliderKbps1 = new JLabel();
        labelSpeedSliderKbps1.setName("labelSpeedSliderKbps");
        JLabel labelSpeedSliderKbps2 = new JLabel();
        labelSpeedSliderKbps2.setName("labelSpeedSliderKbps");
        JLabel labelSpeedSliderKbps3 = new JLabel();
        labelSpeedSliderKbps3.setName("labelSpeedSliderKbps");
        JLabel labelFileSpeedLimiterValues = new JLabel();
        labelFileSpeedLimiterValues.setName("labelFileSpeedLimiterValues");
        this.fieldFileSpeedLimiterValues = new JTextField();
        this.fieldFileSpeedLimiterValues.setName("fieldFileSpeedLimiterValues");
        JLabel labelFileSpeedLimiterValuesDesc = new JLabel();
        labelFileSpeedLimiterValuesDesc.setName("labelFileSpeedLimiterValuesDesc");
        JLabel labelRequiresRestart = new JLabel();
        labelRequiresRestart.setName("labelRequiresRestart");
        labelRequiresRestart.setVisible(false);
        this.setBorder(Borders.TABBED_DIALOG);
        panelConnections1.setBorder(new TitledBorder(null, this.resourceMap.getString("panelConnections1.border", new Object[0]), 4, 2));
        PanelBuilder panelConnections1Builder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, Sizes.dluX(0), 0.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("max(pref;30dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, Sizes.dluX(0), 1.0)}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.NARROW_LINE_GAP_ROWSPEC}), panelConnections1);
        panelConnections1Builder.add((Component)labelMaxConcurrentDownloads, cc.xy(3, 1));
        panelConnections1Builder.add((Component)this.spinnerMaxConcurrentDownloads, cc.xy(5, 1));
        panelConnections1Builder.add((Component)this.checkUseDefaultConnection, cc.xyw(3, 3, 5));
        panelConnections1Builder.add((Component)this.btnSelectConnectionProxy, cc.xy(9, 3));
        panelProxySettings.setBorder(new TitledBorder(null, this.resourceMap.getString("panelProxySettings.border", new Object[0]), 4, 2));
        PanelBuilder panelProxySettingsBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, Sizes.dluX(0), 0.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.dluX(200), 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.NARROW_LINE_GAP_ROWSPEC}), panelProxySettings);
        panelProxySettingsBuilder.add((Component)this.checkUseProxyList, cc.xy(3, 1));
        panelProxySettingsBuilder.add((Component)this.fieldProxyListPath, cc.xy(5, 1));
        panelProxySettingsBuilder.add((Component)this.btnProxyListPathSelect, cc.xy(7, 1));
        panelProxySettingsBuilder.add((Component)labelTextFileFormat, cc.xy(5, 2));
        panelProxyForPlugin.setBorder(new TitledBorder(null, this.resourceMap.getString("panelProxyForPlugin.border", new Object[0]), 4, 2));
        PanelBuilder panelProxyForPluginBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, Sizes.dluX(0), 0.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.NARROW_LINE_GAP_ROWSPEC}), panelProxyForPlugin);
        panelProxyForPluginBuilder.add((Component)this.checkUseProxyForPlugin, cc.xy(3, 1));
        panelProxyForPluginBuilder.add((Component)this.btnProxyForPluginConfigure, cc.xy(5, 1));
        panelErrorHandling.setBorder(new TitledBorder(null, this.resourceMap.getString("panelErrorHandling.border", new Object[0]), 4, 2));
        PanelBuilder panelErrorHandlingBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, Sizes.dluX(0), 0.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("max(pref;30dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.NARROW_LINE_GAP_ROWSPEC}), panelErrorHandling);
        panelErrorHandlingBuilder.add((Component)labelErrorAttemptsCount, cc.xy(3, 1));
        panelErrorHandlingBuilder.add((Component)this.spinnerErrorAttemptsCount, cc.xy(5, 1));
        panelErrorHandlingBuilder.add((Component)labelNoAutoreconnect, cc.xy(7, 1));
        panelErrorHandlingBuilder.add((Component)labelAutoReconnectTime, cc.xy(3, 3));
        panelErrorHandlingBuilder.add((Component)this.spinnerAutoReconnectTime, cc.xy(5, 3));
        panelErrorHandlingBuilder.add((Component)labelSeconds, cc.xy(7, 3));
        panelGlobalSpeedLimiter.setBorder(new TitledBorder(null, this.resourceMap.getString("panelGlobalSpeedLimiter.border", new Object[0]), 4, 2));
        PanelBuilder panelGlobalSpeedLimiterBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, Sizes.dluX(0), 0.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(40)), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.NARROW_LINE_GAP_ROWSPEC}), panelGlobalSpeedLimiter);
        panelGlobalSpeedLimiterBuilder.add((Component)labelSpeedSliderMinValue, cc.xy(3, 1));
        panelGlobalSpeedLimiterBuilder.add((Component)this.spinnerGlobalSpeedSliderMin, cc.xy(5, 1));
        panelGlobalSpeedLimiterBuilder.add((Component)labelSpeedSliderKbps1, cc.xy(7, 1));
        panelGlobalSpeedLimiterBuilder.add((Component)labelSpeedSliderMaxValue, cc.xy(3, 3));
        panelGlobalSpeedLimiterBuilder.add((Component)this.spinnerGlobalSpeedSliderMax, cc.xy(5, 3));
        panelGlobalSpeedLimiterBuilder.add((Component)labelSpeedSliderKbps2, cc.xy(7, 3));
        panelGlobalSpeedLimiterBuilder.add((Component)labelSpeedSliderStep, cc.xy(3, 5));
        panelGlobalSpeedLimiterBuilder.add((Component)this.spinnerGlobalSpeedSliderStep, cc.xy(5, 5));
        panelGlobalSpeedLimiterBuilder.add((Component)labelSpeedSliderKbps3, cc.xy(7, 5));
        panelFileSpeedLimiter.setBorder(new TitledBorder(null, this.resourceMap.getString("panelFileSpeedLimiter.border", new Object[0]), 4, 2));
        PanelBuilder panelFileSpeedLimiterBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, Sizes.dluX(0), 0.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.NARROW_LINE_GAP_ROWSPEC}), panelFileSpeedLimiter);
        panelFileSpeedLimiterBuilder.add((Component)labelFileSpeedLimiterValues, cc.xy(3, 1));
        panelFileSpeedLimiterBuilder.add((Component)this.fieldFileSpeedLimiterValues, cc.xy(3, 3));
        panelFileSpeedLimiterBuilder.add((Component)labelFileSpeedLimiterValuesDesc, cc.xy(3, 5));
        PanelBuilder thisBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0)}, new RowSpec[]{new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 0.0), FormSpecs.RELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 0.0), FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), this);
        thisBuilder.add((Component)panelConnections1, cc.xyw(1, 1, 3));
        thisBuilder.add((Component)panelProxySettings, cc.xyw(1, 3, 3));
        thisBuilder.add((Component)panelProxyForPlugin, cc.xyw(1, 5, 3));
        thisBuilder.add((Component)panelErrorHandling, cc.xyw(1, 7, 3));
        thisBuilder.add((Component)panelGlobalSpeedLimiter, cc.xyw(1, 9, 1));
        thisBuilder.add((Component)panelFileSpeedLimiter, cc.xyw(3, 9, 1));
        thisBuilder.add((Component)labelRequiresRestart, cc.xyw(1, 11, 3));
    }
}

