/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.userprefs;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.Lng;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.SupportedLanguage;
import cz.vity.freerapid.gui.dialogs.userprefs.LanguageAdapter;
import cz.vity.freerapid.gui.dialogs.userprefs.UserPreferencesDialog;
import cz.vity.freerapid.gui.dialogs.userprefs.UserPreferencesTab;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Utils;
import cz.vity.freerapid.utilities.os.OSCommand;
import cz.vity.freerapid.utilities.os.SystemCommander;
import cz.vity.freerapid.utilities.os.SystemCommanderFactory;
import java.awt.Component;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public class GeneralTab
extends UserPreferencesTab {
    private static final String LNG_PROPERTY = "lngFakeProperty";
    private JCheckBox checkForNewVersion;
    private JCheckBox checkAllowOnlyOneInstance;
    private JCheckBox checkUseHistory;
    private JComboBox comboLng;
    private JButton btnCreateDesktopShortcut;
    private JButton btnCreateStartMenuShortcut;
    private JButton btnCreateQuickLaunchShortcut;
    private JButton btnCreateStartupShortcut;
    private JCheckBox checkForFileExistenceBeforeDownload;
    private JCheckBox checkContinueInterrupted;
    private JCheckBox checkRecheckFilesOnStart;
    private JCheckBox checkProcessFromTop;
    private JCheckBox checkAutoStartDownloadsFromDecrypter;
    private JCheckBox checkEnableDirectDownloads;
    private JCheckBox checkNewLinkCheckDownloadHistory;
    private JCheckBox checkSkipDuplicateFiles;
    private JCheckBox checkAutoShutDownDisabledWhenExecuted;
    private JCheckBox checkPreventStandbyWhileDownloading;
    private JComboBox comboFileExists;
    private JComboBox comboRemoveCompleted;

    GeneralTab(UserPreferencesDialog dialog) {
        super(dialog);
    }

    @Override
    public void init() {
        this.bindLngCombobox();
        this.bind(this.checkAllowOnlyOneInstance, "oneinstance", (Object)true);
        this.bind(this.checkForNewVersion, "checkForNewVersionAuto", (Object)true);
        this.bind(this.checkContinueInterrupted, "downloadOnStart", (Object)true);
        this.bind(this.checkUseHistory, "useHistory", (Object)true);
        this.bind(this.checkAutoShutDownDisabledWhenExecuted, "autoshutdownDisabledWhenExecuted", (Object)true);
        this.bind(this.checkProcessFromTop, "startDownloadFromTheTop", (Object)true);
        this.bind(this.checkAutoStartDownloadsFromDecrypter, "autoStartDownloadsFromDecrypter", (Object)true);
        this.bind(this.checkEnableDirectDownloads, "enableDirectDownloads", (Object)false);
        this.bind(this.checkNewLinkCheckDownloadHistory, "enableNewLinkCheckDownloadHistory", (Object)false);
        this.bind(this.checkSkipDuplicateFiles, "skipDuplicateFiles", (Object)false);
        this.bind(this.checkForFileExistenceBeforeDownload, "testFiles", (Object)true);
        this.bind(this.checkRecheckFilesOnStart, "recheckFilesOnStart", (Object)false);
        this.bind(this.checkPreventStandbyWhileDownloading, "preventStandbyWhileDownloading", (Object)false);
        this.bind(this.comboFileExists, "whatToDoIfFileAlreadyExists", 3, "fileAlreadyExistsOptions", 4);
        this.bind(this.comboRemoveCompleted, "removeCompletedDownloads", 0, "removeCompletedOptions", 3);
        this.setAction(this.btnCreateDesktopShortcut, "createDesktopShortcut");
        this.setAction(this.btnCreateQuickLaunchShortcut, "createQuickLaunchShortcut");
        this.setAction(this.btnCreateStartMenuShortcut, "createStartMenuShortcut");
        this.setAction(this.btnCreateStartupShortcut, "createStartupShortcut");
    }

    private void bindLngCombobox() {
        List<SupportedLanguage> languageList = Lng.getSupportedLanguages();
        Collections.sort(languageList);
        ArrayListModel<SupportedLanguage> listModel = new ArrayListModel<SupportedLanguage>(languageList);
        LanguageAdapter adapter = new LanguageAdapter(LNG_PROPERTY, Lng.getSelectedLanguage());
        SelectionInList inList = new SelectionInList(listModel, (ValueModel)this.dialog.getModel().getBufferedModel(adapter));
        Bindings.bind(this.comboLng, inList);
        this.comboLng.setRenderer(new LanguageComboCellRenderer(this.dialog.getApp().getContext().getResourceMap().getResourcesDir(), this.resourceMap));
    }

    @Action
    public void createDesktopShortcut() {
        this.createShortcut(OSCommand.CREATE_DESKTOP_SHORTCUT);
    }

    @Action
    public void createStartMenuShortcut() {
        this.createShortcut(OSCommand.CREATE_STARTMENU_SHORTCUT);
    }

    @Action
    public void createStartupShortcut() {
        this.createShortcut(OSCommand.CREATE_STARTUP_SHORTCUT);
    }

    @Action
    public void createQuickLaunchShortcut() {
        this.createShortcut(OSCommand.CREATE_QUICKLAUNCH_SHORTCUT);
    }

    private void createShortcut(OSCommand command) {
        ApplicationContext context = MainApp.getAContext();
        SystemCommander utils = SystemCommanderFactory.getInstance().getSystemCommanderInstance(context);
        if (utils.isSupported(command)) {
            boolean result = utils.createShortCut(command);
            if (!result) {
                Swinger.showErrorMessage(this.resourceMap, "createShortCutFailed", new Object[0]);
            }
        } else {
            Swinger.showErrorMessage(context.getResourceMap(), "systemCommandNotSupported", command.toString().toLowerCase());
        }
    }

    @Override
    public void apply() {
        SupportedLanguage lng = Lng.getSelectedLanguage();
        if (!lng.equals(this.comboLng.getSelectedItem())) {
            AppPrefs.storeProperty("selLanguage", ((SupportedLanguage)this.comboLng.getSelectedItem()).getLanguageCode());
            AppPrefs.storeProperty("country", ((SupportedLanguage)this.comboLng.getSelectedItem()).getCountry());
            Swinger.showInformationDialog(this.resourceMap.getString("changeLanguageAfterRestart", new Object[0]));
        }
        AppPrefs.removeProperty(LNG_PROPERTY);
    }

    @Override
    public void cancel() {
        AppPrefs.removeProperty(LNG_PROPERTY);
    }

    @Override
    public void build(CellConstraints cc) {
        JPanel panelApplicationSettings = new JPanel();
        JPanel panelShortcutsSettings = new JPanel();
        JPanel panelDownloadsSettings = new JPanel();
        this.checkForNewVersion = new JCheckBox();
        this.checkForNewVersion.setName("checkForNewVersion");
        this.checkAllowOnlyOneInstance = new JCheckBox();
        this.checkAllowOnlyOneInstance.setName("checkAllowOnlyOneInstance");
        this.checkUseHistory = new JCheckBox();
        this.checkUseHistory.setName("checkUseHistory");
        this.comboLng = new JComboBox();
        this.comboLng.setName("comboLng");
        JLabel labelLanguage = new JLabel();
        labelLanguage.setName("language");
        labelLanguage.setLabelFor(this.comboLng);
        this.btnCreateDesktopShortcut = new JButton();
        this.btnCreateStartMenuShortcut = new JButton();
        this.btnCreateQuickLaunchShortcut = new JButton();
        this.btnCreateStartupShortcut = new JButton();
        this.checkForFileExistenceBeforeDownload = new JCheckBox();
        this.checkForFileExistenceBeforeDownload.setName("checkForFileExistenceBeforeDownload");
        this.checkContinueInterrupted = new JCheckBox();
        this.checkContinueInterrupted.setName("checkContinueInterrupted");
        this.checkRecheckFilesOnStart = new JCheckBox();
        this.checkRecheckFilesOnStart.setName("checkRecheckFilesOnStart");
        this.checkProcessFromTop = new JCheckBox();
        this.checkProcessFromTop.setName("checkProcessFromTop");
        this.checkAutoStartDownloadsFromDecrypter = new JCheckBox();
        this.checkAutoStartDownloadsFromDecrypter.setName("checkAutoStartDownloadsFromDecrypter");
        this.checkEnableDirectDownloads = new JCheckBox();
        this.checkEnableDirectDownloads.setName("checkEnableDirectDownloads");
        this.checkNewLinkCheckDownloadHistory = new JCheckBox();
        this.checkNewLinkCheckDownloadHistory.setName("checkNewLinkCheckDownloadHistory");
        this.checkSkipDuplicateFiles = new JCheckBox();
        this.checkSkipDuplicateFiles.setName("checkSkipDuplicateFiles");
        this.checkAutoShutDownDisabledWhenExecuted = new JCheckBox();
        this.checkAutoShutDownDisabledWhenExecuted.setName("checkAutoShutDownDisabledWhenExecuted");
        this.checkPreventStandbyWhileDownloading = new JCheckBox();
        this.checkPreventStandbyWhileDownloading.setName("checkPreventStandbyWhileDownloading");
        this.checkPreventStandbyWhileDownloading.setEnabled(Utils.isWindows());
        JLabel labelIfFilenameExists = new JLabel();
        labelIfFilenameExists.setName("labelIfFilenameExists");
        this.comboFileExists = new JComboBox();
        this.comboRemoveCompleted = new JComboBox();
        this.comboRemoveCompleted.setName("comboRemoveCompleted");
        JLabel labelRemoveCompleted = new JLabel();
        labelRemoveCompleted.setLabelFor(this.comboRemoveCompleted);
        labelRemoveCompleted.setName("labelRemoveCompleted");
        this.setBorder(Borders.TABBED_DIALOG);
        panelApplicationSettings.setBorder(new TitledBorder(null, this.resourceMap.getString("panelApplicationSettings.border", new Object[0]), 4, 2));
        PanelBuilder panelApplicationSettingsBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, Sizes.dluX(0), 0.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("max(default;70dlu)"), new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), panelApplicationSettings);
        panelApplicationSettingsBuilder.add((Component)this.checkForNewVersion, cc.xyw(3, 1, 4));
        panelApplicationSettingsBuilder.add((Component)this.checkAllowOnlyOneInstance, cc.xyw(3, 3, 4));
        panelApplicationSettingsBuilder.add((Component)this.checkUseHistory, cc.xyw(3, 5, 4));
        panelApplicationSettingsBuilder.add((Component)labelLanguage, cc.xyw(3, 7, 1));
        panelApplicationSettingsBuilder.add((Component)this.comboLng, cc.xyw(5, 7, 1));
        panelShortcutsSettings.setBorder(new TitledBorder(null, this.resourceMap.getString("panelShortcutsSettings.border", new Object[0]), 4, 2));
        panelApplicationSettingsBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("max(pref;30dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC}), panelShortcutsSettings);
        panelApplicationSettingsBuilder.add((Component)this.btnCreateDesktopShortcut, cc.xy(2, 1));
        panelApplicationSettingsBuilder.add((Component)this.btnCreateStartMenuShortcut, cc.xy(2, 3));
        panelApplicationSettingsBuilder.add((Component)this.btnCreateQuickLaunchShortcut, cc.xy(2, 5));
        panelApplicationSettingsBuilder.add((Component)this.btnCreateStartupShortcut, cc.xy(2, 7));
        panelDownloadsSettings.setBorder(new TitledBorder(null, this.resourceMap.getString("panelDownloadsSettings.border", new Object[0]), 4, 2));
        PanelBuilder panelDownloadsSettingsBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, Sizes.dluX(0), 0.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC}), panelDownloadsSettings);
        panelDownloadsSettingsBuilder.add((Component)this.checkForFileExistenceBeforeDownload, cc.xywh(3, 1, 7, 1));
        panelDownloadsSettingsBuilder.add((Component)this.checkContinueInterrupted, cc.xywh(3, 2, 7, 1));
        panelDownloadsSettingsBuilder.add((Component)this.checkRecheckFilesOnStart, cc.xywh(3, 3, 7, 1));
        panelDownloadsSettingsBuilder.add((Component)this.checkProcessFromTop, cc.xywh(3, 4, 7, 1));
        panelDownloadsSettingsBuilder.add((Component)this.checkAutoStartDownloadsFromDecrypter, cc.xywh(3, 5, 7, 1));
        panelDownloadsSettingsBuilder.add((Component)this.checkEnableDirectDownloads, cc.xywh(3, 6, 7, 1));
        panelDownloadsSettingsBuilder.add((Component)this.checkNewLinkCheckDownloadHistory, cc.xywh(3, 7, 7, 1));
        panelDownloadsSettingsBuilder.add((Component)this.checkSkipDuplicateFiles, cc.xywh(3, 8, 7, 1));
        panelDownloadsSettingsBuilder.add((Component)this.checkAutoShutDownDisabledWhenExecuted, cc.xywh(3, 9, 7, 1));
        panelDownloadsSettingsBuilder.add((Component)this.checkPreventStandbyWhileDownloading, cc.xywh(3, 10, 7, 1));
        panelDownloadsSettingsBuilder.add((Component)labelIfFilenameExists, cc.xywh(3, 12, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        panelDownloadsSettingsBuilder.add((Component)this.comboFileExists, cc.xy(5, 12));
        panelDownloadsSettingsBuilder.add((Component)labelRemoveCompleted, cc.xywh(7, 12, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        panelDownloadsSettingsBuilder.add((Component)this.comboRemoveCompleted, cc.xy(9, 12));
        PanelBuilder thisBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 0.0), FormSpecs.RELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 0.0), FormSpecs.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 1.0)}), this);
        thisBuilder.add((Component)panelApplicationSettings, cc.xy(1, 1));
        thisBuilder.add((Component)panelShortcutsSettings, cc.xy(3, 1));
        thisBuilder.add((Component)panelDownloadsSettings, cc.xyw(1, 3, 3));
    }

    private static final class LanguageComboCellRenderer
    extends DefaultListCellRenderer {
        private String path;
        private ResourceMap map;

        private LanguageComboCellRenderer(String resourceDir, ResourceMap map) {
            this.map = map;
            this.path = (resourceDir + map.getString("flagsPath", new Object[0])).trim();
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                value = list.getModel().getElementAt(index);
            }
            SupportedLanguage lng = (SupportedLanguage)value;
            assert (lng != null);
            String s = lng.getIcon();
            if (s == null) {
                s = this.map.getString("blank.gif", new Object[0]);
            }
            URL resource = this.map.getClassLoader().getResource(this.path + s);
            Component component = super.getListCellRendererComponent((JList<?>)list, lng.getName(), index, isSelected, cellHasFocus);
            if (resource != null) {
                this.setIcon(new ImageIcon(resource));
            }
            this.getAccessibleContext().setAccessibleDescription(lng.getName());
            return component;
        }
    }
}

