/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.userprefs;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.gui.dialogs.userprefs.LookAndFeelAdapter;
import cz.vity.freerapid.gui.dialogs.userprefs.UserPreferencesDialog;
import cz.vity.freerapid.gui.dialogs.userprefs.UserPreferencesTab;
import cz.vity.freerapid.swing.LaF;
import cz.vity.freerapid.swing.LookAndFeels;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.application.Action;

public class ViewsTab
extends UserPreferencesTab {
    private static final Logger logger = Logger.getLogger(ViewsTab.class.getName());
    private static final String LAF_PROPERTY = "lafFakeProperty";
    private LaF backupLaF;
    private JComboBox comboLaF;
    private JButton btnApplyLookAndFeel;
    private JCheckBox checkDecoratedFrames;
    private JCheckBox checkShowHorizontalLinesInTable;
    private JCheckBox checkShowVerticalLinesInTable;
    private JCheckBox checkShowTitle;
    private JCheckBox checkShowToolbarText;
    private JCheckBox checkServiceAsIconOnly;
    private JCheckBox checkSlimLinesInHistory;
    private JCheckBox checkBringToFrontWhenPasted;
    private JCheckBox checkZoomCaptchaImage;
    private JCheckBox checkShowIconInSystemTray;
    private JCheckBox checkAnimateIcon;
    private JCheckBox checkCloseToTray;
    private JCheckBox checkHideWhenMinimized;
    private JCheckBox checkShowProgressBarProgress;

    ViewsTab(UserPreferencesDialog dialog) {
        super(dialog);
    }

    @Override
    public void init() {
        this.backupLaF = LookAndFeels.getInstance().getSelectedLaF();
        this.bindLaFCombobox();
        this.bind(this.checkDecoratedFrames, "decoratedFrames", (Object)false);
        this.bind(this.checkHideWhenMinimized, "minimizeToTray", (Object)false);
        this.bind(this.checkAnimateIcon, "animateIcon", (Object)true);
        this.bind(this.checkShowTitle, "showInfoInFrameTitle", (Object)false);
        this.bind(this.checkShowHorizontalLinesInTable, "showHorizontalGridLines", (Object)false);
        this.bind(this.checkShowVerticalLinesInTable, "showVerticalGridLines", (Object)false);
        this.bind(this.checkServiceAsIconOnly, "showServicesAsIcons", (Object)true);
        this.bind(this.checkSlimLinesInHistory, "historySlimLines", (Object)false);
        this.bind(this.checkBringToFrontWhenPasted, "bringToFrontWhenPasted", (Object)true);
        this.bind(this.checkZoomCaptchaImage, "zoomCaptchaImage", (Object)false);
        this.bind(this.checkCloseToTray, "minimizeOnClose", (Object)false);
        this.bind(this.checkShowToolbarText, "showButtonTextToolbar", (Object)true);
        this.bind(this.checkShowProgressBarProgress, "showPercentProgress", (Object)false);
        ValueModel valueModel = this.bind(this.checkShowIconInSystemTray, "showTray", (Object)true);
        PropertyConnector.connectAndUpdate(valueModel, this.checkAnimateIcon, "enabled");
        PropertyConnector.connectAndUpdate(valueModel, this.checkCloseToTray, "enabled");
        PropertyConnector.connectAndUpdate(valueModel, this.checkHideWhenMinimized, "enabled");
        this.setAction(this.btnApplyLookAndFeel, "applyLookAndFeelAction");
    }

    private void bindLaFCombobox() {
        LookAndFeels lafs = LookAndFeels.getInstance();
        ArrayListModel<LaF> listModel = new ArrayListModel<LaF>(lafs.getAvailableLookAndFeels());
        LookAndFeelAdapter adapter = new LookAndFeelAdapter(LAF_PROPERTY, lafs.getSelectedLaF());
        SelectionInList inList = new SelectionInList(listModel, (ValueModel)this.dialog.getModel().getBufferedModel(adapter));
        Bindings.bind(this.comboLaF, inList);
    }

    @Action
    public void applyLookAndFeelAction() {
        LaF laf = (LaF)this.comboLaF.getSelectedItem();
        this.applyLookAndFeel(laf);
    }

    private void applyLookAndFeel(LaF laf) {
        LaF selectedLaF = LookAndFeels.getInstance().getSelectedLaF();
        if (laf != null && !selectedLaF.equals((Object)laf)) {
            this.updateLookAndFeel(laf);
        }
    }

    private void updateLookAndFeel(LaF laf) {
        boolean successful;
        try {
            LookAndFeels lafManager = LookAndFeels.getInstance();
            successful = lafManager.loadLookAndFeel(laf, true);
            lafManager.storeSelectedLaF(laf);
        }
        catch (Exception ex) {
            LogUtils.processException(logger, ex);
            Swinger.showErrorDialog(this.resourceMap, "changeLookAndFeelActionFailed", (Throwable)ex);
            successful = false;
        }
        if (successful) {
            Swinger.showInformationDialog(this.resourceMap.getString("message_changeLookAndFeelActionSet", new Object[0]));
        }
    }

    @Override
    public void apply() {
        this.applyLookAndFeelAction();
        AppPrefs.removeProperty(LAF_PROPERTY);
    }

    @Override
    public void cancel() {
        this.applyLookAndFeel(this.backupLaF);
        AppPrefs.removeProperty(LAF_PROPERTY);
    }

    @Override
    public void build(CellConstraints cc) {
        JPanel panelAppearance = new JPanel();
        JPanel panelSystemTray = new JPanel();
        JPanel panelToolbarEditor = new JPanel();
        this.comboLaF = new JComboBox();
        JLabel labelLaF = new JLabel();
        labelLaF.setName("labelLaF");
        labelLaF.setLabelFor(this.comboLaF);
        this.btnApplyLookAndFeel = new JButton();
        this.btnApplyLookAndFeel.setName("btnApplyLookAndFeel");
        JLabel labelRequiresRestart2 = new JLabel();
        labelRequiresRestart2.setName("labelRequiresRestart2");
        this.checkDecoratedFrames = new JCheckBox();
        this.checkDecoratedFrames.setName("checkDecoratedFrames");
        this.checkShowHorizontalLinesInTable = new JCheckBox();
        this.checkShowHorizontalLinesInTable.setName("checkShowHorizontalLinesInTable");
        this.checkShowVerticalLinesInTable = new JCheckBox();
        this.checkShowVerticalLinesInTable.setName("checkShowVerticalLinesInTable");
        this.checkShowTitle = new JCheckBox();
        this.checkShowTitle.setName("checkShowTitle");
        this.checkShowToolbarText = new JCheckBox();
        this.checkShowToolbarText.setName("checkShowToolbarText");
        this.checkServiceAsIconOnly = new JCheckBox();
        this.checkServiceAsIconOnly.setName("checkServiceAsIconOnly");
        this.checkSlimLinesInHistory = new JCheckBox();
        this.checkSlimLinesInHistory.setName("checkSlimLinesInHistory");
        this.checkBringToFrontWhenPasted = new JCheckBox();
        this.checkBringToFrontWhenPasted.setName("checkBringToFrontWhenPasted");
        this.checkZoomCaptchaImage = new JCheckBox();
        this.checkZoomCaptchaImage.setName("checkZoomCaptchaImage");
        this.checkShowProgressBarProgress = new JCheckBox();
        this.checkShowProgressBarProgress.setName("checkShowProgressBarProgress");
        this.checkShowIconInSystemTray = new JCheckBox();
        this.checkShowIconInSystemTray.setName("checkShowIconInSystemTray");
        this.checkAnimateIcon = new JCheckBox();
        this.checkAnimateIcon.setName("checkAnimateIcon");
        this.checkCloseToTray = new JCheckBox();
        this.checkCloseToTray.setName("checkCloseToTray");
        this.checkHideWhenMinimized = new JCheckBox();
        this.checkHideWhenMinimized.setName("checkHideWhenMinimized");
        this.setBorder(Borders.TABBED_DIALOG);
        panelAppearance.setBorder(new CompoundBorder(new TitledBorder(null, this.resourceMap.getString("panelAppearance.border", new Object[0]), 4, 2), Borders.DLU2));
        PanelBuilder panelAppearanceBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, Sizes.dluX(0), 0.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.PREF_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.PREF_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.PREF_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), panelAppearance);
        panelAppearanceBuilder.add((Component)labelLaF, cc.xy(3, 1));
        panelAppearanceBuilder.add((Component)this.comboLaF, cc.xy(5, 1));
        panelAppearanceBuilder.add((Component)this.btnApplyLookAndFeel, cc.xy(7, 1));
        panelAppearanceBuilder.add((Component)labelRequiresRestart2, cc.xy(9, 1));
        panelAppearanceBuilder.add((Component)this.checkDecoratedFrames, cc.xywh(3, 2, 7, 1));
        panelAppearanceBuilder.add((Component)this.checkShowHorizontalLinesInTable, cc.xywh(3, 5, 7, 1));
        panelAppearanceBuilder.add((Component)this.checkShowVerticalLinesInTable, cc.xywh(3, 6, 7, 1));
        panelAppearanceBuilder.add((Component)this.checkShowTitle, cc.xywh(3, 7, 7, 1));
        panelAppearanceBuilder.add((Component)this.checkShowToolbarText, cc.xywh(3, 8, 7, 1));
        panelAppearanceBuilder.add((Component)this.checkServiceAsIconOnly, cc.xywh(3, 9, 7, 1));
        panelAppearanceBuilder.add((Component)this.checkSlimLinesInHistory, cc.xywh(3, 10, 7, 1));
        panelAppearanceBuilder.add((Component)this.checkBringToFrontWhenPasted, cc.xywh(3, 11, 7, 1));
        panelAppearanceBuilder.add((Component)this.checkZoomCaptchaImage, cc.xywh(3, 12, 7, 1));
        panelAppearanceBuilder.add((Component)this.checkShowProgressBarProgress, cc.xywh(3, 13, 7, 1));
        panelSystemTray.setBorder(new CompoundBorder(new TitledBorder(null, this.resourceMap.getString("panelSystemTray.border", new Object[0]), 4, 2), Borders.DLU2));
        PanelBuilder panelSystemTrayBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, Sizes.dluX(0), 0.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.PREF_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), panelSystemTray);
        panelSystemTrayBuilder.add((Component)this.checkShowIconInSystemTray, cc.xy(3, 1));
        panelSystemTrayBuilder.add((Component)this.checkAnimateIcon, cc.xy(5, 1));
        panelSystemTrayBuilder.add((Component)this.checkCloseToTray, cc.xy(3, 2));
        panelSystemTrayBuilder.add((Component)this.checkHideWhenMinimized, cc.xy(5, 2));
        JButton toolbarEditorButton = new JButton(MainApp.getAContext().getActionMap().get("showToolbarEditorAction"));
        panelToolbarEditor.add(toolbarEditorButton);
        PanelBuilder thisBuilder = new PanelBuilder(new FormLayout(ColumnSpec.decodeSpecs("default:grow"), new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, Sizes.DEFAULT, 1.0)}), this);
        thisBuilder.add((Component)panelAppearance, cc.xy(1, 1));
        thisBuilder.add((Component)panelSystemTray, cc.xy(1, 3));
        thisBuilder.add((Component)panelToolbarEditor, cc.xy(1, 5));
    }
}

