/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.DelayedReadValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.actions.URLTransferHandler;
import cz.vity.freerapid.gui.managers.FileListMaintainer;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.gui.managers.ProcessManager;
import cz.vity.freerapid.gui.managers.StateChangeEvent;
import cz.vity.freerapid.gui.managers.exceptions.NotSupportedDownloadServiceException;
import cz.vity.freerapid.gui.managers.interfaces.FileStateChangeListener;
import cz.vity.freerapid.gui.managers.interfaces.UrlListDataListener;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.container.FileInfo;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.FileState;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFile;
import cz.vity.freerapid.plugins.webclient.interfaces.MaintainQueueSupport;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.commons.httpclient.URIException;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;

public class DataManager
extends AbstractBean
implements PropertyChangeListener,
ListDataListener,
MaintainQueueSupport {
    private static final Logger logger = Logger.getLogger(DataManager.class.getName());
    private static final String DATA_CHANGED_PROPERTY = "dataChanged";
    private final ArrayListModel<DownloadFile> downloadFiles = new ArrayListModel();
    private final Set<DownloadFile> changedFiles = Collections.synchronizedSet(new HashSet());
    private ProcessManager processManager;
    private final ManagerDirector director;
    private final ApplicationContext context;
    private final Object lock = new Object();
    private int completed;
    private int notFound;
    private PluginsManager pluginsManager;
    private int dataChanged = 0;
    private FileListMaintainer fileListMaintainer;
    private boolean optimizeSavingList;
    private EventListenerList listenerList = new EventListenerList();

    public DataManager(ManagerDirector director, ApplicationContext context) {
        this.director = director;
        this.context = context;
        this.fileListMaintainer = new FileListMaintainer(context, director, this);
        this.pluginsManager = director.getPluginsManager();
        this.optimizeSavingList = AppPrefs.getProperty("optimizeSavingList", false);
        context.getApplication().addExitListener(new Application.ExitListener(){

            @Override
            public boolean canExit(EventObject event) {
                if (AppPrefs.getProperty("minimizeOnClose", false) && event instanceof WindowEvent) {
                    return true;
                }
                boolean confirmExiting = AppPrefs.getProperty("confirmExit", true);
                if (confirmExiting && DataManager.this.isDownloading()) {
                    int result = Swinger.getChoiceOKCancel("downloadInProgress", new Object[0]);
                    return result == 0;
                }
                return true;
            }

            @Override
            public void willExit(EventObject event) {
                DataManager.this.exitDownloading();
                DataManager.this.updateChangedFilesInDatabase();
                DataManager.this.fileListMaintainer.doShutDown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitDownloading() {
        boolean foundRunning = false;
        this.processManager.interrupt();
        Object object = this.lock;
        synchronized (object) {
            for (DownloadFile file : this.downloadFiles) {
                DownloadTask task = file.getTask();
                if (task == null || task.isTerminated()) continue;
                file.setState(DownloadState.PAUSED);
                task.cancel(true);
                foundRunning = true;
                if (AppPrefs.getProperty("downloadOnStart", true)) {
                    file.setState(DownloadState.QUEUED);
                    continue;
                }
                file.setState(DownloadState.PAUSED);
            }
        }
        if (foundRunning) {
            try {
                Thread.sleep(700L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void addFileStateChangedListener(FileStateChangeListener listener) {
        this.listenerList.add(FileStateChangeListener.class, listener);
    }

    public void removeFileStateChangedListener(FileStateChangeListener listener) {
        this.listenerList.remove(FileStateChangeListener.class, listener);
    }

    private void saveListToBeanImmediately() {
        this.fileListMaintainer.saveToDatabase(this.downloadFiles);
    }

    public void initProcessManagerInstance() {
        this.processManager = new ProcessManager(this.director, this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initProcessManagerQueue() {
        Object object = this.lock;
        synchronized (object) {
            this.fileListMaintainer.loadListToBean(this.downloadFiles);
        }
        this.updateCompleted();
        this.downloadFiles.addListDataListener(this);
        this.processManager.start();
        if (AppPrefs.getProperty("autosaveEnabled", true)) {
            PropertyAdapter<DataManager> adapter = new PropertyAdapter<DataManager>(this, DATA_CHANGED_PROPERTY, true);
            int time = AppPrefs.getProperty("autosaveTime", 10);
            DelayedReadValueModel delayedReadValueModel = new DelayedReadValueModel(adapter, time * 1000, false);
            delayedReadValueModel.addValueChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DataManager.this.updateChangedFilesInDatabase();
                }
            });
        }
        this.addPropertyChangeListener("state", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == DownloadState.COMPLETED && AppPrefs.getProperty("removeCompletedDownloads", 0) == 1) {
                    DataManager.this.removeCompleted();
                }
            }
        });
    }

    private void updateChangedFilesInDatabase() {
        if (!this.changedFiles.isEmpty()) {
            ArrayList<DownloadFile> updateFiles = new ArrayList<DownloadFile>(this.changedFiles);
            this.changedFiles.clear();
            this.fileListMaintainer.saveToDatabaseOnBackground(updateFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(List<DownloadFile> files) {
        Object object = this.lock;
        synchronized (object) {
            for (DownloadFile f : files) {
                f.setState(DownloadState.QUEUED);
            }
        }
        this.processManager.queueUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToList(List<DownloadFile> files) {
        Object object = this.lock;
        synchronized (object) {
            this.addOnList(files);
        }
        this.fireUrlsAdded(files);
    }

    private void addOnList(List<DownloadFile> files) {
        boolean startFromTop = AppPrefs.getProperty("startDownloadFromTheTop", true);
        Date insertDate = new Date();
        int counter = this.downloadFiles.size();
        for (DownloadFile file : files) {
            file.setListOrder(counter++);
            file.setDateInserted(insertDate);
            try {
                file.setPluginID(this.pluginsManager.getServiceIDForURL(file.getFileUrl()));
            }
            catch (NotSupportedDownloadServiceException e) {
                file.setState(DownloadState.ERROR);
                file.setErrorMessage(Swinger.getMessageFromException(Swinger.getResourceMap(), e));
            }
            file.addPropertyChangeListener(this);
        }
        if (startFromTop) {
            this.downloadFiles.addAll(files);
            this.fileListMaintainer.saveToDatabaseOnBackground(files);
        } else {
            this.downloadFiles.addAll(0, files);
            this.fileListMaintainer.saveToDatabaseOnBackground(files);
            this.reOrderListProperty();
        }
    }

    public void addUrlListDataListener(UrlListDataListener l) {
        this.listenerList.add(UrlListDataListener.class, l);
    }

    private void fireUrlsAdded(List<DownloadFile> list) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != UrlListDataListener.class) continue;
            ((UrlListDataListener)listeners[i + 1]).linksAdded(list);
        }
    }

    private void fireFileStateChanged(DownloadFile file, DownloadState oldState, DownloadState newState) {
        Object[] listeners = this.listenerList.getListenerList();
        StateChangeEvent event = new StateChangeEvent(file, oldState, newState);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FileStateChangeListener.class) continue;
            ((FileStateChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public ArrayListModel<DownloadFile> getDownloadFiles() {
        return this.downloadFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadFile> getActualDownloadFiles() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableList(new ArrayList<DownloadFile>(this.downloadFiles));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadFile> getDownloadFilesInStates(EnumSet<DownloadState> states) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<DownloadFile> list = new ArrayList<DownloadFile>();
            for (DownloadFile file : this.downloadFiles) {
                if (!states.contains((Object)file.getState())) continue;
                list.add(file);
            }
            return Collections.unmodifiableList(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadFile> setDownloadFilesState(DownloadState oldState, DownloadState newState) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<DownloadFile> list = new ArrayList<DownloadFile>();
            for (DownloadFile file : this.downloadFiles) {
                if (file.getState() != oldState) continue;
                list.add(file);
            }
            for (DownloadFile downloadFile : list) {
                downloadFile.setState(newState);
            }
            return Collections.unmodifiableList(list);
        }
    }

    private int getIndex(DownloadFile file) {
        return this.downloadFiles.indexOf(file);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        final String s = evt.getPropertyName();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadFile downloadFile = (DownloadFile)evt.getSource();
                if (!"listOrder".equals(s)) {
                    DataManager.this.downloadFiles.fireContentsChanged(DataManager.this.getIndex(downloadFile));
                }
                if (downloadFile.getState() != DownloadState.DELETED) {
                    DataManager.this.changedFiles.add(downloadFile);
                }
                if ("state".equals(s) || !DataManager.this.optimizeSavingList && "downloaded".equals(s)) {
                    DataManager.this.firePropertyChange(s, evt.getOldValue(), evt.getNewValue());
                    DataManager.this.fireDataChanged();
                }
                if ("listOrder".equals(s)) {
                    DataManager.this.fireDataChanged();
                } else if ("state".equals(s)) {
                    DataManager.this.fireFileStateChanged(downloadFile, (DownloadState)((Object)evt.getOldValue()), (DownloadState)((Object)evt.getNewValue()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDownloadFilesStates(int[] indexes, EnumSet<DownloadState> states) {
        Object object = this.lock;
        synchronized (object) {
            if (indexes.length == 0) {
                return false;
            }
            for (int index : indexes) {
                DownloadFile file = (DownloadFile)this.downloadFiles.get(index);
                DownloadState s = file.getState();
                if (states.contains((Object)s)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyDownloadFilesStates(int[] indexes, EnumSet<DownloadState> states) {
        Object object = this.lock;
        synchronized (object) {
            if (indexes.length == 0) {
                return false;
            }
            for (int index : indexes) {
                DownloadFile file = (DownloadFile)this.downloadFiles.get(index);
                DownloadState s = file.getState();
                if (!states.contains((Object)s)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelected(List<DownloadFile> fileList) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<DownloadFile> toRemoveList = new ArrayList<DownloadFile>();
            for (DownloadFile downloadFile : fileList) {
                downloadFile.setState(DownloadState.DELETED);
                toRemoveList.add(downloadFile);
            }
            this.removeFromList(toRemoveList);
            for (DownloadFile file : toRemoveList) {
                DownloadTask task = file.getTask();
                if (task != null && !task.isTerminated()) {
                    task.cancel(true);
                }
                file.removePropertyChangeListener(this);
            }
        }
        this.processManager.queueUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeSelected(int[] indexes) {
        Object object = this.lock;
        synchronized (object) {
            List<DownloadFile> files = this.selectionToList(indexes);
            LinkedList<DownloadFile> resumingFiles = new LinkedList<DownloadFile>();
            for (DownloadFile file : files) {
                if (!DownloadsActions.resumeEnabledStates.contains((Object)file.getState())) continue;
                file.resetErrorAttempts();
                resumingFiles.add(file);
            }
            this.addToQueue(resumingFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSelected(int[] indexes, boolean delete) {
        Object object = this.lock;
        synchronized (object) {
            List<DownloadFile> toRemoveList = this.selectionToList(indexes);
            for (DownloadFile file : toRemoveList) {
                if (!DownloadsActions.cancelEnabledStates.contains((Object)file.getState())) continue;
                DownloadTask task = file.getTask();
                if (task != null && !task.isTerminated()) {
                    task.cancel(true);
                }
                file.setState(DownloadState.CANCELLED);
                if (delete && file.getDownloaded() > 0L) {
                    File outputFile = file.getStoreFile();
                    if (outputFile != null && outputFile.exists()) {
                        FileUtils.deleteFileWithRecycleBin(outputFile);
                    }
                    if ((outputFile = file.getOutputFile()) != null && outputFile.exists()) {
                        FileUtils.deleteFileWithRecycleBin(outputFile);
                    }
                }
                file.setDownloaded(0L);
            }
        }
        this.processManager.queueUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryAllError() {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<DownloadFile> resumingFiles = new LinkedList<DownloadFile>();
            for (DownloadFile file : this.downloadFiles) {
                if (file.getState() != DownloadState.ERROR) continue;
                file.resetErrorAttempts();
                resumingFiles.add(file);
            }
            this.addToQueue(resumingFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadFile> getSelectionToList(int[] indexes) {
        Object object = this.lock;
        synchronized (object) {
            return this.selectionToList(indexes);
        }
    }

    @Override
    public boolean addLinksToQueue(HttpFile parentFile, String data) {
        List<URL> urlList = URLTransferHandler.textURIListToFileList(data, this.pluginsManager, false);
        LinkedList<URI> uriList = new LinkedList<URI>();
        for (URL url : urlList) {
            try {
                uriList.add(Utils.convertToURI(url.toExternalForm()));
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (URIException uRIException) {}
        }
        return !uriList.isEmpty() && this.addLinksToQueue(parentFile, uriList);
    }

    private List<DownloadFile> selectionToList(int[] indexes) {
        ArrayList<DownloadFile> toRemoveList = new ArrayList<DownloadFile>();
        for (int index : indexes) {
            toRemoveList.add((DownloadFile)this.downloadFiles.get(index));
        }
        return toRemoveList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSelected(int[] indexes) {
        Object object = this.lock;
        synchronized (object) {
            List<DownloadFile> toRemoveList = this.selectionToList(indexes);
            for (DownloadFile file : toRemoveList) {
                DownloadState state = file.getState();
                if (!DownloadsActions.pauseEnabledStates.contains((Object)state) && (state != DownloadState.DOWNLOADING || !file.isResumeSupported())) continue;
                DownloadTask task = file.getTask();
                file.setState(DownloadState.PAUSED);
                if (task == null) continue;
                task.cancel(true);
            }
        }
        this.processManager.queueUpdated();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.contentsChanged(e);
        this.fireDataChanged();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.contentsChanged(e);
        this.fireDataChanged();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updateCompleted();
    }

    private Collection<DownloadFile> getItems(ListDataEvent e) {
        int start = e.getIndex0();
        int end = e.getIndex1();
        ArrayList<DownloadFile> result = new ArrayList<DownloadFile>(end - start + 1);
        for (int i = start; i <= end; ++i) {
            result.add((DownloadFile)this.downloadFiles.get(i));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCompleted() {
        Object object = this.lock;
        synchronized (object) {
            int counter = 0;
            int notFound = 0;
            for (DownloadFile file : this.downloadFiles) {
                if (file.getState() == DownloadState.COMPLETED) {
                    ++counter;
                }
                if (file.getFileState() != FileState.FILE_NOT_FOUND) continue;
                ++notFound;
            }
            this.setCompleted(counter);
            this.setNotFound(notFound);
        }
    }

    private void setNotFound(int notFound) {
        int oldValue = this.notFound;
        this.notFound = notFound;
        this.firePropertyChange("notFound", oldValue, this.notFound);
    }

    public int getCompleted() {
        return this.completed;
    }

    public void setCompleted(int completed) {
        int oldValue = this.completed;
        this.completed = completed;
        this.firePropertyChange("completed", oldValue, this.completed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompleted() {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<DownloadFile> toRemoveList = new LinkedList<DownloadFile>();
            for (DownloadFile file : this.downloadFiles) {
                if (file.getState() != DownloadState.COMPLETED) continue;
                file.setState(DownloadState.DELETED);
                toRemoveList.add(file);
                file.removePropertyChangeListener(this);
            }
            this.removeFromList(toRemoveList);
        }
    }

    private void removeFromList(List<DownloadFile> toRemoveList) {
        this.downloadFiles.removeAll(toRemoveList);
        this.changedFiles.removeAll(toRemoveList);
        this.reOrderListProperty();
        this.fileListMaintainer.removeFromDatabaseOnBackground(toRemoveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompletedAndDeleted() {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<DownloadFile> toRemoveList = new LinkedList<DownloadFile>();
            for (DownloadFile file : this.downloadFiles) {
                if (file.getState() != DownloadState.COMPLETED || file.getOutputFile() != null && file.getOutputFile().exists()) continue;
                file.setState(DownloadState.DELETED);
                toRemoveList.add(file);
                file.removePropertyChangeListener(this);
            }
            this.removeFromList(toRemoveList);
        }
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAllComplete() {
        Object object = this.lock;
        synchronized (object) {
            boolean nonFatalErrorIsOK = AppPrefs.getProperty("autoshutdownWithErrors", false);
            for (DownloadFile file : this.downloadFiles) {
                boolean isFatal;
                DownloadState state = file.getState();
                if (DownloadsActions.isProcessState(state) || state == DownloadState.QUEUED || state == DownloadState.SLEEPING) {
                    return false;
                }
                if (state != DownloadState.ERROR || (isFatal = file.getErrorAttemptsCount() == 0) || nonFatalErrorIsOK) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTop(int[] indexes) {
        Object object = this.lock;
        synchronized (object) {
            if (indexes.length > 1) {
                Arrays.sort(indexes);
            }
            for (int i = 0; i < indexes.length; ++i) {
                int index = indexes[i];
                if (index == i) continue;
                DownloadFile f = this.downloadFiles.remove(index);
                this.downloadFiles.add(i, f);
            }
            this.reOrderListProperty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveBottom(int[] indexes) {
        Object object = this.lock;
        synchronized (object) {
            int length = indexes.length;
            if (length > 1) {
                Arrays.sort(indexes);
            }
            int top = this.downloadFiles.size() - 1;
            for (int i = length - 1; i >= 0; --i) {
                int index = indexes[i];
                int newIndex = top - (length - 1 - i);
                if (index == newIndex) continue;
                DownloadFile downloadFile = this.downloadFiles.remove(index);
                this.downloadFiles.add(newIndex, downloadFile);
            }
            this.reOrderListProperty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveUp(int[] indexes) {
        Object object = this.lock;
        synchronized (object) {
            if (indexes.length > 1) {
                Arrays.sort(indexes);
            }
            for (int i = 0; i < indexes.length; ++i) {
                int index = indexes[i];
                int newIndex = Math.max(Math.max(0, index - 1), i);
                if (index != newIndex) {
                    DownloadFile downloadFile = this.downloadFiles.remove(index);
                    this.downloadFiles.add(newIndex, downloadFile);
                }
                indexes[i] = newIndex;
            }
            this.reOrderListProperty();
        }
    }

    private void reOrderListProperty() {
        int counter = 0;
        for (DownloadFile file : this.downloadFiles) {
            file.setListOrder(counter++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDown(int[] indexes) {
        Object object = this.lock;
        synchronized (object) {
            int length = indexes.length;
            if (length > 1) {
                Arrays.sort(indexes);
            }
            int top = this.downloadFiles.size() - 1;
            for (int i = length - 1; i >= 0; --i) {
                int newIndex;
                int index = indexes[i];
                indexes[i] = newIndex = Math.min(Math.min(top, index + 1), top - (length - 1 - i));
                if (index == newIndex) continue;
                DownloadFile downloadFile = this.downloadFiles.remove(index);
                this.downloadFiles.add(newIndex, downloadFile);
            }
            this.reOrderListProperty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloading() {
        Object object = this.lock;
        synchronized (object) {
            for (DownloadFile file : this.downloadFiles) {
                if (!DownloadsActions.isProcessState(file.getState())) continue;
                return true;
            }
        }
        return false;
    }

    public int getDownloading() {
        return this.processManager.getDownloading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDownload(ConnectionSettings settings, int[] indexes) {
        List<DownloadFile> forceDownloadList;
        Object object = this.lock;
        synchronized (object) {
            forceDownloadList = this.selectionToList(indexes);
        }
        this.processManager.forceDownload(settings, forceDownloadList);
    }

    public void checkQueue() {
        this.processManager.queueUpdated();
    }

    public int getDataChanged() {
        return this.dataChanged;
    }

    private void fireDataChanged() {
        this.firePropertyChange(DATA_CHANGED_PROPERTY, this.dataChanged, ++this.dataChanged);
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateLinks(int[] indexes) {
        if (indexes.length == 0) {
            return;
        }
        LinkedList<DownloadFile> files = new LinkedList<DownloadFile>();
        Object object = this.lock;
        synchronized (object) {
            for (DownloadFile file : this.selectionToList(indexes)) {
                ShareDownloadService service = this.pluginsManager.getService(file);
                if (service == null || !DownloadsActions.recheckExistingStates.contains((Object)file.getState()) || !service.supportsRunCheck()) continue;
                file.getProperties().put("previousState", (Object)file.getState());
                file.setFileState(FileState.NOT_CHECKED);
                file.setState(DownloadState.QUEUED);
                files.add(file);
            }
        }
        if (!files.isEmpty()) {
            this.processManager.forceValidateCheck(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvalidLinks() {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<DownloadFile> toRemoveList = new LinkedList<DownloadFile>();
            for (DownloadFile file : this.downloadFiles) {
                if (file.getFileState() != FileState.FILE_NOT_FOUND) continue;
                toRemoveList.add(file);
            }
            this.removeFromList(toRemoveList);
            for (DownloadFile file : toRemoveList) {
                file.setState(DownloadState.DELETED);
            }
        }
    }

    @Override
    public boolean addLinksToQueue(HttpFile parentFile, List<URI> uriList) {
        final LinkedList<DownloadFile> files = new LinkedList<DownloadFile>();
        boolean dontAddNotSupported = AppPrefs.getProperty("dontAddNotSupportedFromCrypter", true);
        final boolean startDownload = AppPrefs.getProperty("autoStartDownloadsFromDecrypter", true);
        for (URI uri : uriList) {
            try {
                URL url = uri.toURL();
                if (dontAddNotSupported && !this.pluginsManager.isSupported(url)) continue;
                DownloadFile downloadFile = new DownloadFile(url, parentFile.getSaveToDirectory(), parentFile.getDescription());
                downloadFile.setPluginID("");
                files.add(downloadFile);
            }
            catch (MalformedURLException e) {
                logger.warning("File with URI " + uri.toString() + " cannot be added to queue");
            }
        }
        final boolean[] result = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DataManager.this.addToList(files);
                    if (startDownload) {
                        DataManager.this.addToQueue(files);
                    }
                    result[0] = true;
                }
                catch (Exception e) {
                    result[0] = false;
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
        } else {
            runnable.run();
        }
        return result[0];
    }

    @Override
    public boolean addLinksToQueueNextTo(final HttpFile parentFile, List<URI> uriList, final boolean autoStart) {
        final LinkedList<DownloadFile> files = new LinkedList<DownloadFile>();
        boolean dontAddNotSupported = AppPrefs.getProperty("dontAddNotSupportedFromCrypter", true);
        final boolean startFromTop = AppPrefs.getProperty("startDownloadFromTheTop", true);
        for (URI uri : uriList) {
            try {
                URL url = uri.toURL();
                if (dontAddNotSupported && !this.pluginsManager.isSupported(url)) continue;
                DownloadFile downloadFile = new DownloadFile(url, parentFile.getSaveToDirectory(), parentFile.getDescription());
                downloadFile.setPluginID("");
                files.add(downloadFile);
            }
            catch (MalformedURLException e) {
                logger.warning("File with URI " + uri.toString() + " cannot be added to queue");
            }
        }
        final boolean[] result = new boolean[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DataManager.this.addToList(files);
                    Object object = DataManager.this.lock;
                    synchronized (object) {
                        int parentIndex = ((DownloadFile)parentFile).getListOrder();
                        if (startFromTop) {
                            for (int i = 0; i < files.size(); ++i) {
                                DataManager.this.downloadFiles.add(parentIndex + i + 1, DataManager.this.downloadFiles.remove(((DownloadFile)files.get(i)).getListOrder()));
                            }
                        } else {
                            for (int i = 0; i < files.size(); ++i) {
                                DataManager.this.downloadFiles.add(Math.max(0, parentIndex - i - 1), DataManager.this.downloadFiles.remove(((DownloadFile)files.get(i)).getListOrder()));
                            }
                        }
                        DataManager.this.reOrderListProperty();
                    }
                    if (autoStart) {
                        DataManager.this.addToQueue(files);
                    }
                    result[0] = true;
                }
                catch (Exception e) {
                    result[0] = false;
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
        } else {
            runnable.run();
        }
        return result[0];
    }

    @Override
    public boolean addLinksToQueueNextTo(HttpFile parentFile, List<URI> uriList) {
        boolean startDownload = AppPrefs.getProperty("autoStartDownloadsFromDecrypter", true);
        return this.addLinksToQueueNextTo(parentFile, uriList, startDownload);
    }

    @Override
    public boolean addLinkToQueueUsingPriority(HttpFile parentFile, String data) throws Exception {
        List<URL> urlList = URLTransferHandler.textURIListToFileList(data, this.pluginsManager, false);
        return !urlList.isEmpty() && this.addLinkToQueueUsingPriority(parentFile, urlList);
    }

    @Override
    public boolean addLinkToQueueUsingPriority(HttpFile parentFile, List<URL> urlList) throws Exception {
        ArrayList<URLByPriority> list = new ArrayList<URLByPriority>(urlList.size());
        for (URL url : urlList) {
            String id;
            try {
                id = this.pluginsManager.getServiceIDForURL(url);
            }
            catch (NotSupportedDownloadServiceException e) {
                continue;
            }
            list.add(new URLByPriority(url, this.pluginsManager.getPluginMetadata(id).getPluginPriority()));
        }
        return !list.isEmpty() && this.addLinksToQueue(parentFile, Arrays.asList(Utils.convertToURI(((URLByPriority)Collections.min(list)).getUrl().toExternalForm())));
    }

    @Override
    public boolean addLinksToQueueFromContainer(HttpFile parentFile, List<FileInfo> infoList) {
        return this.addLinksToQueueFromContainer(infoList, parentFile.getSaveToDirectory(), parentFile.getDescription(), false);
    }

    @Override
    public boolean addLinksToQueueFromContainer(HttpFile parentFile, String childDir, List<FileInfo> infoList) {
        return this.addLinksToQueueFromContainer(infoList, new File(parentFile.getSaveToDirectory(), childDir), parentFile.getDescription(), false);
    }

    @Override
    public boolean addLinkToQueueFromContainerUsingPriority(HttpFile parentFile, List<FileInfo> infoList) throws Exception {
        return this.addLinkToQueueFromContainerUsingPriority(infoList, parentFile.getSaveToDirectory(), parentFile.getDescription());
    }

    public boolean addLinksToQueueFromContainer(List<FileInfo> infoList, File saveToDirectory, String description, final boolean selectAdded) {
        final LinkedList<DownloadFile> files = new LinkedList<DownloadFile>();
        boolean dontAddNotSupported = AppPrefs.getProperty("dontAddNotSupportedFromCrypter", true);
        final boolean startDownload = AppPrefs.getProperty("autoStartDownloadsFromDecrypter", true);
        for (FileInfo info : infoList) {
            if (dontAddNotSupported && !this.pluginsManager.isSupported(info.getFileUrl())) continue;
            DownloadFile downloadFile = new DownloadFile(info, saveToDirectory);
            if (description != null) {
                downloadFile.setDescription(description);
            }
            files.add(downloadFile);
        }
        final boolean[] result = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DataManager.this.addToList(files);
                    if (startDownload) {
                        DataManager.this.addToQueue(files);
                    }
                    if (selectAdded) {
                        DataManager.this.director.getContentManager().getContentPanel().selectAdded(files);
                    }
                    result[0] = true;
                }
                catch (Exception e) {
                    result[0] = false;
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
        } else {
            runnable.run();
        }
        return result[0];
    }

    public boolean addLinkToQueueFromContainerUsingPriority(List<FileInfo> infoList, File saveToDirectory, String description) throws Exception {
        TreeMap<URLByPriority, FileInfo> map = new TreeMap<URLByPriority, FileInfo>();
        for (FileInfo info : infoList) {
            String id;
            try {
                id = this.pluginsManager.getServiceIDForURL(info.getFileUrl());
            }
            catch (NotSupportedDownloadServiceException e) {
                continue;
            }
            map.put(new URLByPriority(info.getFileUrl(), this.pluginsManager.getPluginMetadata(id).getPluginPriority()), info);
        }
        return !map.isEmpty() && this.addLinksToQueueFromContainer(Arrays.asList((FileInfo)map.firstEntry().getValue()), saveToDirectory, description, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpeedLimit(int[] indexes, int speed) {
        if (indexes.length == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            for (DownloadFile file : this.selectionToList(indexes)) {
                file.setSpeedLimit(speed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPausable(int[] indexes) {
        Object object = this.lock;
        synchronized (object) {
            if (indexes.length == 0) {
                return false;
            }
            for (int index : indexes) {
                DownloadFile file = (DownloadFile)this.downloadFiles.get(index);
                DownloadState s = file.getState();
                if (DownloadsActions.pauseEnabledStates.contains((Object)s)) {
                    return true;
                }
                if (s != DownloadState.DOWNLOADING || !file.isResumeSupported()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameDownloading(DownloadFile file) {
        Object object = this.lock;
        synchronized (object) {
            String fileName = file.getFileNameRenameTo() != null ? file.getFileNameRenameTo() : file.getFileName();
            List<DownloadFile> list = this.getDownloadFilesInStates(DownloadsActions.processStates);
            for (DownloadFile downloadFile : list) {
                String downloadFileName;
                String string = downloadFileName = downloadFile.getFileNameRenameTo() != null ? downloadFile.getFileNameRenameTo() : downloadFile.getFileName();
                if (downloadFile.equals(file) || !downloadFileName.equals(fileName) || !downloadFile.getSaveToDirectory().equals(file.getSaveToDirectory()) || downloadFile.getFileSize() < 0L) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sortByName(int[] indexes) {
        Object object = this.lock;
        synchronized (object) {
            if (indexes.length == 1) {
                return -1;
            }
            List<DownloadFile> files = this.selectionToList(indexes);
            DownloadFile[] sorted = files.toArray(new DownloadFile[files.size()]);
            Arrays.sort(sorted, new Comparator<DownloadFile>(){

                @Override
                public int compare(DownloadFile o1, DownloadFile o2) {
                    String o1FileName = o1.getFileNameRenameTo() != null ? o1.getFileNameRenameTo() : o1.getFileName();
                    String o2Filename = o2.getFileNameRenameTo() != null ? o2.getFileNameRenameTo() : o2.getFileName();
                    return o1FileName.compareToIgnoreCase(o2Filename);
                }
            });
            if (indexes.length > 1) {
                Arrays.sort(indexes);
            }
            int placeIndex = indexes[0];
            int length = indexes.length;
            for (int i = length - 1; i >= 0; --i) {
                this.downloadFiles.remove(indexes[i]);
            }
            this.downloadFiles.addAll(placeIndex, Arrays.asList(sorted));
            this.reOrderListProperty();
            return placeIndex;
        }
    }

    private final class URLByPriority
    implements Comparable<URLByPriority> {
        private int priority;
        private URL url;

        public URLByPriority(URL url, int priority) {
            this.url = url;
            this.priority = priority;
        }

        @Override
        public int compareTo(URLByPriority that) {
            return new Integer(that.priority).compareTo(this.priority);
        }

        public URL getUrl() {
            return this.url;
        }
    }
}

