/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.objectdb.o.UserException;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.interfaces.Identifiable;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import org.jdesktop.application.TaskService;

public class DatabaseManager {
    private static final Logger logger = Logger.getLogger(DatabaseManager.class.getName());
    private final ManagerDirector director;
    private final EntityManagerFactory factory;

    public EntityManager getEntityManager() {
        try {
            return this.factory.createEntityManager();
        }
        catch (Exception e) {
            if (e.getCause() instanceof UserException) {
                logger.warning(e.getCause().getMessage());
                File file = new File(this.director.getContext().getLocalStorage().getDirectory(), "frd.odb$");
                if (!file.delete()) {
                    logger.warning("Failed to delete file " + file.getAbsolutePath());
                } else {
                    return this.factory.createEntityManager();
                }
            }
            throw new RuntimeException(e);
        }
    }

    public DatabaseManager(ManagerDirector director) {
        this.director = director;
        String path = new File(director.getContext().getLocalStorage().getDirectory(), "frd.odb").getAbsolutePath();
        logger.info("Database path " + path);
        this.factory = Persistence.createEntityManagerFactory(path);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (DatabaseManager.this.factory != null) {
                    try {
                        DatabaseManager.this.factory.close();
                    }
                    catch (Exception e) {
                        LogUtils.processException(logger, e);
                    }
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveCollection(Collection<? extends Identifiable> entityCollection) {
        EntityManager em = this.getEntityManager();
        try {
            em.getTransaction().begin();
            for (Identifiable identifiable : entityCollection) {
                if (identifiable.getIdentificator() == null) {
                    em.persist(identifiable);
                    continue;
                }
                em.merge(identifiable);
            }
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T extends Identifiable> void removeCollection(Collection<T> entityCollection) {
        EntityManager em = this.getEntityManager();
        try {
            em.getTransaction().begin();
            for (Identifiable o : entityCollection) {
                Object removeObject;
                if (o.getIdentificator() == null || (removeObject = em.find(o.getClass(), o.getIdentificator())) == null) continue;
                em.remove(removeObject);
            }
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int removeAll(Class entityClass) {
        int affectedResult = 0;
        EntityManager em = this.getEntityManager();
        try {
            em.getTransaction().begin();
            affectedResult = em.createQuery("DELETE FROM " + entityClass.getName()).executeUpdate();
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
        return affectedResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveOrUpdate(Identifiable entity) {
        EntityManager em = this.getEntityManager();
        try {
            em.getTransaction().begin();
            if (entity.getIdentificator() == null) {
                em.persist(entity);
            } else {
                em.merge(entity);
            }
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                try {
                    em.getTransaction().rollback();
                }
                catch (Exception exception) {}
            }
            em.close();
        }
    }

    public synchronized <T> List<T> loadAll(Class<T> entityClass) {
        return this.loadAll(entityClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> List<T> loadAll(Class<T> entityClass, String orderBy) {
        EntityManager em = this.getEntityManager();
        try {
            TypedQuery<T> query = em.createQuery("SELECT c FROM " + entityClass.getName() + "  c " + (orderBy == null ? "" : " ORDER BY " + orderBy), entityClass);
            List<T> list = query.getResultList();
            return list;
        }
        finally {
            em.close();
        }
    }

    public void runOnTask(Runnable runnable) {
        this.runOnTask(runnable, null);
    }

    public void runOnTask(final Runnable runnable, final Runnable succeeded) {
        TaskService service = this.director.getTaskServiceManager().getTaskService("databaseService");
        service.execute(new CoreTask(this.director.getContext().getApplication()){

            @Override
            protected void succeeded(Object result) {
                if (succeeded != null) {
                    succeeded.run();
                }
            }

            @Override
            protected Object doInBackground() throws Exception {
                runnable.run();
                return null;
            }

            @Override
            protected void failed(Throwable cause) {
                LogUtils.processException(logger, cause);
                if (cause instanceof PersistenceException && cause.getMessage().contains("error 141")) {
                    Swinger.showErrorDialog(DatabaseManager.this.director.getContext().getResourceMap(), "DatabaseManager.databaseIsAlreadyUsed", cause);
                } else {
                    super.failed(cause);
                }
            }
        });
    }
}

