/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.common.collect.ArrayListModel;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.FileState;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.TaskService;

class FileListMaintainer {
    private final ApplicationContext context;
    private final ManagerDirector director;
    private final DataManager dataManager;
    private final Object saveFileLock = new Object();
    private final Object removeFileLock = new Object();
    private static final Logger logger = Logger.getLogger(FileListMaintainer.class.getName());
    private static final String FILES_LIST_XML = "filesList.xml";

    public FileListMaintainer(ApplicationContext context, ManagerDirector director, DataManager dataManager) {
        this.context = context;
        this.director = director;
        this.dataManager = dataManager;
    }

    private List<DownloadFile> loadFileHistoryList() {
        File backupFile;
        List<DownloadFile> result = null;
        File srcFile = new File(this.context.getLocalStorage().getDirectory(), FILES_LIST_XML);
        if (!srcFile.exists() && (backupFile = FileUtils.getBackupFile(srcFile)).exists()) {
            backupFile.renameTo(srcFile);
        }
        File targetImportedFile = new File(this.context.getLocalStorage().getDirectory(), "filesList.xml.imported");
        if (srcFile.exists() && !targetImportedFile.exists()) {
            try {
                File[] templists = this.context.getLocalStorage().getDirectory().listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.contains("templist");
                    }
                });
                for (File file : templists) {
                    file.delete();
                }
                result = this.loadListFromXML(srcFile);
            }
            catch (Exception e) {
                LogUtils.processException(logger, e);
                logger.info("Trying to renew file from backup");
                try {
                    FileUtils.renewBackup(srcFile);
                    result = this.loadListFromXML(srcFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (Exception e1) {
                    LogUtils.processException(logger, e);
                }
            }
            if (result != null) {
                int counter = 0;
                for (DownloadFile downloadFile : result) {
                    downloadFile.setListOrder(counter++);
                }
                this.saveToDatabaseOnBackground(result);
            } else {
                result = new ArrayList<DownloadFile>();
            }
            File backupFile2 = FileUtils.getBackupFile(srcFile);
            if (backupFile2.exists()) {
                backupFile2.renameTo(new File(this.context.getLocalStorage().getDirectory(), "filesList.xml.backup.imported"));
            }
            srcFile.renameTo(targetImportedFile);
            return result;
        }
        return this.director.getDatabaseManager().loadAll(DownloadFile.class, "c.listOrder ASC, c.dbId DESC");
    }

    void loadListToBean(Collection<DownloadFile> downloadFiles) {
        List<DownloadFile> result = this.loadFileHistoryList();
        this.initDownloadFiles(downloadFiles, result);
    }

    private List<DownloadFile> loadListFromXML(File srcFile) throws IOException {
        LinkedList<DownloadFile> list = new LinkedList<DownloadFile>();
        LocalStorage localStorage = this.context.getLocalStorage();
        if (!srcFile.exists()) {
            return list;
        }
        Object o = localStorage.load(FILES_LIST_XML);
        if (o instanceof ArrayListModel) {
            return (ArrayListModel)o;
        }
        return list;
    }

    private void initDownloadFiles(Collection<DownloadFile> list, Collection<DownloadFile> listFromDb) {
        boolean downloadOnStart = AppPrefs.getProperty("downloadOnStart", true);
        boolean removeCompleted = AppPrefs.getProperty("removeCompletedDownloads", 0) == 2;
        boolean recheckOnStart = AppPrefs.getProperty("recheckFilesOnStart", false);
        int listOrder = 0;
        LinkedList<DownloadFile> toRemoveList = new LinkedList<DownloadFile>();
        LinkedList<DownloadFile> changedFiles = new LinkedList<DownloadFile>();
        for (DownloadFile file : listFromDb) {
            DownloadState state = file.getState();
            if (state == DownloadState.DELETED) {
                toRemoveList.add(file);
                continue;
            }
            if (state == DownloadState.COMPLETED && removeCompleted) {
                toRemoveList.add(file);
                file.setState(DownloadState.DELETED);
                continue;
            }
            if (state != DownloadState.COMPLETED && recheckOnStart) {
                file.setFileState(FileState.NOT_CHECKED);
            }
            if ((state == DownloadState.ERROR || state == DownloadState.SLEEPING) && downloadOnStart && file.getTimeToQueued() > 0) {
                file.setTimeToQueued(-1);
                file.setTimeToQueuedMax(-1);
                file.setState(DownloadState.QUEUED);
            }
            if (DownloadsActions.isProcessState(state)) {
                if (downloadOnStart) {
                    file.setState(DownloadState.QUEUED);
                } else {
                    file.setState(DownloadState.PAUSED);
                }
            }
            if (file.getDownloaded() <= 0L) {
                file.setRealDownload(0L);
            } else {
                file.setDownloaded(file.getRealDownload());
            }
            file.resetSpeed();
            file.setTimeToQueued(-1);
            if (file.getListOrder() != listOrder) {
                changedFiles.add(file);
            }
            file.setListOrder(listOrder);
            file.addPropertyChangeListener(this.dataManager);
            list.add(file);
            ++listOrder;
        }
        if (toRemoveList.size() > 0) {
            this.removeFromDatabase(toRemoveList);
        }
        if (changedFiles.size() > 0) {
            this.saveToDatabase(changedFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveToDatabase(Collection<DownloadFile> downloadFiles) {
        Object object = this.saveFileLock;
        synchronized (object) {
            logger.info("=====Saving updated/added files into the database (" + downloadFiles.size() + ") =====");
            this.director.getDatabaseManager().saveCollection(downloadFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDatabase(Collection<DownloadFile> downloadFiles) {
        Object object = this.removeFileLock;
        synchronized (object) {
            logger.info("=====Removing deleted files from the database (" + downloadFiles.size() + ") =====");
            this.director.getDatabaseManager().removeCollection(downloadFiles);
        }
    }

    void removeFromDatabaseOnBackground(final Collection<DownloadFile> downloadFiles) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileListMaintainer.this.removeFromDatabase(downloadFiles);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable);
    }

    void saveToDatabaseOnBackground(final Collection<DownloadFile> downloadFiles) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileListMaintainer.this.saveToDatabase(downloadFiles);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable);
    }

    void doShutDown() {
        logger.info("Shutdown database service");
        TaskService service = this.director.getTaskServiceManager().getTaskService("databaseService");
        service.shutdown();
        try {
            service.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LogUtils.processException(logger, e);
        }
    }
}

