/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.FileTypeIconProvider;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.SpeedRegulator;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.gui.managers.ClipboardMonitorManager;
import cz.vity.freerapid.gui.managers.ContentManager;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.DatabaseManager;
import cz.vity.freerapid.gui.managers.FileHistoryManager;
import cz.vity.freerapid.gui.managers.LinkStoreManager;
import cz.vity.freerapid.gui.managers.MenuManager;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.gui.managers.ProxyForPluginManager;
import cz.vity.freerapid.gui.managers.ProxySetManager;
import cz.vity.freerapid.gui.managers.SearchManager;
import cz.vity.freerapid.gui.managers.StatusBarManager;
import cz.vity.freerapid.gui.managers.SystemManager;
import cz.vity.freerapid.gui.managers.TaskServiceManager;
import cz.vity.freerapid.gui.managers.ToolbarManager;
import cz.vity.freerapid.gui.managers.UpdateManager;
import cz.vity.freerapid.swing.TextComponentContextMenuListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.IIORegistry;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jdesktop.application.ApplicationContext;

public class ManagerDirector {
    private static final Logger logger = Logger.getLogger(ManagerDirector.class.getName());
    private final ApplicationContext context;
    private MenuManager menuManager;
    private StatusBarManager statusBarManager;
    private ToolbarManager toolbarManager;
    private ContentManager contentManager;
    private Container rootContainer;
    private JFrame mainFrame;
    private DataManager inputDataManager;
    private FileTypeIconProvider fileTypeIconProvider;
    private ClientManager clientManager;
    private PluginsManager pluginsManager;
    private FileHistoryManager fileHistoryManager;
    private ClipboardMonitorManager clipboardMonitorManager;
    private TaskServiceManager taskServiceManager;
    private UpdateManager updateManager;
    private SpeedRegulator speedRegulator;
    private LinkStoreManager linkStoreManager;
    private SearchManager searchManager;
    private SystemManager systemManager;
    private CountDownLatch countDownLatch = new CountDownLatch(1);
    private DatabaseManager databaseManager;
    private ProxySetManager proxySetManager;
    private ProxyForPluginManager proxyForPluginManager;

    public ManagerDirector(ApplicationContext context) {
        this.context = context;
    }

    public void initComponents() {
        logger.info("Starting version FreeRapid 1.0beta");
        this.mainFrame = ((MainApp)this.context.getApplication()).getMainFrame();
        this.rootContainer = new JPanel();
        this.rootContainer.setName("JPanel2");
        this.rootContainer.setPreferredSize(new Dimension(700, 550));
        this.taskServiceManager = new TaskServiceManager(this.context);
        this.clientManager = new ClientManager(this);
        this.proxySetManager = new ProxySetManager(this);
        this.proxyForPluginManager = new ProxyForPluginManager(this);
        this.databaseManager = new DatabaseManager(this);
        this.fileHistoryManager = new FileHistoryManager(this, this.context);
        this.pluginsManager = new PluginsManager(this.context, this, this.countDownLatch);
        this.searchManager = new SearchManager(this.context, this);
        this.updateManager = new UpdateManager(this, this.context);
        this.fileTypeIconProvider = new FileTypeIconProvider(this.context);
        this.inputDataManager = new DataManager(this, this.context);
        this.contentManager = new ContentManager(this.context, this);
        this.contentManager.getContentPanel();
        this.menuManager = new MenuManager(this.context, this);
        this.rootContainer.setLayout(new BorderLayout());
        this.clipboardMonitorManager = new ClipboardMonitorManager(this.context, this);
        this.inputDataManager.initProcessManagerInstance();
        this.systemManager = new SystemManager(this, this.context);
        this.rootContainer.add((Component)this.getToolbarManager().getComponent(), "North");
        this.rootContainer.add(this.getContentManager().getComponent(), "Center");
        this.rootContainer.add((Component)this.getStatusBarManager().getStatusBar(), "South");
    }

    public void guiIsReady() {
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.inputDataManager.initProcessManagerQueue();
        this.inputDataManager.getDownloadFiles().addListDataListener(this.getStatusBarManager());
        this.getStatusBarManager().updateInfoStatus();
        this.systemManager.initManager();
        this.linkStoreManager = new LinkStoreManager(this, this.context);
        this.searchManager.loadSearchData();
        this.toolbarManager.initManager();
        this.clipboardMonitorManager.initManager();
        this.updateManager.initManager();
        Toolkit.getDefaultToolkit().addAWTEventListener(new TextComponentContextMenuListener(), 16L);
    }

    private StatusBarManager getStatusBarManager() {
        if (this.statusBarManager == null) {
            this.statusBarManager = new StatusBarManager(this, this.context);
        }
        return this.statusBarManager;
    }

    public Container getComponent() {
        return this.rootContainer;
    }

    public ToolbarManager getToolbarManager() {
        if (this.toolbarManager == null) {
            this.toolbarManager = new ToolbarManager(this, this.context);
        }
        return this.toolbarManager;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public Container getRootContainer() {
        return this.rootContainer;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public DataManager getDataManager() {
        return this.inputDataManager;
    }

    public FileTypeIconProvider getFileTypeIconProvider() {
        return this.fileTypeIconProvider;
    }

    public ClientManager getClientManager() {
        return this.clientManager;
    }

    public PluginsManager getPluginsManager() {
        return this.pluginsManager;
    }

    public FileHistoryManager getFileHistoryManager() {
        return this.fileHistoryManager;
    }

    public ClipboardMonitorManager getClipboardMonitorManager() {
        return this.clipboardMonitorManager;
    }

    public TaskServiceManager getTaskServiceManager() {
        return this.taskServiceManager;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public SpeedRegulator getSpeedRegulator() {
        if (this.speedRegulator == null) {
            this.speedRegulator = new SpeedRegulator();
        }
        return this.speedRegulator;
    }

    public SearchManager getSearchManager() {
        return this.searchManager;
    }

    public SystemManager getSystemManager() {
        return this.systemManager;
    }

    public ProxySetManager getProxySetManager() {
        return this.proxySetManager;
    }

    public ProxyForPluginManager getProxyForPluginManager() {
        return this.proxyForPluginManager;
    }

    static {
        try {
            IIORegistry registry = IIORegistry.getDefaultInstance();
            Object spi = registry.getServiceProviderByClass(Class.forName("com.sun.imageio.plugins.wbmp.WBMPImageReaderSpi"));
            registry.deregisterServiceProvider(spi);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to remove WBMP SPI, problems may occur when reading ICO files", e);
        }
    }
}

