/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.binding.beans.PropertyConnector;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.actions.FileActions;
import cz.vity.freerapid.gui.actions.HelpActions;
import cz.vity.freerapid.gui.actions.OptionsActions;
import cz.vity.freerapid.gui.actions.ViewActions;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.binding.BindUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;

public class MenuManager {
    public static final String MENU_SEPARATOR = "---";
    private static final String SELECTED_TEXT_PROPERTY = "selectedText";
    private static final String RADIO = "*";
    private static final String RADIO2 = "*2";
    private static final String CHECKED = "!";
    private final ApplicationContext context;
    private final ManagerDirector director;
    private final FileActions fileActions;
    private final OptionsActions optionsActions;
    private JMenuBar menuBar;
    private JMenu useConnections;

    public FileActions getFileActions() {
        return this.fileActions;
    }

    public MenuManager(ApplicationContext context, ManagerDirector director) {
        this.context = context;
        this.director = director;
        this.fileActions = new FileActions(context);
        this.optionsActions = new OptionsActions();
        Swinger.initActions(this.fileActions, context);
        Swinger.initActions(this.optionsActions, context);
        Swinger.initActions(new ViewActions(), context);
        Swinger.initActions(new HelpActions(), context);
    }

    private void init() {
        Object[] fileMenuActionNames = new Object[]{"addNewLinksAction", MENU_SEPARATOR, "importLinksAction", "exportSelectedLinksAction", "exportAllLinksAction", MENU_SEPARATOR, "quit"};
        Object[] removeActionNames = new Object[]{"removeCompletedAction", "removeCompletedAndDeletedAction", "removeInvalidLinksAction", "removeSelectedAction"};
        Object[] downloadActionNames = new Object[]{"downloadInformationAction", MENU_SEPARATOR, "openFileAction", "deleteFileAction", "openDirectoryAction", "renameAction", MENU_SEPARATOR, "resumeAction", "pauseAction", "cancelAction", "retryAllErrorAction", MENU_SEPARATOR, this.createMenu("removeMenu", removeActionNames), MENU_SEPARATOR, "validateLinksAction", MENU_SEPARATOR, "selectAllAction", "invertSelectionAction", MENU_SEPARATOR, "sortbyNameAction", MENU_SEPARATOR, "topAction", "upAction", "downAction", "bottomAction"};
        Object[] shutdownActionNames = new Object[]{"*2shutdownDisabledAction", MENU_SEPARATOR, "*2shutdownQuitAction", "*2shutdownHibernateAction", "*2shutdownStandByAction", "*2shutdownRebootAction", "*2shutdownShutdownAction"};
        JMenu shutDownMenu = this.createMenu("autoShutdownMenu", shutdownActionNames);
        Object[] optionsMenuActionNames = new Object[]{"options", MENU_SEPARATOR, "!monitorClipboardAction", MENU_SEPARATOR, "!quietModeAction", MENU_SEPARATOR, "!globalSpeedLimitAction", MENU_SEPARATOR, this.createConnectionsMenu(), MENU_SEPARATOR, shutDownMenu};
        Object[] viewMenuActionNames = new Object[]{"showDownloadHistoryAction", MENU_SEPARATOR, "showToolbarEditorAction", MENU_SEPARATOR, "!showCompletedAction", MENU_SEPARATOR, "!showToolbar", "!showStatusBar"};
        Object[] helpMenuActionNames = new Object[]{"help", MENU_SEPARATOR, "showDemo", "visitHomepage", "visitForum", "checkPluginStatuses", MENU_SEPARATOR, "checkForNewPlugins", "checkForNewVersion", MENU_SEPARATOR, "openLogFile", "browseToLogFile", MENU_SEPARATOR, "paypalSupportAction", MENU_SEPARATOR, "about"};
        boolean isWindows = Utils.isWindows();
        MenuSelectionManager.defaultManager().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MenuSelectionManager msm = (MenuSelectionManager)evt.getSource();
                MenuElement[] path = msm.getSelectedPath();
                StringBuilder builder = new StringBuilder();
                for (MenuElement menuElement : path) {
                    JComponent comp;
                    String text;
                    if (menuElement instanceof ComboPopup) {
                        return;
                    }
                    Component component = menuElement.getComponent();
                    if (component instanceof JMenuItem) {
                        JMenuItem menuItem = (JMenuItem)component;
                        Action action = menuItem.getAction();
                        if (action == null) continue;
                        String longDescription = (String)action.getValue("LongDescription");
                        if (longDescription != null) {
                            if (builder.length() > 0) {
                                builder.append(" - ");
                            }
                            builder.append(longDescription);
                            continue;
                        }
                        Object shortDescription = action.getValue("ShortDescription");
                        if (shortDescription == null) continue;
                        if (builder.length() > 0) {
                            builder.append(" - ");
                        }
                        builder.append(shortDescription);
                        continue;
                    }
                    if (!(component instanceof JComponent) || (text = (comp = (JComponent)component).getToolTipText()) == null) continue;
                    builder.append(text);
                }
                MenuManager.this.menuBar.putClientProperty(MenuManager.SELECTED_TEXT_PROPERTY, path.length != 0 ? builder.toString() : "cancel");
            }
        });
        this.menuBar.add(this.createMenu("fileMenu", fileMenuActionNames));
        this.menuBar.add(this.createMenu("downloadsMenu", downloadActionNames));
        this.menuBar.add(this.createMenu("connectionsMenu", optionsMenuActionNames));
        this.menuBar.add(this.createMenu("viewMenu", viewMenuActionNames));
        this.menuBar.add(this.createMenu("helpMenu", helpMenuActionNames));
        this.menuBar.putClientProperty(SELECTED_TEXT_PROPERTY, "");
        ApplicationActionMap map = this.context.getActionMap();
        PropertyConnector.connectAndUpdate(BindUtils.getPrefsValueModel("removeCompleted", true), map.get("showCompletedAction"), "selected");
        PropertyConnector.connectAndUpdate(BindUtils.getPrefsValueModel("speedLimitEnabled", false), map.get("globalSpeedLimitAction"), "selected");
        PropertyConnector.connectAndUpdate(BindUtils.getPrefsValueModel("clipboardMonitoring", true), map.get("monitorClipboardAction"), "selected");
        PropertyConnector.connectAndUpdate(BindUtils.getPrefsValueModel("quietModeEnabled", false), map.get("quietModeAction"), "selected");
        JRootPane rootPane = this.director.getMainFrame().getRootPane();
        rootPane.registerKeyboardAction(Swinger.getAction("showDownloadHistoryAction"), SwingUtils.getCtrlKeyStroke(72), 2);
        if (isWindows) {
            this.selectAutoShutDownMenu(map);
        }
        if (AppPrefs.getProperty("autoshutdownDisabledWhenExecuted", true)) {
            AppPrefs.storeProperty("autoshutdown", 0);
        }
    }

    private void selectAutoShutDownMenu(ApplicationActionMap map) {
        String action = this.getSelectedShutDownAction();
        map.get(action).putValue("SwingSelectedKey", Boolean.TRUE);
    }

    public String getSelectedShutDownAction() {
        String action;
        int property = AppPrefs.getProperty("autoshutdown", 0);
        switch (property) {
            case 1: {
                action = "shutdownQuitAction";
                break;
            }
            case 5: {
                action = "shutdownHibernateAction";
                break;
            }
            case 3: {
                action = "shutdownRebootAction";
                break;
            }
            case 4: {
                action = "shutdownShutdownAction";
                break;
            }
            case 2: {
                action = "shutdownStandByAction";
                break;
            }
            default: {
                action = "shutdownDisabledAction";
            }
        }
        return action;
    }

    private JMenu createConnectionsMenu() {
        this.useConnections = new JMenu();
        this.useConnections.setName("useConnectionsMenu");
        this.updateConnectionSettings(this.director.getClientManager().getAvailableConnections());
        return this.useConnections;
    }

    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            this.init();
        }
        return this.menuBar;
    }

    private JMenu createMenu(String menuName, Object[] actionNames) {
        JMenu menu = new JMenu();
        return this.processMenu(menu, menuName, (ActionMap)this.context.getActionMap(), actionNames);
    }

    public JMenu createMenu(String menuName, ActionMap actionMap, Object ... actionNames) {
        JMenu menu = new JMenu();
        return this.processMenu(menu, menuName, actionMap, actionNames);
    }

    private JMenu processMenu(JMenu menu, String menuName, ActionMap actionMap, Object ... actionNames) {
        menu.setName(menuName);
        ButtonGroup group = new ButtonGroup();
        ButtonGroup group2 = new ButtonGroup();
        for (Object actionName : actionNames) {
            JMenuItem menuItem;
            if (actionName instanceof JMenu) {
                menu.add((JMenu)actionName);
                continue;
            }
            if (MENU_SEPARATOR.equals(actionName)) {
                menu.addSeparator();
                group = new ButtonGroup();
                continue;
            }
            String action = (String)actionName;
            if (action.startsWith(RADIO2)) {
                action = action.substring(RADIO2.length());
                menuItem = new JRadioButtonMenuItem();
                group2.add(menuItem);
            } else if (action.startsWith(RADIO)) {
                action = action.substring(RADIO.length());
                menuItem = new JRadioButtonMenuItem();
                group.add(menuItem);
            } else if (action.startsWith(CHECKED)) {
                action = action.substring(CHECKED.length());
                menuItem = new JCheckBoxMenuItem();
            } else {
                menuItem = new JMenuItem();
            }
            menuItem.setAction(actionMap.get(action));
            menuItem.setToolTipText(null);
            menu.add(menuItem);
        }
        return menu;
    }

    public JPopupMenu processMenu(JPopupMenu menu, String menuName, ActionMap actionMap, Object[] actionNames) {
        menu.setName(menuName);
        for (Object actionName : actionNames) {
            if (actionName instanceof JMenu) {
                menu.add((JMenu)actionName);
                continue;
            }
            if (MENU_SEPARATOR.equals(actionName)) {
                menu.addSeparator();
                continue;
            }
            JMenuItem menuItem = new JMenuItem();
            menuItem.setAction(actionMap.get(actionName));
            menu.add(menuItem);
        }
        return menu;
    }

    public void updateConnectionSettings(List<ConnectionSettings> connectionSettingses) {
        this.useConnections.removeAll();
        JMenuItem refreshProxyList = new JMenuItem();
        refreshProxyList.setName("refreshProxyList");
        this.optionsActions.setRefreshProxyListActionEnabled(AppPrefs.getProperty("useProxyList", false));
        refreshProxyList.setAction(this.context.getActionMap().get("refreshProxyList"));
        this.useConnections.add(refreshProxyList);
        this.useConnections.add(new JSeparator());
        for (final ConnectionSettings settings : connectionSettingses) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(settings.toString());
            PropertyConnector propertyConnector = PropertyConnector.connect(settings, "enabled", item, "selected");
            propertyConnector.updateProperty2();
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuManager.this.director.getClientManager().setConnectionEnabled(settings, !settings.isEnabled());
                    MenuManager.this.director.getDataManager().checkQueue();
                }
            });
            this.useConnections.add(item);
        }
    }
}

