/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;

public class PluginMetaDataManager {
    private static final Logger logger = Logger.getLogger(PluginMetaDataManager.class.getName());
    private final ApplicationContext context;
    private static final String FILES_LIST_XML = "plugins.xml";
    private ManagerDirector director;

    public PluginMetaDataManager(ManagerDirector director) {
        this.director = director;
        this.context = director.getContext();
    }

    public void saveToDatabase(final Set<PluginMetaData> files) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                logger.info("Saving metadata info into database - start");
                PluginMetaDataManager.this.director.getDatabaseManager().saveCollection(files);
                logger.info("Saving metadata info into database - end");
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable);
    }

    public Collection<PluginMetaData> getItems() {
        return Collections.unmodifiableCollection(this.loadData());
    }

    private Collection<PluginMetaData> loadData() {
        File backupFile;
        Set<PluginMetaData> result = null;
        File srcFile = new File(this.context.getLocalStorage().getDirectory(), FILES_LIST_XML);
        if (!srcFile.exists() && (backupFile = FileUtils.getBackupFile(srcFile)).exists()) {
            backupFile.renameTo(srcFile);
        }
        File targetImportedFile = new File(this.context.getLocalStorage().getDirectory(), "plugins.xml.imported");
        if (srcFile.exists() && !targetImportedFile.exists()) {
            try {
                result = this.loadList(srcFile);
            }
            catch (Exception e) {
                LogUtils.processException(logger, e);
                logger.info("Trying to renew file from backup");
                try {
                    FileUtils.renewBackup(srcFile);
                    result = this.loadList(srcFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (Exception e1) {
                    LogUtils.processException(logger, e);
                }
            }
            if (result != null) {
                this.saveToDatabase(result);
            } else {
                result = new HashSet<PluginMetaData>();
            }
            File backupFile2 = FileUtils.getBackupFile(srcFile);
            if (backupFile2.exists()) {
                backupFile2.renameTo(new File(this.context.getLocalStorage().getDirectory(), "plugins.xml.backup.imported"));
            }
            srcFile.renameTo(targetImportedFile);
            return result;
        }
        return this.director.getDatabaseManager().loadAll(PluginMetaData.class);
    }

    private Set<PluginMetaData> loadList(File srcFile) throws IOException {
        HashSet<PluginMetaData> set = new HashSet<PluginMetaData>();
        LocalStorage localStorage = this.context.getLocalStorage();
        if (!srcFile.exists()) {
            return set;
        }
        Object o = localStorage.load(FILES_LIST_XML);
        if (o instanceof Set) {
            return (Set)o;
        }
        return set;
    }
}

