/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.dialogs.WrappedPluginData;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginMetaDataManager;
import cz.vity.freerapid.gui.managers.exceptions.NotSupportedDownloadServiceException;
import cz.vity.freerapid.gui.managers.exceptions.PluginIsNotEnabledException;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.plugimpl.StandardDialogSupportImpl;
import cz.vity.freerapid.plugimpl.StandardPluginContextImpl;
import cz.vity.freerapid.plugimpl.StandardStorageSupportImpl;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.interfaces.PluginContext;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import jlibs.core.util.ReverseComparator;
import org.java.plugin.JpfException;
import org.java.plugin.ObjectFactory;
import org.java.plugin.Plugin;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.standard.ShadingPathResolver;
import org.java.plugin.standard.StandardPluginLocation;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;

public class PluginsManager {
    private static final Logger logger = Logger.getLogger(PluginsManager.class.getName());
    private static final String ID_DIRECT = "direct";
    private final Map<String, PluginMetaData> supportedPlugins = new HashMap<String, PluginMetaData>();
    private final Object lock = new Object();
    private final ApplicationContext context;
    private final ManagerDirector director;
    private PluginManager pluginManager;
    private PluginMetaDataManager pluginMetaDataManager;
    private static final int MAX_ENTRIES = 10;
    private final Map<String, PluginMetaData> pluginsCache = Collections.synchronizedMap(new LinkedHashMap<String, PluginMetaData>(10, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 10;
        }
    });

    public PluginsManager(ApplicationContext context, ManagerDirector director, final CountDownLatch countDownLatch) {
        this.context = context;
        this.director = director;
        this.pluginMetaDataManager = new PluginMetaDataManager(director);
        this.context.getApplication().addExitListener(new Application.ExitListener(){

            @Override
            public boolean canExit(EventObject event) {
                return true;
            }

            @Override
            public void willExit(EventObject event) {
                if (PluginsManager.this.pluginManager != null) {
                    try {
                        PluginsManager.this.pluginManager.shutdown();
                        File shadowFolder = new File(System.getProperty("java.io.tmpdir"), ".jpf-shadow");
                        IoUtil.emptyFolder(shadowFolder);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PluginsManager.this.findAndInitNewPlugins();
                }
                finally {
                    countDownLatch.countDown();
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAndInitNewPlugins() {
        logger.info("Init Plugins Manager");
        Object object = this.lock;
        synchronized (object) {
            ObjectFactory objectFactory = ObjectFactory.newInstance();
            ShadingPathResolver resolver = new ShadingPathResolver(){

                @Override
                protected URL maybeJarUrl(URL url) throws MalformedURLException {
                    if ("jar".equalsIgnoreCase(url.getProtocol())) {
                        return url;
                    }
                    File file = IoUtil.url2file(url);
                    if (file == null || !file.isFile()) {
                        return url;
                    }
                    String fileName = file.getName().toLowerCase(Locale.ROOT);
                    if (fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
                        return new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/");
                    }
                    return url;
                }
            };
            try {
                resolver.configure(new ExtendedProperties());
            }
            catch (Exception e) {
                LogUtils.processException(logger, e);
            }
            this.pluginManager = objectFactory.createManager(objectFactory.createRegistry(), resolver);
        }
        this.initNewPlugins(this.searchExistingPlugins());
    }

    public boolean isPluginInUseForUpdates(String id) {
        PluginRegistry pluginRegistry;
        if (this.hasPlugin(id) && (pluginRegistry = this.pluginManager.getRegistry()).isPluginDescriptorAvailable(id)) {
            PluginDescriptor descr = pluginRegistry.getPluginDescriptor(id);
            return this.pluginManager.isBadPlugin(descr) || !this.pluginManager.isPluginEnabled(descr);
        }
        return false;
    }

    public boolean isPluginDisabled(String id) {
        PluginRegistry pluginRegistry;
        if (this.hasPlugin(id) && (pluginRegistry = this.pluginManager.getRegistry()).isPluginDescriptorAvailable(id)) {
            PluginDescriptor descr = pluginRegistry.getPluginDescriptor(id);
            return this.pluginManager.isBadPlugin(descr) || !this.pluginManager.isPluginEnabled(descr);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNewPlugins(Collection<WrappedPluginData> updatedPlugins) throws JpfException {
        if (updatedPlugins.isEmpty()) {
            return;
        }
        PluginRegistry pluginRegistry = this.pluginManager.getRegistry();
        HashSet<String> updatedIds = new HashSet<String>();
        ArrayList<File> updatedPluginsFiles = new ArrayList<File>(updatedPlugins.size());
        Object object = this.lock;
        synchronized (object) {
            File file;
            for (WrappedPluginData updatedPlugin : updatedPlugins) {
                String id = updatedPlugin.getID();
                if (pluginRegistry.isPluginDescriptorAvailable(id)) {
                    PluginDescriptor descriptor = pluginRegistry.getPluginDescriptor(id);
                    if (updatedPlugin.isToBeDeleted()) {
                        try {
                            file = PluginsManager.urlToFile(descriptor.getLocation());
                            if (!file.delete()) {
                                logger.severe("Failed to delete plugin file " + file.getAbsolutePath());
                            }
                            logger.info(id + " " + updatedPlugin.getVersion() + " should be deleted");
                            updatedIds.add(id);
                            this.supportedPlugins.remove(id);
                        }
                        catch (Exception e) {
                            LogUtils.processException(logger, e);
                            updatedPlugin.getHttpFile().setState(DownloadState.ERROR);
                        }
                        continue;
                    }
                    updatedIds.add(id);
                    Collection<PluginDescriptor> dependencies = pluginRegistry.getDependingPlugins(descriptor);
                    for (PluginDescriptor dependency : dependencies) {
                        logger.info("Found dependency update for plugin " + id + " - dependency plugin " + dependency.getId());
                        updatedIds.add(dependency.getId());
                    }
                    continue;
                }
                updatedPluginsFiles.add(updatedPlugin.getHttpFile().getOutputFile());
            }
            for (String id : updatedIds) {
                if (!pluginRegistry.isPluginDescriptorAvailable(id)) continue;
                PluginDescriptor descriptor = pluginRegistry.getPluginDescriptor(id);
                try {
                    URL location = descriptor.getLocation();
                    logger.info("Location " + location.toExternalForm());
                    file = PluginsManager.urlToFile(location);
                    if (!file.exists()) continue;
                    updatedPluginsFiles.add(file);
                }
                catch (URISyntaxException e) {
                    logger.severe("Descriptor location " + descriptor.getLocation() + " cannot be converted to URI!");
                    LogUtils.processException(logger, e);
                }
                catch (MalformedURLException e) {
                    LogUtils.processException(logger, e);
                }
            }
            Object[] ids = updatedIds.toArray(new String[updatedIds.size()]);
            logger.info("Unregistering plugins " + Arrays.toString(ids));
            pluginRegistry.unregister((String[])ids);
            logger.info("Clearing plugin cache");
            this.pluginsCache.clear();
            this.initNewPlugins(updatedPluginsFiles.toArray(new File[updatedPluginsFiles.size()]));
        }
    }

    private void initNewPlugins(File[] plugins) {
        block6: {
            if (plugins.length == 0) {
                return;
            }
            try {
                this.pluginManager.publishPlugins(this.getPluginLocations(plugins));
                Collection<PluginMetaData> datas = this.pluginMetaDataManager.getItems();
                HashMap<String, PluginMetaData> datasId = new HashMap<String, PluginMetaData>(datas.size());
                for (PluginMetaData data : datas) {
                    datasId.put(data.getId(), data);
                }
                Collection<PluginDescriptor> pluginDescriptorCollection = this.pluginManager.getRegistry().getPluginDescriptors();
                for (PluginDescriptor pluginDescriptor : pluginDescriptorCollection) {
                    String id = pluginDescriptor.getId();
                    if (datasId.containsKey(id)) {
                        PluginMetaData data = (PluginMetaData)datasId.get(id);
                        data.setPluginDescriptor(pluginDescriptor);
                        this.supportedPlugins.put(id, data);
                        continue;
                    }
                    this.supportedPlugins.put(id, new PluginMetaData(pluginDescriptor));
                }
                this.disablePluginsInConflict();
                this.updatePluginSettings();
            }
            catch (Exception e) {
                LogUtils.processException(logger, e);
                if (!this.supportedPlugins.isEmpty()) break block6;
                this.context.getApplication().exit();
            }
        }
    }

    private PluginManager.PluginLocation[] getPluginLocations(File[] plugins) {
        if (plugins == null) {
            throw new IllegalStateException("Plugin directory does not exist");
        }
        int length = plugins.length;
        PluginManager.PluginLocation[] loc = new PluginManager.PluginLocation[length];
        for (int i = 0; i < length; ++i) {
            try {
                String path = PluginsManager.fileToUrl(plugins[i]).toExternalForm();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Plugins path:" + path);
                }
                URL context = new URL("jar:" + path + "!/");
                URL manifest = new URL("jar:" + path + "!/plugin.xml");
                loc[i] = new StandardPluginLocation(context, manifest);
                continue;
            }
            catch (MalformedURLException e) {
                LogUtils.processException(logger, e);
            }
        }
        logger.info("Found " + length + " plugins.");
        return loc;
    }

    private File[] searchExistingPlugins() {
        File pluginsDir = this.getPluginsDir();
        logger.info("Plugins dir: " + pluginsDir.getAbsolutePath());
        this.initiatePluginsIfNeccessary(pluginsDir);
        return pluginsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase(Locale.ENGLISH).endsWith(".frp");
            }
        });
    }

    public File getPluginsDir() {
        File parentDir = System.getProperties().containsKey("portable") ? new File(Utils.getAppPath()) : this.context.getLocalStorage().getDirectory();
        File pluginsDir = new File(parentDir, "plugins");
        if (pluginsDir.exists() && !pluginsDir.isDirectory()) {
            logger.warning("Deleting file with same name as plugin directory: " + pluginsDir);
            if (!pluginsDir.delete()) {
                logger.severe("Failed to delete file with same name as plugin directory: " + pluginsDir);
            }
        }
        if (!pluginsDir.exists() && !pluginsDir.mkdirs()) {
            logger.severe("Failed to create plugin directory: " + pluginsDir);
        }
        return pluginsDir;
    }

    private void initiatePluginsIfNeccessary(File pluginsDir) {
        boolean extractPlugins = true;
        if (this.isPluginsDirForCorrectVersion(pluginsDir)) {
            extractPlugins = false;
        } else {
            logger.info("Deleting old plugins");
            if (!IoUtil.emptyFolder(pluginsDir)) {
                logger.severe("Failed to empty plugin directory");
            }
        }
        if (extractPlugins) {
            logger.info("Extracting dist plugins");
            File pluginsDistFile = new File(Utils.getAppPath(), "instplgs.dat");
            FileUtils.extractZipFileInto(pluginsDistFile, pluginsDir);
            File file = new File(pluginsDir, "version.dat");
            FileUtils.writeFileWithValue(file, String.valueOf(12));
        }
    }

    private boolean isPluginsDirForCorrectVersion(File pluginsDir) {
        File versionFile = new File(pluginsDir, "version.dat");
        if (!versionFile.exists() || versionFile.length() <= 0L) {
            return false;
        }
        return Integer.valueOf(12).equals(Integer.valueOf(Utils.loadFile(versionFile)));
    }

    private void disablePluginsInConflict() {
        HashMap serviceConficts = new HashMap();
        for (PluginMetaData pluginMetaData : this.supportedPlugins.values()) {
            if (!pluginMetaData.isEnabled()) continue;
            String s = pluginMetaData.getServices();
            if (serviceConficts.containsKey(s)) {
                List datas = (List)serviceConficts.get(s);
                datas.add(pluginMetaData);
                continue;
            }
            LinkedList<PluginMetaData> list = new LinkedList<PluginMetaData>();
            list.add(pluginMetaData);
            serviceConficts.put(s, list);
        }
        for (List list : serviceConficts.values()) {
            if (list.size() <= 1) continue;
            for (PluginMetaData data : list) {
                if (!data.isPremium()) continue;
                data.setEnabled(false);
            }
        }
    }

    public boolean isSupported(URL url) {
        return this.isSupported(url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupported(URL url, boolean monitoring) {
        String s = url.toExternalForm();
        Object object = this.lock;
        synchronized (object) {
            PluginMetaData[] datas = this.getCachedPlugins();
            for (int i = datas.length - 1; i >= 0; --i) {
                PluginMetaData pluginMetaData = datas[i];
                if (!pluginMetaData.isSupported(s)) continue;
                this.addToCache(pluginMetaData);
                logger.fine("Cache hit");
                if (!pluginMetaData.isEnabled()) continue;
                return !monitoring || pluginMetaData.isClipboardMonitored();
            }
            for (PluginMetaData pluginMetaData : this.supportedPlugins.values()) {
                if (!pluginMetaData.isSupported(s)) continue;
                this.addToCache(pluginMetaData);
                if (!pluginMetaData.isEnabled()) continue;
                return !monitoring || pluginMetaData.isClipboardMonitored();
            }
            return (!monitoring || AppPrefs.getProperty("enableClipboardMonitoringForDirectDownloads", false)) && this.isDirectDownloadEnabled();
        }
    }

    private void addToCache(PluginMetaData pluginMetaData) {
        this.pluginsCache.put(pluginMetaData.getId(), pluginMetaData);
    }

    private PluginMetaData[] getCachedPlugins() {
        Collection<PluginMetaData> cached = this.pluginsCache.values();
        int cacheSize = cached.size();
        PluginMetaData[] datas = new PluginMetaData[cacheSize];
        cached.toArray(datas);
        return datas;
    }

    public String getServiceIDForURL(URL url) throws NotSupportedDownloadServiceException {
        String s = url.toExternalForm();
        PluginMetaData disabledPlugin = null;
        boolean priorityFirst = AppPrefs.getProperty("pluginWithPriorityPrecedence", false);
        if (priorityFirst) {
            Collection<PluginMetaData> values = this.supportedPlugins.values();
            PluginMetaData[] pluginMetaDatas = values.toArray(new PluginMetaData[values.size()]);
            Arrays.sort(pluginMetaDatas, new ReverseComparator<PluginMetaData>(new PriorityComparator()));
            for (PluginMetaData plugin : pluginMetaDatas) {
                if (!plugin.isSupported(s)) continue;
                if (!plugin.isEnabled()) {
                    disabledPlugin = plugin;
                    continue;
                }
                return plugin.getId();
            }
        } else {
            PluginMetaData[] plugins = this.getCachedPlugins();
            for (int i = plugins.length - 1; i >= 0; --i) {
                PluginMetaData plugin = plugins[i];
                if (!plugin.isSupported(s)) continue;
                this.addToCache(plugin);
                logger.fine("Cache hit");
                if (!plugin.isEnabled()) continue;
                return plugin.getId();
            }
            Collection<PluginMetaData> values = this.supportedPlugins.values();
            for (PluginMetaData plugin : values) {
                if (!plugin.isSupported(s)) continue;
                this.addToCache(plugin);
                if (!plugin.isEnabled()) {
                    disabledPlugin = plugin;
                    continue;
                }
                return plugin.getId();
            }
        }
        if (disabledPlugin != null) {
            throw new PluginIsNotEnabledException(disabledPlugin);
        }
        if (this.isDirectDownloadEnabled()) {
            return ID_DIRECT;
        }
        throw new NotSupportedDownloadServiceException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareDownloadService getPluginInstance(String id) throws NotSupportedDownloadServiceException {
        Object object = this.lock;
        synchronized (object) {
            Plugin p;
            if (!this.hasPlugin(id)) {
                throw new NotSupportedDownloadServiceException(id);
            }
            try {
                logger.info("Loading plugin with ID=" + id);
                p = this.pluginManager.getPlugin(id);
            }
            catch (Exception e) {
                LogUtils.processException(logger, e);
                throw new NotSupportedDownloadServiceException(id);
            }
            if (!(p instanceof ShareDownloadService)) {
                throw new NotSupportedDownloadServiceException(id);
            }
            ShareDownloadService plugin = (ShareDownloadService)((Object)p);
            if (plugin.getPluginContext() == null) {
                plugin.setPluginContext(this.createPluginContext());
            }
            logger.info("Plugin with ID=" + id + " was loaded");
            return plugin;
        }
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    private PluginContext createPluginContext() {
        return StandardPluginContextImpl.create(new StandardDialogSupportImpl(this.context), new StandardStorageSupportImpl(this.context), this.director.getDataManager());
    }

    public List<PluginMetaData> getSupportedPlugins() {
        Collection<PluginMetaData> datas = this.supportedPlugins.values();
        ArrayList<PluginMetaData> result = new ArrayList<PluginMetaData>(datas.size());
        for (PluginMetaData data : datas) {
            if (data.isLibraryPlugin() || data.getMaxParallelDownloads() < 1) continue;
            result.add(data);
        }
        return result;
    }

    public void updatePluginSettings() {
        this.pluginMetaDataManager.saveToDatabase(new HashSet<PluginMetaData>(this.supportedPlugins.values()));
    }

    public PluginMetaData getPluginMetadata(String serviceID) throws NotSupportedDownloadServiceException {
        if (!this.supportedPlugins.containsKey(serviceID)) {
            throw new NotSupportedDownloadServiceException(serviceID);
        }
        return this.supportedPlugins.get(serviceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareDownloadService getService(DownloadFile file) {
        Object object = this.lock;
        synchronized (object) {
            return this.getActiveService(file);
        }
    }

    private ShareDownloadService getActiveService(DownloadFile file) {
        String id = file.getPluginID();
        try {
            PluginMetaData data = this.getPluginMetadata(id);
            if (!data.isEnabled()) {
                try {
                    String newId = this.getServiceIDForURL(file.getFileUrl());
                    file.setPluginID(newId);
                    return this.getPluginInstance(newId);
                }
                catch (NotSupportedDownloadServiceException ex) {
                    file.setPluginID(id);
                    file.setState(DownloadState.DISABLED);
                    file.setErrorMessage(Swinger.getMessageFromException(Swinger.getResourceMap(), ex));
                    return null;
                }
            }
            return this.getPluginInstance(id);
        }
        catch (NotSupportedDownloadServiceException e) {
            try {
                String newId = this.getServiceIDForURL(file.getFileUrl());
                file.setPluginID(newId);
                return this.getPluginInstance(newId);
            }
            catch (PluginIsNotEnabledException e1) {
                file.setState(DownloadState.DISABLED);
                file.setErrorMessage(Swinger.getResourceMap().getString("PluginIsNotEnabled", file.getPluginID()));
            }
            catch (NotSupportedDownloadServiceException e1) {
                file.setState(DownloadState.ERROR);
                file.setErrorMessage(Swinger.getMessageFromException(Swinger.getResourceMap(), e));
            }
            return null;
        }
    }

    public boolean hasPlugin(String id) {
        return this.supportedPlugins.containsKey(id);
    }

    private static URL fileToUrl(File plugin) throws MalformedURLException {
        return plugin.toURI().toURL();
    }

    private static File urlToFile(URL plugin) throws MalformedURLException, URISyntaxException {
        String s = plugin.getFile();
        int i = s.lastIndexOf("!/");
        if (i != -1) {
            return new File(new URL(s.substring(0, i)).toURI());
        }
        return new File(plugin.toURI());
    }

    private boolean isDirectDownloadEnabled() {
        return AppPrefs.getProperty("enableDirectDownloads", false) && !this.isPluginDisabled(ID_DIRECT);
    }

    public static class PriorityComparator
    implements Comparator<PluginMetaData> {
        @Override
        public int compare(PluginMetaData o1, PluginMetaData o2) {
            return new Integer(o1.getPluginPriority()).compareTo(o2.getPluginPriority());
        }
    }
}

