/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.application.GlobalEDTExceptionHandler;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.core.tasks.DownloadTaskError;
import cz.vity.freerapid.core.tasks.RunCheckTask;
import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.DownloadService;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.gui.managers.ProxyForPluginManager;
import cz.vity.freerapid.gui.managers.exceptions.NotSupportedDownloadServiceException;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.model.LocalConnectionSettingsType;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadClient;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.FileState;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.event.SwingPropertyChangeSupport;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;
import org.jdesktop.application.TaskService;

public class ProcessManager
extends Thread {
    private static final Logger logger = Logger.getLogger(ProcessManager.class.getName());
    private final ApplicationContext context;
    private DataManager dataManager;
    private final PropertyChangeSupport pcs;
    private volatile Map<String, DownloadService> services = new Hashtable<String, DownloadService>();
    private volatile Map<DownloadFile, ConnectionSettings> forceDownloadFiles = new Hashtable<DownloadFile, ConnectionSettings>();
    private volatile List<DownloadFile> forceValidateCheck = new Vector<DownloadFile>();
    private boolean threadSuspended;
    private final Object downloadingLock = new Object();
    private final Object manipulation = new Object();
    private final Timer errorTimer = new Timer();
    private PluginsManager pluginsManager;
    private AtomicInteger downloading = new AtomicInteger(0);
    private final TaskService downloadTaskService;
    private final TaskService runCheckTaskService;
    private ClientManager clientManager;
    private final ProxyForPluginManager proxyForPluginManager;

    public ProcessManager(ManagerDirector director, ApplicationContext context) {
        this.dataManager = director.getDataManager();
        this.pluginsManager = director.getPluginsManager();
        this.pcs = new SwingPropertyChangeSupport(this);
        this.context = context;
        this.downloadTaskService = director.getTaskServiceManager().getTaskService("downloadService");
        this.runCheckTaskService = director.getTaskServiceManager().getTaskService("runCheckService");
        this.clientManager = director.getClientManager();
        this.proxyForPluginManager = director.getProxyForPluginManager();
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if ("maxDownloadsAtATime".equals(evt.getKey())) {
                    ProcessManager.this.queueUpdated();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("ProcessManagerThread");
        this.setUncaughtExceptionHandler(new GlobalEDTExceptionHandler());
        while (!this.isInterrupted()) {
            Object object = this.dataManager.getLock();
            synchronized (object) {
                Object object2 = this.manipulation;
                synchronized (object2) {
                    if (this.canCreateAnotherConnection(true) && !this.forceDownloadFiles.isEmpty()) {
                        this.executeForceDownload();
                    }
                    if (this.canCreateAnotherConnection(true) && !this.forceValidateCheck.isEmpty()) {
                        this.executeForceValidateCheck();
                    }
                    if (this.canCreateAnotherConnection(true)) {
                        this.execute();
                    }
                }
            }
            try {
                object = this;
                synchronized (object) {
                    this.threadSuspended = true;
                    logger.info("Test for sleeping");
                    while (this.threadSuspended) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        logger.info("Process Manager thread was interrupted succesfuly");
    }

    private void executeForceValidateCheck() {
        DownloadFile[] array = new DownloadFile[this.forceValidateCheck.size()];
        for (DownloadFile file : array = this.forceValidateCheck.toArray(array)) {
            logger.info("Getting file for check " + file);
            ShareDownloadService service = this.pluginsManager.getService(file);
            if (service == null) continue;
            DownloadService downloadService = this.getDownloadService(service);
            List<ConnectionSettings> connectionSettingses = this.getConnectionSettingses(file);
            if (file.getFileState() == FileState.NOT_CHECKED && service.supportsRunCheck() && !connectionSettingses.isEmpty()) {
                this.queueDownload(file, connectionSettingses.get(0), downloadService, service, true);
            }
            if (!this.canCreateAnotherConnection(true)) break;
        }
        this.forceValidateCheck.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCreateAnotherConnection(boolean forceDownload) {
        Object object = this.downloadingLock;
        synchronized (object) {
            if (forceDownload) {
                return true;
            }
            int maxDownloads = AppPrefs.getProperty("maxDownloadsAtATime", 5);
            boolean bl = maxDownloads > this.getDownloading();
            return bl;
        }
    }

    private List<DownloadFile> getFilesForForceDownload() {
        return new LinkedList<DownloadFile>(this.forceDownloadFiles.keySet());
    }

    private boolean execute() {
        ArrayList<DownloadFile> files = new ArrayList<DownloadFile>(this.dataManager.getDownloadFiles());
        boolean testFiles = AppPrefs.getProperty("testFiles", true);
        List<DownloadFile> queuedFiles = this.getQueued(files);
        for (DownloadFile file : queuedFiles) {
            logger.info("Getting downloadFile " + file);
            ShareDownloadService service = this.pluginsManager.getService(file);
            if (service == null) continue;
            DownloadService downloadService = this.getDownloadService(service);
            List<ConnectionSettings> connectionSettingses = this.getConnectionSettingses(file);
            if (testFiles && file.getFileState() == FileState.NOT_CHECKED && service.supportsRunCheck() && !connectionSettingses.isEmpty()) {
                this.queueDownload(file, connectionSettingses.get(0), downloadService, service, true);
            } else if (this.canCreateAnotherConnection(false) && downloadService.canDownloadBeforeCheck(file, files, this.isStartFromTop())) {
                for (ConnectionSettings settings : connectionSettingses) {
                    if (!downloadService.canDownloadWith(settings)) continue;
                    this.queueDownload(file, settings, downloadService, service, false);
                    break;
                }
            }
            if (this.canCreateAnotherConnection(true)) continue;
            return true;
        }
        return false;
    }

    private List<ConnectionSettings> getConnectionSettingses(DownloadFile file) {
        ArrayList<ConnectionSettings> connectionSettingses = new ArrayList<ConnectionSettings>();
        boolean useProxyForPlugin = AppPrefs.getProperty("useProxyForPlugin", false);
        List<String> proxies = this.proxyForPluginManager.getProxies(file.getPluginID());
        if (file.getLocalConnectionSettingsType() == LocalConnectionSettingsType.DIRECT) {
            connectionSettingses.add(new ConnectionSettings());
        } else if (file.getLocalConnectionSettingsType() == LocalConnectionSettingsType.LOCAL_PROXY) {
            ConnectionSettings proxyConnection = this.clientManager.getProxyConnection(file.getLocalProxy(), false);
            if (proxyConnection == null) {
                logger.warning("Invalid local proxy connection settings. Using application's connections settings as fallback");
                connectionSettingses.addAll(this.clientManager.getRotatedEnabledConnections(file.getFileUrl().getHost()));
            } else {
                connectionSettingses.add(proxyConnection);
            }
        } else if (useProxyForPlugin && proxies != null && proxies.size() > 0) {
            connectionSettingses.add(this.clientManager.getProxyForPluginRotatedConnection(file.getPluginID(), proxies));
        } else {
            connectionSettingses.addAll(this.clientManager.getRotatedEnabledConnections(file.getFileUrl().getHost()));
        }
        return connectionSettingses;
    }

    private boolean executeForceDownload() {
        for (DownloadFile file : this.getFilesForForceDownload()) {
            logger.info("Getting downloadFile " + file);
            ShareDownloadService service = this.pluginsManager.getService(file);
            if (service == null) continue;
            DownloadService downloadService = this.getDownloadService(service);
            ConnectionSettings settings = this.forceDownloadFiles.remove(file);
            if (settings == null) {
                throw new IllegalStateException("Cannot find forceDownloaded File");
            }
            logger.info("Force downloading with settings " + settings);
            this.queueDownload(file, settings, downloadService, service, false);
            if (this.canCreateAnotherConnection(true)) continue;
            return true;
        }
        return false;
    }

    private DownloadService getDownloadService(ShareDownloadService service) {
        PluginMetaData metaData = this.pluginsManager.getPluginMetadata(service.getId());
        String idServices = metaData.getServices();
        DownloadService downloadService = this.services.get(idServices);
        if (downloadService == null) {
            downloadService = new DownloadService(metaData, service);
            this.services.put(idServices, downloadService);
        } else {
            downloadService.setPluginMetaData(metaData);
        }
        logger.info("Getting plugin: " + metaData.toString());
        return downloadService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDownload(ConnectionSettings settings, List<DownloadFile> files) {
        Object object = this.manipulation;
        synchronized (object) {
            for (DownloadFile file : files) {
                if (DownloadsActions.isProcessState(file.getState())) continue;
                logger.info("Force downloading file " + file + " with settings " + settings);
                this.forceDownloadFiles.put(file, settings);
                file.setState(DownloadState.QUEUED);
            }
        }
        this.queueUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceValidateCheck(List<DownloadFile> files) {
        Object object = this.manipulation;
        synchronized (object) {
            for (DownloadFile file : files) {
                if (DownloadsActions.isProcessState(file.getState())) continue;
                logger.info("Force validate check file " + file);
                this.forceValidateCheck.add(file);
                file.setState(DownloadState.QUEUED);
            }
        }
        this.queueUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueDownload(final DownloadFile downloadFile, ConnectionSettings settings, final DownloadService downloadService, final ShareDownloadService service, final boolean runCheck) {
        DownloadClient client;
        if (downloadFile.getState() != DownloadState.QUEUED) {
            logger.info("QUEUED not found - found " + (Object)((Object)downloadFile.getState()));
            return;
        }
        if (!runCheck && AppPrefs.getProperty("skipDuplicateFiles", false) && this.dataManager.isSameDownloading(downloadFile)) {
            downloadFile.setState(DownloadState.SKIPPED);
            downloadFile.setErrorMessage(this.context.getResourceMap().getString("fileIsBeingAlreadyDownloading", new Object[0]));
            return;
        }
        Object object = this.downloadingLock;
        synchronized (object) {
            client = new DownloadClient();
            this.setDownloading(this.downloading.intValue(), this.downloading.incrementAndGet());
            client.setConnectionTimeOut(AppPrefs.getProperty("connectionTimeoutMS", 120000));
            client.initClient(settings);
        }
        if (runCheck) {
            downloadService.addTestingFile(downloadFile);
            downloadFile.setState(DownloadState.TESTING);
        } else {
            downloadService.addDownloadingClient(client);
            downloadFile.setState(DownloadState.GETTING);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadState state = downloadFile.getState();
                if (state != DownloadState.GETTING && state != DownloadState.TESTING) {
                    ProcessManager.this.finishedDownloading(downloadFile, client, downloadService, null, runCheck);
                } else {
                    ProcessManager.this.startDownload(downloadFile, client, downloadService, service, runCheck);
                }
            }
        });
    }

    private List<DownloadFile> getQueued(List<DownloadFile> queue) {
        LinkedList<DownloadFile> queued = new LinkedList<DownloadFile>();
        boolean startFromTop = this.isStartFromTop();
        if (startFromTop) {
            for (DownloadFile downloadFile : queue) {
                if (downloadFile.getState() != DownloadState.QUEUED) continue;
                queued.add(downloadFile);
            }
        } else {
            for (int i = queue.size() - 1; i >= 0; --i) {
                DownloadFile downloadFile = queue.get(i);
                if (downloadFile.getState() != DownloadState.QUEUED) continue;
                queued.add(downloadFile);
            }
        }
        return queued;
    }

    private boolean isStartFromTop() {
        return AppPrefs.getProperty("startDownloadFromTheTop", true);
    }

    private void startDownload(final DownloadFile downloadFile, final HttpDownloadClient client, final DownloadService downloadService, ShareDownloadService service, final boolean runCheck) {
        DownloadState s = downloadFile.getState();
        logger.info("starting download in state s = " + (Object)((Object)s));
        try {
            TaskService taskService;
            DownloadTask task;
            if (runCheck) {
                task = new RunCheckTask(this.context.getApplication(), client, downloadFile, service);
                taskService = this.runCheckTaskService;
            } else {
                task = new DownloadTask(this.context.getApplication(), client, downloadFile, service);
                taskService = this.downloadTaskService;
            }
            downloadFile.setTask(task);
            this.updateResumable(downloadFile);
            task.addTaskListener(new TaskListener.Adapter<Void, Long>(){

                @Override
                public void finished(TaskEvent<Void> event) {
                    ProcessManager.this.finishedDownloading(downloadFile, client, downloadService, task, runCheck);
                    downloadFile.setTask(null);
                }
            });
            try {
                taskService.execute(task);
            }
            catch (RejectedExecutionException e) {
                logger.severe(Utils.dumpStackTraces());
                logger.severe("downloading = " + this.downloading);
                throw e;
            }
            catch (Exception e) {
                logger.severe("downloading2 = " + this.downloading);
            }
        }
        catch (NotSupportedDownloadServiceException e) {
            LogUtils.processException(logger, e);
        }
    }

    private void updateResumable(DownloadFile downloadFile) {
        if (downloadFile.isResumeSupported()) {
            try {
                boolean supportsResume = this.pluginsManager.getPluginMetadata(downloadFile.getPluginID()).isResumeSupported();
                downloadFile.setResumeSupported(supportsResume);
            }
            catch (NotSupportedDownloadServiceException e) {
                LogUtils.processException(logger, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishedDownloading(DownloadFile file, HttpDownloadClient client, DownloadService downloadService, DownloadTask task, boolean runCheck) {
        Object object = this.manipulation;
        synchronized (object) {
            if (runCheck) {
                downloadService.finishedTestingFile(file);
            } else {
                downloadService.finishedDownloading(client);
            }
            Object object2 = this.downloadingLock;
            synchronized (object2) {
                this.setDownloading(this.downloading.intValue(), this.downloading.decrementAndGet());
            }
            if (task != null) {
                DownloadTaskError error = task.getServiceError();
                ConnectionSettings settings = client.getSettings();
                if (error == DownloadTaskError.NO_ROUTE_TO_HOST) {
                    boolean useProxyForPlugin = AppPrefs.getProperty("useProxyForPlugin", false);
                    List<String> proxies = this.proxyForPluginManager.getProxies(file.getPluginID());
                    if (file.getLocalConnectionSettingsType() == LocalConnectionSettingsType.DIRECT) {
                        file.setState(DownloadState.QUEUED);
                    } else if (file.getLocalConnectionSettingsType() == LocalConnectionSettingsType.LOCAL_PROXY) {
                        error = DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR;
                    } else if (useProxyForPlugin && proxies != null && proxies.size() > 0) {
                        file.setState(DownloadState.QUEUED);
                    } else {
                        this.clientManager.setConnectionEnabled(settings, false);
                        if (this.clientManager.getEnabledConnections().size() > 0) {
                            file.setState(DownloadState.QUEUED);
                        } else {
                            error = DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR;
                        }
                    }
                }
                DownloadState state = file.getState();
                int errorAttemptsCount = file.getErrorAttemptsCount();
                if (state == DownloadState.ERROR && errorAttemptsCount != 0 || state == DownloadState.SLEEPING) {
                    if (error == DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR && errorAttemptsCount != -1) {
                        file.setErrorAttemptsCount(0);
                    } else {
                        if (errorAttemptsCount != -1) {
                            file.setErrorAttemptsCount(errorAttemptsCount - 1);
                        }
                        downloadService.addProblematicConnection(settings);
                        int purge = this.errorTimer.purge();
                        if (purge > 0) {
                            logger.info("Purging timer threads count:" + purge);
                        }
                        if (error == DownloadTaskError.YOU_HAVE_TO_WAIT_ERROR) {
                            int waitTime = task.getYouHaveToSleepSecondsTime();
                            this.errorTimer.schedule((TimerTask)new ErrorTimerTask(downloadService, settings, file, waitTime), 0L, 1000L);
                        } else {
                            this.errorTimer.schedule((TimerTask)new ErrorTimerTask(downloadService, settings, file), 0L, 1000L);
                        }
                    }
                }
            }
        }
        this.checkCompleted(file);
        this.wakeUp();
    }

    private void checkCompleted(DownloadFile file) {
        if (file.getState() == DownloadState.COMPLETED) {
            boolean remove = false;
            if (Boolean.TRUE.equals(file.getProperties().get("removeCompleted"))) {
                remove = true;
            } else {
                boolean removeCompleted = AppPrefs.getProperty("removeCompletedCrypter", true);
                try {
                    PluginMetaData data = this.pluginsManager.getPluginMetadata(file.getPluginID());
                    if (removeCompleted && data.isRemoveCompleted()) {
                        remove = true;
                    }
                }
                catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
                    // empty catch block
                }
            }
            if (remove) {
                this.dataManager.removeSelected(Arrays.asList(file));
            }
        }
    }

    public void queueUpdated() {
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        ProcessManager processManager = this;
        synchronized (processManager) {
            this.threadSuspended = false;
            this.notify();
        }
    }

    public int getDownloading() {
        return this.downloading.get();
    }

    private void setDownloading(int intOldValue, int downloading) {
        this.pcs.firePropertyChange("downloading", intOldValue, downloading);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    private class ErrorTimerTask
    extends TimerTask
    implements PropertyChangeListener {
        private int counter;
        private final DownloadService service;
        private final ConnectionSettings settings;
        private final DownloadFile file;
        private long lastTime;
        private boolean finished;

        public ErrorTimerTask(DownloadService service, ConnectionSettings settings, DownloadFile file) {
            this(service, settings, file, AppPrefs.getProperty("autoReconnectTime", 120));
        }

        public ErrorTimerTask(DownloadService service, ConnectionSettings settings, DownloadFile file, int waitTime) {
            this.service = service;
            this.settings = settings;
            this.file = file;
            this.counter = waitTime;
            file.setTimeToQueuedMax(waitTime);
            this.lastTime = System.currentTimeMillis();
            this.finished = false;
            file.addPropertyChangeListener("state", this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DownloadState newState = (DownloadState)((Object)evt.getNewValue());
            if (newState != DownloadState.ERROR && newState != DownloadState.SLEEPING) {
                Object object = ProcessManager.this.manipulation;
                synchronized (object) {
                    this.cancel();
                    if (newState != DownloadState.WAITING) {
                        this.file.setTimeToQueued(-1);
                        this.file.setTimeToQueuedMax(-1);
                    }
                    this.finished = true;
                    this.unregisterListener();
                    this.file.resetErrorAttempts();
                    this.renewProblematicConnection();
                }
                ProcessManager.this.queueUpdated();
            }
        }

        private void unregisterListener() {
            this.file.removePropertyChangeListener("state", this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.finished) {
                return;
            }
            this.file.setTimeToQueued(--this.counter);
            long currentTime = System.currentTimeMillis();
            if (this.counter <= 0 || currentTime - this.lastTime > 60000L) {
                Object object = ProcessManager.this.manipulation;
                synchronized (object) {
                    this.unregisterListener();
                    this.file.setTimeToQueued(-1);
                    this.file.setTimeToQueuedMax(-1);
                    this.file.setState(DownloadState.QUEUED);
                    this.cancel();
                    this.renewProblematicConnection();
                }
                ProcessManager.this.queueUpdated();
            }
            this.lastTime = currentTime;
        }

        private void renewProblematicConnection() {
            this.service.removeProblematicConnection(this.settings);
        }
    }
}

