/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.exceptions.NotSupportedDownloadServiceException;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.model.ProxyForPlugin;
import cz.vity.freerapid.model.ProxySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jdesktop.application.AbstractBean;

public class ProxyForPluginManager
extends AbstractBean {
    private final Object lock = new Object();
    private final ManagerDirector director;

    public ProxyForPluginManager(ManagerDirector director) {
        this.director = director;
        this.init();
    }

    private void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ProxyForPlugin> getItems() {
        Object object = this.lock;
        synchronized (object) {
            List<ProxyForPlugin> proxyForPlugins = this.director.getDatabaseManager().loadAll(ProxyForPlugin.class);
            Collection<ProxySet> proxies = this.director.getProxySetManager().getItems();
            HashMap<Long, ProxySet> proxySetMap = new HashMap<Long, ProxySet>(proxies.size());
            for (ProxySet proxySet : proxies) {
                proxySetMap.put(proxySet.getIdentificator(), proxySet);
            }
            LinkedList<ProxyForPlugin> toRemoveList = new LinkedList<ProxyForPlugin>();
            for (ProxyForPlugin proxyForPlugin : proxyForPlugins) {
                PluginMetaData plugin = null;
                try {
                    plugin = this.director.getPluginsManager().getPluginMetadata(proxyForPlugin.getPluginId());
                }
                catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
                    // empty catch block
                }
                ProxySet proxySet = (ProxySet)proxySetMap.get(proxyForPlugin.getProxySetId());
                if (plugin == null || proxySet == null) {
                    toRemoveList.add(proxyForPlugin);
                    continue;
                }
                proxyForPlugin.setPluginServices(plugin.getServices());
                proxyForPlugin.setProxySetName(proxySet.getName());
            }
            if (toRemoveList.size() > 0) {
                proxyForPlugins.removeAll(toRemoveList);
            }
            return proxyForPlugins;
        }
    }

    public List<String> getProxies(String pluginId) {
        List<ProxyForPlugin> proxyForPlugins = this.director.getDatabaseManager().loadAll(ProxyForPlugin.class);
        ProxySet proxySet = null;
        for (ProxyForPlugin proxyForPlugin : proxyForPlugins) {
            if (!proxyForPlugin.getPluginId().equals(pluginId)) continue;
            if (!proxyForPlugin.isEnabled()) break;
            proxySet = this.director.getProxySetManager().getProxySetFromId(proxyForPlugin.getProxySetId());
            break;
        }
        if (proxySet == null) {
            return null;
        }
        return new ArrayList<String>(proxySet.getProxies());
    }

    public void addProxyForPluginItem(final ProxyForPlugin item) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProxyForPluginManager.this.director.getDatabaseManager().saveOrUpdate(item);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable);
        this.fireDataAdded(item);
    }

    public void updateProxyForPluginItem(final ProxyForPlugin item) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProxyForPluginManager.this.director.getDatabaseManager().saveOrUpdate(item);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable);
    }

    public void clearProxyForPlugin(Runnable succeeded) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProxyForPluginManager.this.director.getDatabaseManager().removeAll(ProxyForPlugin.class);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable, succeeded);
    }

    public void removeItems(final Collection<ProxyForPlugin> items) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProxyForPluginManager.this.director.getDatabaseManager().removeCollection(items);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable, null);
    }

    public void removeItems(final Collection<ProxyForPlugin> items, Runnable succeeded) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProxyForPluginManager.this.director.getDatabaseManager().removeCollection(items);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable, succeeded);
    }

    public boolean isPluginExists(String pluginId) {
        for (ProxyForPlugin item : this.getItems()) {
            if (!item.getPluginId().equals(pluginId)) continue;
            return true;
        }
        return false;
    }

    private void fireDataAdded(ProxyForPlugin dataAdded) {
        this.firePropertyChange("dataAdded", null, dataAdded);
    }
}

