/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.model.ProxySet;
import java.util.Collection;
import org.jdesktop.application.AbstractBean;

public class ProxySetManager
extends AbstractBean {
    private final ManagerDirector director;

    public ProxySetManager(ManagerDirector director) {
        this.director = director;
        this.init();
    }

    private void init() {
    }

    public Collection<ProxySet> getItems() {
        return this.director.getDatabaseManager().loadAll(ProxySet.class);
    }

    public void addProxySetItem(final ProxySet item) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProxySetManager.this.director.getDatabaseManager().saveOrUpdate(item);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable);
        this.fireDataAdded(item);
    }

    public void updateProxySetItem(final ProxySet item) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProxySetManager.this.director.getDatabaseManager().saveOrUpdate(item);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable);
        this.fireDataModified();
    }

    public void clearProxySet(Runnable succeeded) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProxySetManager.this.director.getDatabaseManager().removeAll(ProxySet.class);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable, succeeded);
        this.fireDataModified();
    }

    public void removeItems(final Collection<ProxySet> items) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProxySetManager.this.director.getDatabaseManager().removeCollection(items);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable, null);
        this.fireDataModified();
    }

    public void removeItems(final Collection<ProxySet> items, Runnable succeeded) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProxySetManager.this.director.getDatabaseManager().removeCollection(items);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable, succeeded);
        this.fireDataModified();
    }

    public boolean isNameExists(String name) {
        for (ProxySet item : this.getItems()) {
            if (!item.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public ProxySet getProxySetFromId(long proxySetId) {
        for (ProxySet item : this.getItems()) {
            if (item.getIdentificator() != proxySetId) continue;
            return item;
        }
        return null;
    }

    private void fireDataAdded(ProxySet dataAdded) {
        this.firePropertyChange("dataAdded", null, dataAdded);
    }

    private void fireDataModified() {
        this.firePropertyChange("dataModified", null, null);
    }
}

