/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.BoundedRangeAdapter;
import com.jgoodies.binding.adapter.SpinnerAdapterFactory;
import com.jgoodies.binding.beans.BeanAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ConverterFactory;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.TrayIconSupport;
import cz.vity.freerapid.swing.binding.BindUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXStatusBar;

public class StatusBarManager
implements PropertyChangeListener,
ListDataListener {
    private JXStatusBar statusbar;
    private JLabel infoLabel;
    private final ManagerDirector director;
    private final ApplicationContext context;
    private JProgressBar progress;
    private MainApp app;
    private ResourceMap resourceMap;
    private DataManager dataManager;
    private Image defaultIconImage;
    private Image downloadingIconImage;
    private TrayIconSupport trayIconSupport;
    private PropertyChangeListener taskPCL;
    private Task activeTask = null;
    private JSlider slider;
    private static final int BAR_HEIGHT = 18;
    private JPopupMenu popupMenu;
    private JSpinner spinnerMaxConcurrentDownloads;
    private JSpinner spinnerPluginMaxDownloads;

    public StatusBarManager(ManagerDirector director, ApplicationContext context) {
        this.director = director;
        this.context = context;
        this.resourceMap = context.getResourceMap();
        this.dataManager = director.getDataManager();
        this.app = (MainApp)context.getApplication();
    }

    public JXStatusBar getStatusBar() {
        if (this.statusbar == null) {
            this.statusbar = new JXStatusBar();
            this.trayIconSupport = this.app.getTrayIconSupport();
            this.defaultIconImage = Utils.isWindows() ? this.resourceMap.getImageIcon("trayIconImageWin").getImage() : this.resourceMap.getImageIcon("trayIconImage").getImage();
            this.downloadingIconImage = this.resourceMap.getImageIcon("downloadingIconImage").getImage();
            Action action = this.context.getActionMap().get("showStatusBar");
            ValueModel valueModel = BindUtils.getPrefsValueModel("showStatusbar", true);
            action.putValue("SwingSelectedKey", valueModel.getValue());
            PropertyConnector.connectAndUpdate(valueModel, this.getStatusBar(), "visible");
            JLabel clipboardMonitoring = new JLabel();
            clipboardMonitoring.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AppPrefs.negateProperty("clipboardMonitoring", true);
                }
            });
            JLabel quietMode = new JLabel();
            quietMode.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AppPrefs.negateProperty("quietModeEnabled", false);
                }
            });
            this.taskPCL = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if ("progress".equals(e.getPropertyName())) {
                        StatusBarManager.this.progress.setIndeterminate(false);
                        StatusBarManager.this.progress.setValue((Integer)e.getNewValue());
                    } else if ("message".equals(e.getPropertyName())) {
                        StatusBarManager.this.progress.setIndeterminate(true);
                        StatusBarManager.this.progress.setStringPainted(true);
                        String s = (String)e.getNewValue();
                        StatusBarManager.this.progress.setString(s);
                        StatusBarManager.this.progress.setToolTipText(s);
                    }
                }
            };
            clipboardMonitoring.setName("labelClipboardMonitoring");
            this.resourceMap.injectComponent(clipboardMonitoring);
            quietMode.setName("labelQuietMode");
            this.resourceMap.injectComponent(quietMode);
            this.statusbar.setName("statusbarPanel");
            this.infoLabel = new JLabel();
            this.progress = new JProgressBar();
            this.infoLabel.setPreferredSize(new Dimension(420, 18));
            clipboardMonitoring.setPreferredSize(new Dimension(17, 18));
            quietMode.setPreferredSize(new Dimension(17, 18));
            this.progress.setPreferredSize(new Dimension(this.progress.getPreferredSize().width + 35, 18));
            this.progress.setVisible(false);
            this.director.getMenuManager().getMenuBar().addPropertyChangeListener("selectedText", this);
            this.statusbar.add((Component)this.infoLabel, (Object)JXStatusBar.Constraint.ResizeBehavior.FIXED);
            JPanel speedBarPanel = new JPanel();
            speedBarPanel.setLayout(new BoxLayout(speedBarPanel, 2));
            this.initSpeedBar(speedBarPanel, this.resourceMap);
            final JLabel lblSetMaxDownloads = new JLabel();
            JPanel maxDownloadsPanel = new JPanel();
            this.initMaxDownloadsPanel(maxDownloadsPanel, this.resourceMap);
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("InternalFrame.borderShadow")));
            this.popupMenu.add(maxDownloadsPanel);
            lblSetMaxDownloads.setName("labelSetMaxDownloads");
            this.resourceMap.injectComponent(lblSetMaxDownloads);
            lblSetMaxDownloads.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    StatusBarManager.this.setPluginMaxDownloads();
                    Rectangle rect = lblSetMaxDownloads.getVisibleRect();
                    StatusBarManager.this.popupMenu.show(lblSetMaxDownloads, rect.x, rect.y - ((StatusBarManager)StatusBarManager.this).popupMenu.getPreferredSize().height - 5);
                    Swinger.inputFocus(StatusBarManager.this.spinnerMaxConcurrentDownloads);
                }
            });
            PropertyConnector.connectAndUpdate(BindUtils.getPrefsValueModel("clipboardMonitoring", true), clipboardMonitoring, "enabled");
            PropertyConnector.connectAndUpdate(BindUtils.getPrefsValueModel("quietModeEnabled", false), quietMode, "enabled");
            this.statusbar.add((Component)clipboardMonitoring, (Object)JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusbar.add((Component)quietMode, (Object)JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusbar.add((Component)lblSetMaxDownloads, (Object)JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusbar.add((Component)speedBarPanel, (Object)JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusbar.add((Component)this.progress, (Object)JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusbar.add(Box.createGlue(), (Object)JXStatusBar.Constraint.ResizeBehavior.FILL);
            this.context.getTaskMonitor().addPropertyChangeListener(this);
            this.dataManager.getProcessManager().addPropertyChangeListener("downloading", this);
            this.director.getSpeedRegulator().addPropertyChangeListener("speed", this);
            this.dataManager.addPropertyChangeListener("completed", this);
            this.dataManager.addPropertyChangeListener("state", this);
            AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

                @Override
                public void preferenceChange(final PreferenceChangeEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StatusBarManager.this.checkPropertyChange(evt);
                        }
                    });
                }
            });
            this.updateInfoStatus();
        }
        return this.statusbar;
    }

    private void initSpeedBar(JPanel panel, ResourceMap resourceMap) {
        JXCollapsiblePane cp = new JXCollapsiblePane();
        cp.setDirection(JXCollapsiblePane.Direction.RIGHT);
        cp.setBorder(null);
        cp.setAnimated(true);
        cp.setPreferredSize(new Dimension(160, 18));
        cp.setBorder(null);
        JLabel labelSpeedBtn = new JLabel();
        labelSpeedBtn.setName("labelSpeedBtn");
        resourceMap.injectComponent(labelSpeedBtn);
        labelSpeedBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AppPrefs.negateProperty("speedLimitEnabled", false);
            }
        });
        panel.add(labelSpeedBtn);
        panel.add(cp);
        labelSpeedBtn.setBackground(null);
        ValueModel valueModel = BindUtils.getPrefsValueModel("speedLimitEnabled", false);
        PropertyConnector.connectAndUpdate(ConverterFactory.createBooleanNegator(valueModel), cp, "collapsed");
        ValueModel speedAdapter = BindUtils.getReadOnlyPrefsValueModel("speedLimit", 250);
        this.slider = new JSlider(new BoundedRangeAdapter(speedAdapter, 0, 0, Integer.MAX_VALUE));
        this.slider.setName("speedSlider");
        this.slider.setPreferredSize(new Dimension(100, 18));
        this.slider.setMaximumSize(new Dimension(100, 18));
        this.slider.setSize(45, 12);
        Font font = this.slider.getFont().deriveFont(6.0f);
        this.slider.setFont(font);
        this.slider.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.slider.setSnapToTicks(true);
        this.bindSpeedSlider(this.slider);
        JLabel labelSpeed = new JLabel();
        labelSpeed.setName("labelSpeed");
        labelSpeed.setLabelFor(this.slider);
        Bindings.bind(labelSpeed, ConverterFactory.createStringConverter(speedAdapter, NumberFormat.getIntegerInstance()));
        labelSpeed.setAlignmentX(1.0f);
        labelSpeed.setPreferredSize(new Dimension(32, 18));
        labelSpeed.setBackground(Color.green);
        JLabel labelSpeedUnit = new JLabel();
        labelSpeedUnit.setLabelFor(this.slider);
        labelSpeedUnit.setName("labelSpeedUnit");
        PropertyConnector.connectAndUpdate(valueModel, this.slider, "enabled");
        PropertyConnector.connectAndUpdate(valueModel, labelSpeed, "enabled");
        PropertyConnector.connectAndUpdate(valueModel, labelSpeedUnit, "enabled");
        PropertyConnector.connectAndUpdate(valueModel, labelSpeedBtn, "enabled");
        CellConstraints cc = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.PREF_COLSPEC, FormSpecs.PREF_COLSPEC, FormSpecs.PREF_COLSPEC}, new RowSpec[]{FormSpecs.PREF_ROWSPEC}), cp);
        panelBuilder.add((Component)this.slider, cc.xy(1, 1));
        panelBuilder.add((Component)labelSpeed, cc.xy(2, 1));
        panelBuilder.add((Component)labelSpeedUnit, cc.xy(3, 1));
    }

    private void initMaxDownloadsPanel(JPanel maxDownloadsPanel, ResourceMap resourceMap) {
        maxDownloadsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.spinnerMaxConcurrentDownloads = new JSpinner();
        ValueModel maxConcurrentDownloadsAdapter = BindUtils.getReadOnlyPrefsValueModel("maxDownloadsAtATime", 5);
        this.bind(this.spinnerMaxConcurrentDownloads, 5, 1, 1000000, 1, maxConcurrentDownloadsAdapter);
        this.spinnerMaxConcurrentDownloads.setName("spinnerMaxConcurrentDownloads");
        this.spinnerPluginMaxDownloads = new JSpinner();
        this.spinnerPluginMaxDownloads.setName("spinnerPluginMaxDownloads");
        this.spinnerPluginMaxDownloads.setEnabled(false);
        this.spinnerPluginMaxDownloads.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StatusBarManager.this.director.getPluginsManager().updatePluginSettings();
            }
        });
        JLabel lblMaxConcurrentDownloads = new JLabel();
        lblMaxConcurrentDownloads.setName("labelMaxConcurrentDownloads");
        resourceMap.injectComponent(lblMaxConcurrentDownloads);
        lblMaxConcurrentDownloads.setLabelFor(this.spinnerMaxConcurrentDownloads);
        JLabel lblPluginMaxDownloads = new JLabel();
        lblPluginMaxDownloads.setName("labelPluginMaxDownloads");
        resourceMap.injectComponent(lblPluginMaxDownloads);
        lblPluginMaxDownloads.setLabelFor(this.spinnerPluginMaxDownloads);
        CellConstraints cc = new CellConstraints();
        PanelBuilder maxDownloadsPanelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.bounded(Sizes.PREFERRED, Sizes.dluX(56), Sizes.dluX(65)), 1.0)}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), maxDownloadsPanel);
        maxDownloadsPanelBuilder.add((Component)lblMaxConcurrentDownloads, cc.xy(1, 1));
        maxDownloadsPanelBuilder.add((Component)this.spinnerMaxConcurrentDownloads, cc.xy(3, 1));
        maxDownloadsPanelBuilder.add((Component)lblPluginMaxDownloads, cc.xy(1, 3));
        maxDownloadsPanelBuilder.add((Component)this.spinnerPluginMaxDownloads, cc.xy(3, 3));
    }

    private void setPluginMaxDownloads() {
        this.spinnerPluginMaxDownloads.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int[] index = StatusBarManager.this.director.getContentManager().getContentPanel().getSelectedRows();
                if (index.length == 0) {
                    return;
                }
                List<DownloadFile> files = StatusBarManager.this.dataManager.getSelectionToList(index);
                if (!files.isEmpty()) {
                    PluginMetaData pluginMetaData;
                    DownloadFile httpFile = files.get(0);
                    if (httpFile.getState() == DownloadState.COMPLETED || httpFile.getState() == DownloadState.DELETED) {
                        return;
                    }
                    String pluginID = httpFile.getPluginID();
                    try {
                        pluginMetaData = StatusBarManager.this.director.getPluginsManager().getPluginMetadata(pluginID);
                    }
                    catch (Exception ex) {
                        return;
                    }
                    int max = pluginMetaData.getMaxParallelDownloads();
                    BeanAdapter<PluginMetaData> beanModel = new BeanAdapter<PluginMetaData>(pluginMetaData, true);
                    StatusBarManager.this.bind(StatusBarManager.this.spinnerPluginMaxDownloads, 1, 1, max, 1, beanModel.getValueModel("maxAllowedDownloads"));
                    StatusBarManager.this.spinnerPluginMaxDownloads.setEnabled(max > 1);
                }
            }
        });
    }

    private void checkPropertyChange(PreferenceChangeEvent evt) {
        String key = evt.getKey();
        if ("showInfoInFrameTitle".equals(key)) {
            this.updateInfoStatus();
        } else if ("animateIcon".equals(key)) {
            if (!AppPrefs.getProperty("animateIcon", true)) {
                this.trayIconSupport.setImage(this.defaultIconImage);
            } else {
                this.updateIconAnimation();
            }
        } else if (!"showMemoryIndicator".equals(key)) {
            if ("speedLimitEnabled".equals(key)) {
                if (Boolean.TRUE.equals(Boolean.valueOf(evt.getNewValue()))) {
                    Swinger.inputFocus(this.slider);
                }
            } else if ("globalSpeedMax".equals(key) || "globalSpeedSliderStep".equals(key)) {
                this.bindSpeedSlider(this.slider);
            } else if ("maxDownloadsAtATime".equals(key)) {
                this.spinnerMaxConcurrentDownloads.setValue(AppPrefs.getProperty("maxDownloadsAtATime", 5));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("speed".equals(propertyName) || "completed".equals(propertyName)) {
            this.updateInfoStatus();
        } else if ("started".equals(propertyName) || "done".equals(propertyName) || "message".equals(propertyName)) {
            if (!(evt.getSource() instanceof DownloadTask)) {
                this.updateProgress(evt);
            }
        } else if ("selectedText".equals(propertyName)) {
            String s = (String)evt.getNewValue();
            if ("cancel".equals(s)) {
                this.updateInfoStatus();
            } else {
                this.infoLabel.setText(s);
            }
        } else if ("downloading".equals(propertyName) && AppPrefs.getProperty("animateIcon", true)) {
            this.updateIconAnimation();
        }
    }

    private void updateIconAnimation() {
        int downloading = this.dataManager.getDownloading();
        if (downloading == 0) {
            this.trayIconSupport.setImage(this.defaultIconImage);
        } else {
            this.trayIconSupport.setImage(this.downloadingIconImage);
        }
    }

    private void updateProgress(PropertyChangeEvent evt) {
        Task task = (Task)evt.getSource();
        String propertyName = evt.getPropertyName();
        if ("done".equals(propertyName)) {
            this.progress.setVisible(false);
            task.removePropertyChangeListener(this.taskPCL);
            this.activeTask = null;
        } else if ("started".equals(propertyName)) {
            if (this.activeTask != null) {
                task.removePropertyChangeListener(this.taskPCL);
            }
            this.activeTask = task;
            this.progress.setStringPainted(false);
            this.progress.setVisible(true);
            this.progress.setToolTipText(null);
            this.progress.setIndeterminate(!task.isProgressPropertyValid());
            task.addPropertyChangeListener(this.taskPCL);
        }
    }

    public void updateInfoStatus() {
        int completed = this.dataManager.getCompleted();
        int size = this.dataManager.getDownloadFiles().size();
        long speed = this.director.getSpeedRegulator().getSpeed();
        TrayIconSupport trayIconSupport = this.app.getTrayIconSupport();
        boolean showInFrameTitle = AppPrefs.getProperty("showInfoInFrameTitle", false);
        String speedFormatted = ContentPanel.bytesToAnother(speed);
        int downloading = this.dataManager.getDownloading();
        if (showInFrameTitle) {
            String s = downloading == 0 ? this.resourceMap.getString("frameTitleInfoNoDownloads", completed, size) : (speed == 0L ? this.resourceMap.getString("frameTitleInfo0Speed", completed, size, speedFormatted) : this.resourceMap.getString("frameTitleInfo", completed, size, speedFormatted));
            this.app.getMainFrame().setTitle(s);
        } else {
            this.app.getMainFrame().setTitle(this.resourceMap.getString("Application.title", new Object[0]));
        }
        if (size >= 0) {
            trayIconSupport.setToolTip(this.resourceMap.getString("tooltipTrayInfo", completed, size, speedFormatted));
            this.infoLabel.setText(this.resourceMap.getString("statusBarInfo", completed, size, speedFormatted));
        } else {
            trayIconSupport.setToolTip(this.resourceMap.getString("Application.title", new Object[0]));
            this.infoLabel.setText(this.resourceMap.getString("statusBarInfoIdle", new Object[0]));
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.updateInfoStatus();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.updateInfoStatus();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
    }

    private void bindSpeedSlider(JSlider slider) {
        int minimum = AppPrefs.getProperty("globalSpeedMin", 50);
        int maximum = AppPrefs.getProperty("globalSpeedMax", 250);
        int step = AppPrefs.getProperty("globalSpeedSliderStep", 10);
        slider.setMinimum(minimum);
        slider.setMaximum(maximum);
        slider.setMinorTickSpacing(step);
    }

    private void bind(JSpinner spinner, int defaultValue, int minValue, int maxValue, int step, ValueModel valueModel) {
        spinner.setModel(SpinnerAdapterFactory.createNumberAdapter(valueModel, defaultValue, minValue, maxValue, step));
        JComponent editor = spinner.getEditor();
        if (editor instanceof JFormattedTextField) {
            JFormattedTextField field = (JFormattedTextField)editor;
            field.setFocusLostBehavior(0);
        }
    }
}

