/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ValueModel;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.SearchField;
import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.dialogs.CompoundUndoManager;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.search.SearchItem;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.model.LocalConnectionSettingsType;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.ToolbarSeparator;
import cz.vity.freerapid.swing.binding.BindUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.ApplicationContext;

public class ToolbarManager
implements PropertyChangeListener {
    private final JPanel toolbarPanel = new JPanel(new BorderLayout());
    private static final Dimension buttonDimensionWithText = new Dimension(74, 68);
    private static final Dimension buttonWithoutWithoutTextDimension = new Dimension(40, 38);
    private JToolBar toolbar;
    private float fontSize;
    private SearchField searchField;
    private final ManagerDirector directorManager;
    private final ApplicationContext context;
    private final ClientManager clientManager;
    private JButton forceDownloadButton = new JButton();
    private JPopupMenu forceDownloadButtonMenu = new JPopupMenu();
    private LinkedHashMap<String, ToolbarButtonProperties> toolbarButtons;

    public ToolbarManager(ManagerDirector directorManager, ApplicationContext context) {
        this.directorManager = directorManager;
        this.context = context;
        this.clientManager = directorManager.getClientManager();
        this.toolbarPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        Action action = context.getActionMap().get("showToolbar");
        ValueModel valueModel = BindUtils.getPrefsValueModel("showToolbar", true);
        action.putValue("SwingSelectedKey", valueModel.getValue());
        PropertyConnector.connectAndUpdate(valueModel, this.toolbarPanel, "visible");
        this.fontSize = context.getResourceMap().getFloat("buttonBarFontSize").floatValue();
        this.toolbar = new JToolBar("mainToolbar");
        this.initToolbarButtons();
        this.createToolbar();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("done".equals(propertyName) || "started".equals(propertyName)) {
            // empty if block
        }
    }

    private void initForceDownloadButton() {
        ForceDownloadButtonAction forceButtonAction = new ForceDownloadButtonAction(this.context.getResourceMap().getString("forceDownloadMenu.text", new Object[0]), this.context.getResourceMap().getIcon("forceDownloadMenu_largeIcon"));
        this.forceDownloadButton.setAction(forceButtonAction);
        this.setButtonProperties(this.forceDownloadButton, forceButtonAction);
        this.directorManager.getContentManager().getContentPanel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ToolbarManager.this.forceDownloadButton.setEnabled(ToolbarManager.this.getForceEnabled());
                if (!ToolbarManager.this.forceDownloadButton.isEnabled()) {
                    ToolbarManager.this.forceDownloadButtonMenu.setVisible(false);
                }
            }
        });
        this.forceDownloadButton.setEnabled(false);
    }

    private boolean getForceEnabled() {
        return this.directorManager.getContentManager().getContentPanel().isSelectedEnabled() && this.directorManager.getDataManager().hasDownloadFilesStates(this.directorManager.getContentManager().getContentPanel().getSelectedRows(), DownloadsActions.forceEnabledStates);
    }

    private void updateForceDownloadButtonMenu() {
        boolean forceEnabled = this.getForceEnabled();
        this.forceDownloadButton.setEnabled(forceEnabled);
        if (forceEnabled) {
            this.forceDownloadButtonMenu.removeAll();
            int[] selectedRows = this.directorManager.getContentManager().getContentPanel().getSelectedRows();
            List<DownloadFile> files = this.directorManager.getDataManager().getSelectionToList(selectedRows);
            ArrayList<ConnectionSettings> connectionSettingses = new ArrayList<ConnectionSettings>();
            connectionSettingses.addAll(this.directorManager.getClientManager().getAvailableConnections());
            boolean useProxyForPlugin = AppPrefs.getProperty("useProxyForPlugin", false);
            for (DownloadFile file : files) {
                ConnectionSettings proxy;
                if (file.getLocalConnectionSettingsType() == LocalConnectionSettingsType.DIRECT) {
                    ConnectionSettings direct = new ConnectionSettings();
                    if (!connectionSettingses.contains(direct)) {
                        connectionSettingses.add(direct);
                    }
                } else if (file.getLocalConnectionSettingsType() == LocalConnectionSettingsType.LOCAL_PROXY && (proxy = this.directorManager.getClientManager().getProxyConnection(file.getLocalProxy(), false)) != null && !connectionSettingses.contains(proxy)) {
                    connectionSettingses.add(proxy);
                }
                if (!useProxyForPlugin) continue;
                List<ConnectionSettings> proxyForPluginConnections = this.clientManager.getProxyForPluginConnections(file.getPluginID());
                for (ConnectionSettings connectionSettings : proxyForPluginConnections) {
                    if (connectionSettingses.contains(connectionSettings)) continue;
                    connectionSettingses.add(connectionSettings);
                }
            }
            boolean anyEnabled = false;
            for (ConnectionSettings settings : connectionSettingses) {
                ForceDownloadOptionAction action = new ForceDownloadOptionAction(settings);
                this.forceDownloadButtonMenu.add(action);
                action.setEnabled(forceEnabled);
                if (!settings.isEnabled()) continue;
                anyEnabled = true;
            }
            this.forceDownloadButton.setEnabled(anyEnabled);
        }
    }

    private void initToolbarButtons() {
        this.toolbarButtons = new LinkedHashMap();
        this.toolbarButtons.put("-", new ToolbarButtonProperties(""));
        this.toolbarButtons.get("-").setName("   ----");
        this.toolbarButtons.put("A", new ToolbarButtonProperties("addNewLinksAction"));
        this.toolbarButtons.put("B", new ToolbarButtonProperties("resumeAction"));
        this.toolbarButtons.put("C", new ToolbarButtonProperties("pauseAction"));
        this.toolbarButtons.put("D", new ToolbarButtonProperties("cancelAction"));
        this.toolbarButtons.put("E", new ToolbarButtonProperties("topAction"));
        this.toolbarButtons.put("F", new ToolbarButtonProperties("upAction"));
        this.toolbarButtons.put("G", new ToolbarButtonProperties("downAction"));
        this.toolbarButtons.put("H", new ToolbarButtonProperties("bottomAction"));
        this.toolbarButtons.put("I", new ToolbarButtonProperties("downloadInformationAction"));
        this.toolbarButtons.put("J", new ToolbarButtonProperties("copyContent"));
        this.toolbarButtons.put("K", new ToolbarButtonProperties("openLogFile"));
        this.toolbarButtons.put("L", new ToolbarButtonProperties("browseToLogFile"));
        this.toolbarButtons.put("M", new ToolbarButtonProperties("checkForNewPlugins"));
        this.toolbarButtons.put("N", new ToolbarButtonProperties("checkForNewVersion"));
        this.toolbarButtons.put("O", new ToolbarButtonProperties("openInBrowser"));
        this.toolbarButtons.put("P", new ToolbarButtonProperties("options"));
        this.toolbarButtons.put("Q", new ToolbarButtonProperties("showDownloadHistoryAction"));
        this.toolbarButtons.get("Q").setSmallIcon("showDownloadHistoryAction_smallIcon");
        this.toolbarButtons.put("R", new ToolbarButtonProperties("removeCompletedAction"));
        this.toolbarButtons.put("S", new ToolbarButtonProperties("removeCompletedAndDeletedAction"));
        this.toolbarButtons.put("T", new ToolbarButtonProperties("removeInvalidLinksAction"));
        this.toolbarButtons.put("U", new ToolbarButtonProperties("removeSelectedAction"));
        this.toolbarButtons.put("V", new ToolbarButtonProperties("validateLinksAction"));
        this.toolbarButtons.put("W", new ToolbarButtonProperties(""));
        this.toolbarButtons.get("W").setName(this.context.getResourceMap().getString("forceDownloadMenu.text", new Object[0]).replace("&", ""));
        this.toolbarButtons.get("W").setSmallIcon("forceDownloadMenu_smallIcon");
        this.toolbarButtons.put("X", new ToolbarButtonProperties("retryAllErrorAction"));
        this.toolbarButtons.put("Y", new ToolbarButtonProperties("selectAllAction"));
        this.toolbarButtons.put("Z", new ToolbarButtonProperties("invertSelectionAction"));
    }

    private void addToolbarButtons() {
        String customButtons = AppPrefs.getProperty("customToolbarButtons", "A-BCD-EFGH");
        for (char button : customButtons.toCharArray()) {
            if (button == '-') {
                this.toolbar.add(new ToolbarSeparator());
                continue;
            }
            if (button == 'W') {
                this.initForceDownloadButton();
                this.toolbar.add(this.forceDownloadButton);
                continue;
            }
            if (!this.toolbarButtons.containsKey("" + button)) continue;
            this.toolbar.add(this.getButton(this.toolbarButtons.get("" + button).getAction()));
        }
    }

    public void reloadToolbar() {
        this.toolbar = new JToolBar("mainToolbar");
        this.toolbarPanel.removeAll();
        this.createToolbar();
        this.initManager();
    }

    private void createToolbar() {
        this.toolbarPanel.add(this.toolbar);
        this.toolbar.setFocusable(false);
        this.toolbar.setFloatable(false);
        Border border = this.toolbar.getBorder();
        Border innerBorder = BorderFactory.createEmptyBorder(2, 2, 1, 2);
        if (border != null) {
            this.toolbar.setBorder(BorderFactory.createCompoundBorder(border, innerBorder));
        } else {
            this.toolbar.setBorder(innerBorder);
        }
        this.addToolbarButtons();
        this.toolbar.add(Box.createGlue());
        this.searchField = new SearchField(this.context);
        new CompoundUndoManager(this.searchField);
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SearchItem searchItem;
                if (e.getKeyCode() == 10 && (searchItem = ToolbarManager.this.searchField.getSelectedItem()) != null) {
                    ToolbarManager.this.directorManager.getSearchManager().openBrowser(searchItem, ToolbarManager.this.searchField.getText());
                    Swinger.inputFocus(ToolbarManager.this.searchField);
                }
            }
        });
        ValueModel valueModel = BindUtils.getPrefsValueModel("searchFieldText", "");
        Bindings.bind(this.searchField, valueModel, false);
        valueModel = BindUtils.getPrefsValueModel("searchFieldVisible", true);
        PropertyConnector.connectAndUpdate(valueModel, this.searchField, "visible");
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ToolbarManager.this.directorManager.getSearchManager().checkForDirChange()) {
                    ToolbarManager.this.directorManager.getSearchManager().loadSearchData();
                    ToolbarManager.this.searchField.setSearchItemList(ToolbarManager.this.directorManager.getSearchManager().getSearchItems());
                }
            }
        });
        this.toolbar.add(this.searchField);
        this.toolbar.add(Box.createHorizontalStrut(3));
        AbstractButton btn = this.getButton(Swinger.getAction("paypalSupportAction"));
        btn.setCursor(Cursor.getPredefinedCursor(12));
        btn.putClientProperty("noChange", true);
        btn.setOpaque(false);
        btn.setRolloverEnabled(false);
        btn.setBackground(null);
        btn.setText(null);
        btn.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPrefs.getProperty("showPaypal", true)) {
            this.toolbar.add(btn);
        }
        this.toolbar.add(Box.createHorizontalStrut(18));
        this.toolbar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new JMenuItem(ToolbarManager.this.context.getActionMap().get("showToolbarEditorAction")));
                    SwingUtils.showPopMenu(popup, e, ToolbarManager.this.toolbar, ToolbarManager.this.toolbar);
                }
            }
        });
        this.updateButtons(AppPrefs.getProperty("showButtonTextToolbar", true));
        this.checkPreferences();
    }

    void initManager() {
        this.searchField.setSearchItemList(this.directorManager.getSearchManager().getSearchItems());
    }

    private void checkPreferences() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(final PreferenceChangeEvent evt) {
                if ("showButtonTextToolbar".equals(evt.getKey())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ToolbarManager.this.updateButtons(Boolean.valueOf(evt.getNewValue()));
                        }
                    });
                }
            }
        });
    }

    private void updateButtons(boolean withText) {
        Dimension dimension;
        Component[] components = this.toolbar.getComponents();
        if (withText) {
            this.toolbarPanel.setPreferredSize(new Dimension(400, 54));
            dimension = buttonDimensionWithText;
        } else {
            dimension = buttonWithoutWithoutTextDimension;
            this.toolbarPanel.setPreferredSize(new Dimension(400, 47));
        }
        for (Component c : components) {
            AbstractButton button;
            if (!(c instanceof AbstractButton) || (button = (AbstractButton)c).getClientProperty("noChange") != null) continue;
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            button.setMaximumSize(dimension);
            if (withText) {
                this.updateButtonText(button, button.getAction());
                continue;
            }
            button.setText(null);
        }
        this.toolbar.getParent().validate();
        this.toolbar.getParent().repaint();
    }

    private void setToolBarVisible(boolean visible) {
        this.toolbarPanel.setVisible(visible);
    }

    public JComponent getComponent() {
        return this.toolbarPanel;
    }

    private AbstractButton getToggleButton(Action action) {
        JToggleButton button = new JToggleButton(action);
        return this.setButtonProperties(button, action);
    }

    private AbstractButton getButton(Action action) {
        JButton button = new JButton(action);
        return this.setButtonProperties(button, action);
    }

    private AbstractButton setButtonProperties(AbstractButton button, Action action) {
        button.setRolloverEnabled(true);
        button.setIconTextGap(0);
        Object desc = action.getValue("ShortDescription");
        Font font = button.getFont();
        button.setFont(font.deriveFont(this.fontSize));
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setText(null);
        Object keystroke = action.getValue("AcceleratorKey");
        if (desc != null && keystroke != null) {
            button.setToolTipText(desc.toString() + " (" + SwingUtils.keyStroke2String((KeyStroke)keystroke) + ")");
        }
        button.setMnemonic(0);
        button.setFocusable(false);
        return button;
    }

    private void updateButtonText(AbstractButton button, Action action) {
        String s = (String)action.getValue("Name");
        if (s != null && s.endsWith("...")) {
            s = s.substring(0, s.length() - 3);
        }
        button.setText(s);
    }

    public SearchField getSearchField() {
        return this.searchField;
    }

    public Set<String> getToolbarButtonList() {
        return this.toolbarButtons.keySet();
    }

    public String getToolbarButtonName(String key) {
        if (this.toolbarButtons.containsKey(key)) {
            return this.toolbarButtons.get(key).getName();
        }
        return key;
    }

    public Icon getToolbarButtonSmallIcon(String key) {
        if (this.toolbarButtons.containsKey(key)) {
            return this.toolbarButtons.get(key).getSmallIcon();
        }
        return null;
    }

    private class ToolbarButtonProperties {
        private String actionProperty = "";
        private String name = "";
        private Icon smallIcon;

        ToolbarButtonProperties(String actionProperty) {
            this.actionProperty = actionProperty;
        }

        void setName(String name) {
            this.name = name;
        }

        void setSmallIcon(String smallIconProperty) {
            this.smallIcon = ToolbarManager.this.context.getResourceMap().getIcon(smallIconProperty);
        }

        Action getAction() {
            if (!this.actionProperty.isEmpty()) {
                return Swinger.getAction(this.actionProperty);
            }
            return null;
        }

        String getName() {
            if (!this.name.isEmpty()) {
                return this.name;
            }
            if (!this.actionProperty.isEmpty()) {
                return (String)Swinger.getAction(this.actionProperty).getValue("Name");
            }
            return "";
        }

        Icon getSmallIcon() {
            if (this.smallIcon != null) {
                return this.smallIcon;
            }
            if (!this.actionProperty.isEmpty()) {
                return (Icon)Swinger.getAction(this.actionProperty).getValue("SmallIcon");
            }
            return null;
        }
    }

    private class ForceDownloadOptionAction
    extends AbstractAction {
        private final ConnectionSettings settings;

        public ForceDownloadOptionAction(ConnectionSettings settings) {
            this.settings = settings;
            this.putValue("Name", settings.toString());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolbarManager.this.directorManager.getDataManager().forceDownload(this.settings, ToolbarManager.this.directorManager.getContentManager().getContentPanel().getSelectedRows());
        }
    }

    private class ForceDownloadButtonAction
    extends AbstractAction {
        public ForceDownloadButtonAction(String name, Icon largeIcon) {
            this.putValue("Name", name.replace("&", ""));
            this.putValue("ShortDescription", name.replace("&", ""));
            this.putValue("SwingLargeIconKey", largeIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolbarManager.this.updateForceDownloadButtonMenu();
            if (ToolbarManager.this.forceDownloadButton.isEnabled()) {
                ToolbarManager.this.forceDownloadButtonMenu.show((JComponent)e.getSource(), ToolbarManager.this.forceDownloadButtonMenu.getX(), ToolbarManager.this.forceDownloadButtonMenu.getY() + (int)(ToolbarManager.this.forceDownloadButton.getPreferredSize().getHeight() * 2.0 / 3.0));
            }
        }
    }
}

