/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.model;

import com.objectdb.spi.OMember;
import com.objectdb.spi.OReader;
import com.objectdb.spi.OType;
import com.objectdb.spi.OWriter;
import com.objectdb.spi.TrackableUserType;
import com.objectdb.spi.Tracker;
import cz.vity.freerapid.gui.managers.interfaces.Identifiable;
import cz.vity.freerapid.utilities.DescriptorUtils;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import org.java.plugin.registry.PluginDescriptor;
import org.jdesktop.application.AbstractBean;

@Entity
public final class PluginMetaData
extends AbstractBean
implements Identifiable<Long>,
Comparable<PluginMetaData> {
    private static final Logger logger = Logger.getLogger(PluginMetaData.class.getName());
    private static final Pattern NOPE_URL_MATCHER = Pattern.compile("&&&XXX&&&");
    @Id
    @GeneratedValue
    private Long dbId;
    private String id;
    private boolean updatesEnabled;
    private boolean enabled;
    private int pluginPriority;
    private int maxAllowedDownloads;
    private boolean clipboardMonitored;
    private boolean removeCompleted;
    @Transient
    private Pattern supportedURL;
    @Transient
    private PluginDescriptor descriptor;
    @Transient
    private boolean hasOptions;
    @Transient
    private String services;
    @Transient
    private String www;
    @Transient
    private boolean premium;
    @Transient
    private boolean favicon;
    @Transient
    private boolean resumeSupported;
    @Transient
    private int maxParallelDownloads;
    @Transient
    private boolean libraryPlugin;
    protected transient /* synthetic */ Tracker __odbTracker;
    public static final /* synthetic */ long __odbVersionCrc = -4127671281109472956L;

    public PluginMetaData() {
        PluginMetaData.__odbSet_enabled(this, true);
        PluginMetaData.__odbSet_clipboardMonitored(this, true);
        PluginMetaData.__odbSet_updatesEnabled(this, true);
        PluginMetaData.__odbSet_pluginPriority(this, -1);
        PluginMetaData.__odbSet_maxAllowedDownloads(this, -1);
        this.libraryPlugin = false;
    }

    public PluginMetaData(PluginDescriptor descriptor) {
        this();
        this.descriptor = descriptor;
        PluginMetaData.__odbSet_id(this, descriptor.getId());
        this.setPluginDescriptor(descriptor);
    }

    public void setPluginDescriptor(PluginDescriptor descriptor) {
        this.descriptor = descriptor;
        this.hasOptions = DescriptorUtils.getAttribute("hasOptions", false, descriptor);
        this.services = DescriptorUtils.getAttribute("services", this.getId(), descriptor).toLowerCase(Locale.ENGLISH);
        this.www = DescriptorUtils.getAttribute("www", "http://wordrider.net/freerapid", descriptor);
        this.premium = DescriptorUtils.getAttribute("premium", false, descriptor);
        this.favicon = DescriptorUtils.getAttribute("faviconImage", null, descriptor) != null;
        this.setRemoveCompleted(DescriptorUtils.getAttribute("removeCompleted", false, descriptor));
        this.setMaxParallelDownloads(DescriptorUtils.getAttribute("maxDownloads", 1, descriptor));
        boolean bl = this.libraryPlugin = DescriptorUtils.getAttribute("libraryPlugin", false, descriptor) || this.maxParallelDownloads == 0;
        if (PluginMetaData.__odbGet_pluginPriority(this) == -1) {
            PluginMetaData.__odbSet_pluginPriority(this, DescriptorUtils.getAttribute("priority", this.premium ? 1000 : 100, descriptor));
        }
        this.supportedURL = this.libraryPlugin ? NOPE_URL_MATCHER : Pattern.compile(DescriptorUtils.getAttribute("urlRegex", "&&&XX&&&", descriptor), 2);
        if (PluginMetaData.__odbGet_maxAllowedDownloads(this) > 1) {
            this.setMaxAllowedDownloads(Math.min(this.maxParallelDownloads, PluginMetaData.__odbGet_maxAllowedDownloads(this)));
        } else if (PluginMetaData.__odbGet_maxAllowedDownloads(this) == -1) {
            this.setMaxAllowedDownloads(Math.max(1, Math.min(DescriptorUtils.getAttribute("defaultDownloads", this.maxParallelDownloads, descriptor), this.maxParallelDownloads)));
        }
        this.resumeSupported = DescriptorUtils.getAttribute("resumeSupported", true, descriptor);
    }

    public boolean isLibraryPlugin() {
        return this.libraryPlugin;
    }

    public boolean isSupported(String url) {
        return !this.isLibraryPlugin() && this.supportedURL.matcher(url).matches();
    }

    public void setRemoveCompleted(boolean removeCompleted) {
        PluginMetaData.__odbSet_removeCompleted(this, removeCompleted);
    }

    public void setResumeSupported(boolean resumeSupported) {
        this.resumeSupported = resumeSupported;
    }

    public void setMaxParallelDownloads(int maxParallelDownloads) {
        this.maxParallelDownloads = maxParallelDownloads;
    }

    @Override
    public Long getIdentificator() {
        return PluginMetaData.__odbGet_dbId(this);
    }

    public String getId() {
        return PluginMetaData.__odbGet_id(this);
    }

    public void setId(String id) {
        PluginMetaData.__odbSet_id(this, id);
    }

    public boolean isEnabled() {
        return PluginMetaData.__odbGet_enabled(this);
    }

    public boolean isOptionable() {
        return this.hasOptions;
    }

    public String getServices() {
        return this.services;
    }

    public String getVendor() {
        return this.descriptor.getVendor();
    }

    public String getWWW() {
        return this.www;
    }

    public boolean isDescriptorSet() {
        return this.descriptor != null;
    }

    public void setEnabled(boolean enabled) {
        boolean oldValue = PluginMetaData.__odbGet_enabled(this);
        PluginMetaData.__odbSet_enabled(this, enabled);
        this.firePropertyChange("enabled", oldValue, enabled);
    }

    public boolean isUpdatesEnabled() {
        return PluginMetaData.__odbGet_updatesEnabled(this);
    }

    public void setUpdatesEnabled(boolean updatesEnabled) {
        boolean oldValue = PluginMetaData.__odbGet_updatesEnabled(this);
        PluginMetaData.__odbSet_updatesEnabled(this, updatesEnabled);
        this.firePropertyChange("updatesEnabled", oldValue, updatesEnabled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginMetaData that = (PluginMetaData)o;
        return PluginMetaData.__odbGet_id(this).equals(PluginMetaData.__odbGet_id(that));
    }

    @Override
    public int compareTo(PluginMetaData o) {
        return PluginMetaData.__odbGet_id(this).compareToIgnoreCase(PluginMetaData.__odbGet_id(o));
    }

    public int hashCode() {
        return PluginMetaData.__odbGet_id(this).hashCode();
    }

    public String getVersion() {
        return this.descriptor.getVersion().toString();
    }

    public boolean isPremium() {
        return this.premium;
    }

    public boolean hasFavicon() {
        return this.favicon;
    }

    public boolean isRemoveCompleted() {
        return PluginMetaData.__odbGet_removeCompleted(this);
    }

    public String toString() {
        return "PluginMetaData{dbId=" + PluginMetaData.__odbGet_dbId(this) + " id='" + PluginMetaData.__odbGet_id(this) + '\'' + " Version=" + this.getVersion() + '}';
    }

    public boolean isResumeSupported() {
        return this.resumeSupported;
    }

    public int getMaxParallelDownloads() {
        return this.maxParallelDownloads;
    }

    public int getPluginPriority() {
        return PluginMetaData.__odbGet_pluginPriority(this);
    }

    @Deprecated
    public void setPriority(int value) {
    }

    public int getMaxAllowedDownloads() {
        return PluginMetaData.__odbGet_maxAllowedDownloads(this);
    }

    public boolean isClipboardMonitored() {
        return PluginMetaData.__odbGet_clipboardMonitored(this);
    }

    public void setPluginPriority(int value) {
        Integer oldValue = PluginMetaData.__odbGet_pluginPriority(this);
        PluginMetaData.__odbSet_pluginPriority(this, value);
        this.firePropertyChange("priority", oldValue, value);
    }

    public void setMaxAllowedDownloads(int maxAllowedDownloads) {
        int oldValue = PluginMetaData.__odbGet_maxAllowedDownloads(this);
        PluginMetaData.__odbSet_maxAllowedDownloads(this, maxAllowedDownloads);
        this.firePropertyChange("maxAllowedDownloads", oldValue, maxAllowedDownloads);
    }

    public void setClipboardMonitored(boolean clipboardMonitored) {
        boolean oldValue = PluginMetaData.__odbGet_clipboardMonitored(this);
        PluginMetaData.__odbSet_clipboardMonitored(this, clipboardMonitored);
        this.firePropertyChange("clipboardMonitored", oldValue, clipboardMonitored);
    }

    public void __odbSetTracker(Tracker tracker) {
        this.__odbTracker = tracker;
    }

    public Tracker __odbGetTracker() {
        return this.__odbTracker;
    }

    public TrackableUserType __odbNewInstance() {
        return new PluginMetaData();
    }

    public static void __odbSet_dbId(PluginMetaData pluginMetaData, Long l) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(0)) {
            pluginMetaData.dbId = l;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.dbId = l;
        }
    }

    public static Long __odbGet_dbId(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(0);
        }
        return pluginMetaData.dbId;
    }

    public static void __odbSet_id(PluginMetaData pluginMetaData, String string) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(1)) {
            pluginMetaData.id = string;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.id = string;
        }
    }

    public static String __odbGet_id(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(1);
        }
        return pluginMetaData.id;
    }

    public static void __odbSet_updatesEnabled(PluginMetaData pluginMetaData, boolean bl) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(2)) {
            pluginMetaData.updatesEnabled = bl;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.updatesEnabled = bl;
        }
    }

    public static boolean __odbGet_updatesEnabled(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(2);
        }
        return pluginMetaData.updatesEnabled;
    }

    public static void __odbSet_enabled(PluginMetaData pluginMetaData, boolean bl) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(3)) {
            pluginMetaData.enabled = bl;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.enabled = bl;
        }
    }

    public static boolean __odbGet_enabled(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(3);
        }
        return pluginMetaData.enabled;
    }

    public static void __odbSet_pluginPriority(PluginMetaData pluginMetaData, int n) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(4)) {
            pluginMetaData.pluginPriority = n;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.pluginPriority = n;
        }
    }

    public static int __odbGet_pluginPriority(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(4);
        }
        return pluginMetaData.pluginPriority;
    }

    public static void __odbSet_maxAllowedDownloads(PluginMetaData pluginMetaData, int n) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(5)) {
            pluginMetaData.maxAllowedDownloads = n;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.maxAllowedDownloads = n;
        }
    }

    public static int __odbGet_maxAllowedDownloads(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(5);
        }
        return pluginMetaData.maxAllowedDownloads;
    }

    public static void __odbSet_clipboardMonitored(PluginMetaData pluginMetaData, boolean bl) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(6)) {
            pluginMetaData.clipboardMonitored = bl;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.clipboardMonitored = bl;
        }
    }

    public static boolean __odbGet_clipboardMonitored(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(6);
        }
        return pluginMetaData.clipboardMonitored;
    }

    public static void __odbSet_removeCompleted(PluginMetaData pluginMetaData, boolean bl) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(7)) {
            pluginMetaData.removeCompleted = bl;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.removeCompleted = bl;
        }
    }

    public static boolean __odbGet_removeCompleted(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(7);
        }
        return pluginMetaData.removeCompleted;
    }

    public static void __odbSet_supportedURL(PluginMetaData pluginMetaData, Pattern pattern) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(8)) {
            pluginMetaData.supportedURL = pattern;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.supportedURL = pattern;
        }
    }

    public static Pattern __odbGet_supportedURL(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(8);
        }
        return pluginMetaData.supportedURL;
    }

    public static void __odbSet_descriptor(PluginMetaData pluginMetaData, PluginDescriptor pluginDescriptor) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(9)) {
            pluginMetaData.descriptor = pluginDescriptor;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.descriptor = pluginDescriptor;
        }
    }

    public static PluginDescriptor __odbGet_descriptor(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(9);
        }
        return pluginMetaData.descriptor;
    }

    public static void __odbSet_hasOptions(PluginMetaData pluginMetaData, boolean bl) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(10)) {
            pluginMetaData.hasOptions = bl;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.hasOptions = bl;
        }
    }

    public static boolean __odbGet_hasOptions(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(10);
        }
        return pluginMetaData.hasOptions;
    }

    public static void __odbSet_services(PluginMetaData pluginMetaData, String string) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(11)) {
            pluginMetaData.services = string;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.services = string;
        }
    }

    public static String __odbGet_services(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(11);
        }
        return pluginMetaData.services;
    }

    public static void __odbSet_www(PluginMetaData pluginMetaData, String string) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(12)) {
            pluginMetaData.www = string;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.www = string;
        }
    }

    public static String __odbGet_www(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(12);
        }
        return pluginMetaData.www;
    }

    public static void __odbSet_premium(PluginMetaData pluginMetaData, boolean bl) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(13)) {
            pluginMetaData.premium = bl;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.premium = bl;
        }
    }

    public static boolean __odbGet_premium(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(13);
        }
        return pluginMetaData.premium;
    }

    public static void __odbSet_favicon(PluginMetaData pluginMetaData, boolean bl) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(14)) {
            pluginMetaData.favicon = bl;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.favicon = bl;
        }
    }

    public static boolean __odbGet_favicon(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(14);
        }
        return pluginMetaData.favicon;
    }

    public static void __odbSet_resumeSupported(PluginMetaData pluginMetaData, boolean bl) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(15)) {
            pluginMetaData.resumeSupported = bl;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.resumeSupported = bl;
        }
    }

    public static boolean __odbGet_resumeSupported(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(15);
        }
        return pluginMetaData.resumeSupported;
    }

    public static void __odbSet_maxParallelDownloads(PluginMetaData pluginMetaData, int n) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(16)) {
            pluginMetaData.maxParallelDownloads = n;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.maxParallelDownloads = n;
        }
    }

    public static int __odbGet_maxParallelDownloads(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(16);
        }
        return pluginMetaData.maxParallelDownloads;
    }

    public static void __odbSet_libraryPlugin(PluginMetaData pluginMetaData, boolean bl) {
        if (pluginMetaData.__odbTracker != null && pluginMetaData.__odbTracker.beforeModifyMember(17)) {
            pluginMetaData.libraryPlugin = bl;
            pluginMetaData.__odbTracker.afterModify();
        } else {
            pluginMetaData.libraryPlugin = bl;
        }
    }

    public static boolean __odbGet_libraryPlugin(PluginMetaData pluginMetaData) {
        if (pluginMetaData.__odbTracker != null) {
            pluginMetaData.__odbTracker.beforeAccess(17);
        }
        return pluginMetaData.libraryPlugin;
    }

    public static int __odbGetMemberCount() {
        return 18;
    }

    public void __odbClear() {
        this.id = null;
        this.updatesEnabled = (byte)0;
        this.enabled = (byte)0;
        this.pluginPriority = 0;
        this.maxAllowedDownloads = 0;
        this.clipboardMonitored = (byte)0;
        this.removeCompleted = (byte)0;
    }

    public void __odbWriteContent(OType[] oTypeArray, OWriter oWriter) {
        oWriter.writeStringValue(this.id);
        oWriter.writeBooleanValue(this.updatesEnabled);
        oWriter.writeBooleanValue(this.enabled);
        oWriter.writeSInt32Value(this.pluginPriority);
        oWriter.writeSInt32Value(this.maxAllowedDownloads);
        oWriter.writeBooleanValue(this.clipboardMonitored);
        oWriter.writeBooleanValue(this.removeCompleted);
    }

    public void __odbReadContent(OMember[] oMemberArray, OReader oReader) {
        this.id = oReader.readStringValue();
        this.updatesEnabled = oReader.readBooleanValue();
        this.enabled = oReader.readBooleanValue();
        this.pluginPriority = oReader.readSInt32Value();
        this.maxAllowedDownloads = oReader.readSInt32Value();
        this.clipboardMonitored = oReader.readBooleanValue();
        this.removeCompleted = oReader.readBooleanValue();
    }

    public void __odbWriteMember(OMember oMember, OWriter oWriter) {
        switch (oMember.getMemberIx()) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: {
                oWriter.writeElement(oMember.getType(), this.dbId);
                return;
            }
            case 1: {
                oWriter.writeStringValue(this.id);
                return;
            }
            case 2: {
                oWriter.writeBooleanValue(this.updatesEnabled);
                return;
            }
            case 3: {
                oWriter.writeBooleanValue(this.enabled);
                return;
            }
            case 4: {
                oWriter.writeSInt32Value(this.pluginPriority);
                return;
            }
            case 5: {
                oWriter.writeSInt32Value(this.maxAllowedDownloads);
                return;
            }
            case 6: {
                oWriter.writeBooleanValue(this.clipboardMonitored);
                return;
            }
            case 7: 
        }
        oWriter.writeBooleanValue(this.removeCompleted);
    }

    public void __odbReadMember(OMember oMember, OReader oReader) {
        switch (oMember.getMemberIx()) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: {
                this.dbId = (Long)oMember.readAndAdjust(oReader);
                return;
            }
            case 1: {
                this.id = oReader.readStringValue();
                return;
            }
            case 2: {
                this.updatesEnabled = oReader.readBooleanValue();
                return;
            }
            case 3: {
                this.enabled = oReader.readBooleanValue();
                return;
            }
            case 4: {
                this.pluginPriority = oReader.readSInt32Value();
                return;
            }
            case 5: {
                this.maxAllowedDownloads = oReader.readSInt32Value();
                return;
            }
            case 6: {
                this.clipboardMonitored = oReader.readBooleanValue();
                return;
            }
            case 7: 
        }
        this.removeCompleted = oReader.readBooleanValue();
    }

    public void __odbSetMember(int n, Object object) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: {
                this.dbId = (Long)object;
                return;
            }
            case 1: {
                this.id = (String)object;
                return;
            }
            case 2: {
                this.updatesEnabled = (Boolean)object;
                return;
            }
            case 3: {
                this.enabled = (Boolean)object;
                return;
            }
            case 4: {
                this.pluginPriority = (Integer)object;
                return;
            }
            case 5: {
                this.maxAllowedDownloads = (Integer)object;
                return;
            }
            case 6: {
                this.clipboardMonitored = (Boolean)object;
                return;
            }
            case 7: {
                this.removeCompleted = (Boolean)object;
                return;
            }
            case 8: {
                this.supportedURL = (Pattern)object;
                return;
            }
            case 9: {
                this.descriptor = (PluginDescriptor)object;
                return;
            }
            case 10: {
                this.hasOptions = (Boolean)object;
                return;
            }
            case 11: {
                this.services = (String)object;
                return;
            }
            case 12: {
                this.www = (String)object;
                return;
            }
            case 13: {
                this.premium = (Boolean)object;
                return;
            }
            case 14: {
                this.favicon = (Boolean)object;
                return;
            }
            case 15: {
                this.resumeSupported = (Boolean)object;
                return;
            }
            case 16: {
                this.maxParallelDownloads = (Integer)object;
                return;
            }
            case 17: 
        }
        this.libraryPlugin = (Boolean)object;
    }

    public Object __odbGetMember(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: {
                return this.dbId;
            }
            case 1: {
                return this.id;
            }
            case 2: {
                return this.updatesEnabled;
            }
            case 3: {
                return this.enabled;
            }
            case 4: {
                return this.pluginPriority;
            }
            case 5: {
                return this.maxAllowedDownloads;
            }
            case 6: {
                return this.clipboardMonitored;
            }
            case 7: {
                return this.removeCompleted;
            }
            case 8: {
                return this.supportedURL;
            }
            case 9: {
                return this.descriptor;
            }
            case 10: {
                return this.hasOptions;
            }
            case 11: {
                return this.services;
            }
            case 12: {
                return this.www;
            }
            case 13: {
                return this.premium;
            }
            case 14: {
                return this.favicon;
            }
            case 15: {
                return this.resumeSupported;
            }
            case 16: {
                return this.maxParallelDownloads;
            }
            case 17: 
        }
        return this.libraryPlugin;
    }

    public void __odbSetNumMember(int n, long l) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
        }
        this.dbId = l;
    }

    public long __odbGetNumMember(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: {
                return this.dbId;
            }
            case 4: {
                return this.pluginPriority;
            }
            case 5: {
                return this.maxAllowedDownloads;
            }
            case 16: 
        }
        return this.maxParallelDownloads;
    }

    public void __odbClearMember(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: {
                this.dbId = null;
                return;
            }
            case 1: {
                this.id = null;
                return;
            }
            case 2: {
                this.updatesEnabled = (byte)0;
                return;
            }
            case 3: {
                this.enabled = (byte)0;
                return;
            }
            case 4: {
                this.pluginPriority = 0;
                return;
            }
            case 5: {
                this.maxAllowedDownloads = 0;
                return;
            }
            case 6: {
                this.clipboardMonitored = (byte)0;
                return;
            }
            case 7: {
                this.removeCompleted = (byte)0;
                return;
            }
            case 8: {
                this.supportedURL = null;
                return;
            }
            case 9: {
                this.descriptor = null;
                return;
            }
            case 10: {
                this.hasOptions = (byte)0;
                return;
            }
            case 11: {
                this.services = null;
                return;
            }
            case 12: {
                this.www = null;
                return;
            }
            case 13: {
                this.premium = (byte)0;
                return;
            }
            case 14: {
                this.favicon = (byte)0;
                return;
            }
            case 15: {
                this.resumeSupported = (byte)0;
                return;
            }
            case 16: {
                this.maxParallelDownloads = 0;
                return;
            }
            case 17: 
        }
        this.libraryPlugin = (byte)0;
    }

    public long __odbGetVersionCrc() {
        return -4127671281109472956L;
    }

    public Object __odbsuperClone() throws CloneNotSupportedException {
        return Tracker.fixClone(super.clone());
    }
}

